/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoBounds;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeoUtil {
    public static Dimension getMapSize(int zoom, TileFactoryInfo info) {
        return new Dimension(info.getMapWidthInTilesAtZoom(zoom), info.getMapHeightInTilesAtZoom(zoom));
    }

    public static boolean isValidTile(int x, int y, int zoomLevel, TileFactoryInfo info) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getX() * 2.0 <= (double)(x * info.getTileSize(zoomLevel))) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getY() * 2.0 <= (double)(y * info.getTileSize(zoomLevel))) {
            return false;
        }
        return zoomLevel >= info.getMinimumZoomLevel() && zoomLevel <= info.getMaximumZoomLevel();
    }

    public static final Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel, TileFactoryInfo info) {
        return info.getBitmapCoordinate(c.getLatitude(), c.getLongitude(), zoomLevel);
    }

    public static final GeoPosition getPositionForAddress(String[] fields) throws IOException {
        return GeoUtil.getPositionForAddress(fields[0], fields[1], fields[2]);
    }

    public static final GeoPosition getPositionForAddress(String street, String city, String state) throws IOException {
        try {
            URL load = new URL("http://api.local.yahoo.com/MapsService/V1/geocode?appid=joshy688&street=" + street.replace(' ', '+') + "&city=" + city.replace(' ', '+') + "&state=" + state.replace(' ', '+'));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(load.openConnection().getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Double lat = (Double)xpath.evaluate("//Result/Latitude/text()", doc, XPathConstants.NUMBER);
            Double lon = (Double)xpath.evaluate("//Result/Longitude/text()", doc, XPathConstants.NUMBER);
            return new GeoPosition(lat, lon);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to retrieve location information from the internet: " + e.toString());
        }
    }

    public static GeoBounds getMapBounds(JXMapViewer mapViewer) {
        return new GeoBounds(GeoUtil.getMapGeoBounds(mapViewer));
    }

    private static Set<GeoPosition> getMapGeoBounds(JXMapViewer mapViewer) {
        HashSet<GeoPosition> set = new HashSet<GeoPosition>();
        TileFactory tileFactory = mapViewer.getTileFactory();
        int zoom = mapViewer.getZoom();
        Rectangle bounds = mapViewer.getViewportBounds();
        Point2D.Double pt = new Point2D.Double(((RectangularShape)bounds).getX(), ((RectangularShape)bounds).getY());
        set.add(tileFactory.pixelToGeo(pt, zoom));
        pt = new Point2D.Double(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight());
        set.add(tileFactory.pixelToGeo(pt, zoom));
        tileFactory = null;
        return set;
    }
}

