/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.GenericMemberTypeProcessor;
import com.tngtech.archunit.core.importer.SignatureTypeParameterProcessor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureReader;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaCodeUnitSignatureImporter {
    private static final Logger log = LoggerFactory.getLogger(JavaCodeUnitSignatureImporter.class);

    JavaCodeUnitSignatureImporter() {
    }

    public static JavaCodeUnitSignature parseAsmMethodSignature(String signature, DeclarationHandler declarationHandler) {
        if (signature == null) {
            return JavaCodeUnitSignature.ABSENT;
        }
        log.trace("Analyzing method signature: {}", (Object)signature);
        SignatureProcessor signatureProcessor = new SignatureProcessor(declarationHandler);
        new SignatureReader(signature).accept(signatureProcessor);
        return signatureProcessor.getParsedSignature();
    }

    static class JavaCodeUnitSignature {
        static final JavaCodeUnitSignature ABSENT = new JavaCodeUnitSignature(Collections.emptyList(), Collections.emptyList(), Optional.empty());
        private final List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders;
        private final List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> parameterTypes;
        private final Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> returnType;

        private JavaCodeUnitSignature(List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders, List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> parameterTypes, Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> returnType) {
            this.typeParameterBuilders = Preconditions.checkNotNull(typeParameterBuilders);
            this.parameterTypes = parameterTypes;
            this.returnType = Preconditions.checkNotNull(returnType);
        }

        List<DomainBuilders.JavaTypeParameterBuilder<JavaCodeUnit>> getTypeParameterBuilders() {
            return this.typeParameterBuilders;
        }

        List<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> getParameterTypes() {
            return this.parameterTypes;
        }

        Optional<DomainBuilders.JavaTypeCreationProcess<JavaCodeUnit>> getReturnType() {
            return this.returnType;
        }
    }

    private static class SignatureProcessor
    extends SignatureVisitor {
        private final DeclarationHandler declarationHandler;
        private final SignatureTypeParameterProcessor<JavaCodeUnit> typeParameterProcessor;
        private final GenericMemberTypeProcessor<JavaCodeUnit> genericMethodReturnTypeProcessor;
        private final List<GenericMemberTypeProcessor<JavaCodeUnit>> genericMethodParameterTypeProcessors = new ArrayList<GenericMemberTypeProcessor<JavaCodeUnit>>();

        SignatureProcessor(DeclarationHandler declarationHandler) {
            super(589824);
            this.declarationHandler = declarationHandler;
            this.typeParameterProcessor = new SignatureTypeParameterProcessor(declarationHandler);
            this.genericMethodReturnTypeProcessor = new GenericMemberTypeProcessor(declarationHandler);
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            log.trace("Encountered type parameter {}", (Object)name);
            this.typeParameterProcessor.addTypeParameter(name);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.typeParameterProcessor;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.typeParameterProcessor;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            GenericMemberTypeProcessor parameterTypeProcessor = new GenericMemberTypeProcessor(this.declarationHandler);
            this.genericMethodParameterTypeProcessors.add(parameterTypeProcessor);
            return parameterTypeProcessor;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return this.genericMethodReturnTypeProcessor;
        }

        public JavaCodeUnitSignature getParsedSignature() {
            List parameterTypes = this.genericMethodParameterTypeProcessors.stream().flatMap(parameterTypeProcessor -> parameterTypeProcessor.getType().map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
            return new JavaCodeUnitSignature(this.typeParameterProcessor.getTypeParameterBuilders(), parameterTypes, this.genericMethodReturnTypeProcessor.getType());
        }
    }
}

