/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;

public final class ElementListObserver {
    private static List<Observer> activeObservers;

    private ElementListObserver() {
    }

    public static void addObserver(Observer observer) {
        if (!ElementListObserver.isObservationActive()) {
            activeObservers = new ArrayList<Observer>();
        }
        activeObservers.add(observer);
    }

    public static void removeObserver(Observer observer) {
        if (ElementListObserver.isObservationActive()) {
            activeObservers.remove(observer);
        }
    }

    public static void observe(List elementList, String category, String id) {
        if (ElementListObserver.isObservationActive()) {
            if (category == null) {
                throw new NullPointerException("category must not be null");
            }
            for (Observer activeObserver : activeObservers) {
                activeObserver.observe(elementList, category, id);
            }
        }
    }

    public static boolean isObservationActive() {
        return activeObservers != null;
    }

    public static interface Observer {
        public void observe(List var1, String var2, String var3);
    }
}

