/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.oat.IndexBssUtilities;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class IndexBssMappingEntry
implements StructConverter {
    private int index_and_mask;
    private int bss_offset;

    IndexBssMappingEntry(BinaryReader reader) throws IOException {
        this.index_and_mask = reader.readNextInt();
        this.bss_offset = reader.readNextInt();
    }

    public int getIndexAndMask() {
        return this.index_and_mask;
    }

    public int getIndex(int index_bits) {
        return this.index_and_mask & IndexBssUtilities.indexMask(index_bits);
    }

    public int getMask(int index_bits) {
        return this.index_and_mask >> index_bits;
    }

    public int getBssOffset() {
        return this.bss_offset;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(IndexBssMappingEntry.class);
    }
}

