/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.AbstractLayoutModel;
import org.jungrapht.visualization.layout.model.DefaultLayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public interface LayoutModel<V>
extends Function<V, Point>,
ModelChange.Producer,
ViewChange.Producer,
LayoutVertexPositionChange.Producer<V>,
LayoutStateChange.Producer,
LayoutVertexPositionChange.Listener<V>,
LayoutSizeChange.Producer<V> {
    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public int getWidth();

    public int getHeight();

    public int getPreferredWidth();

    public int getPreferredHeight();

    default public Point getCenter() {
        return Point.of(this.getWidth() / 2, this.getHeight() / 2);
    }

    public void accept(LayoutAlgorithm<V> var1);

    default public Map<V, Point> getLocations() {
        return Collections.unmodifiableMap(this.getGraph().vertexSet().stream().collect(Collectors.toMap(v -> v, this::apply)));
    }

    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> var1);

    public void setSize(int var1, int var2);

    public void setPreferredSize(int var1, int var2);

    default public void stop() {
    }

    public void setRelaxing(boolean var1);

    public boolean isRelaxing();

    public boolean isLocked(V var1);

    public void set(V var1, Point var2);

    public void set(V var1, double var2, double var4);

    public Point get(V var1);

    public <E> Graph<V, E> getGraph();

    public void setGraph(Graph<V, ?> var1);

    public void lock(V var1, boolean var2);

    public void lock(boolean var1);

    public boolean isLocked();

    public void setInitializer(Function<V, Point> var1);

    public void resizeToSurroundingRectangle();

    public void appendLayoutModel(LayoutModel<V> var1);

    default public void setFireEvents(boolean fireEvents) {
        if (this.getModelChangeSupport() != null) {
            this.getModelChangeSupport().setFireEvents(fireEvents);
        }
        if (this.getViewChangeSupport() != null) {
            this.getViewChangeSupport().setFireEvents(fireEvents);
        }
        if (this.getLayoutStateChangeSupport() != null) {
            this.getLayoutStateChangeSupport().setFireEvents(fireEvents);
        }
        if (this.getLayoutSizeChangeSupport() != null) {
            this.getLayoutSizeChangeSupport().setFireEvents(fireEvents);
        }
    }

    public static class Builder<V, T extends DefaultLayoutModel<V>, B extends Builder<V, T, B>>
    extends AbstractLayoutModel.Builder<V, T, B> {
        Function<V, Point> initializer = v -> Point.ORIGIN;

        public B layoutModel(LayoutModel<V> layoutModel) {
            this.width = layoutModel.getWidth();
            this.height = layoutModel.getHeight();
            return (B)this;
        }

        public B initializer(Function<V, Point> initializer) {
            this.initializer = initializer;
            return (B)this;
        }

        @Override
        public B createVisRunnable(boolean createVisRunnable) {
            this.createVisRunnable = createVisRunnable;
            return (B)this;
        }

        public T build() {
            return (T)new DefaultLayoutModel(this);
        }
    }
}

