/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ExternalCallNode
extends CallNode {
    private static final Icon EXTERNAL_ICON = new GIcon("icon.plugin.calltree.node.external");
    private static final Icon CALL_REFERENCE_ICON = ExternalCallNode.createIcon(EXTERNAL_ICON, true);
    private static final Icon NON_CALL_REFERENCE_ICON = ExternalCallNode.createIcon(EXTERNAL_ICON, false);
    private final Function function;
    private final Address sourceAddress;
    private final String name;

    ExternalCallNode(Function function, Address sourceAddress, boolean isCallReference, CallTreeOptions callTreeOptions) {
        super(callTreeOptions);
        this.function = function;
        this.sourceAddress = sourceAddress;
        this.name = function.getName();
        this.isCallReference = isCallReference;
    }

    @Override
    public int loadAll(TaskMonitor monitor) throws CancelledException {
        return 1;
    }

    @Override
    CallNode recreate() {
        return new ExternalCallNode(this.function, this.sourceAddress, this.isCallReference, this.callTreeOptions);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return new ArrayList<GTreeNode>();
    }

    public Icon getIcon(boolean expanded) {
        return this.isCallReference ? CALL_REFERENCE_ICON : NON_CALL_REFERENCE_ICON;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getToolTip() {
        return "(External) " + super.getToolTip();
    }

    public boolean isLeaf() {
        return true;
    }
}

