/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfObsoleteRecord;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUnknownRecord;
import ghidra.app.util.bin.format.omf.OmfUnsupportedRecord;
import ghidra.app.util.bin.format.omf.omf.OmfComdatExternalSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfComdefRecord;
import ghidra.app.util.bin.format.omf.omf.OmfCommentRecord;
import ghidra.app.util.bin.format.omf.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.omf.OmfModuleEnd;
import ghidra.app.util.bin.format.omf.omf.OmfNamesRecord;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.app.util.bin.format.omf.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.omf.OmfSymbolRecord;
import java.io.IOException;
import java.util.List;

public class OmfRecordFactory
extends AbstractOmfRecordFactory {
    public OmfRecordFactory(ByteProvider provider) {
        super(new BinaryReader(provider, true));
    }

    @Override
    public OmfRecord readNextRecord() throws IOException, OmfException {
        int type = Byte.toUnsignedInt(this.reader.peekNextByte());
        OmfRecord record = switch (type & 0xFFFFFFFE) {
            case 128, 130 -> new OmfFileHeader(this.reader);
            case 136 -> new OmfCommentRecord(this.reader);
            case 138 -> new OmfModuleEnd(this.reader);
            case 140 -> new OmfExternalSymbol(this.reader, false);
            case 144 -> new OmfSymbolRecord(this.reader, false);
            case 150 -> new OmfNamesRecord(this.reader);
            case 152 -> new OmfSegmentHeader(this.reader);
            case 154 -> new OmfGroupRecord(this.reader);
            case 156 -> new OmfFixupRecord(this.reader);
            case 160 -> new OmfEnumeratedData(this.reader);
            case 162 -> new OmfIteratedData(this.reader);
            case 176 -> new OmfComdefRecord(this.reader, false);
            case 180 -> new OmfExternalSymbol(this.reader, true);
            case 182 -> new OmfSymbolRecord(this.reader, true);
            case 184 -> new OmfComdefRecord(this.reader, true);
            case 188 -> new OmfComdatExternalSymbol(this.reader);
            case 110, 112, 114, 116, 118, 120, 122, 124, 126, 132, 134, 148, 164, 166, 168, 170 -> new OmfObsoleteRecord(this.reader);
            case 142, 146, 178, 194, 196, 198, 200, 202, 204, 206 -> new OmfUnsupportedRecord(this.reader, OmfRecordTypes.class);
            default -> new OmfUnknownRecord(this.reader);
        };
        record.parseData();
        return record;
    }

    @Override
    public List<Integer> getStartRecordTypes() {
        return List.of(Integer.valueOf(128), Integer.valueOf(130));
    }

    @Override
    public int getEndRecordType() {
        return 138;
    }
}

