/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Selects a region of space where two independent fronts run towards
each other.


The filter can be used to quickly segment anatomical structures (e.g.
for level set initialization).

The filter uses two instances of FastMarchingUpwindGradientImageFilter to compute the gradients of arrival times of two wavefronts
propagating from two sets of seeds. The input of the filter is used as
the speed of the two wavefronts. The output is the dot product between
the two gradient vector fields.

The filter works on the following basic idea. In the regions where the
dot product between the two gradient fields is negative, the two
fronts propagate in opposite directions. In the regions where the dot
product is positive, the two fronts propagate in the same direction.
This can be used to extract the region of space between two sets of
points.

If StopOnTargets is On, then each front will stop as soon as all seeds
of the other front have been reached. This can markedly speed up the
execution of the filter, since wave propagation does not take place on
the complete image.

Optionally, a connectivity criterion can be applied to the resulting
dot product image. In this case, the only negative region in the
output image is the one connected to the seeds.


Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.

See:
 itk::simple::CollidingFronts for the procedural interface

 itk::CollidingFrontsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCollidingFrontsImageFilter.h
*/
public class CollidingFrontsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CollidingFrontsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CollidingFrontsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CollidingFrontsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CollidingFrontsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CollidingFrontsImageFilter::~CollidingFrontsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CollidingFrontsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CollidingFrontsImageFilter::CollidingFrontsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CollidingFrontsImageFilter() {
    this(SimpleITKJNI.new_CollidingFrontsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::SetSeedPoints1(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; SeedPoints1)

Set the container of Seed Points representing the first initial front.
Seed points are represented as a VectorContainer of LevelSetNodes.

*/
public  void setSeedPoints1(VectorUIntList SeedPoints1) {
    SimpleITKJNI.CollidingFrontsImageFilter_setSeedPoints1(swigCPtr, this, VectorUIntList.getCPtr(SeedPoints1), SeedPoints1);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::CollidingFrontsImageFilter::GetSeedPoints1() const

Get the container of Seed Points representing the first initial front.

*/
public  VectorUIntList getSeedPoints1() {
    return new VectorUIntList(SimpleITKJNI.CollidingFrontsImageFilter_getSeedPoints1(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::AddSeedPoint1(std::vector&lt; unsigned int &gt; point)

Add SeedPoints1 point.

*/
public  void addSeedPoint1(VectorUInt32 point) {
    SimpleITKJNI.CollidingFrontsImageFilter_addSeedPoint1(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::ClearSeedPoints1()

Remove all SeedPoints1 points.

*/
public  void clearSeedPoints1() {
    SimpleITKJNI.CollidingFrontsImageFilter_clearSeedPoints1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::SetSeedPoints2(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; SeedPoints2)

Set the container of Seed Points representing the second initial
front. Seed points are represented as a VectorContainer of LevelSetNodes.

*/
public  void setSeedPoints2(VectorUIntList SeedPoints2) {
    SimpleITKJNI.CollidingFrontsImageFilter_setSeedPoints2(swigCPtr, this, VectorUIntList.getCPtr(SeedPoints2), SeedPoints2);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::CollidingFrontsImageFilter::GetSeedPoints2() const

Get the container of Seed Points representing the second initial
front.

*/
public  VectorUIntList getSeedPoints2() {
    return new VectorUIntList(SimpleITKJNI.CollidingFrontsImageFilter_getSeedPoints2(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::AddSeedPoint2(std::vector&lt; unsigned int &gt; point)

Add SeedPoints2 point.

*/
public  void addSeedPoint2(VectorUInt32 point) {
    SimpleITKJNI.CollidingFrontsImageFilter_addSeedPoint2(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::ClearSeedPoints2()

Remove all SeedPoints2 points.

*/
public  void clearSeedPoints2() {
    SimpleITKJNI.CollidingFrontsImageFilter_clearSeedPoints2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::SetApplyConnectivity(bool ApplyConnectivity)
*/
public  void setApplyConnectivity(boolean ApplyConnectivity) {
    SimpleITKJNI.CollidingFrontsImageFilter_setApplyConnectivity(swigCPtr, this, ApplyConnectivity);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOn()

Set the value of ApplyConnectivity to true or false respectfully.

*/
public  void applyConnectivityOn() {
    SimpleITKJNI.CollidingFrontsImageFilter_applyConnectivityOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOff()
*/
public  void applyConnectivityOff() {
    SimpleITKJNI.CollidingFrontsImageFilter_applyConnectivityOff(swigCPtr, this);
  }

  /**
bool itk::simple::CollidingFrontsImageFilter::GetApplyConnectivity() const
*/
public  boolean getApplyConnectivity() {
    return SimpleITKJNI.CollidingFrontsImageFilter_getApplyConnectivity(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::SetNegativeEpsilon(double NegativeEpsilon)
*/
public  void setNegativeEpsilon(double NegativeEpsilon) {
    SimpleITKJNI.CollidingFrontsImageFilter_setNegativeEpsilon(swigCPtr, this, NegativeEpsilon);
  }

  /**
double itk::simple::CollidingFrontsImageFilter::GetNegativeEpsilon() const
*/
public  double getNegativeEpsilon() {
    return SimpleITKJNI.CollidingFrontsImageFilter_getNegativeEpsilon(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::SetStopOnTargets(bool StopOnTargets)
*/
public  void setStopOnTargets(boolean StopOnTargets) {
    SimpleITKJNI.CollidingFrontsImageFilter_setStopOnTargets(swigCPtr, this, StopOnTargets);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::StopOnTargetsOn()

Set the value of StopOnTargets to true or false respectfully.

*/
public  void stopOnTargetsOn() {
    SimpleITKJNI.CollidingFrontsImageFilter_stopOnTargetsOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CollidingFrontsImageFilter::StopOnTargetsOff()
*/
public  void stopOnTargetsOff() {
    SimpleITKJNI.CollidingFrontsImageFilter_stopOnTargetsOff(swigCPtr, this);
  }

  /**
bool itk::simple::CollidingFrontsImageFilter::GetStopOnTargets() const
*/
public  boolean getStopOnTargets() {
    return SimpleITKJNI.CollidingFrontsImageFilter_getStopOnTargets(swigCPtr, this);
  }

  /**
std::string itk::simple::CollidingFrontsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CollidingFrontsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CollidingFrontsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CollidingFrontsImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CollidingFrontsImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CollidingFrontsImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
