/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segments structures in images based on a user supplied edge potential
map.


IMPORTANT
The SegmentationLevelSetImageFilter class and the ShapeDetectionLevelSetFunction class contain additional information necessary to gain full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. An initial
contour is propagated outwards (or inwards) until it ''sticks'' to the
shape boundaries. This is done by using a level set speed function
based on a user supplied edge potential map. This approach for
segmentation follows that of Malladi et al (1995).
INPUTS
This filter requires two inputs. The first input is a initial level
set. The initial level set is a real image which contains the initial
contour/surface as the zero level set. For example, a signed distance
function from the initial contour/surface is typically used. Note that
for this algorithm the initial contour has to be wholly within (or
wholly outside) the structure to be segmented.

The second input is the feature image. For this filter, this is the
edge potential map. General characteristics of an edge potential map
is that it has values close to zero in regions near the edges and
values close to one inside the shape itself. Typically, the edge
potential map is compute from the image gradient, for example:
\\[ g(I) = 1 / ( 1 + | (\\nabla * G)(I)| ) \\] \\[ g(I) = \\exp^{-|(\\nabla * G)(I)|} \\]

where $ I $ is image intensity and $ (\\nabla * G) $ is the derivative of Gaussian operator.


See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.
PARAMETERS
The PropagationScaling parameter can be used to switch from
propagation outwards (POSITIVE scaling parameter) versus propagating
inwards (NEGATIVE scaling parameter).
 The smoothness of the resulting contour/surface can be adjusted using
a combination of PropagationScaling and CurvatureScaling parameters.
The larger the CurvatureScaling parameter, the smoother the resulting
contour. The CurvatureScaling parameter should be non-negative for
proper operation of this algorithm. To follow the implementation in
Malladi et al paper, set the PropagationScaling to $\\pm 1.0$ and CurvatureScaling to $ \\epsilon $ .

Note that there is no advection term for this filter. Setting the
advection scaling will have no effect.

OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative
values in the output image represent the inside of the segmented
region and positive values in the image represent the outside of the
segmented region. The zero crossings of the image correspond to the
position of the propagating front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
REFERENCES

"Shape Modeling with Front Propagation: A Level Set Approach", R.
Malladi, J. A. Sethian and B. C. Vermuri. IEEE Trans. on Pattern
Analysis and Machine Intelligence, Vol 17, No. 2, pp 158-174, February
1995

See:
 SegmentationLevelSetImageFilter

 ShapeDetectionLevelSetFunction

 SparseFieldLevelSetImageFilter

 itk::simple::ShapeDetectionLevelSet for the procedural interface

 itk::ShapeDetectionLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkShapeDetectionLevelSetImageFilter.h
*/
public class ShapeDetectionLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ShapeDetectionLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ShapeDetectionLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ShapeDetectionLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ShapeDetectionLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ShapeDetectionLevelSetImageFilter::~ShapeDetectionLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ShapeDetectionLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ShapeDetectionLevelSetImageFilter::ShapeDetectionLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ShapeDetectionLevelSetImageFilter() {
    this(SimpleITKJNI.new_ShapeDetectionLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::ShapeDetectionLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public  void setPropagationScaling(double PropagationScaling) {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_setPropagationScaling(swigCPtr, this, PropagationScaling);
  }

  /**
double itk::simple::ShapeDetectionLevelSetImageFilter::GetPropagationScaling() const
*/
public  double getPropagationScaling() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getPropagationScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public  void setCurvatureScaling(double CurvatureScaling) {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_setCurvatureScaling(swigCPtr, this, CurvatureScaling);
  }

  /**
double itk::simple::ShapeDetectionLevelSetImageFilter::GetCurvatureScaling() const
*/
public  double getCurvatureScaling() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getCurvatureScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::ShapeDetectionLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public  void setReverseExpansionDirection(boolean ReverseExpansionDirection) {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_setReverseExpansionDirection(swigCPtr, this, ReverseExpansionDirection);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public  void reverseExpansionDirectionOn() {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_reverseExpansionDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShapeDetectionLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public  void reverseExpansionDirectionOff() {
    SimpleITKJNI.ShapeDetectionLevelSetImageFilter_reverseExpansionDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::ShapeDetectionLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public  boolean getReverseExpansionDirection() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getReverseExpansionDirection(swigCPtr, this);
  }

  /**
uint32_t itk::simple::ShapeDetectionLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::ShapeDetectionLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::ShapeDetectionLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ShapeDetectionLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ShapeDetectionLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ShapeDetectionLevelSetImageFilter::Execute(Image &amp;&amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.ShapeDetectionLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
