/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/nrf/51/irq.json
 */

#ifndef LIBOPENCM3_NRF51_NVIC_H
#define LIBOPENCM3_NRF51_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for Nordic Semi NRF51 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_POWER_CLOCK_IRQ 0
#define NVIC_RADIO_IRQ 1
#define NVIC_UART0_IRQ 2
#define NVIC_SPI0_TWI0_IRQ 3
#define NVIC_SPI1_TWI1_IRQ 4
#define NVIC_RESERVED0_IRQ 5
#define NVIC_GPIOTE_IRQ 6
#define NVIC_ADC_IRQ 7
#define NVIC_TIMER0_IRQ 8
#define NVIC_TIMER1_IRQ 9
#define NVIC_TIMER2_IRQ 10
#define NVIC_RTC0_IRQ 11
#define NVIC_TEMP_IRQ 12
#define NVIC_RNG_IRQ 13
#define NVIC_ECB_IRQ 14
#define NVIC_CCM_AAR_IRQ 15
#define NVIC_WDT_IRQ 16
#define NVIC_RTC1_IRQ 17
#define NVIC_QDEC_IRQ 18
#define NVIC_LPCOMP_IRQ 19
#define NVIC_SWI0_IRQ 20
#define NVIC_SWI1_IRQ 21
#define NVIC_SWI2_IRQ 22
#define NVIC_SWI3_IRQ 23
#define NVIC_SWI4_IRQ 24
#define NVIC_SWI5_IRQ 25

#define NVIC_IRQ_COUNT 26

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_NRF51 User interrupt service routines (ISR) prototypes for Nordic Semi NRF51 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void power_clock_isr(void);
void radio_isr(void);
void uart0_isr(void);
void spi0_twi0_isr(void);
void spi1_twi1_isr(void);
void reserved0_isr(void);
void gpiote_isr(void);
void adc_isr(void);
void timer0_isr(void);
void timer1_isr(void);
void timer2_isr(void);
void rtc0_isr(void);
void temp_isr(void);
void rng_isr(void);
void ecb_isr(void);
void ccm_aar_isr(void);
void wdt_isr(void);
void rtc1_isr(void);
void qdec_isr(void);
void lpcomp_isr(void);
void swi0_isr(void);
void swi1_isr(void);
void swi2_isr(void);
void swi3_isr(void);
void swi4_isr(void);
void swi5_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_NRF51_NVIC_H */
