/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class TemporalRoutingProcessor
extends AbstractProcessor {
    public static final String TYPE = "temporal_routing";
    private static final String DEFAULT_FORMAT = "strict_date_optional_time";
    private final String timestampField;
    private final Granularity granularity;
    private final DateFormatter dateFormatter;
    private final boolean ignoreMissing;
    private final boolean overrideExisting;
    private final boolean hashBucket;

    TemporalRoutingProcessor(String tag, @Nullable String description, String timestampField, Granularity granularity, String format, boolean ignoreMissing, boolean overrideExisting, boolean hashBucket) {
        super(tag, description);
        this.timestampField = timestampField;
        this.granularity = granularity;
        this.dateFormatter = DateFormatter.forPattern((String)format);
        this.ignoreMissing = ignoreMissing;
        this.overrideExisting = overrideExisting;
        this.hashBucket = hashBucket;
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        Object timestampValue;
        if (!this.overrideExisting) {
            try {
                Object existingRouting = document.getFieldValue("_routing", Object.class, true);
                if (existingRouting != null) {
                    return document;
                }
            }
            catch (Exception existingRouting) {
                // empty catch block
            }
        }
        if ((timestampValue = document.getFieldValue(this.timestampField, Object.class, this.ignoreMissing)) == null && this.ignoreMissing) {
            return document;
        }
        if (timestampValue == null) {
            throw new IllegalArgumentException("field [" + this.timestampField + "] not present as part of path [" + this.timestampField + "]");
        }
        String routingValue = this.computeRoutingValue(timestampValue.toString());
        document.setFieldValue("_routing", (Object)routingValue);
        return document;
    }

    private String computeRoutingValue(String timestamp) {
        TemporalAccessor accessor = this.dateFormatter.parse(timestamp);
        ZonedDateTime dateTime = DateFormatters.from((TemporalAccessor)accessor, (Locale)Locale.ROOT, (ZoneId)ZoneOffset.UTC);
        ZonedDateTime truncated = this.truncateToGranularity(dateTime);
        String temporalBucket = this.createTemporalBucketKey(truncated);
        if (this.hashBucket) {
            byte[] bucketBytes = temporalBucket.getBytes(StandardCharsets.UTF_8);
            long hash = MurmurHash3.hash128((byte[])bucketBytes, (int)0, (int)bucketBytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
            return String.valueOf(hash == Long.MIN_VALUE ? 0L : (hash < 0L ? -hash : hash));
        }
        return temporalBucket;
    }

    private ZonedDateTime truncateToGranularity(ZonedDateTime dateTime) {
        switch (this.granularity.ordinal()) {
            case 0: {
                return dateTime.withMinute(0).withSecond(0).withNano(0);
            }
            case 1: {
                return dateTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
            case 2: {
                ZonedDateTime dayTruncated = dateTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
                return dayTruncated.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            }
            case 3: {
                return dateTime.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
        }
        throw new IllegalArgumentException("Unsupported granularity: " + String.valueOf((Object)this.granularity));
    }

    private String createTemporalBucketKey(ZonedDateTime truncated) {
        switch (this.granularity.ordinal()) {
            case 0: {
                return truncated.getYear() + "-" + String.format(Locale.ROOT, "%02d", truncated.getMonthValue()) + "-" + String.format(Locale.ROOT, "%02d", truncated.getDayOfMonth()) + "T" + String.format(Locale.ROOT, "%02d", truncated.getHour());
            }
            case 1: {
                return truncated.getYear() + "-" + String.format(Locale.ROOT, "%02d", truncated.getMonthValue()) + "-" + String.format(Locale.ROOT, "%02d", truncated.getDayOfMonth());
            }
            case 2: {
                int weekOfYear = truncated.get(WeekFields.ISO.weekOfWeekBasedYear());
                int weekYear = truncated.get(WeekFields.ISO.weekBasedYear());
                return weekYear + "-W" + String.format(Locale.ROOT, "%02d", weekOfYear);
            }
            case 3: {
                return truncated.getYear() + "-" + String.format(Locale.ROOT, "%02d", truncated.getMonthValue());
            }
        }
        throw new IllegalArgumentException("Unsupported granularity: " + String.valueOf((Object)this.granularity));
    }

    public String getType() {
        return TYPE;
    }

    String getTimestampField() {
        return this.timestampField;
    }

    Granularity getGranularity() {
        return this.granularity;
    }

    DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    boolean isOverrideExisting() {
        return this.overrideExisting;
    }

    boolean isHashBucket() {
        return this.hashBucket;
    }

    public static enum Granularity {
        HOUR(ChronoUnit.HOURS),
        DAY(ChronoUnit.DAYS),
        WEEK(ChronoUnit.WEEKS),
        MONTH(ChronoUnit.MONTHS);

        private final ChronoUnit chronoUnit;

        private Granularity(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public static Granularity fromString(String value) {
            try {
                return Granularity.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid granularity: " + value + ". Supported values are: hour, day, week, month");
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public TemporalRoutingProcessor create(Map<String, Processor.Factory> processorFactories, String tag, @Nullable String description, Map<String, Object> config) throws Exception {
            Granularity granularity;
            String timestampField = ConfigurationUtils.readStringProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"timestamp_field");
            String granularityStr = ConfigurationUtils.readStringProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"granularity");
            String format = ConfigurationUtils.readOptionalStringProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"format");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            boolean overrideExisting = ConfigurationUtils.readBooleanProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"override_existing", (boolean)true);
            boolean hashBucket = ConfigurationUtils.readBooleanProperty((String)TemporalRoutingProcessor.TYPE, (String)tag, config, (String)"hash_bucket", (boolean)false);
            if (format == null) {
                format = TemporalRoutingProcessor.DEFAULT_FORMAT;
            }
            if (Strings.isNullOrEmpty((String)timestampField)) {
                throw ConfigurationUtils.newConfigurationException((String)TemporalRoutingProcessor.TYPE, (String)tag, (String)"timestamp_field", (String)"cannot be null or empty");
            }
            if (Strings.isNullOrEmpty((String)granularityStr)) {
                throw ConfigurationUtils.newConfigurationException((String)TemporalRoutingProcessor.TYPE, (String)tag, (String)"granularity", (String)"cannot be null or empty");
            }
            try {
                granularity = Granularity.fromString(granularityStr);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)TemporalRoutingProcessor.TYPE, (String)tag, (String)"granularity", (String)e.getMessage());
            }
            try {
                DateFormatter.forPattern((String)format);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)TemporalRoutingProcessor.TYPE, (String)tag, (String)"format", (String)("invalid date format: " + e.getMessage()));
            }
            return new TemporalRoutingProcessor(tag, description, timestampField, granularity, format, ignoreMissing, overrideExisting, hashBucket);
        }
    }
}

