/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Expires;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;

public class TimestampImpl
extends AbstractWSSecurityObject
implements Timestamp {
    @Nullable
    private String id;
    @Nullable
    private Created created;
    @Nullable
    private Expires expires;
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap(this);
    @Nonnull
    private final IndexedXMLObjectChildrenList<XMLObject> unknownChildren = new IndexedXMLObjectChildrenList(this);

    public TimestampImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public Created getCreated() {
        return this.created;
    }

    @Override
    @Nullable
    public Expires getExpires() {
        return this.expires;
    }

    @Override
    public void setCreated(@Nullable Created newCreated) {
        this.created = this.prepareForAssignment(this.created, newCreated);
    }

    @Override
    public void setExpires(@Nullable Expires newExpires) {
        this.expires = this.prepareForAssignment(this.expires, newExpires);
    }

    @Override
    @Nullable
    public String getWSUId() {
        return this.id;
    }

    @Override
    public void setWSUId(@Nullable String newId) {
        String oldId = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldId, this.id);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.id != null);
    }

    @Override
    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Override
    @Nonnull
    public List<XMLObject> getUnknownXMLObjects() {
        return this.unknownChildren;
    }

    @Override
    @Nonnull
    public List<XMLObject> getUnknownXMLObjects(@Nonnull QName typeOrName) {
        return this.unknownChildren.subList(typeOrName);
    }

    @Override
    @Nullable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        if (this.created != null) {
            children.add(this.created);
        }
        if (this.expires != null) {
            children.add(this.expires);
        }
        children.addAll(this.getUnknownXMLObjects());
        return CollectionSupport.copyToList(children);
    }
}

