\name{LoggerBase}
\alias{LoggerBase}
\title{LoggerBase}
\Rdversion{1.1}
\docType{class}
\description{
A base class to handle SimpleITK and ITK messages and logging.
LoggerBase}
\details{
In ITK this function is implemented by the itk::OutputWindow, but in SimpleITK it is called a logger.
Provides a base class for SimpleITK to provide the "DisplayText"
methods that match the interface of itk::OutputWindow. Derived instances of LoggerBase are used by an internal adaptor derived from the itk::OutputWindow so that this object instances can be used in ITK.
/sa itk::OutputWindow
LoggerBase}
%C++ includes: sitkLogger.h
\section{Methods}{
\describe{
\item{void DisplayDebugText(const char *t):}{}
\item{void DisplayErrorText(const char *t):}{}
\item{void DisplayGenericOutputText(const char *t):}{}
\item{void DisplayText(const char *t)=0:}{}
\item{void DisplayWarningText(const char *t):}{}
\item{std::string GetName() const override:}{
Set object name.
}
\item{ LoggerBase()=default:}{}
\item{ITKLogger SetAsGlobalITKLogger():}{
Set this logger instance to the ITK output window.
After calling this method, all ITK and SimpleITK display, warning and
error texts will be handled by this object's methods.
An ITKLogger object holding the previous itk::OutputWindow instance. The returned object can be used to restore the original
instance.
}
\item{void SetName(const std::string &n) override:}{
Get object name.
}
\item{ ~LoggerBase() override:}{}
}
}
