/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVDialectBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.CSVDialectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.csv.CSVModuleBuiltins;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CSVDialect})
public final class CSVDialectBuiltins
extends PythonBuiltins {
    private static final String J_ATTR_DOUBLEQUOTE = "doublequote";
    private static final String J_ATTR_ESCAPECHAR = "escapechar";
    private static final String J_ATTR_LINETERMINATOR = "lineterminator";
    private static final String J_ATTR_QUOTING = "quoting";
    private static final String J_ATTR_QUOTECHAR = "quotechar";
    private static final String J_ATTR_SKIPINITIALSPACE = "skipinitialspace";
    private static final String J_ATTR_STRICT = "strict";
    private static final TruffleString T_ATTR_SKIPINITIALSPACE = PythonUtils.tsLiteral("skipinitialspace");
    private static final TruffleString T_ATTR_QUOTECHAR = PythonUtils.tsLiteral("quotechar");
    private static final TruffleString T_ATTR_QUOTING = PythonUtils.tsLiteral("quoting");
    private static final TruffleString T_ATTR_LINETERMINATOR = PythonUtils.tsLiteral("lineterminator");
    private static final TruffleString T_ATTR_ESCAPECHAR = PythonUtils.tsLiteral("escapechar");
    private static final TruffleString T_ATTR_DOUBLEQUOTE = PythonUtils.tsLiteral("doublequote");
    private static final TruffleString T_ATTR_DELIMITER = PythonUtils.tsLiteral("delimiter");
    private static final TruffleString T_ATTR_STRICT = StringLiterals.T_STRICT;
    private static final TruffleString T_NOT_SET = PythonUtils.tsLiteral("NOT_SET");
    public static final TpSlots SLOTS = CSVDialectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVDialectBuiltinsFactory.getFactories();
    }

    @Builtin(name="strict", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StrictNode
    extends PythonUnaryBuiltinNode {
        StrictNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.strict;
        }
    }

    @Builtin(name="skipinitialspace", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SkipInitialSpaceNode
    extends PythonUnaryBuiltinNode {
        SkipInitialSpaceNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.skipInitialSpace;
        }
    }

    @Builtin(name="quoting", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class QuotingNode
    extends PythonUnaryBuiltinNode {
        QuotingNode() {
        }

        @Specialization
        static int doIt(CSVDialect self) {
            return self.quoting.ordinal();
        }
    }

    @Builtin(name="quotechar", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class QuoteCharNode
    extends PythonUnaryBuiltinNode {
        QuoteCharNode() {
        }

        @Specialization
        static Object doIt(CSVDialect self) {
            return self.quoteCharCodePoint == -1 ? PNone.NONE : self.quoteChar;
        }
    }

    @Builtin(name="lineterminator", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class LineTerminatorNode
    extends PythonUnaryBuiltinNode {
        LineTerminatorNode() {
        }

        @Specialization
        static TruffleString doIt(CSVDialect self) {
            return self.lineTerminator;
        }
    }

    @Builtin(name="escapechar", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EscapeCharNode
    extends PythonUnaryBuiltinNode {
        EscapeCharNode() {
        }

        @Specialization
        static Object doIt(CSVDialect self) {
            return self.escapeCharCodePoint == -1 ? PNone.NONE : self.escapeChar;
        }
    }

    @Builtin(name="doublequote", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DoubleQuoteNode
    extends PythonUnaryBuiltinNode {
        DoubleQuoteNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.doubleQuote;
        }
    }

    @Builtin(name="delimiter", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DelimiterNode
    extends PythonUnaryBuiltinNode {
        DelimiterNode() {
        }

        @Specialization
        static Object doIt(CSVDialect self) {
            return self.delimiterCodePoint == -1 ? PNone.NONE : self.delimiter;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="CSVDialect", parameterNames={"class", "dialect", "delimiter", "doublequote", "escapechar", "lineterminator", "quotechar", "quoting", "skipinitialspace", "strict"})
    @GenerateNodeFactory
    public static abstract class DialectNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doCSVDialectWithoutKeywords(PythonBuiltinClassType cls, CSVDialect dialect, PNone delimiter, PNone doublequote, PNone escapechar, PNone lineterminator, PNone quotechar, PNone quoting, PNone skipinitialspace, PNone strict) {
            return dialect;
        }

        @Specialization
        static CSVDialect doStringWithoutKeywords(VirtualFrame frame, PythonBuiltinClassType cls, TruffleString dialectName, PNone delimiter, PNone doublequote, PNone escapechar, PNone lineterminator, PNone quotechar, PNone quoting, PNone skipinitialspace, PNone strict, @Bind Node inliningTarget, @Cached.Exclusive @Cached CSVModuleBuiltins.CSVGetDialectNode getDialect) {
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(CSVModuleBuiltins.T__CSV);
            return getDialect.execute(frame, module, dialectName);
        }

        @Specialization
        static Object doNoDialectObj(VirtualFrame frame, PythonBuiltinClassType cls, PNone dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return DialectNode.createCSVDialect(frame, inliningTarget, (Object)cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doStringWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, TruffleString dialectName, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached CSVModuleBuiltins.CSVGetDialectNode getDialect, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(CSVModuleBuiltins.T__CSV);
            CSVDialect dialectObj = getDialect.execute(frame, module, dialectName);
            if (delimiterObj == PNone.NO_VALUE) {
                delimiterObj = dialectObj.delimiter;
            }
            if (doublequoteObj == PNone.NO_VALUE) {
                doublequoteObj = dialectObj.doubleQuote;
            }
            if (escapecharObj == PNone.NO_VALUE) {
                escapecharObj = dialectObj.escapeChar;
            }
            if (lineterminatorObj == PNone.NO_VALUE) {
                lineterminatorObj = dialectObj.lineTerminator;
            }
            if (quotingObj == PNone.NO_VALUE) {
                quotingObj = dialectObj.quoting;
            }
            if (quotecharObj == PNone.NO_VALUE) {
                quotecharObj = dialectObj.quoteChar;
            }
            if (skipinitialspaceObj == PNone.NO_VALUE) {
                skipinitialspaceObj = dialectObj.skipInitialSpace;
            }
            if (strictObj == PNone.NO_VALUE) {
                strictObj = dialectObj.strict;
            }
            return DialectNode.createCSVDialect(frame, inliningTarget, (Object)cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doDialectClassWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, PythonClass dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectLookupAttr getFirstAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getSecondAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getThirdAttributesNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            delimiterObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, delimiterObj, T_ATTR_DELIMITER, getFirstAttributesNode);
            doublequoteObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, doublequoteObj, T_ATTR_DOUBLEQUOTE, getFirstAttributesNode);
            escapecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, escapecharObj, T_ATTR_ESCAPECHAR, getFirstAttributesNode);
            lineterminatorObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, lineterminatorObj, T_ATTR_LINETERMINATOR, getSecondAttributesNode);
            quotecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotecharObj, T_ATTR_QUOTECHAR, getSecondAttributesNode);
            quotingObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotingObj, T_ATTR_QUOTING, getSecondAttributesNode);
            skipinitialspaceObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, skipinitialspaceObj, T_ATTR_SKIPINITIALSPACE, getThirdAttributesNode);
            strictObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, strictObj, T_ATTR_STRICT, getThirdAttributesNode);
            return DialectNode.createCSVDialect(frame, inliningTarget, (Object)cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization
        static Object doPStringWithKeywords(VirtualFrame frame, PythonBuiltinClassType cls, PString dialectName, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached CSVModuleBuiltins.CSVGetDialectNode getDialect, @Cached CastToTruffleStringNode castToStringNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString dialectNameStr = castToStringNode.execute(inliningTarget, dialectName);
            PythonModule module = PythonContext.get(inliningTarget).lookupBuiltinModule(CSVModuleBuiltins.T__CSV);
            CSVDialect dialectObj = getDialect.execute(frame, module, dialectNameStr);
            if (delimiterObj == PNone.NO_VALUE) {
                delimiterObj = dialectObj.delimiter;
            }
            if (doublequoteObj == PNone.NO_VALUE) {
                doublequoteObj = dialectObj.doubleQuote;
            }
            if (escapecharObj == PNone.NO_VALUE) {
                escapecharObj = dialectObj.escapeChar;
            }
            if (lineterminatorObj == PNone.NO_VALUE) {
                lineterminatorObj = dialectObj.lineTerminator;
            }
            if (quotingObj == PNone.NO_VALUE) {
                quotingObj = dialectObj.quoting;
            }
            if (quotecharObj == PNone.NO_VALUE) {
                quotecharObj = dialectObj.quoteChar;
            }
            if (skipinitialspaceObj == PNone.NO_VALUE) {
                skipinitialspaceObj = dialectObj.skipInitialSpace;
            }
            if (strictObj == PNone.NO_VALUE) {
                strictObj = dialectObj.strict;
            }
            return DialectNode.createCSVDialect(frame, inliningTarget, (Object)cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        @Specialization(guards={"!isCSVDialect(dialectObj)", "!isPythonClass(dialectObj)", "!isString(dialectObj)", "!isPNone(dialectObj)"})
        static Object doGeneric(VirtualFrame frame, Object cls, Object dialectObj, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectLookupAttr getFirstAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getSecondAttributesNode, @Cached.Exclusive @Cached PyObjectLookupAttr getThirdAttributesNode, @Cached.Exclusive @Cached PyObjectIsTrueNode isTrueNode, @Cached.Exclusive @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached.Exclusive @Cached PyLongAsIntNode pyLongAsIntNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            delimiterObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, delimiterObj, T_ATTR_DELIMITER, getFirstAttributesNode);
            doublequoteObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, doublequoteObj, T_ATTR_DOUBLEQUOTE, getFirstAttributesNode);
            escapecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, escapecharObj, T_ATTR_ESCAPECHAR, getFirstAttributesNode);
            lineterminatorObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, lineterminatorObj, T_ATTR_LINETERMINATOR, getSecondAttributesNode);
            quotingObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotingObj, T_ATTR_QUOTING, getSecondAttributesNode);
            quotecharObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, quotecharObj, T_ATTR_QUOTECHAR, getSecondAttributesNode);
            skipinitialspaceObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, skipinitialspaceObj, T_ATTR_SKIPINITIALSPACE, getThirdAttributesNode);
            strictObj = DialectNode.getAttributeValue(frame, inliningTarget, dialectObj, strictObj, T_ATTR_STRICT, getThirdAttributesNode);
            return DialectNode.createCSVDialect(frame, inliningTarget, cls, delimiterObj, doublequoteObj, escapecharObj, lineterminatorObj, quotecharObj, quotingObj, skipinitialspaceObj, strictObj, isTrueNode, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
        }

        protected static boolean isCSVDialect(Object dialect) {
            return dialect instanceof CSVDialect;
        }

        private static Object createCSVDialect(VirtualFrame frame, Node inliningTarget, Object cls, Object delimiterObj, Object doublequoteObj, Object escapecharObj, Object lineterminatorObj, Object quotecharObj, Object quotingObj, Object skipinitialspaceObj, Object strictObj, PyObjectIsTrueNode isTrueNode, PyLongCheckExactNode pyLongCheckExactNode, PyLongAsIntNode pyLongAsIntNode, PRaiseNode raiseNode) {
            TruffleString delimiter = DialectNode.getChar(inliningTarget, T_ATTR_DELIMITER, delimiterObj, StringLiterals.T_COMMA, false);
            boolean doubleQuote = DialectNode.getBoolean(frame, doublequoteObj, true, isTrueNode);
            TruffleString escapeChar = DialectNode.getChar(inliningTarget, T_ATTR_ESCAPECHAR, escapecharObj, T_NOT_SET, true);
            TruffleString lineTerminator = DialectNode.getString(inliningTarget, T_ATTR_LINETERMINATOR, lineterminatorObj, StringLiterals.T_CRLF);
            TruffleString quoteChar = DialectNode.getChar(inliningTarget, T_ATTR_QUOTECHAR, quotecharObj, StringLiterals.T_DOUBLE_QUOTE, true);
            QuoteStyle quoting = DialectNode.getQuotingValue(frame, inliningTarget, T_ATTR_QUOTING, quotingObj, QuoteStyle.QUOTE_MINIMAL, pyLongCheckExactNode, pyLongAsIntNode, raiseNode);
            boolean skipInitialSpace = DialectNode.getBoolean(frame, skipinitialspaceObj, false, isTrueNode);
            boolean strict = DialectNode.getBoolean(frame, strictObj, false, isTrueNode);
            if (quotecharObj == PNone.NONE && quotingObj == PNone.NO_VALUE) {
                quoting = QuoteStyle.QUOTE_NONE;
            }
            return DialectNode.createCSVDialect(inliningTarget, cls, delimiter, doubleQuote, escapeChar, lineTerminator, quoteChar, quoting, skipInitialSpace, strict);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object createCSVDialect(Node raisingNode, Object cls, TruffleString delimiter, boolean doubleQuote, TruffleString escapeChar, TruffleString lineTerminator, TruffleString quoteChar, QuoteStyle quoting, boolean skipInitialSpace, boolean strict) {
            if (TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)delimiter, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.DELIMITER_MUST_BE_ONE_CHAR_STRING);
            }
            if (quoting != QuoteStyle.QUOTE_NONE && TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)quoteChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.QUOTECHAR_MUST_BE_SET_IF_QUOTING_ENABLED);
            }
            if (lineTerminator == null) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.LINETERMINATOR_MUST_BE_SET);
            }
            int delimiterCodePoint = TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)delimiter, 0, PythonUtils.TS_ENCODING);
            int escapeCharCodePoint = TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)escapeChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING) ? -1 : TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)escapeChar, 0, PythonUtils.TS_ENCODING);
            int quoteCharCodePoint = TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)quoteChar, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING) ? -1 : TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)quoteChar, 0, PythonUtils.TS_ENCODING);
            return PFactory.createCSVDialect(PythonLanguage.get(null), cls, TypeNodes.GetInstanceShape.executeUncached(cls), delimiter, delimiterCodePoint, doubleQuote, escapeChar, escapeCharCodePoint, lineTerminator, quoteChar, quoteCharCodePoint, quoting, skipInitialSpace, strict);
        }

        private static Object getAttributeValue(VirtualFrame frame, Node inliningTarget, Object dialect, Object inputValue, TruffleString attributeName, PyObjectLookupAttr getAttributeNode) {
            if (inputValue != PNone.NO_VALUE) {
                return inputValue;
            }
            return getAttributeNode.execute((Frame)frame, inliningTarget, dialect, attributeName);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getChar(Node raisingNode, TruffleString name, Object valueObj, TruffleString defaultValue, boolean optional) {
            TruffleString charValue;
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (optional && valueObj == PNone.NONE) {
                return T_NOT_SET;
            }
            try {
                charValue = CastToTruffleStringNode.executeUncached(valueObj);
            }
            catch (CannotCastException e) {
                TruffleString format = optional ? ErrorMessages.S_MUST_BE_STRING_OR_NONE_NOT_S : ErrorMessages.S_MUST_BE_STRING_NOT_S;
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, format, name, GetClassNode.executeUncached(valueObj));
            }
            if (optional && TruffleString.EqualNode.getUncached().execute((AbstractTruffleString)charValue, (AbstractTruffleString)T_NOT_SET, PythonUtils.TS_ENCODING)) {
                return T_NOT_SET;
            }
            if (TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)charValue, PythonUtils.TS_ENCODING) != 1) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.MUST_BE_ONE_CHARACTER_STRING, name);
            }
            return charValue;
        }

        private static boolean getBoolean(VirtualFrame frame, Object valueObj, boolean defaultValue, PyObjectIsTrueNode isTrueNode) {
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            return isTrueNode.execute((Frame)frame, valueObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getString(Node raisingNode, TruffleString attribute, Object valueObj, TruffleString defaultValue) {
            TruffleString value;
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (valueObj == PNone.NONE) {
                return null;
            }
            try {
                value = CastToTruffleStringNode.executeUncached(valueObj);
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRING_QUOTED, attribute);
            }
            return value;
        }

        private static QuoteStyle getQuotingValue(VirtualFrame frame, Node inliningTarget, TruffleString name, Object valueObj, QuoteStyle defaultValue, PyLongCheckExactNode pyLongCheckExactNode, PyLongAsIntNode pyLongAsIntNode, PRaiseNode raiseNode) {
            if (valueObj == PNone.NO_VALUE) {
                return defaultValue;
            }
            if (valueObj instanceof QuoteStyle) {
                return (QuoteStyle)((Object)valueObj);
            }
            if (!pyLongCheckExactNode.execute(inliningTarget, valueObj)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.MUST_BE_INTEGER_QUOTED_ATTR, name);
            }
            int value = pyLongAsIntNode.execute((Frame)frame, inliningTarget, valueObj);
            if (!QuoteStyle.containsOrdinalValue(value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BAD_QUOTING_VALUE);
            }
            return QuoteStyle.getQuoteStyle(value);
        }
    }
}

