/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class, PythonOptions.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class ReadAttributeFromPythonObjectNode
extends PNodeWithContext {
    @NeverDefault
    public static ReadAttributeFromPythonObjectNode create() {
        return ReadAttributeFromPythonObjectNodeGen.create();
    }

    public static ReadAttributeFromPythonObjectNode getUncached() {
        return ReadAttributeFromPythonObjectNodeGen.getUncached();
    }

    public static Object executeUncached(PythonObject object, TruffleString key, Object defaultValue) {
        return ReadAttributeFromPythonObjectNode.getUncached().execute(object, key, defaultValue);
    }

    public abstract Object execute(PythonObject var1, TruffleString var2, Object var3);

    public final Object execute(PythonObject object, TruffleString key) {
        return this.execute(object, key, (Object)PNone.NO_VALUE);
    }

    public abstract Object execute(DynamicObject var1, TruffleString var2, Object var3);

    protected static Object getAttribute(DynamicObject object, TruffleString key, Object defaultValue) {
        return DynamicObjectLibrary.getUncached().getOrDefault(object, (Object)key, defaultValue);
    }

    @Idempotent
    protected static boolean isLongLivedObject(DynamicObject object) {
        return object instanceof PythonModule || object instanceof PythonManagedClass;
    }

    @Idempotent
    protected static boolean isPrimitive(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double;
    }

    @NonIdempotent
    protected static boolean locationIsAssumedFinal(Location loc) {
        return loc != null && loc.isAssumedFinal();
    }

    protected static Location getLocationOrNull(Property prop) {
        return prop == null ? null : prop.getLocation();
    }

    @Specialization(limit="1", guards={"isSingleContext()", "dynamicObject == cachedObject", "isLongLivedObject(cachedObject)", "key == cachedKey", "dynamicObject.getShape() == cachedShape", "locationIsAssumedFinal(loc)", "!isPrimitive(value)"}, assumptions={"cachedShape.getValidAssumption()", "loc.getFinalAssumption()"})
    protected static Object readFinalAttr(DynamicObject dynamicObject, TruffleString key, Object defaultValue, @Cached(value="key") TruffleString cachedKey, @Cached(value="dynamicObject", weak=true) DynamicObject cachedObject, @Cached(value="dynamicObject.getShape()") Shape cachedShape, @Cached(value="getLocationOrNull(cachedShape.getProperty(cachedKey))") Location loc, @Cached(value="dynamicObject.getShape().getPropertyAssumption(key)") Assumption propertyAssumption, @Cached(value="getAttribute(dynamicObject, key, defaultValue)", weak=true) Object value) {
        return value;
    }

    @Specialization(limit="1", guards={"isSingleContext()", "dynamicObject == cachedObject", "isLongLivedObject(cachedObject)", "key == cachedKey", "dynamicObject.getShape() == cachedShape", "locationIsAssumedFinal(loc)", "isPrimitive(value)"}, assumptions={"cachedShape.getValidAssumption()", "loc.getFinalAssumption()"})
    protected static Object readFinalPrimitiveAttr(DynamicObject dynamicObject, TruffleString key, Object defaultValue, @Cached(value="key") TruffleString cachedKey, @Cached(value="dynamicObject", weak=true) DynamicObject cachedObject, @Cached(value="dynamicObject.getShape()") Shape cachedShape, @Cached(value="getLocationOrNull(cachedShape.getProperty(cachedKey))") Location loc, @Cached(value="dynamicObject.getShape().getPropertyAssumption(key)") Assumption propertyAssumption, @Cached(value="getAttribute(dynamicObject, key, defaultValue)") Object value) {
        return value;
    }

    @Specialization(limit="getAttributeAccessInlineCacheMaxDepth()", replaces={"readFinalAttr", "readFinalPrimitiveAttr"})
    protected static Object readDirect(DynamicObject dynamicObject, TruffleString key, Object defaultValue, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        return dylib.getOrDefault(dynamicObject, (Object)key, defaultValue);
    }
}

