/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.tz.TimeZoneDatatypeCoder;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

abstract class AbstractWithTimeZoneField
extends FBField {
    private ZoneId defaultZoneId;
    private final @NonNull TimeZoneDatatypeCoder.TimeZoneCodec timeZoneCodec;

    @NullMarked
    AbstractWithTimeZoneField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.timeZoneCodec = TimeZoneDatatypeCoder.getInstanceFor(this.getDatatypeCoder()).getTimeZoneCodecFor(fieldDescriptor);
    }

    @Override
    final OffsetDateTime getOffsetDateTime() throws SQLException {
        return this.timeZoneCodec.decodeOffsetDateTime(this.getFieldData());
    }

    @Override
    final void setOffsetDateTime(OffsetDateTime offsetDateTime) throws SQLException {
        this.setFieldData(this.getTimeZoneCodec().encodeOffsetDateTime(offsetDateTime));
    }

    @Override
    final OffsetTime getOffsetTime() throws SQLException {
        return this.timeZoneCodec.decodeOffsetTime(this.getFieldData());
    }

    @Override
    final void setOffsetTime(OffsetTime offsetTime) throws SQLException {
        this.setFieldData(this.timeZoneCodec.encodeOffsetTime(offsetTime));
    }

    @Override
    final ZonedDateTime getZonedDateTime() throws SQLException {
        return this.timeZoneCodec.decodeZonedDateTime(this.getFieldData());
    }

    @Override
    final void setZonedDateTime(ZonedDateTime zonedDateTime) throws SQLException {
        this.setFieldData(this.timeZoneCodec.encodeZonedDateTime(zonedDateTime));
    }

    @Override
    public Time getTime() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        return offsetDateTime != null ? new Time(offsetDateTime.toInstant().toEpochMilli()) : null;
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        return this.getTime();
    }

    @Override
    public void setTime(Time value) throws SQLException {
        this.setOffsetDateTime(value != null ? ZonedDateTime.of(LocalDate.now(), value.toLocalTime(), this.getDefaultZoneId()).toOffsetDateTime() : null);
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        this.setTime(value);
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        if (offsetDateTime == null) {
            return null;
        }
        Instant instant = offsetDateTime.toInstant();
        Timestamp timestamp = new Timestamp(instant.toEpochMilli());
        timestamp.setNanos(instant.getNano());
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        return this.getTimestamp();
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        this.setOffsetDateTime(value != null ? value.toLocalDateTime().atZone(this.getDefaultZoneId()).toOffsetDateTime() : null);
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        this.setTimestamp(value);
    }

    final @NonNull TimeZoneDatatypeCoder.TimeZoneCodec getTimeZoneCodec() {
        return this.timeZoneCodec;
    }

    final @NonNull ZoneId getDefaultZoneId() {
        if (this.defaultZoneId != null) {
            return this.defaultZoneId;
        }
        this.defaultZoneId = ZoneId.systemDefault();
        return this.defaultZoneId;
    }

    private void setStringParse(@NonNull String value) throws SQLException {
        if (value.indexOf(84) != -1) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(value);
            this.setOffsetDateTime(offsetDateTime);
        } else {
            OffsetTime offsetTime = OffsetTime.parse(value);
            this.setOffsetTime(offsetTime);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setStringParse(string);
        }
        catch (DateTimeParseException e) {
            throw this.invalidSetConversion(String.class, string, (Throwable)e);
        }
    }
}

