/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.property.PropertyName;

class LinterTableWithBadlyNamedColumns
extends BaseLinter {
    private InclusionRule columnNames;

    LinterTableWithBadlyNamedColumns(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        return "badly named column";
    }

    @Override
    protected void configure(Config config) {
        Objects.requireNonNull(config, "No configuration provided");
        Optional inclusionRuleLookup = config.getOptionalInclusionRule("bad-column-names", "");
        this.columnNames = (InclusionRule)inclusionRuleLookup.orElse(new IncludeAll());
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        List<Column> badlyNamedColumns = this.findBadlyNamedColumns(this.getColumns(table));
        for (Column column : badlyNamedColumns) {
            this.addTableLint(table, this.getSummary(), column);
        }
    }

    private List<Column> findBadlyNamedColumns(List<Column> columns) {
        ArrayList<Column> badlyNamedColumns = new ArrayList<Column>();
        if (this.columnNames == null) {
            return badlyNamedColumns;
        }
        for (Column column : columns) {
            if (!this.columnNames.test((Object)column.getFullName())) continue;
            badlyNamedColumns.add(column);
        }
        return badlyNamedColumns;
    }
}

