/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.jdbc.ResourceLock;
import org.postgresql.ssl.BaseX509KeyManager;
import org.postgresql.ssl.LibPQFactory;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.internal.FileUtils;

public class PKCS12KeyManager
extends BaseX509KeyManager {
    private final CallbackHandler cbh;
    private final String keyfile;
    private final KeyStore keyStore;
    boolean keystoreLoaded;
    private final ResourceLock lock = new ResourceLock();

    public PKCS12KeyManager(String pkcsFile, CallbackHandler cbh) throws PSQLException {
        try {
            this.keyStore = KeyStore.getInstance("pkcs12");
            this.keyfile = pkcsFile;
            this.cbh = cbh;
        }
        catch (KeyStoreException kse) {
            throw new PSQLException(GT.tr("Unable to find pkcs12 keystore.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)kse);
        }
    }

    @Override
    public X509Certificate @Nullable [] getCertificateChain(String alias) {
        try {
            this.loadKeyStore();
            Certificate[] certs = this.keyStore.getCertificateChain(alias);
            if (certs == null) {
                return null;
            }
            X509Certificate[] x509Certificates = new X509Certificate[certs.length];
            int i = 0;
            for (Certificate cert : certs) {
                x509Certificates[i++] = (X509Certificate)cert;
            }
            return x509Certificates;
        }
        catch (Exception kse) {
            this.error = new PSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)kse);
            return null;
        }
    }

    @Override
    public @Nullable PrivateKey getPrivateKey(String s) {
        try {
            this.loadKeyStore();
            PasswordCallback pwdcb = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
            this.cbh.handle(new Callback[]{pwdcb});
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(pwdcb.getPassword());
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry("user", protParam);
            if (pkEntry == null) {
                return null;
            }
            return pkEntry.getPrivateKey();
        }
        catch (Exception ioex) {
            this.error = new PSQLException(GT.tr("Could not read SSL key file {0}.", this.keyfile), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
            return null;
        }
    }

    private void loadKeyStore() throws Exception {
        try (ResourceLock ignore = this.lock.obtain();){
            if (this.keystoreLoaded) {
                return;
            }
            PasswordCallback pwdcb = new PasswordCallback(GT.tr("Enter SSL password: ", new Object[0]), false);
            try {
                this.cbh.handle(new Callback[]{pwdcb});
            }
            catch (UnsupportedCallbackException ucex) {
                this.error = this.cbh instanceof LibPQFactory.ConsoleCallbackHandler && "Console is not available".equals(ucex.getMessage()) ? new PSQLException(GT.tr("Could not read password for SSL key file, console is not available.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)ucex) : new PSQLException(GT.tr("Could not read password for SSL key file by callbackhandler {0}.", this.cbh.getClass().getName()), PSQLState.CONNECTION_FAILURE, (Throwable)ucex);
            }
            this.keyStore.load(FileUtils.newBufferedInputStream(this.keyfile), pwdcb.getPassword());
            this.keystoreLoaded = true;
        }
    }
}

