/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.NamedObjectKey;
import us.fatehi.utility.InclusionCounts;

public final class RetrievalCounts
extends InclusionCounts {
    private static final Logger LOGGER = Logger.getLogger(RetrievalCounts.class.getName());
    private final Counts keyCount = new Counts();
    private final Counts includedKeyCount = new Counts();

    public RetrievalCounts(String name) {
        super(name);
    }

    public void count(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        this.keyCount.count(key);
        this.count();
    }

    void countIfIncluded(NamedObjectKey key, boolean included) {
        if (key == null) {
            return;
        }
        if (included) {
            this.includedKeyCount.count(key);
            this.countIncluded();
        }
    }

    void countIncluded(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        this.includedKeyCount.count(key);
        this.countIncluded();
    }

    public void log(NamedObjectKey key) {
        if (key == null) {
            return;
        }
        Level level = Level.INFO;
        if (LOGGER.isLoggable(level)) {
            int count = this.keyCount.get(key);
            int includedCount = this.includedKeyCount.get(key);
            LOGGER.log(level, "Processed %d/%d %s %s".formatted(includedCount, count, this.getName(), key == null ? "" : " for " + String.valueOf(key)));
        }
    }

    private static class Counts {
        private final Map<NamedObjectKey, Integer> counts = new HashMap<NamedObjectKey, Integer>();

        int count(NamedObjectKey key) {
            if (key == null) {
                return 0;
            }
            int count = 0;
            if (this.counts.containsKey(key)) {
                count = this.get(key);
            }
            this.counts.put(key, ++count);
            return count;
        }

        int get(NamedObjectKey key) {
            if (key == null) {
                return 0;
            }
            int count = 0;
            if (this.counts.containsKey(key)) {
                count = this.counts.get(key);
            }
            return count;
        }
    }
}

