/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Objects;
import schemacrawler.ermodel.implementation.AbstractTableBacked;
import schemacrawler.ermodel.model.Entity;
import schemacrawler.ermodel.model.ManyToManyRelationship;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;

final class MutableManyToManyRelationship
extends AbstractTableBacked
implements ManyToManyRelationship {
    private static final long serialVersionUID = 867546565892159921L;
    private Entity leftEntity;
    private Entity rightEntity;

    public MutableManyToManyRelationship(Table table) {
        super(table);
    }

    @Override
    public int compareTo(NamedObject namedObj) {
        if (namedObj == null) {
            return 1;
        }
        return this.key().compareTo(namedObj.key());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedObject) {
            NamedObject namedObj = (NamedObject)obj;
            return this.key().equals(namedObj.key());
        }
        return false;
    }

    @Override
    public Entity getLeftEntity() {
        return this.leftEntity;
    }

    @Override
    public Entity getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public RelationshipCardinality getType() {
        return RelationshipCardinality.many_many;
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    void setLeftEntity(Entity leftEntity) {
        this.leftEntity = Objects.requireNonNull(leftEntity, "No left entity provided");
    }

    void setRightEntity(Entity rightEntity) {
        this.rightEntity = Objects.requireNonNull(rightEntity, "No right entity provided");
    }
}

