/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.LogData;
import io.jaegertracing.internal.Reference;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerSpan
implements Span {
    private static final Logger log = LoggerFactory.getLogger(JaegerSpan.class);
    private static final AtomicReferenceFieldUpdater<JaegerSpan, Long> durationMicrosUpdater = AtomicReferenceFieldUpdater.newUpdater(JaegerSpan.class, Long.class, "durationMicroseconds");
    private final JaegerTracer tracer;
    private final long startTimeMicroseconds;
    private final long startTimeNanoTicks;
    private final boolean computeDurationViaNanoTicks;
    private final Map<String, Object> tags;
    private volatile Long durationMicroseconds;
    private volatile String operationName;
    private final List<Reference> references;
    private volatile JaegerSpanContext context;
    private List<LogData> logs;

    protected JaegerSpan(JaegerTracer tracer, String operationName, JaegerSpanContext context, long startTimeMicroseconds, long startTimeNanoTicks, boolean computeDurationViaNanoTicks, Map<String, Object> tags, List<Reference> references) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.startTimeNanoTicks = startTimeNanoTicks;
        this.computeDurationViaNanoTicks = computeDurationViaNanoTicks;
        this.tags = new ConcurrentHashMap<String, Object>();
        this.references = references != null ? new ArrayList<Reference>(references) : null;
        Object samplingPriorityValue = tags.get(Tags.SAMPLING_PRIORITY.getKey());
        if (samplingPriorityValue != null) {
            this.setTagAsObject(Tags.SAMPLING_PRIORITY.getKey(), samplingPriorityValue);
        }
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            if (tag.getKey().equals(Tags.SAMPLING_PRIORITY.getKey())) continue;
            this.setTagAsObject(tag.getKey(), tag.getValue());
        }
    }

    public long getStart() {
        return this.startTimeMicroseconds;
    }

    public boolean isFinished() {
        return this.durationMicroseconds != null;
    }

    public long getDuration() {
        Long durationMicroseconds = this.durationMicroseconds;
        return durationMicroseconds == null ? 0L : durationMicroseconds;
    }

    public JaegerTracer getTracer() {
        return this.tracer;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.references);
    }

    public Map<String, Object> getTags() {
        return new HashMap<String, Object>(this.tags);
    }

    public JaegerSpan setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getServiceName() {
        return this.getTracer().getServiceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            if (this.logs == null) {
                return null;
            }
            return new ArrayList<LogData>(this.logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaegerSpan setBaggageItem(String key, String value) {
        if (key == null || value == null && this.context.getBaggageItem(key) == null) {
            return this;
        }
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            this.context = this.tracer.setBaggage(this, key, value);
            return this;
        }
    }

    public String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public String toString() {
        return this.context.toString() + " - " + this.operationName;
    }

    public JaegerSpanContext context() {
        return this.context;
    }

    public void finish() {
        if (this.computeDurationViaNanoTicks) {
            long nanoDuration = this.tracer.clock().currentNanoTicks() - this.startTimeNanoTicks;
            this.finishWithDuration(nanoDuration / 1000L);
        } else {
            this.finish(this.tracer.clock().currentTimeMicros());
        }
    }

    public void finish(long finishMicros) {
        this.finishWithDuration(finishMicros - this.startTimeMicroseconds);
    }

    private void finishWithDuration(long durationMicros) {
        if (durationMicrosUpdater.compareAndSet(this, null, durationMicros)) {
            if (this.context.isSampled()) {
                this.tracer.reportSpan(this);
            }
        } else {
            log.warn("Span has already been finished; will not be reported again.");
        }
    }

    public synchronized JaegerSpan setTag(String key, String value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized JaegerSpan setTag(String key, boolean value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized JaegerSpan setTag(String key, Number value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized <T> Span setTag(Tag<T> tag, T value) {
        return this.setTagAsObject(tag.getKey(), value);
    }

    private JaegerSpan setTagAsObject(String key, Object value) {
        if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value instanceof Number) {
            int priority = ((Number)value).intValue();
            byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
            this.context = this.context.withFlags(newFlags);
        }
        if (this.context.isSampled()) {
            this.tags.put(key, value == null ? "null" : value);
        }
        return this;
    }

    public JaegerSpan log(Map<String, ?> fields) {
        return this.log(this.tracer.clock().currentTimeMicros(), null, fields);
    }

    public JaegerSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        return this.log(timestampMicroseconds, null, fields);
    }

    public JaegerSpan log(String event) {
        return this.log(this.tracer.clock().currentTimeMicros(), event, null);
    }

    public JaegerSpan log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaegerSpan log(long timestampMicroseconds, String event, Map<String, ?> fields) {
        JaegerSpan jaegerSpan = this;
        synchronized (jaegerSpan) {
            if (fields == null && event == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (fields != null && this.tracer.isExpandExceptionLogs()) {
                    fields = JaegerSpan.addExceptionLogs(fields);
                }
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, event, fields));
            }
            return this;
        }
    }

    private static Map<String, ?> addExceptionLogs(Map<String, ?> fields) {
        String message;
        Object ex = fields.get("error.object");
        if (!(ex instanceof Throwable)) {
            return fields;
        }
        HashMap errorFields = new HashMap(fields);
        Throwable loggedException = (Throwable)ex;
        if (fields.get("error.kind") == null) {
            errorFields.put("error.kind", loggedException.getClass().getName());
        }
        if (fields.get("message") == null && (message = loggedException.getMessage()) != null) {
            errorFields.put("message", message);
        }
        if (fields.get("stack") == null) {
            StringWriter sw = new StringWriter();
            loggedException.printStackTrace(new PrintWriter(sw));
            errorFields.put("stack", sw.toString());
        }
        return errorFields;
    }
}

