/*
 * Decompiled with CFR 0.152.
 */
package hughai;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.AbstractOOAI;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.WeaponDef;
import hughai.GameAdapter;
import hughai.GameListener;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.loader.HughAILoader;
import hughai.loader.utils.IHughAI;
import hughai.test.Debugging;
import hughai.test.Tester;
import hughai.ui.MainUI;
import hughai.utils.Config;
import hughai.utils.DrawingUtils;
import hughai.utils.Formatting;
import hughai.utils.LogFile;
import hughai.utils.TimeHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CSAI
extends AbstractOOAI
implements IHughAI {
    public int skirmishAIId;
    public OOAICallback aicallback;
    public PlayerObjects playerObjects;
    TimeHelper timeHelper;
    LogFile logfile;
    DrawingUtils drawingUtils;
    Config config;
    Tester tester;
    Debugging debugging;
    public final String AIVersion = "0.0012";
    private static final int DEFAULT_ZONE = 0;
    public int Team;
    public boolean DebugOn = false;
    HughAILoader hughAILoader;
    ArrayList<GameAdapter> gameListeners = new ArrayList();
    HashSet<ShutdownHandler> shutdownHandlers = new HashSet();
    TimeHelper.TimeSpan unitcreatedtime = new TimeHelper.TimeSpan();
    TimeHelper.TimeSpan unitfinishedtime = new TimeHelper.TimeSpan();
    TimeHelper.TimeSpan unitdestroyedtime = new TimeHelper.TimeSpan();
    TimeHelper.TimeSpan unitidletime = new TimeHelper.TimeSpan();
    TimeHelper.TimeSpan unitmovefailedtime = new TimeHelper.TimeSpan();
    TimeHelper.TimeSpan ticktime = new TimeHelper.TimeSpan();
    HashSet<Unit> unitmovesfailed = new HashSet();
    boolean aistopped = false;
    int lastdebugframe = 0;
    public int currentFrame;
    List<VoiceCommandInfo> VoiceCommands = new ArrayList<VoiceCommandInfo>();

    public String getAIDirectoryPath() {
        return this.aicallback.getDataDirs().getWriteableDir();
    }

    public String getCacheDirectoryPath() {
        return this.getAIDirectoryPath() + "cache" + File.separator;
    }

    public void sendTextMessage(String string) {
        try {
            this.aicallback.getGame().sendTextMessage(string, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HughAILoader getLoader() {
        return this.hughAILoader;
    }

    @Override
    public void setHughAILoader(HughAILoader hughAILoader) {
        this.hughAILoader = hughAILoader;
    }

    public CSAI() {
        System.out.println("CSAI constructor.");
    }

    public void registerGameListener(GameAdapter gameAdapter) {
        this.logfile.WriteLine("registerGameListener " + gameAdapter.getClass().getEnclosingClass().getSimpleName());
        this.gameListeners.add(gameAdapter);
    }

    public void unregisterGameListener(GameAdapter gameAdapter) {
        GameAdapter gameAdapter2 = null;
        for (GameAdapter gameAdapter3 : this.gameListeners) {
            if (gameAdapter3.getClass() != gameAdapter.getClass()) continue;
            gameAdapter2 = gameAdapter3;
        }
        this.gameListeners.remove(gameAdapter2);
    }

    public int init(int n, OOAICallback oOAICallback) {
        this.skirmishAIId = n;
        this.aicallback = oOAICallback;
        try {
            this.sendTextMessage("ai " + n + " initing..");
            this.Team = oOAICallback.getSkirmishAI().getTeamId();
            this.playerObjects = new PlayerObjects(this);
            this.logfile = this.playerObjects.getLogFile();
            this.logfile.Init(this.getAIDirectoryPath() + "team" + this.Team + ".log");
            this.logfile.writeLine("Opening log");
            this.logfile.WriteLine("Hugh AI started v0.0012, team " + this.Team + " map " + oOAICallback.getMap().getName() + " mod " + oOAICallback.getMod().getHumanName());
            this.config = this.playerObjects.getConfig();
            this.playerObjects.getOptionsFromStartScript();
            if (this.config.isDebug().booleanValue()) {
                this.logfile.WriteLine("Toggling debug on");
                this.DebugOn = true;
            }
            if (this.DebugOn) {
                // empty if block
            }
            this.InitCache();
            this.logfile.WriteLine("Is game paused? : " + oOAICallback.getGame().isPaused());
            this.playerObjects.getFrameController().Init();
            this.drawingUtils = this.playerObjects.getDrawingUtils();
            this.drawingUtils.CleanDrawing();
            this.timeHelper = this.playerObjects.getTimeHelper();
            this.playerObjects.getMainUI();
            this.playerObjects.getConfigDialog();
            this.playerObjects.getConsoleJava();
            this.playerObjects.getConsoleEcma();
            this.playerObjects.getWelcomeMessages();
            this.playerObjects.getUnitController();
            this.playerObjects.getEnemyTracker();
            this.playerObjects.getMaps();
            this.playerObjects.getBuildEconomy();
            if (this.DebugOn) {
                this.tester = new Tester(this.playerObjects);
                this.debugging = new Debugging(this.playerObjects);
            }
            this.RegisterVoiceCommand("unpauseai", new VoiceUnpauseAI());
            this.playerObjects.getMainUI().registerButton("Reload AI", new ReloadAIButton());
            this.SendTextMsg("Hugh AI initialized v0.0012, team " + this.Team);
        }
        catch (Exception exception) {
            this.logfile.WriteLine("Exception: " + exception.toString() + " " + Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            this.release(23);
            return 23;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logfile.WriteLine("Throwable: " + throwable.toString() + " " + Formatting.throwableToStackTrace(throwable));
            this.release(24);
            return 24;
        }
        return 0;
    }

    public void registerShutdown(ShutdownHandler shutdownHandler) {
        this.logfile.WriteLine("csai.registershutdownhandler " + shutdownHandler.getClass().getEnclosingClass().getSimpleName());
        this.shutdownHandlers.add(shutdownHandler);
    }

    @Override
    public void Shutdown() {
        try {
            for (ShutdownHandler shutdownHandler : this.shutdownHandlers) {
                shutdownHandler.shutdown();
            }
            if (this.playerObjects != null) {
                this.playerObjects.dispose();
                this.playerObjects = null;
            }
            if (this.logfile != null) {
                this.logfile.Shutdown();
                this.logfile = null;
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine("Exception: " + exception.toString() + " " + Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    public void DebugSay(String string) {
        if (this.DebugOn) {
            this.logfile.WriteLine(string);
        }
    }

    void InitCache() {
        if (!new File(this.getCacheDirectoryPath()).exists()) {
            new File(this.getCacheDirectoryPath()).mkdirs();
        }
    }

    public int unitCreated(Unit unit, Unit unit2) {
        this.logfile.WriteLine("UnitCreated()");
        TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitCreated(unit, unit2);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine("Exception: " + exception.toString() + " " + Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        this.unitcreatedtime.add(this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint));
        return 0;
    }

    public int unitFinished(Unit unit) {
        TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
        try {
            this.logfile.WriteLine("csai.unitfinished " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitFinished(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine("Exception in csai.unitfinished: " + exception.toString());
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        this.unitfinishedtime.add(this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint));
        return 0;
    }

    public int unitDestroyed(Unit unit, Unit unit2) {
        TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitDestroyed(unit, unit2);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        this.unitdestroyedtime.add(this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint));
        return 0;
    }

    public int unitIdle(Unit unit) {
        TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitIdle(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        this.unitidletime.add(this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint));
        return 0;
    }

    public int unitDamaged(Unit unit, Unit unit2, float f, AIFloat3 aIFloat3, WeaponDef weaponDef, boolean bl) {
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitDamaged(unit, unit2, f, aIFloat3, weaponDef, bl);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int unitMoveFailed(Unit unit) {
        try {
            TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
            this.unitmovesfailed.add(unit);
            for (GameListener gameListener : this.gameListeners) {
                gameListener.UnitMoveFailed(unit);
            }
            this.unitmovefailedtime.add(this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint));
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int enemyEnterLOS(Unit unit) {
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.EnemyEnterLOS(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int enemyLeaveLOS(Unit unit) {
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.EnemyLeaveLOS(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int enemyEnterRadar(Unit unit) {
        try {
            this.logfile.WriteLine("enemy entered radar: " + unit);
            for (GameListener gameListener : this.gameListeners) {
                gameListener.EnemyEnterRadar(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int enemyLeaveRadar(Unit unit) {
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.EnemyLeaveRadar(unit);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int enemyDamaged(Unit unit, Unit unit2, float f, AIFloat3 aIFloat3, WeaponDef weaponDef, boolean bl) {
        return 0;
    }

    public int enemyDestroyed(Unit unit, Unit unit2) {
        try {
            for (GameListener gameListener : this.gameListeners) {
                gameListener.EnemyDestroyed(unit, unit2);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public int message(int n, String string) {
        try {
            if (string.toLowerCase().indexOf(".hughai") == 0) {
                String[] stringArray;
                boolean bl = false;
                if (string.length() > 9 && (string.toLowerCase().substring(7, 8).equals("*") || string.toLowerCase().substring(7, 8).equals(" ") || string.toLowerCase().substring(7, 8).equals("" + this.Team))) {
                    this.logfile.WriteLine(string.substring(7, 8));
                    stringArray = string.split(" ");
                    String string2 = stringArray[1].toLowerCase();
                    for (VoiceCommandInfo voiceCommandInfo : this.VoiceCommands) {
                        if (!voiceCommandInfo.command.equals(string2)) continue;
                        voiceCommandInfo.handler.commandReceived(string, stringArray, n);
                        bl = true;
                    }
                }
                if (!bl) {
                    stringArray = "HughAI commands available: help, ";
                    for (VoiceCommandInfo voiceCommandInfo : this.VoiceCommands) {
                        stringArray = (String)stringArray + voiceCommandInfo.command + ", ";
                    }
                    this.sendTextMessage((String)stringArray);
                    this.sendTextMessage("Example: .hughai" + this.Team + " showmetalspots");
                }
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.logfile.WriteLine("Exception: " + exception.toString());
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public boolean getAIStopped() {
        return this.aistopped;
    }

    void DumpTimings() {
        this.logfile.WriteLine("Timings:");
        this.logfile.WriteLine("unitcreatedtime: " + this.unitcreatedtime);
        this.logfile.WriteLine("unitfinishedtime: " + this.unitfinishedtime);
        this.logfile.WriteLine("unitidletime: " + this.unitidletime);
        this.logfile.WriteLine("unitmovefailedtime: " + this.unitmovefailedtime);
        this.logfile.WriteLine("ticktime: " + this.ticktime);
        this.unitcreatedtime = new TimeHelper.TimeSpan();
        this.unitfinishedtime = new TimeHelper.TimeSpan();
        this.unitidletime = new TimeHelper.TimeSpan();
        this.unitmovefailedtime = new TimeHelper.TimeSpan();
        this.ticktime = new TimeHelper.TimeSpan();
        if (this.unitmovesfailed.size() > 0) {
            this.logfile.WriteLine("moves failed for " + this.unitmovesfailed.size() + " units:");
        }
    }

    public int update(int n) {
        try {
            TimeHelper.RealTimePoint realTimePoint = this.timeHelper.GetRealTimePoint();
            this.currentFrame = n;
            if (!this.aicallback.getGame().isPaused() && !this.aistopped && n % this.config.getTickFrameInterval() == 0) {
                for (GameAdapter gameAdapter : this.gameListeners) {
                    long l = System.currentTimeMillis();
                    gameAdapter.overriden = true;
                    gameAdapter.Tick(n);
                    long l2 = System.currentTimeMillis() - l;
                    if (gameAdapter.overriden) {
                        // empty if block
                    }
                    if (!this.DebugOn || n - this.lastdebugframe <= 150) continue;
                    this.DumpTimings();
                    this.lastdebugframe = n;
                }
                TimeHelper.TimeSpan timeSpan = this.timeHelper.CompareRealTimePoint(this.timeHelper.GetRealTimePoint(), realTimePoint);
                this.logfile.WriteLine("Total tick time: " + timeSpan);
                this.ticktime.add(timeSpan);
            }
        }
        catch (Exception exception) {
            this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
            this.logfile.WriteLine("Exception: " + exception.toString());
            this.SendTextMsg("Exception: " + exception.toString());
            if (this.playerObjects != null && this.playerObjects.getExceptionList() != null) {
                this.playerObjects.getExceptionList().reportException(exception);
            }
            return 1;
        }
        return 0;
    }

    public void RegisterVoiceCommand(String string, VoiceCommandHandler voiceCommandHandler) {
        string = string.toLowerCase();
        this.logfile.WriteLine("CSAI registering voicecommand " + string);
        this.VoiceCommands.add(new VoiceCommandInfo(string, voiceCommandHandler));
    }

    public void UnregisterVoiceCommand(String string) {
        string = string.toLowerCase();
    }

    public void SendTextMsg(String string) {
        this.sendTextMessage(string);
    }

    static class VoiceCommandInfo {
        public String command;
        public VoiceCommandHandler handler;

        public VoiceCommandInfo(String string, VoiceCommandHandler voiceCommandHandler) {
            this.command = string;
            this.handler = voiceCommandHandler;
        }
    }

    public static interface ShutdownHandler {
        public void shutdown();
    }

    class VoiceUnpauseAI
    implements VoiceCommandHandler {
        VoiceUnpauseAI() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            CSAI.this.sendTextMessage("unpausing AI");
            CSAI.this.aistopped = false;
        }
    }

    class ReloadAIButton
    implements MainUI.ButtonHandler {
        ReloadAIButton() {
        }

        @Override
        public void go() {
            try {
                CSAI.this.hughAILoader.triggerReload();
            }
            catch (Exception exception) {
                CSAI.this.logfile.WriteLine(Formatting.exceptionToStackTrace(exception));
                throw new RuntimeException(exception);
            }
        }
    }
}

