/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.concurrent.TimeUnit;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.coyote.http2.Stream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

class WindowAllocationManager {
    private static final Log log = LogFactory.getLog(WindowAllocationManager.class);
    private static final StringManager sm = StringManager.getManager(WindowAllocationManager.class);
    private static final int NONE = 0;
    private static final int STREAM = 1;
    private static final int CONNECTION = 2;
    private final Stream stream;
    private int waitingFor = 0;

    WindowAllocationManager(Stream stream) {
        this.stream = stream;
    }

    void waitForStream(long l) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitFor.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Long.toString(l)}));
        }
        this.waitFor(1, l);
    }

    void waitForConnection(long l) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitFor.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Integer.toString(this.stream.getConnectionAllocationRequested()), Long.toString(l)}));
        }
        this.waitFor(2, l);
    }

    void waitForStreamNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitForNonBlocking.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        this.waitForNonBlocking(1);
    }

    void waitForConnectionNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("windowAllocationManager.waitForNonBlocking.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        this.waitForNonBlocking(2);
    }

    void notifyStream() {
        this.notify(1);
    }

    void notifyConnection() {
        this.notify(2);
    }

    void notifyAny() {
        this.notify(3);
    }

    boolean isWaitingForStream() {
        return this.isWaitingFor(1);
    }

    boolean isWaitingForConnection() {
        return this.isWaitingFor(2);
    }

    private boolean isWaitingFor(int n) {
        this.stream.windowAllocationLock.lock();
        try {
            boolean bl = (this.waitingFor & n) > 0;
            return bl;
        }
        finally {
            this.stream.windowAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(int n, long l) throws InterruptedException {
        this.stream.windowAllocationLock.lock();
        try {
            if (this.waitingFor != 0) {
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
            }
            this.waitingFor = n;
            long l2 = -1L;
            do {
                long l3;
                if (l < 0L) {
                    this.stream.windowAllocationAvailable.await();
                    continue;
                }
                if (l2 == -1L) {
                    l2 = System.nanoTime();
                    l3 = l;
                } else {
                    long l4 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                    if (l4 == 0L) {
                        l4 = 1L;
                    }
                    if ((l3 = l - l4) <= 0L) {
                        return;
                    }
                }
                this.stream.windowAllocationAvailable.await(l3, TimeUnit.MILLISECONDS);
            } while (this.waitingFor != 0);
        }
        finally {
            this.stream.windowAllocationLock.unlock();
        }
    }

    private void waitForNonBlocking(int n) {
        block5: {
            this.stream.windowAllocationLock.lock();
            try {
                if (this.waitingFor == 0) {
                    this.waitingFor = n;
                    break block5;
                }
                if (this.waitingFor == n) {
                    break block5;
                }
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
            }
            finally {
                this.stream.windowAllocationLock.unlock();
            }
        }
    }

    private void notify(int n) {
        this.stream.windowAllocationLock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("windowAllocationManager.notify", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString(), Integer.toString(this.waitingFor), Integer.toString(n)}));
            }
            if ((n & this.waitingFor) > 0) {
                this.waitingFor = 0;
                Response response = this.stream.getCoyoteResponse();
                if (response != null) {
                    if (response.getWriteListener() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("windowAllocationManager.notified", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
                        }
                        this.stream.windowAllocationAvailable.signal();
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("windowAllocationManager.dispatched", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
                        }
                        response.action(ActionCode.DISPATCH_WRITE, null);
                        response.action(ActionCode.DISPATCH_EXECUTE, null);
                    }
                }
            }
        }
        finally {
            this.stream.windowAllocationLock.unlock();
        }
    }
}

