# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network express-route update",
)
class Update(AAZCommand):
    """Update settings of an ExpressRoute circuit.

    :example: Change the SKU of an ExpressRoute circuit from Standard to Premium.
        az network express-route update -n MyCircuit -g MyResourceGroup --sku-tier Premium
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/expressroutecircuits/{}", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="ExpressRoute circuit name.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.allow_classic_operations = AAZBoolArg(
            options=["--allow-classic-operations"],
            help="Allow classic operations.  Allowed values: false, true.",
            nullable=True,
        )
        _args_schema.bandwidth_in_gbps = AAZFloatArg(
            options=["--bandwidth-in-gbps"],
            help="Bandwidth of the circuit. Usage: INT {Mbps,Gbps}. Defaults to Mbps.  Values from: az network express-route list-service-providers.",
            nullable=True,
        )
        _args_schema.express_route_port = AAZResourceIdArg(
            options=["--express-route-port"],
            help="Name or ID of an ExpressRoute port.",
            nullable=True,
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{subscription}/resourceGroups/{resource_group}/providers/Microsoft.Network/expressRoutePorts/{}"
            )
        )
        _args_schema.allow_global_reach = AAZBoolArg(
            options=["--allow-global-reach"],
            help="Enable global reach on the circuit.",
            nullable=True,
        )
        _args_schema.peering_location = AAZStrArg(
            options=["--peering-location"],
            help="Name of the peering location.",
            nullable=True,
        )
        _args_schema.provider = AAZStrArg(
            options=["--provider"],
            help="Name of the ExpressRoute Service Provider.",
            nullable=True,
        )
        _args_schema.sku_family = AAZStrArg(
            options=["--sku-family"],
            help="Chosen SKU family of ExpressRoute circuit.  Allowed values: MeteredData, UnlimitedData.  Default: MeteredData.",
            nullable=True,
            enum={"MeteredData": "MeteredData", "UnlimitedData": "UnlimitedData"},
        )
        _args_schema.sku_name = AAZStrArg(
            options=["--sku-name"],
            help="The name of the SKU.",
            nullable=True,
        )
        _args_schema.sku_tier = AAZStrArg(
            options=["--sku-tier"],
            help="SKU Tier of ExpressRoute circuit.  Allowed values: Basic, Local, Premium, Standard.  Default: Standard.",
            nullable=True,
            enum={"Basic": "Basic", "Local": "Local", "Premium": "Premium", "Standard": "Standard"},
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use \"\" to clear existing tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        # define Arg Group "ServiceProviderProperties"

        _args_schema = cls._args_schema
        _args_schema.bandwidth_in_mbps = AAZIntArg(
            options=["--bandwidth-in-mbps"],
            arg_group="ServiceProviderProperties",
            help="Bandwidth of the circuit. Usage: INT {Mbps,Gbps}. Defaults to Mbps. Values from: az network express-route list-service-providers.",
            nullable=True,
        )
        return cls._args_schema

    _args_express_route_circuit_peering_config_update = None

    @classmethod
    def _build_args_express_route_circuit_peering_config_update(cls, _schema):
        if cls._args_express_route_circuit_peering_config_update is not None:
            _schema.advertised_communities = cls._args_express_route_circuit_peering_config_update.advertised_communities
            _schema.advertised_public_prefixes = cls._args_express_route_circuit_peering_config_update.advertised_public_prefixes
            _schema.customer_asn = cls._args_express_route_circuit_peering_config_update.customer_asn
            _schema.legacy_mode = cls._args_express_route_circuit_peering_config_update.legacy_mode
            _schema.routing_registry_name = cls._args_express_route_circuit_peering_config_update.routing_registry_name
            return

        cls._args_express_route_circuit_peering_config_update = AAZObjectArg(
            nullable=True,
        )

        express_route_circuit_peering_config_update = cls._args_express_route_circuit_peering_config_update
        express_route_circuit_peering_config_update.advertised_communities = AAZListArg(
            options=["advertised-communities"],
            help="The communities of bgp peering. Specified for microsoft peering.",
            nullable=True,
        )
        express_route_circuit_peering_config_update.advertised_public_prefixes = AAZListArg(
            options=["advertised-public-prefixes"],
            help="The reference to AdvertisedPublicPrefixes.",
            nullable=True,
        )
        express_route_circuit_peering_config_update.customer_asn = AAZIntArg(
            options=["customer-asn"],
            help="The CustomerASN of the peering.",
            nullable=True,
        )
        express_route_circuit_peering_config_update.legacy_mode = AAZIntArg(
            options=["legacy-mode"],
            help="The legacy mode of the peering.",
            nullable=True,
        )
        express_route_circuit_peering_config_update.routing_registry_name = AAZStrArg(
            options=["routing-registry-name"],
            help="The RoutingRegistryName of the configuration.",
            nullable=True,
        )

        advertised_communities = cls._args_express_route_circuit_peering_config_update.advertised_communities
        advertised_communities.Element = AAZStrArg(
            nullable=True,
        )

        advertised_public_prefixes = cls._args_express_route_circuit_peering_config_update.advertised_public_prefixes
        advertised_public_prefixes.Element = AAZStrArg(
            nullable=True,
        )

        _schema.advertised_communities = cls._args_express_route_circuit_peering_config_update.advertised_communities
        _schema.advertised_public_prefixes = cls._args_express_route_circuit_peering_config_update.advertised_public_prefixes
        _schema.customer_asn = cls._args_express_route_circuit_peering_config_update.customer_asn
        _schema.legacy_mode = cls._args_express_route_circuit_peering_config_update.legacy_mode
        _schema.routing_registry_name = cls._args_express_route_circuit_peering_config_update.routing_registry_name

    _args_sub_resource_update = None

    @classmethod
    def _build_args_sub_resource_update(cls, _schema):
        if cls._args_sub_resource_update is not None:
            _schema.id = cls._args_sub_resource_update.id
            return

        cls._args_sub_resource_update = AAZObjectArg(
            nullable=True,
        )

        sub_resource_update = cls._args_sub_resource_update
        sub_resource_update.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
            nullable=True,
        )

        _schema.id = cls._args_sub_resource_update.id

    def _execute_operations(self):
        self.pre_operations()
        self.ExpressRouteCircuitsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.ExpressRouteCircuitsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ExpressRouteCircuitsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "circuitName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _build_schema_express_route_circuit_read(cls._schema_on_200)

            return cls._schema_on_200

    class ExpressRouteCircuitsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "circuitName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _build_schema_express_route_circuit_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("sku", AAZObjectType)
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("allowClassicOperations", AAZBoolType, ".allow_classic_operations")
                properties.set_prop("bandwidthInGbps", AAZFloatType, ".bandwidth_in_gbps")
                properties.set_prop("expressRoutePort", AAZObjectType)
                properties.set_prop("globalReachEnabled", AAZBoolType, ".allow_global_reach")
                properties.set_prop("serviceProviderProperties", AAZObjectType)

            express_route_port = _builder.get(".properties.expressRoutePort")
            if express_route_port is not None:
                express_route_port.set_prop("id", AAZStrType, ".express_route_port")

            service_provider_properties = _builder.get(".properties.serviceProviderProperties")
            if service_provider_properties is not None:
                service_provider_properties.set_prop("bandwidthInMbps", AAZIntType, ".bandwidth_in_mbps")
                service_provider_properties.set_prop("peeringLocation", AAZStrType, ".peering_location")
                service_provider_properties.set_prop("serviceProviderName", AAZStrType, ".provider")

            sku = _builder.get(".sku")
            if sku is not None:
                sku.set_prop("family", AAZStrType, ".sku_family")
                sku.set_prop("name", AAZStrType, ".sku_name")
                sku.set_prop("tier", AAZStrType, ".sku_tier")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


def _build_schema_express_route_circuit_peering_config_update(_builder):
    if _builder is None:
        return
    _builder.set_prop("advertisedCommunities", AAZListType, ".advertised_communities")
    _builder.set_prop("advertisedPublicPrefixes", AAZListType, ".advertised_public_prefixes")
    _builder.set_prop("customerASN", AAZIntType, ".customer_asn")
    _builder.set_prop("legacyMode", AAZIntType, ".legacy_mode")
    _builder.set_prop("routingRegistryName", AAZStrType, ".routing_registry_name")

    advertised_communities = _builder.get(".advertisedCommunities")
    if advertised_communities is not None:
        advertised_communities.set_elements(AAZStrType, ".")

    advertised_public_prefixes = _builder.get(".advertisedPublicPrefixes")
    if advertised_public_prefixes is not None:
        advertised_public_prefixes.set_elements(AAZStrType, ".")


def _build_schema_sub_resource_update(_builder):
    if _builder is None:
        return
    _builder.set_prop("id", AAZStrType, ".id")


_schema_express_route_circuit_peering_config_read = None


def _build_schema_express_route_circuit_peering_config_read(_schema):
    global _schema_express_route_circuit_peering_config_read
    if _schema_express_route_circuit_peering_config_read is not None:
        _schema.advertised_communities = _schema_express_route_circuit_peering_config_read.advertised_communities
        _schema.advertised_public_prefixes = _schema_express_route_circuit_peering_config_read.advertised_public_prefixes
        _schema.advertised_public_prefixes_state = _schema_express_route_circuit_peering_config_read.advertised_public_prefixes_state
        _schema.customer_asn = _schema_express_route_circuit_peering_config_read.customer_asn
        _schema.legacy_mode = _schema_express_route_circuit_peering_config_read.legacy_mode
        _schema.routing_registry_name = _schema_express_route_circuit_peering_config_read.routing_registry_name
        return

    _schema_express_route_circuit_peering_config_read = AAZObjectType()

    express_route_circuit_peering_config_read = _schema_express_route_circuit_peering_config_read
    express_route_circuit_peering_config_read.advertised_communities = AAZListType(
        serialized_name="advertisedCommunities",
    )
    express_route_circuit_peering_config_read.advertised_public_prefixes = AAZListType(
        serialized_name="advertisedPublicPrefixes",
    )
    express_route_circuit_peering_config_read.advertised_public_prefixes_state = AAZStrType(
        serialized_name="advertisedPublicPrefixesState",
        flags={"read_only": True},
    )
    express_route_circuit_peering_config_read.customer_asn = AAZIntType(
        serialized_name="customerASN",
    )
    express_route_circuit_peering_config_read.legacy_mode = AAZIntType(
        serialized_name="legacyMode",
    )
    express_route_circuit_peering_config_read.routing_registry_name = AAZStrType(
        serialized_name="routingRegistryName",
    )

    advertised_communities = _schema_express_route_circuit_peering_config_read.advertised_communities
    advertised_communities.Element = AAZStrType()

    advertised_public_prefixes = _schema_express_route_circuit_peering_config_read.advertised_public_prefixes
    advertised_public_prefixes.Element = AAZStrType()

    _schema.advertised_communities = _schema_express_route_circuit_peering_config_read.advertised_communities
    _schema.advertised_public_prefixes = _schema_express_route_circuit_peering_config_read.advertised_public_prefixes
    _schema.advertised_public_prefixes_state = _schema_express_route_circuit_peering_config_read.advertised_public_prefixes_state
    _schema.customer_asn = _schema_express_route_circuit_peering_config_read.customer_asn
    _schema.legacy_mode = _schema_express_route_circuit_peering_config_read.legacy_mode
    _schema.routing_registry_name = _schema_express_route_circuit_peering_config_read.routing_registry_name


_schema_express_route_circuit_read = None


def _build_schema_express_route_circuit_read(_schema):
    global _schema_express_route_circuit_read
    if _schema_express_route_circuit_read is not None:
        _schema.etag = _schema_express_route_circuit_read.etag
        _schema.id = _schema_express_route_circuit_read.id
        _schema.location = _schema_express_route_circuit_read.location
        _schema.name = _schema_express_route_circuit_read.name
        _schema.properties = _schema_express_route_circuit_read.properties
        _schema.sku = _schema_express_route_circuit_read.sku
        _schema.tags = _schema_express_route_circuit_read.tags
        _schema.type = _schema_express_route_circuit_read.type
        return

    _schema_express_route_circuit_read = AAZObjectType()

    express_route_circuit_read = _schema_express_route_circuit_read
    express_route_circuit_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    express_route_circuit_read.id = AAZStrType()
    express_route_circuit_read.location = AAZStrType()
    express_route_circuit_read.name = AAZStrType(
        flags={"read_only": True},
    )
    express_route_circuit_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    express_route_circuit_read.sku = AAZObjectType()
    express_route_circuit_read.tags = AAZDictType()
    express_route_circuit_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_express_route_circuit_read.properties
    properties.allow_classic_operations = AAZBoolType(
        serialized_name="allowClassicOperations",
    )
    properties.authorization_key = AAZStrType(
        serialized_name="authorizationKey",
    )
    properties.authorizations = AAZListType()
    properties.bandwidth_in_gbps = AAZFloatType(
        serialized_name="bandwidthInGbps",
    )
    properties.circuit_provisioning_state = AAZStrType(
        serialized_name="circuitProvisioningState",
    )
    properties.express_route_port = AAZObjectType(
        serialized_name="expressRoutePort",
    )
    _build_schema_sub_resource_read(properties.express_route_port)
    properties.gateway_manager_etag = AAZStrType(
        serialized_name="gatewayManagerEtag",
    )
    properties.global_reach_enabled = AAZBoolType(
        serialized_name="globalReachEnabled",
    )
    properties.peerings = AAZListType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service_key = AAZStrType(
        serialized_name="serviceKey",
    )
    properties.service_provider_notes = AAZStrType(
        serialized_name="serviceProviderNotes",
    )
    properties.service_provider_properties = AAZObjectType(
        serialized_name="serviceProviderProperties",
    )
    properties.service_provider_provisioning_state = AAZStrType(
        serialized_name="serviceProviderProvisioningState",
    )
    properties.stag = AAZIntType(
        flags={"read_only": True},
    )

    authorizations = _schema_express_route_circuit_read.properties.authorizations
    authorizations.Element = AAZObjectType()

    _element = _schema_express_route_circuit_read.properties.authorizations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_express_route_circuit_read.properties.authorizations.Element.properties
    properties.authorization_key = AAZStrType(
        serialized_name="authorizationKey",
    )
    properties.authorization_use_status = AAZStrType(
        serialized_name="authorizationUseStatus",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    peerings = _schema_express_route_circuit_read.properties.peerings
    peerings.Element = AAZObjectType()

    _element = _schema_express_route_circuit_read.properties.peerings.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_express_route_circuit_read.properties.peerings.Element.properties
    properties.azure_asn = AAZIntType(
        serialized_name="azureASN",
    )
    properties.connections = AAZListType()
    properties.express_route_connection = AAZObjectType(
        serialized_name="expressRouteConnection",
    )
    properties.gateway_manager_etag = AAZStrType(
        serialized_name="gatewayManagerEtag",
    )
    properties.ipv6_peering_config = AAZObjectType(
        serialized_name="ipv6PeeringConfig",
    )
    properties.last_modified_by = AAZStrType(
        serialized_name="lastModifiedBy",
        flags={"read_only": True},
    )
    properties.microsoft_peering_config = AAZObjectType(
        serialized_name="microsoftPeeringConfig",
    )
    _build_schema_express_route_circuit_peering_config_read(properties.microsoft_peering_config)
    properties.peer_asn = AAZIntType(
        serialized_name="peerASN",
    )
    properties.peered_connections = AAZListType(
        serialized_name="peeredConnections",
        flags={"read_only": True},
    )
    properties.peering_type = AAZStrType(
        serialized_name="peeringType",
    )
    properties.primary_azure_port = AAZStrType(
        serialized_name="primaryAzurePort",
    )
    properties.primary_peer_address_prefix = AAZStrType(
        serialized_name="primaryPeerAddressPrefix",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.route_filter = AAZObjectType(
        serialized_name="routeFilter",
    )
    _build_schema_sub_resource_read(properties.route_filter)
    properties.secondary_azure_port = AAZStrType(
        serialized_name="secondaryAzurePort",
    )
    properties.secondary_peer_address_prefix = AAZStrType(
        serialized_name="secondaryPeerAddressPrefix",
    )
    properties.shared_key = AAZStrType(
        serialized_name="sharedKey",
    )
    properties.state = AAZStrType()
    properties.stats = AAZObjectType()
    properties.vlan_id = AAZIntType(
        serialized_name="vlanId",
    )

    connections = _schema_express_route_circuit_read.properties.peerings.Element.properties.connections
    connections.Element = AAZObjectType()

    _element = _schema_express_route_circuit_read.properties.peerings.Element.properties.connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_express_route_circuit_read.properties.peerings.Element.properties.connections.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.authorization_key = AAZStrType(
        serialized_name="authorizationKey",
    )
    properties.circuit_connection_status = AAZStrType(
        serialized_name="circuitConnectionStatus",
        flags={"read_only": True},
    )
    properties.express_route_circuit_peering = AAZObjectType(
        serialized_name="expressRouteCircuitPeering",
    )
    _build_schema_sub_resource_read(properties.express_route_circuit_peering)
    properties.ipv6_circuit_connection_config = AAZObjectType(
        serialized_name="ipv6CircuitConnectionConfig",
    )
    properties.peer_express_route_circuit_peering = AAZObjectType(
        serialized_name="peerExpressRouteCircuitPeering",
    )
    _build_schema_sub_resource_read(properties.peer_express_route_circuit_peering)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    ipv6_circuit_connection_config = _schema_express_route_circuit_read.properties.peerings.Element.properties.connections.Element.properties.ipv6_circuit_connection_config
    ipv6_circuit_connection_config.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    ipv6_circuit_connection_config.circuit_connection_status = AAZStrType(
        serialized_name="circuitConnectionStatus",
        flags={"read_only": True},
    )

    express_route_connection = _schema_express_route_circuit_read.properties.peerings.Element.properties.express_route_connection
    express_route_connection.id = AAZStrType(
        flags={"read_only": True},
    )

    ipv6_peering_config = _schema_express_route_circuit_read.properties.peerings.Element.properties.ipv6_peering_config
    ipv6_peering_config.microsoft_peering_config = AAZObjectType(
        serialized_name="microsoftPeeringConfig",
    )
    _build_schema_express_route_circuit_peering_config_read(ipv6_peering_config.microsoft_peering_config)
    ipv6_peering_config.primary_peer_address_prefix = AAZStrType(
        serialized_name="primaryPeerAddressPrefix",
    )
    ipv6_peering_config.route_filter = AAZObjectType(
        serialized_name="routeFilter",
    )
    _build_schema_sub_resource_read(ipv6_peering_config.route_filter)
    ipv6_peering_config.secondary_peer_address_prefix = AAZStrType(
        serialized_name="secondaryPeerAddressPrefix",
    )
    ipv6_peering_config.state = AAZStrType()

    peered_connections = _schema_express_route_circuit_read.properties.peerings.Element.properties.peered_connections
    peered_connections.Element = AAZObjectType()

    _element = _schema_express_route_circuit_read.properties.peerings.Element.properties.peered_connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_express_route_circuit_read.properties.peerings.Element.properties.peered_connections.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.auth_resource_guid = AAZStrType(
        serialized_name="authResourceGuid",
    )
    properties.circuit_connection_status = AAZStrType(
        serialized_name="circuitConnectionStatus",
        flags={"read_only": True},
    )
    properties.connection_name = AAZStrType(
        serialized_name="connectionName",
    )
    properties.express_route_circuit_peering = AAZObjectType(
        serialized_name="expressRouteCircuitPeering",
    )
    _build_schema_sub_resource_read(properties.express_route_circuit_peering)
    properties.peer_express_route_circuit_peering = AAZObjectType(
        serialized_name="peerExpressRouteCircuitPeering",
    )
    _build_schema_sub_resource_read(properties.peer_express_route_circuit_peering)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    stats = _schema_express_route_circuit_read.properties.peerings.Element.properties.stats
    stats.primarybytes_in = AAZIntType(
        serialized_name="primarybytesIn",
    )
    stats.primarybytes_out = AAZIntType(
        serialized_name="primarybytesOut",
    )
    stats.secondarybytes_in = AAZIntType(
        serialized_name="secondarybytesIn",
    )
    stats.secondarybytes_out = AAZIntType(
        serialized_name="secondarybytesOut",
    )

    service_provider_properties = _schema_express_route_circuit_read.properties.service_provider_properties
    service_provider_properties.bandwidth_in_mbps = AAZIntType(
        serialized_name="bandwidthInMbps",
    )
    service_provider_properties.peering_location = AAZStrType(
        serialized_name="peeringLocation",
    )
    service_provider_properties.service_provider_name = AAZStrType(
        serialized_name="serviceProviderName",
    )

    sku = _schema_express_route_circuit_read.sku
    sku.family = AAZStrType()
    sku.name = AAZStrType()
    sku.tier = AAZStrType()

    tags = _schema_express_route_circuit_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_express_route_circuit_read.etag
    _schema.id = _schema_express_route_circuit_read.id
    _schema.location = _schema_express_route_circuit_read.location
    _schema.name = _schema_express_route_circuit_read.name
    _schema.properties = _schema_express_route_circuit_read.properties
    _schema.sku = _schema_express_route_circuit_read.sku
    _schema.tags = _schema_express_route_circuit_read.tags
    _schema.type = _schema_express_route_circuit_read.type


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType()

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType()

    _schema.id = _schema_sub_resource_read.id


__all__ = ["Update"]
