{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @code(Rotation). This wrapper API may change, we advise to access simpler @code(Rotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

{$endif read_interface}

{$ifdef read_implementation}

{ TRotationNode_1 ----------------------------------------------- }

function TRotationNode_1.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TRotationNode_1.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

class function TRotationNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TRotationNode_1.ClassX3DType: String;
begin
  Result := 'Rotation';
end;

procedure TRotationNode_1.CreateNode;
begin
  inherited;

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chEverything;
  AddField(FFdRotation);
end;

{$endif read_implementation}
