/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef SOC_MEDIATEK_MT8192_GPIO_H
#define SOC_MEDIATEK_MT8192_GPIO_H

#include <soc/addressmap.h>
#include <soc/gpio_common.h>
#include <soc/gpio_defs.h>
#include <types.h>

enum {
	PIN(0, EINT0, 0, 9, 0x23, 0xb0,
		SPI6_CLK, I2S5_MCK, PWM_0, TDM_LRCK,
		TP_GPIO0_AO, MD_INT0, RES7),
	PIN(1, EINT1, 0, 10, 0x23, 0xb0,
		SPI6_CSB, I2S5_BCK, PWM_1, TDM_BCK,
		TP_GPIO1_AO, MD_INT1_C2K_UIM0_HOT_PLUG, DBG_MON_A9),
	PIN(2, EINT2, 0, 11, 0x23, 0xb0,
		SPI6_MI, I2S5_LRCK, PWM_2, TDM_MCK,
		TP_GPIO2_AO, MD_INT2_C2K_UIM1_HOT_PLUG, DBG_MON_A10),
	PIN(3, EINT3, 0, 12, 0x23, 0xb0,
		SPI6_MO, I2S5_DO, PWM_3, TDM_DATA0,
		TP_GPIO3_AO, CLKM0, DBG_MON_A11),
	PIN(4, EINT4, 0, 13, 0x23, 0xb0,
		SPI4_A_CLK, I2S2_MCK, DMIC1_CLK, TDM_DATA1,
		TP_GPIO4_AO, PCM1_DI, IDDIG),
	PIN(5, EINT5, 0, 14, 0x23, 0xb0,
		SPI4_A_CSB, I2S2_BCK, DMIC1_DAT,
		TDM_DATA2, TP_GPIO5_AO, PCM1_CLK, USB_DRVVBUS),
	PIN(6, EINT6, 0, 15, 0x23, 0xb0,
		SPI4_A_MI, I2S2_LRCK, DMIC_CLK, TDM_DATA3,
		TP_GPIO6_AO, PCM1_SYNC, RES7),
	PIN(7, EINT7, 0, 16, 0x23, 0xb0,
		SPI4_A_MO, I2S2_DI, DMIC_DAT, WIFI_TXD,
		TP_GPIO7_AO, PCM1_DO0, RES7),
	PIN(8, EINT8, 0, 17, 0x23, 0xb0,
		SRCLKENAI1, I2S2_DI2, KPCOL2,
		CONN_TCXOENA_REQ, CLKM1, PCM1_DO1, DBG_MON_A12),
	PIN(9, EINT9, 0, 18, 0x23, 0xb0,
		SRCLKENAI0, DVFSRC_EXT_REQ, KPROW2,
		CMMCLK4, CLKM3, PCM1_DO2, DBG_MON_A13),
	PIN(10, EINT10, 1, 0, 0x15, 0x20,
		MSDC2_CLK, SPI4_B_CLK, I2S8_MCK,
		RES4, MD_INT0, TP_GPIO8_AO, RES7),
	PIN(11, EINT11, 1, 1, 0x15, 0x20,
		MSDC2_CMD, SPI4_B_CSB, I2S8_BCK, PCIE_CLKREQ_N,
		MD_INT1_C2K_UIM0_HOT_PLUG, TP_GPIO9_AO, RES7),
	PIN(12, EINT12, 1, 2, 0x15, 0x20,
		MSDC2_DAT3, SPI4_B_MI, I2S8_LRCK, DMIC1_CLK,
		MD_INT2_C2K_UIM1_HOT_PLUG, TP_GPIO10_AO, RES7),
	PIN(13, EINT13, 1, 3, 0x15, 0x20,
		DMSDC2_DAT0, SPI4_B_MO, I2S8_DI, DMIC1_DAT,
		ANT_SEL10, TP_GPIO11_AO, RES7),
	PIN(14, EINT14, 1, 4, 0x15, 0x20,
		MSDC2_DAT2, IDDIG, SCL_6306, PCIE_PERESET_N,
		ANT_SEL11, TP_GPIO12_AO, RES7),
	PIN(15, EINT15, 1, 5, 0x15, 0x20,
		MSDC2_DAT1, USB_DRVVBUS, SDA_6306,
		PCIE_WAKE_N, ANT_SEL12, TP_GPIO13_AO, RES7),
	PIN(16, EINT16, 0, 2, 0x17, 0x50,
		SRCLKENAI1, IDDIG, TP_GPIO14_AO, KPCOL2,
		GPS_L1_ELNA_EN, SPI7_A_MI, DBG_MON_A0),
	PIN(17, EINT17, 0, 3, 0x17, 0x50,
		SRCLKENAI0, USB_DRVVBUS, TP_GPIO15_AO,
		KPROW2, RES5, SPI7_A_MO, DBG_MON_A1),
	PIN(18, EINT18, 0, 21, 0x36, 0xa0,
		SRCLKENAI0, SPI4_C_MI, SPI1_B_MI,
		GPS_L1_ELNA_EN, ANT_SEL10, MD_INT0, DBG_MON_B2),
	PIN(19, EINT19, 0, 22, 0x36, 0xa0,
		SRCLKENAI1, SPI4_C_MO, SPI1_B_MO, RES4,
		ANT_SEL11, MD_INT1_C2K_UIM0_HOT_PLUG, DBG_MON_B3),
	PIN(20, EINT20, 0, 23, 0x36, 0xa0,
		SRCLKENAI0, SPI4_C_CLK, SPI1_B_CLK, PWM_3,
		ANT_SEL12, MD_INT2_C2K_UIM1_HOT_PLUG, DBG_MON_B4),
	PIN(21, EINT21, 0, 24, 0x36, 0xa0,
		RES1, SPI4_C_CSB, SPI1_B_CSB, RES4,
		RES5, IDDIG, DBG_MON_B5),
	PIN(22, EINT22, 0, 3, 0x21, 0x90,
		RES1, SPI0_C_CLK, SPI7_B_CLK, I2S7_BCK,
		I2S9_BCK, SCL_6306, RES7),
	PIN(23, EINT23, 0, 4, 0x21, 0x90,
		RES1, SPI0_C_CSB, SPI7_B_CSB, I2S7_LRCK,
		I2S9_LRCK, SDA_6306, RES7),
	PIN(24, EINT24, 0, 5, 0x21, 0x90,
		SRCLKENAI1, SPI0_C_MI, SPI7_B_MI, I2S6_DI,
		I2S8_DI, SPINOR_CS, RES7),
	PIN(25, EINT25, 0, 6, 0x21, 0x90,
		SRCLKENAI0, SPI0_C_MO, SPI7_B_MO,
		I2S7_DO, I2S9_DO, SPINOR_CK, RES7),
	PIN(26, PERIPHERAL_EN4, 0, 5, 0x22, 0x80,
		PWM_2, CLKM0, USB_DRVVBUS, SPI5_C_MI,
		I2S9_BCK, RES6, RES7),
	PIN(27, PERIPHERAL_EN5, 0, 6, 0x22, 0x80,
		PWM_3, CLKM1, RES3, SPI5_C_MO,
		I2S9_LRCK, SPINOR_IO0, RES7),
	PIN(28, PERIPHERAL_EN6, 0, 7, 0x22, 0x80,
		PWM_0, CLKM2, RES3, SPI5_C_CSB,
		I2S9_MCK, SPINOR_IO1, RES7),
	PIN(29, PERIPHERAL_EN7, 0, 8, 0x22, 0x80,
		PWM_1, CLKM3, RES3, SPI5_C_CLK,
		I2S9_DO, SPINOR_IO2, RES7),
	PIN(30, PERIPHERAL_EN8, 0, 9, 0x22, 0x80,
		PWM_2, CLKM0, GPS_L1_ELNA_EN, I2S7_MCK,
		I2S9_MCK, SPINOR_IO3, RES7),
	PIN(31, I2S3_MCK, 0, 27, 0x22, 0x70,
		I2S3_MCK, I2S1_MCK, I2S5_MCK,
		SRCLKENAI0, I2S0_MCK, RES6, RES7),
	PIN(32, I2S3_BCK, 0, 24, 0x22, 0x70,
		I2S3_BCK, I2S1_BCK, I2S5_BCK,
		PCM0_CLK, I2S0_BCK, RES6, RES7),
	PIN(33, I2S3_LRCK, 0, 26, 0x22, 0x70,
		I2S3_LRCK, I2S1_LRCK, I2S5_LRCK,
		PCM0_SYNC, I2S0_LRCK, RES6, RES7),
	PIN(34, I2S0_DI, 0, 23, 0x22, 0x70,
		I2S3_DO, I2S1_DO, I2S5_DO, PCM0_DO,
		RES5, RES6, RES7),
	PIN(35, I2S3_DO, 0, 25, 0x22, 0x70,
		I2S3_DO, I2S1_DO, I2S5_DO,
		PCM0_DO, RES5, RES6, RES7),
	PIN(36, SPI5_CLK, 0, 20, 0x21, 0x90,
		SPI5_A_CLK, DMIC1_CLK, RES3,
		MD_URXD0, UCTS0, URXD1, RES7),
	PIN(37, SPI5_CSB, 0, 21, 0x21, 0x90,
		SPI5_A_CSB, DMIC1_DAT, RES3,
		MD_UTXD0, URTS0, UTXD1, RES7),
	PIN(38, SPI5_MI, 0, 22, 0x21, 0x90,
		SPI5_A_MI, DMIC_CLK, RES3,
		MD_URXD1, URXD0, UCTS1, RES7),
	PIN(39, SPI5_MO, 0, 23, 0x21, 0x90,
		SPI5_A_MO, DMIC_DAT, RES3,
		MD_UTXD1, UTXD0, URTS1, RES7),
	PIN(40, DISP_PWM, 0, 0, 0x17, 0x50,
		DISP_PWM, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A6),
	PIN(41, DSI_TE, 0, 1, 0x17, 0x50,
		DSI_TE, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A7),
	PIN(42, LCM_RST, 0, 4, 0x17, 0x50,
		LCM_RST, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A8),
	PIN(43, INT_SIM1, 0, 25, 0x36, 0xa0,
		MD_INT1_C2K_UIM0_HOT_PLUG, MD_INT2_C2K_UIM1_HOT_PLUG,
		SCL_6306, ADSP_URXD0, PTA_RXD, SSPM_URXD_AO, DBG_MON_B0),
	PIN(44, INT_SIM2, 0, 26, 0x36, 0xa0,
		MD_INT2_C2K_UIM1_HOT_PLUG, MD_INT1_C2K_UIM0_HOT_PLUG,
		SDA_6306, ADSP_UTXD0, PTA_TXD, SSPM_UTXD_AO, DBG_MON_B1),
	PIN(45, SIM2_SCLK, 1, 9, 0x20, 0x60,
		MD1_SIM2_SCLK, MD1_SIM1_SCLK, MCUPM_JTAG_TDI,
		APU_JTAG_TDI, CCU_JTAG_TDI, LVTS_SCK, CONN_DSP_JDI),
	PIN(46, SIM2_SRST, 1, 11, 0x20, 0x60,
		MD1_SIM2_SRST, MD1_SIM1_SRST, MCUPM_JTAG_TMS,
		APU_JTAG_TMS, CCU_JTAG_TMS, LVTS_SDI, CONN_DSP_JMS),
	PIN(47, SIM2_SIO, 1, 10, 0x20, 0x60,
		MD1_SIM2_SIO, MD1_SIM1_SIO, MCUPM_JTAG_TDO,
		APU_JTAG_TDO, CCU_JTAG_TDO, LVTS_SCF, CONN_DSP_JDO),
	PIN(48, SIM1_SIO, 1, 7, 0x20, 0x60,
		MD1_SIM1_SIO, MD1_SIM2_SIO, MCUPM_JTAG_TRSTN,
		APU_JTAG_TRST, CCU_JTAG_TRST, LVTS_FOUT, CONN_DSP_JINTP),
	PIN(49, SIM1_SRST, 1, 8, 0x20, 0x60,
		MD1_SIM1_SRST, MD1_SIM2_SRST, MCUPM_JTAG_TCK,
		APU_JTAG_TCK, CCU_JTAG_TCK, LVTS_SDO, CONN_DSP_JCK),
	PIN(50, SIM1_SCLK, 1, 6, 0x20, 0x60,
		MD1_SIM1_SCLK, MD1_SIM2_SCLK, RES3,
		RES4, RES5, LVTS_26M, RES7),
	PIN(51, MSDC1_CLK, 1, 0, 0x20, 0x60,
		MSDC1_CLK, PCM1_CLK, CONN_DSP_JCK, UDI_TCK,
		IPU_JTAG_TCK, SSPM_JTAG_TCK, JTCK_SEL3),
	PIN(52, MSDC1_CMD, 1, 1, 0x20, 0x60,
		MSDC1_CMD, PCM1_SYNC, CONN_DSP_JMS, UDI_TMS,
		IPU_JTAG_TMS, SSPM_JTAG_TMS, JTMS_SEL3),
	PIN(53, MSDC1_DAT3, 1, 5, 0x20, 0x60,
		MSDC1_DAT3, PCM1_DI, CONN_DSP_JINTP,
		CONN_MCU_AICE_TMSC, RES5, RES6, RES7),
	PIN(54, MSDC1_DAT0, 1, 2, 0x20, 0x60,
		MSDC1_DAT0, PCM1_DO0, CONN_DSP_JDI,
		UDI_TDI, IPU_JTAG_TDI, SSPM_JTAG_TDI, JTDI_SEL3),
	PIN(55, MSDC1_DAT2, 1, 4, 0x20, 0x60,
		MSDC1_DAT2, PCM1_DO2, CONN_MCU_AICE_TCKC,
		UDI_NTRST, IPU_JTAG_TRST, SSPM_JTAG_TRSTN, JTRSTN_SEL3),
	PIN(56, MSDC1_DAT1, 1, 3, 0x20, 0x60,
		MSDC1_DAT1, PCM1_DO1, CONN_DSP_JDO, UDI_TDO,
		IPU_JTAG_TDO, SSPM_JTAG_TDO, JTDO_SEL3),
	PIN(57, MIPI2_D_SCLK, 0, 1, 0x22, 0x80,
		MIPI2_D_SCLK, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(58, MIPI2_D_SDATA, 0, 2, 0x22, 0x80,
		MIPI2_D_SDATA, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(59, MIPI_M_SCLK, 0, 3, 0x22, 0x80,
		MIPI_M_SCLK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(60, MIPI_M_SDATA, 0, 4, 0x22, 0x80,
		MIPI_M_SDATA, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(61, MD_UCNT, 0, 28, 0x22, 0x70,
		MD_UCNT_A_TGL, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(62, DIGRF_IRQ, 0, 22, 0x22, 0x70,
		DIGRF_IRQ, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(63, BPI_D_BUS0, 0, 0, 0x22, 0x70,
		BPI_BUS0, RES2, PCIE_WAKE_N,
		RES4, RES5, RES6, RES7),
	PIN(64, BPI_D_BUS1, 0, 1, 0x22, 0x70,
		BPI_BUS1, RES2, PCIE_PERESET_N,
		RES4, RES5, RES6, RES7),
	PIN(65, BPI_D_BUS2, 0, 12, 0x22, 0x70,
		BPI_BUS2, RES2, PCIE_CLKREQ_N,
		RES4, RES5, RES6, RES7),
	PIN(66, BPI_D_BUS3, 0, 15, 0x22, 0x70,
		BPI_BUS3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(67, BPI_D_BUS4, 0, 16, 0x22, 0x70,
		BPI_BUS4, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(68, BPI_D_BUS5, 0, 17, 0x22, 0x70,
		BPI_BUS5, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(69, BPI_D_BUS6, 0, 18, 0x22, 0x70,
		BPI_BUS6, CONN_BPI_BUS6,
		RES3, RES4, RES5, RES6, RES7),
	PIN(70, BPI_D_BUS7, 0, 19, 0x22, 0x70,
		BPI_BUS7, CONN_BPI_BUS7, RES3,
		RES4, RES5, RES6, RES7),
	PIN(71, BPI_D_BUS8, 0, 20, 0x22, 0x70,
		BPI_BUS8, CONN_BPI_BUS8,
		RES3, RES4, RES5, RES6, RES7),
	PIN(72, BPI_D_BUS9, 0, 21, 0x22, 0x70,
		BPI_BUS9, CONN_BPI_BUS9,
		RES3, RES4, RES5, RES6, RES7),
	PIN(73, BPI_D_BUS10, 0, 2, 0x22, 0x70,
		BPI_BUS10, CONN_BPI_BUS10,
		RES3, RES4, RES5, RES6, RES7),
	PIN(74, BPI_D_BUS11_OLAT0, 0, 3, 0x22, 0x70,
		BPI_BUS11_OLAT0, CONN_BPI_BUS11_OLAT0,
		RES3, RES4, RES5, RES6, RES7),
	PIN(75, BPI_D_BUS12_OLAT1, 0, 4, 0x22, 0x70,
		BPI_BUS12_OLAT1, CONN_BPI_BUS12_OLAT1,
		RES3, RES4, RES5, RES6, RES7),
	PIN(76, BPI_D_BUS13_OLAT2, 0, 5, 0x22, 0x70,
		BPI_BUS13_OLAT2, CONN_BPI_BUS13_OLAT2,
		RES3, RES4, RES5, RES6, RES7),
	PIN(77, BPI_D_BUS14_OLAT3, 0, 6, 0x22, 0x70,
		BPI_BUS14_OLAT3, CONN_BPI_BUS14_OLAT3,
		RES3, RES4, RES5, RES6, RES7),
	PIN(78, BPI_D_BUS15_OLAT4, 0, 7, 0x22, 0x70,
		BPI_BUS15_OLAT4, CONN_BPI_BUS15_OLAT4,
		RES3, RES4, RES5, RES6, RES7),
	PIN(79, BPI_D_BUS16_OLAT5, 0, 8, 0x22, 0x70,
		BPI_BUS16_OLAT5, CONN_BPI_BUS16_OLAT5,
		RES3, RES4, RES5, RES6, RES7),
	PIN(80, BPI_D_BUS17_ANT0, 0, 9, 0x22, 0x70,
		BPI_BUS17_ANT0, CONN_BPI_BUS17_ANT0,
		PCIE_WAKE_N, RES4, RES5, RES6, RES7),
	PIN(81, BPI_D_BUS18_ANT1, 0, 10, 0x22, 0x70,
		BPI_BUS18_ANT1, CONN_BPI_BUS18_ANT1,
		PCIE_PERESET_N, RES4, RES5, RES6, RES7),
	PIN(82, BPI_D_BUS19_ANT2, 0, 11, 0x22, 0x70,
		BPI_BUS19_ANT2, CONN_BPI_BUS19_ANT2,
		PCIE_CLKREQ_N, RES4, RES5, RES6, RES7),
	PIN(83, BPI_D_BUS20_ANT3, 0, 13, 0x22, 0x70,
		BPI_BUS20_ANT3, CONN_BPI_BUS20_ANT3,
		RES3, RES4, RES5, RES6, RES7),
	PIN(84, BPI_D_BUS21_ANT4, 0, 14, 0x22, 0x70,
		BPI_BUS21_ANT4, CONN_BPI_BUS21_ANT4,
		RES3, RES4, RES5, RES6, RES7),
	PIN(85, MIPI1_D_SCLK, 0, 31, 0x22, 0x70,
		MIPI1_D_SCLK, CONN_MIPI1_SCLK,
		RES3, RES4, RES5, RES6, RES7),
	PIN(86, MIPI1_D_SDATA, 0, 0, 0x22, 0x80,
		MIPI1_D_SDATA, CONN_MIPI1_SDATA,
		RES3, RES4, RES5, RES6, RES7),
	PIN(87, MIPI0_D_SCLK, 0, 29, 0x22, 0x70,
		MIPI0_D_SCLK, CONN_MIPI0_SCLK,
		RES3, RES4, RES5, RES6, RES7),
	PIN(88, MIPI0_D_SDATA, 0, 30, 0x22, 0x70,
		SMIPI0_D_SDATA, CONN_MIPI0_SDATA,
		RES3, RES4, RES5, RES6, RES7),
	PIN(89, SPMI_SCL, 0, 24, 0x21, 0x90,
		SPMI_SCL, SCL10, RES3,
		RES4, RES5, RES6, RES7),
	PIN(90, SPMI_SDA, 0, 25, 0x21, 0x90,
		SPMI_SDA, SDA10, RES3,
		RES4, RES5, RES6, RES7),
	PIN(91, AP_GOOD, 0, 0, 0x21, 0x90,
		AP_GOOD, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(92, URXD0, 0, 2, 0x21, 0xa0,
		URXD0, MD_URXD0, MD_URXD1,
		SSPM_URXD_AO, CONN_UART0_RXD, RES6, RES7),
	PIN(93, UTXD0, 0, 4, 0x21, 0xa0,
		UTXD0, MD_UTXD0, MD_UTXD1, SSPM_UTXD_AO,
		CONN_UART0_TXD, WIFI_TXD, RES7),
	PIN(94, URXD1, 0, 3, 0x21, 0xa0,
		URXD1, ADSP_URXD0, MD32_0_RXD,
		SSPM_URXD_AO, TP_URXD1_AO, TP_URXD2_AO, MBISTREADEN_TRIGGER),
	PIN(95, UTXD1, 0, 5, 0x21, 0xa0,
		UTXD1, ADSP_UTXD0, MD32_0_TXD, SSPM_UTXD_AO,
		TP_UTXD1_AO, TP_UTXD2_AO, MBISTWRITEEN_TRIGGER),
	PIN(96, TDM_LRCK, 0, 31, 0x21, 0x90,
		TDM_LRCK, I2S7_LRCK, I2S9_LRCK,
		DPI_D0, ADSP_JTAG0_TDI, RES6, IO_JTAG_TDI),
	PIN(97, TDM_BCK, 0, 26, 0x21, 0x90,
		TDM_BCK, I2S7_BCK, I2S9_BCK, DPI_D1,
		ADSP_JTAG0_TRSTN, RES6, IO_JTAG_TRSTN),
	PIN(98, TDM_MCLK, 0, 0, 0x21, 0xa0,
		TDM_MCK, I2S7_MCK, I2S9_MCK, DPI_D2,
		ADSP_JTAG0_TCK, RES6, IO_JTAG_TCK),
	PIN(99, TDM_DATA0, 0, 27, 0x21, 0x90,
		TDM_DATA0, I2S6_DI, I2S8_DI, DPI_D3,
		ADSP_JTAG0_TDO, RES6, IO_JTAG_TDO),
	PIN(100, TDM_DATA1, 0, 28, 0x21, 0x90,
		TDM_DATA1, I2S7_DO, I2S9_DO, DPI_D4,
		ADSP_JTAG0_TMS, RES6, IO_JTAG_TMS),
	PIN(101, TDM_DATA2, 0, 29, 0x21, 0x90,
		TDM_DATA2, DMIC1_CLK, SRCLKENAI0, DPI_D5,
		CLKM0, RES6, DAP_MD32_SWD),
	PIN(102, TDM_DATA3, 0, 30, 0x21, 0x90,
		TDM_DATA3, DMIC1_DAT, SRCLKENAI1,
		DPI_D6, RES5, DVFSRC_EXT_REQ, DAP_MD32_SWCK),
	PIN(103, SPI0_MI, 0, 18, 0x21, 0x90,
		SPI0_A_MI, SCP_SPI0_MI, RES3, DPI_D7,
		DFD_TDO, SPM_JTAG_TDO, JTDO_SEL1),
	PIN(104, SPI0_CSB, 0, 17, 0x21, 0x90,
		SPI0_A_CSB, SCP_SPI0_CS, RES3, DPI_D8, DFD_TMS,
		SPM_JTAG_TMS, JTMS_SEL1),
	PIN(105, SPI0_MO, 0, 19, 0x21, 0x90,
		SPI0_A_MO, SCP_SPI0_MO, SCP_SDA0, DPI_D9,
		DFD_TDI, SPM_JTAG_TDI, JTDI_SEL1),
	PIN(106, SPI0_CLK, 0, 16, 0x21, 0x90,
		SPI0_A_CLK, SCP_SPI0_CK, SCP_SCL0,
		DPI_D10, DFD_TCK_XI, SPM_JTAG_TCK, JTCK_SEL1),
	PIN(107, DMIC_CLK, 0, 1, 0x21, 0x90,
		DMIC_CLK, PWM_0, CLKM2, RES4, RES5,
		SPM_JTAG_TRSTN, JTRSTN_SEL1),
	PIN(108, DMIC_DAT, 0, 2, 0x21, 0x90,
		DMIC_DAT, PWM_1, CLKM3, RES4,
		RES5, RES6, DAP_SONIC_SWD),
	PIN(109, I2S1_MCK, 0, 10, 0x21, 0x90,
		I2S1_MCK, I2S3_MCK, I2S2_MCK, DPI_DE,
		I2S2_MCK_1, SRCLKENAI0, DAP_SONIC_SWCK),
	PIN(110, I2S1_BCK, 0, 7, 0x21, 0x90,
		I2S1_BCK, I2S3_BCK, I2S2_BCK, DPI_D11,
		I2S2_BCK_1, CONN_MCU_TDO, RES7),
	PIN(111, I2S1_LRCK, 0, 9, 0x21, 0x90,
		I2S1_LRCK, I2S3_LRCK, I2S2_LRCK,
		DPI_VSYNC, I2S2_LRCK_1, CONN_MCU_TDI, RES7),
	PIN(112, I2S2_DI, 0, 11, 0x21, 0x90,
		I2S2_DI, I2S0_DI, I2S2_DI2, DPI_CK,
		I2S2_DI_1, CONN_MCU_TMS, RES7),
	PIN(113, I2S1_DO, 0, 8, 0x21, 0x90,
		I2S1_DO, I2S3_DO, I2S5_DO, DPI_HSYNC,
		I2S2_DI2, CONN_MCU_TCK, RES7),
	PIN(114, SCP_SPI2_MI, 0, 14, 0x21, 0x90,
		SPI2_MI, SCP_SPI2_MI, RES3,
		PCM0_DI, RES5, CONN_MCU_TRST_B, RES7),
	PIN(115, SCP_SPI2_CSB, 0, 13, 0x21, 0x90,
		SPI2_CSB, SCP_SPI2_CS, RES3, PCM0_SYNC,
		RES5, CONN_MCU_DBGI_N, RES7),
	PIN(116, SCP_SPI2_MO, 0, 15, 0x21, 0x90,
		SPI2_MO, SCP_SPI2_MO, SCP_SDA1,
		PCM0_DO, RES5, CONN_MCU_DBGACK_N, RES7),
	PIN(117, SCP_SPI2_CK, 0, 12, 0x21, 0x90,
		SPI2_CLK, SCP_SPI2_CK, SCP_SCL1,
		PCM0_CLK, RES5, RES6, RES7),
	PIN(118, SCL1, 0, 23, 0x23, 0xb0,
		SCL1, SCP_SCL0, SCP_SCL1,
		RES4, RES5, RES6, RES7),
	PIN(119, SDA1, 0, 29, 0x23, 0xb0,
		SDA1, SCP_SDA0, SCP_SDA1,
		RES4, RES5, RES6, RES7),
	PIN(120, SCL9, 0, 28, 0x23, 0xb0,
		SCL9, SCP_SCL0, RES3,
		RES4, RES5, RES6, RES7),
	PIN(121, SDA9, 0, 2, 0x23, 0xc0,
		SDA9, SCP_SDA0, RES3,
		RES4, RES5, RES6, RES7),
	PIN(122, SCL8, 0, 27, 0x23, 0xb0,
		SCL8, SCP_SDA0, RES3,
		RES4, RES5, RES6, RES7),
	PIN(123, SDA8, 0, 1, 0x23, 0xc0,
		SDA8, SCP_SCL0, RES3,
		RES4, RES5, RES6, RES7),
	PIN(124, SCL7, 0, 26, 0x23, 0xb0,
		SCL7, DMIC1_CLK, RES3,
		RES4, RES5, RES6, RES7),
	PIN(125, SDA7, 0, 0, 0x23, 0xc0,
		SDA7, DMIC1_DAT, RES3,
		RES4, RES5, RES6, RES7),
	PIN(126, PERIPHERAL_EN0, 0, 19, 0x23, 0xb0,
		CMFLASH0, PWM_2, TP_UCTS1_AO,
		UCTS0, SCL11, GPS_L1_ELNA_EN, DBG_MON_A14),
	PIN(127, PERIPHERAL_EN1, 0, 20, 0x23, 0xb0,
		CMFLASH1, PWM_3, TP_URTS1_AO, URTS0,
		SDA11, RES6, DBG_MON_A15),
	PIN(128, PERIPHERAL_EN2, 0, 21, 0x23, 0xb0,
		CMFLASH2, PWM_0, TP_UCTS2_AO,
		UCTS1, SCL_6306, RES6, DBG_MON_A16),
	PIN(129, PERIPHERAL_EN3, 0, 22, 0x23, 0xb0,
		CMFLASH3, PWM_1, TP_URTS2_AO, URTS1,
		SDA_6306, RES6, DBG_MON_A17),
	PIN(130, CAM_RST3, 0, 6, 0x23, 0xb0,
		CMVREF0, ANT_SEL10, SCP_JTAG0_TDO,
		MD32_0_JTAG_TDO, SCL11, SPI5_B_CLK, DBG_MON_A22),
	PIN(131, CAM_RST4, 0, 7, 0x23, 0xb0,
		CMVREF1, ANT_SEL11, SCP_JTAG0_TDI,
		MD32_0_JTAG_TDI, SDA11, SPI5_B_MO, DBG_MON_A25),
	PIN(132, CAM_RST5, 0, 8, 0x23, 0xb0,
		CMVREF2, ANT_SEL12, SCP_JTAG0_TMS,
		MD32_0_JTAG_TMS, RES5, RES6, DBG_MON_A28),
	PIN(133, CAM_PDN3, 0, 3, 0x23, 0xb0,
		CMVREF3, GPS_L1_ELNA_EN, SCP_JTAG0_TCK,
		MD32_0_JTAG_TCK, CMMCLK5, SPI5_B_CSB, DBG_MON_A23),
	PIN(134, CAM_PDN4, 0, 4, 0x23, 0xb0,
		CMVREF4, RES2, SCP_JTAG0_TRSTN,
		MD32_0_JTAG_TRST, RES5, RES6, DBG_MON_A26),
	PIN(135, CAM_PDN5, 0, 5, 0x23, 0xb0,
		PWM_0, SRCLKENAI1, MD_URXD0,
		MD32_0_RXD, CONN_TCXOENA_REQ, RES6, DBG_MON_A29),
	PIN(136, CAM_CLK3, 0, 0, 0x23, 0xb0,
		CMMCLK3, CLKM1, MD_UTXD0, MD32_0_TXD,
		RES5, SPI5_B_MI, DBG_MON_A24),
	PIN(137, CAM_CLK4, 0, 1, 0x23, 0xb0,
		CMMCLK4, CLKM2, MD_URXD1, RES4,
		RES5, CONN_UART0_RXD, DBG_MON_A27),
	PIN(138, CAM_CLK5, 0, 2, 0x23, 0xb0,
		CMMCLK5, CLKM3, MD_UTXD1,
		RES4, RES5, CONN_UART0_TXD, DBG_MON_A30),
	PIN(139, SCL4, 0, 25, 0x23, 0xb0,
		SCL4, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A21),
	PIN(140, SDA4, 0, 31, 0x23, 0xb0,
		SDA4, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A20),
	PIN(141, SCL2, 0, 24, 0x23, 0xb0,
		SCL2, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A18),
	PIN(142, SDA2, 0, 30, 0x23, 0xb0,
		SDA2, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_A19),
	PIN(143, CAM_RST0, 0, 6, 0x20, 0x70,
		CMVREF0, SPI3_CLK, ADSP_JTAG1_TDO,
		SCP_JTAG1_TDO, RES5, RES6, DBG_MON_A31),
	PIN(144, CAM_RST1, 0, 7, 0x20, 0x70,
		CMVREF1, SPI3_CSB, ADSP_JTAG1_TDI,
		SCP_JTAG1_TDI, RES5, RES6, RES7),
	PIN(145, CAM_RST2, 0, 8, 0x20, 0x70,
		CMVREF2, SPI3_MI, ADSP_JTAG1_TMS,
		SCP_JTAG1_TMS, RES5, RES6, RES7),
	PIN(146, CAM_PDN0, 0, 3, 0x20, 0x70,
		CMVREF3, SPI3_MO, ADSP_JTAG1_TCK,
		SCP_JTAG1_TCK, RES5, RES6, DBG_MON_A32),
	PIN(147, CAM_PDN1, 0, 4, 0x20, 0x70,
		CMVREF4, EXT_FRAME_SYNC, ADSP_JTAG1_TRSTN,
		SCP_JTAG1_TRSTN, RES5, RES6, RES7),
	PIN(148, CAM_PDN2, 0, 5, 0x20, 0x70,
		PWM_1, AGPS_SYNC, RES3, RES4,
		RES5, RES6, RES7),
	PIN(149, CAM_CLK0, 0, 0, 0x20, 0x70,
		CMMCLK0, CLKM0, MD32_0_GPIO0,
		RES4, RES5, RES6, RES7),
	PIN(150, CAM_CLK1, 0, 1, 0x20, 0x70,
		CMMCLK1, CLKM1, MD32_0_GPIO1,
		RES4, RES5, RES6, CONN_MCU_AICE_TMSC),
	PIN(151, CAM_CLK2, 0, 2, 0x20, 0x70,
		CMMCLK2, CLKM2, MD32_0_GPIO2,
		RES4, RES5, RES6, CONN_MCU_AICE_TCKC),
	PIN(152, KPROW1, 1, 3, 0x36, 0x90,
		KPROW1, PWM_2, IDDIG, RES4, RES5,
		MBISTREADEN_TRIGGER, DBG_MON_B9),
	PIN(153, KPROW0, 1, 2, 0x36, 0x90,
		KPROW0, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_B8),
	PIN(154, KPCOL0, 1, 0, 0x36, 0x90,
		KPCOL0, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_B6),
	PIN(155, KPCOL1, 1, 1, 0x36, 0x90,
		KPCOL1, PWM_3, USB_DRVVBUS, CONN_TCXOENA_REQ,
		RES5, MBISTWRITEEN_TRIGGER, DBG_MON_B7),
	PIN(156, SPI1_CLK, 0, 29, 0x36, 0xa0,
		SPI1_A_CLK, SCP_SPI1_A_CK, MRG_CLK,
		AGPS_SYNC, MD_URXD0, UDI_TMS, DBG_MON_B10),
	PIN(157, SPI1_CSB, 0, 30, 0x36, 0xa0,
		SPI1_A_CSB, SCP_SPI1_A_CS, MRG_SYNC,
		EXT_FRAME_SYNC, MD_UTXD0, UDI_TCK, DBG_MON_B11),
	PIN(158, SPI1_MI, 0, 31, 0x36, 0xa0,
		SPI1_A_MI, SCP_SPI1_A_MI, MRG_DI,
		PTA_RXD, MD_URXD1, UDI_TDO, DBG_MON_B12),
	PIN(159, SPI1_MO, 0, 0, 0x36, 0xb0,
		SPI1_A_MO, SCP_SPI1_A_MO, MRG_DO, PTA_TXD,
		MD_UTXD1, UDI_NTRST, DBG_MON_B13),
	PIN(160, SCL3, 0, 27, 0x36, 0xa0,
		SCL3, RES2, SCP_SCL1, RES4,
		RES5, RES6, DBG_MON_B14),
	PIN(161, SDA3, 0, 28, 0x36, 0xa0,
		SDA3, RES2, SCP_SDA1, RES4,
		RES5, RES6, DBG_MON_B15),
	PIN(162, ANT_SEL0, 0, 0, 0x36, 0xa0,
		ANT_SEL0, GPS_L1_ELNA_EN, RES3,
		RES4, RES5, UDI_TDI, DBG_MON_B16),
	PIN(163, ANT_SEL1, 0, 1, 0x36, 0xa0,
		ANT_SEL1, CONN_TCXOENA_REQ, RES3,
		RES4, RES5, RES6, DBG_MON_B17),
	PIN(164, ANT_SEL2, 0, 2, 0x36, 0xa0,
		ANT_SEL2, SCP_SPI1_B_CK, TP_URXD1_AO,
		RES4, UCTS0, RES6, DBG_MON_B18),
	PIN(165, ANT_SEL3, 0, 3, 0x36, 0xa0,
		ANT_SEL3, SCP_SPI1_B_CS, TP_UTXD1_AO,
		CONN_TCXOENA_REQ, URTS0, RES6, DBG_MON_B19),
	PIN(166, ANT_SEL4, 0, 4, 0x36, 0xa0,
		ANT_SEL4, SCP_SPI1_B_MI, TP_URXD2_AO,
		SRCLKENAI1, UCTS1, RES6, DBG_MON_B207),
	PIN(167, ANT_SEL5, 0, 5, 0x36, 0xa0,
		ANT_SEL5, SCP_SPI1_B_MO, TP_UTXD2_AO,
		SRCLKENAI0, URTS1, RES6, DBG_MON_B21),
	PIN(168, ANT_SEL6, 0, 6, 0x36, 0xa0,
		ANT_SEL6, SPI0_B_CLK, TP_UCTS1_AO,
		KPCOL2, MD_UCTS0, SCL11, DBG_MON_B22),
	PIN(169, ANT_SEL7, 0, 7, 0x36, 0xa0,
		ANT_SEL7, SPI0_B_CSB, TP_URTS1_AO, KPROW2,
		MD_URTS0, SDA11, DBG_MON_B23),
	PIN(170, ANT_SEL8, 0, 8, 0x36, 0xa0,
		ANT_SEL8, SPI0_B_MI, TP_UCTS2_AO,
		SRCLKENAI1, MD_UCTS1, RES6, DBG_MON_B24),
	PIN(171, ANT_SEL9, 0, 9, 0x36, 0xa0,
		ANT_SEL9, SPI0_B_MO, TP_URTS2_AO,
		SRCLKENAI0, MD_URTS1, RES6, DBG_MON_B25),
	PIN(172, CONN_TOP_CLK, 0, 13, 0x36, 0xa0,
		CONN_TOP_CLK, AUXIF_CLK0, RES3,
		RES4, RES5, RES6, DBG_MON_B29),
	PIN(173, CONN_TOP_DATA, 0, 14, 0x36, 0xa0,
		CONN_TOP_DATA, AUXIF_ST0, RES3,
		RES4, RES5, RES6, DBG_MON_B30),
	PIN(174, CONN_HRST_B, 0, 12, 0x36, 0xa0,
		CONN_HRST_B, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_B28),
	PIN(175, CONN_WB_PTA, 0, 15, 0x36, 0xa0,
		CONN_WB_PTA, RES2, RES3, RES4,
		RES5, RES6, DBG_MON_B31),
	PIN(176, CONN_BT_CLK, 0, 10, 0x36, 0xa0,
		CONN_BT_CLK, AUXIF_CLK1, RES3, RES4,
		RES5, RES6, DBG_MON_B26),
	PIN(177, CONN_BT_DATA, 0, 11, 0x36, 0xa0,
		CONN_BT_DATA, AUXIF_ST1, RES3,
		RES4, RES5, RES6, DBG_MON_B27),
	PIN(178, CONN_WF_CTRL0, 0, 16, 0x36, 0xa0,
		CONN_WF_CTRL0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(179, CONN_WF_CTRL1, 0, 17, 0x36, 0xa0,
		CONN_WF_CTRL1, UFS_MPHY_SCL,
		RES3, RES4, RES5, RES6, RES7),
	PIN(180, CONN_WF_CTRL2, 0, 18, 0x36, 0xa0,
		CONN_WF_CTRL2, UFS_MPHY_SDA,
		RES3, RES4, RES5, RES6, RES7),
	PIN(181, CONN_WF_CTRL3, 0, 19, 0x36, 0xa0,
		CONN_WF_CTRL3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(182, CONN_WF_CTRL4, 0, 20, 0x36, 0xa0,
		CONN_WF_CTRL4, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(183, MSDC0_CMD, 1, 1, 0x18, 0x30,
		MSDC0_CMD, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(184, MSDC0_DAT0, 1, 2, 0x18, 0x30,
		MSDC0_DAT0, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(185, MSDC0_DAT2, 1, 4, 0x18, 0x30,
		MSDC0_DAT2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(186, MSDC0_DAT4, 1, 6, 0x18, 0x30,
		MSDC0_DAT4, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(187, MSDC0_DAT6, 1, 8, 0x18, 0x30,
		MSDC0_DAT6, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(188, MSDC0_DAT1, 1, 3, 0x18, 0x30,
		MSDC0_DAT1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(189, MSDC0_DAT5, 1, 7, 0x18, 0x30,
		MSDC0_DAT5, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(190, MSDC0_DAT7, 1, 9, 0x18, 0x30,
		MSDC0_DAT7, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(191, MSDC0_DSL, 1, 10, 0x18, 0x30,
		MSDC0_DSL, GPS_L1_ELNA_EN,
		IDDIG, DMIC_CLK, RES5, RES6, RES7),
	PIN(192, MSDC0_CLK, 1, 0, 0x18, 0x30,
		MSDC0_CLK, RES2, USB_DRVVBUS,
		DMIC_DAT, RES5, RES6, RES7),
	PIN(193, MSDC0_DAT3, 1, 5, 0x18, 0x30,
		MSDC0_DAT3, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(194, MSDC0_RSTB, 1, 11, 0x18, 0x30,
		MSDC0_RSTB, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(195, SCP_VREQ_VAO, 0, 16, 0x14, 0x50,
		SCP_VREQ_VAO, DVFSRC_EXT_REQ,
		RES3, RES4, RES5, RES6, RES7),
	PIN(196, AUD_DAT_MOSI2, 0, 6, 0x14, 0x50,
		AUD_DAT_MOSI2, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(197, AUD_NLE_MOSI1, 0, 8, 0x14, 0x50,
		AUD_NLE_MOSI1, AUD_CLK_MISO,
		I2S2_MCK, I2S6_MCK, I2S8_MCK, RES6, RES7),
	PIN(198, AUD_NLE_MOSI0, 0, 7, 0x14, 0x50,
		AUD_NLE_MOSI0, AUD_SYNC_MISO,
		I2S2_BCK, I2S6_BCK, I2S8_BCK, RES6, RES7),
	PIN(199, AUD_DAT_MISO2, 0, 3, 0x14, 0x50,
		AUD_DAT_MISO2, RES2, I2S2_DI2,
		RES4, RES5, RES6, RES7),
	PIN(200, SCL6, 0, 6, 0x17, 0x50,
		SCL6, RES2, SCP_SCL1, SCL_6306,
		RES5, RES6, DBG_MON_A4),
	PIN(201, SDA6, 0, 8, 0x17, 0x50,
		SDA6, RES2, SCP_SDA1, SDA_6306,
		RES5, RES6, DBG_MON_A5),
	PIN(202, SCL5, 0, 15, 0x14, 0x50,
		SCL5, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(203, SDA5, 0, 17, 0x14, 0x50,
		SDA5, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(204, SCL0, 0, 5, 0x17, 0x50,
		SCL0, RES2, RES3, RES4,
		RES5, SPI7_A_CLK, DBG_MON_A2),
	PIN(205, SDA0, 0, 7, 0x17, 0x50,
		SDA0, RES2, RES3, RES4,
		RES5, SPI7_A_CSB, DBG_MON_A3),
	PIN(206, SRCLKENA0, 0, 18, 0x14, 0x50,
		SRCLKENA0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(207, SRCLKENA1, 0, 19, 0x14, 0x50,
		SRCLKENA1, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(208, WATCHDOG, 0, 20, 0x14, 0x50,
		WATCHDOG, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(209, PWRAP_SPI0_MI, 0, 12, 0x14, 0x50,
		PWRAP_SPI0_MI, PWRAP_SPI0_MO,
		RES3, RES4, RES5, RES6, RES7),
	PIN(210, PWRAP_SPI0_CSN, 0, 11, 0x14, 0x50,
		PWRAP_SPI0_CSN, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(211, PWRAP_SPI0_MO, 0, 13, 0x14, 0x50,
		PWRAP_SPI0_MO, PWRAP_SPI0_MI,
		RES3, RES4, RES5, RES6, RES7),
	PIN(212, PWRAP_SPI0_CK, 0, 10, 0x14, 0x50,
		PWRAP_SPI0_CK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(213, RTC32K_CK, 0, 14, 0x14, 0x50,
		RTC32K_CK, RES2, RES3,
		RES4, RES5, RES6, RES7),
	PIN(214, AUD_CLK_MOSI, 0, 0, 0x14, 0x50,
		AUD_CLK_MOSI, RES2, I2S1_MCK,
		I2S7_MCK, I2S9_MCK, RES6, RES7),
	PIN(215, AUD_SYNC_MOSI, 0, 9, 0x14, 0x50,
		AUD_SYNC_MOSI, RES2, I2S1_BCK,
		I2S7_BCK, I2S9_BCK, RES6, RES7),
	PIN(216, AUD_DAT_MOSI0, 0, 4, 0x14, 0x50,
		AUD_DAT_MOSI0, RES2, I2S1_LRCK,
		I2S7_LRCK, I2S9_LRCK, RES6, RES7),
	PIN(217, AUD_DAT_MOSI1, 0, 5, 0x14, 0x50,
		AUD_DAT_MOSI1, RES2, I2S1_DO,
		I2S7_DO, I2S9_DO, RES6, RES7),
	PIN(218, AUD_DAT_MISO0, 0, 1, 0x14, 0x50,
		AUD_DAT_MISO0, VOW_DAT_MISO, I2S2_LRCK,
		I2S6_LRCK, I2S8_LRCK, RES6, RES7),
	PIN(219, AUD_DAT_MISO1, 0, 2, 0x14, 0x50,
		AUD_DAT_MISO1, VOW_CLK_MISO, I2S2_DI,
		I2S6_DI, I2S8_DI, RES6, RES7),
};

struct gpio_regs {
	struct gpio_val_regs dir[7];
	uint8_t rsv00[144];
	struct gpio_val_regs dout[7];
	uint8_t rsv01[144];
	struct gpio_val_regs din[7];
	uint8_t rsv02[144];
	struct gpio_val_regs mode[28];
	uint8_t rsv03[560];
	uint32_t dram_pinmux_trapping;
};

check_member(gpio_regs, mode[27].val, 0x4b0);
check_member(gpio_regs, dram_pinmux_trapping, 0x6f0);

static struct gpio_regs *const mtk_gpio = (void *)(GPIO_BASE);

#endif
