/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.soap.FileList;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;

public class RemoteFileNode
extends DefaultMutableTreeNode
implements Transferable,
Serializable {
    private boolean explored = false;
    private boolean isDir = false;
    private String fullname;
    private String serverPathToFile;
    private String rootdir;
    private transient JembossParams mysettings;
    private transient FileRoots froots;
    private String fs = "/";
    public static final DataFlavor REMOTEFILENODE = new DataFlavor(RemoteFileNode.class, "Remote file");
    static DataFlavor[] remoteFlavors = new DataFlavor[]{REMOTEFILENODE, DataFlavor.stringFlavor};

    public RemoteFileNode(JembossParams mysettings, FileRoots froots, String file, FileList parentList, String parent) {
        this(mysettings, froots, file, parentList, parent, false);
    }

    public RemoteFileNode(JembossParams mysettings, FileRoots froots, String file, FileList parentList, String parent, boolean ldir) {
        this.mysettings = mysettings;
        this.froots = froots;
        this.isDir = ldir;
        this.rootdir = froots.getCurrentRoot();
        this.serverPathToFile = (String)froots.getRoots().get(this.rootdir);
        if (file.equals(" ")) {
            this.isDir = true;
        }
        if (parent != null) {
            if (parent.endsWith("/.")) {
                parent = parent.substring(0, parent.length() - 1);
            } else if (parent.endsWith(this.fs)) {
                parent = parent.substring(0, parent.length());
            }
            if (parent.equals(".")) {
                this.fullname = file;
            } else {
                this.fullname = parent + this.fs + file;
                this.serverPathToFile = this.serverPathToFile.endsWith(this.fs) ? this.serverPathToFile.concat(parent) : this.serverPathToFile.concat(this.fs + parent);
            }
        }
        if (parentList != null) {
            if (parentList.isDirectory(file)) {
                this.isDir = true;
            }
        } else if (parent == null) {
            this.fullname = ".";
        }
        this.setUserObject(file);
    }

    public boolean getAllowsChildren() {
        return this.isDir;
    }

    public boolean isLeaf() {
        return !this.isDir;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public String getFile() {
        return (String)this.getUserObject();
    }

    public String getRootDir() {
        return this.rootdir;
    }

    public String getFullName() {
        return this.fullname;
    }

    public String getPathName() {
        return this.serverPathToFile;
    }

    public boolean isExplored() {
        return this.explored;
    }

    public String getServerName() {
        String prefix = this.serverPathToFile;
        if (!prefix.endsWith(this.fs)) {
            prefix = prefix.concat(this.fs);
        }
        if (this.fullname.equals(".")) {
            return prefix;
        }
        return prefix + (String)this.getUserObject();
    }

    public void explore() {
        if (!this.isDir) {
            return;
        }
        if (!this.explored) {
            try {
                FileList efl = new FileList(this.mysettings, this.getRootDir(), this.fullname);
                Vector children = efl.fileVector();
                for (int i = 0; i < children.size(); ++i) {
                    this.add(new RemoteFileNode(this.mysettings, this.froots, (String)children.get(i), efl, this.fullname));
                }
            }
            catch (JembossSoapException eae) {
                eae.printStackTrace();
            }
        }
        this.explored = true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return remoteFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(REMOTEFILENODE) || f.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor d) throws UnsupportedFlavorException, IOException {
        if (d.equals(REMOTEFILENODE)) {
            return this;
        }
        if (d.equals(DataFlavor.stringFlavor)) {
            return this.getServerName();
        }
        throw new UnsupportedFlavorException(d);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

