/* { dg-final { check-function-bodies "**" "" "-DCHECK_ASM" } } */

#include "test_sve_acle.h"

/*
** max_s64_m_tied1:
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_m_tied1, svint64_t,
		z0 = svmax_s64_m (p0, z0, z1),
		z0 = svmax_m (p0, z0, z1))

/*
** max_s64_m_tied2:
**	mov	(z[0-9]+\.d), z0\.d
**	movprfx	z0, z1
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_s64_m_tied2, svint64_t,
		z0 = svmax_s64_m (p0, z1, z0),
		z0 = svmax_m (p0, z1, z0))

/*
** max_s64_m_untied:
**	movprfx	z0, z1
**	smax	z0\.d, p0/m, z0\.d, z2\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_m_untied, svint64_t,
		z0 = svmax_s64_m (p0, z1, z2),
		z0 = svmax_m (p0, z1, z2))

/*
** max_x0_s64_m_tied1:
**	mov	(z[0-9]+\.d), x0
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_m_tied1, svint64_t, int64_t,
		 z0 = svmax_n_s64_m (p0, z0, x0),
		 z0 = svmax_m (p0, z0, x0))

/*
** max_x0_s64_m_untied:
**	mov	(z[0-9]+\.d), x0
**	movprfx	z0, z1
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_m_untied, svint64_t, int64_t,
		 z0 = svmax_n_s64_m (p0, z1, x0),
		 z0 = svmax_m (p0, z1, x0))

/*
** max_1_s64_m_tied1:
**	mov	(z[0-9]+\.d), #1
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_m_tied1, svint64_t,
		z0 = svmax_n_s64_m (p0, z0, 1),
		z0 = svmax_m (p0, z0, 1))

/*
** max_1_s64_m_untied: { xfail *-*-* }
**	mov	(z[0-9]+\.d), #1
**	movprfx	z0, z1
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_m_untied, svint64_t,
		z0 = svmax_n_s64_m (p0, z1, 1),
		z0 = svmax_m (p0, z1, 1))

/*
** max_m1_s64_m:
**	mov	(z[0-9]+)\.b, #-1
**	smax	z0\.d, p0/m, z0\.d, \1\.d
**	ret
*/
TEST_UNIFORM_Z (max_m1_s64_m, svint64_t,
		z0 = svmax_n_s64_m (p0, z0, -1),
		z0 = svmax_m (p0, z0, -1))

/*
** max_s64_z_tied1:
**	movprfx	z0\.d, p0/z, z0\.d
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_z_tied1, svint64_t,
		z0 = svmax_s64_z (p0, z0, z1),
		z0 = svmax_z (p0, z0, z1))

/*
** max_s64_z_tied2:
**	movprfx	z0\.d, p0/z, z0\.d
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_z_tied2, svint64_t,
		z0 = svmax_s64_z (p0, z1, z0),
		z0 = svmax_z (p0, z1, z0))

/*
** max_s64_z_untied:
** (
**	movprfx	z0\.d, p0/z, z1\.d
**	smax	z0\.d, p0/m, z0\.d, z2\.d
** |
**	movprfx	z0\.d, p0/z, z2\.d
**	smax	z0\.d, p0/m, z0\.d, z1\.d
** )
**	ret
*/
TEST_UNIFORM_Z (max_s64_z_untied, svint64_t,
		z0 = svmax_s64_z (p0, z1, z2),
		z0 = svmax_z (p0, z1, z2))

/*
** max_x0_s64_z_tied1:
**	mov	(z[0-9]+\.d), x0
**	movprfx	z0\.d, p0/z, z0\.d
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_z_tied1, svint64_t, int64_t,
		 z0 = svmax_n_s64_z (p0, z0, x0),
		 z0 = svmax_z (p0, z0, x0))

/*
** max_x0_s64_z_untied:
**	mov	(z[0-9]+\.d), x0
** (
**	movprfx	z0\.d, p0/z, z1\.d
**	smax	z0\.d, p0/m, z0\.d, \1
** |
**	movprfx	z0\.d, p0/z, \1
**	smax	z0\.d, p0/m, z0\.d, z1\.d
** )
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_z_untied, svint64_t, int64_t,
		 z0 = svmax_n_s64_z (p0, z1, x0),
		 z0 = svmax_z (p0, z1, x0))

/*
** max_1_s64_z_tied1:
**	mov	(z[0-9]+\.d), #1
**	movprfx	z0\.d, p0/z, z0\.d
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_z_tied1, svint64_t,
		z0 = svmax_n_s64_z (p0, z0, 1),
		z0 = svmax_z (p0, z0, 1))

/*
** max_1_s64_z_untied:
**	mov	(z[0-9]+\.d), #1
** (
**	movprfx	z0\.d, p0/z, z1\.d
**	smax	z0\.d, p0/m, z0\.d, \1
** |
**	movprfx	z0\.d, p0/z, \1
**	smax	z0\.d, p0/m, z0\.d, z1\.d
** )
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_z_untied, svint64_t,
		z0 = svmax_n_s64_z (p0, z1, 1),
		z0 = svmax_z (p0, z1, 1))

/*
** max_s64_x_tied1:
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_x_tied1, svint64_t,
		z0 = svmax_s64_x (p0, z0, z1),
		z0 = svmax_x (p0, z0, z1))

/*
** max_s64_x_tied2:
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_Z (max_s64_x_tied2, svint64_t,
		z0 = svmax_s64_x (p0, z1, z0),
		z0 = svmax_x (p0, z1, z0))

/*
** max_s64_x_untied:
** (
**	movprfx	z0, z1
**	smax	z0\.d, p0/m, z0\.d, z2\.d
** |
**	movprfx	z0, z2
**	smax	z0\.d, p0/m, z0\.d, z1\.d
** )
**	ret
*/
TEST_UNIFORM_Z (max_s64_x_untied, svint64_t,
		z0 = svmax_s64_x (p0, z1, z2),
		z0 = svmax_x (p0, z1, z2))

/*
** max_x0_s64_x_tied1:
**	mov	(z[0-9]+\.d), x0
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_x_tied1, svint64_t, int64_t,
		 z0 = svmax_n_s64_x (p0, z0, x0),
		 z0 = svmax_x (p0, z0, x0))

/*
** max_x0_s64_x_untied:
**	mov	z0\.d, x0
**	smax	z0\.d, p0/m, z0\.d, z1\.d
**	ret
*/
TEST_UNIFORM_ZX (max_x0_s64_x_untied, svint64_t, int64_t,
		 z0 = svmax_n_s64_x (p0, z1, x0),
		 z0 = svmax_x (p0, z1, x0))

/*
** max_1_s64_x_tied1:
**	smax	z0\.d, z0\.d, #1
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_x_tied1, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, 1),
		z0 = svmax_x (p0, z0, 1))

/*
** max_1_s64_x_untied:
**	movprfx	z0, z1
**	smax	z0\.d, z0\.d, #1
**	ret
*/
TEST_UNIFORM_Z (max_1_s64_x_untied, svint64_t,
		z0 = svmax_n_s64_x (p0, z1, 1),
		z0 = svmax_x (p0, z1, 1))

/*
** max_127_s64_x:
**	smax	z0\.d, z0\.d, #127
**	ret
*/
TEST_UNIFORM_Z (max_127_s64_x, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, 127),
		z0 = svmax_x (p0, z0, 127))

/*
** max_128_s64_x:
**	mov	(z[0-9]+\.d), #128
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_128_s64_x, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, 128),
		z0 = svmax_x (p0, z0, 128))

/*
** max_m1_s64_x:
**	smax	z0\.d, z0\.d, #-1
**	ret
*/
TEST_UNIFORM_Z (max_m1_s64_x, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, -1),
		z0 = svmax_x (p0, z0, -1))

/*
** max_m128_s64_x:
**	smax	z0\.d, z0\.d, #-128
**	ret
*/
TEST_UNIFORM_Z (max_m128_s64_x, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, -128),
		z0 = svmax_x (p0, z0, -128))

/*
** max_m129_s64_x:
**	mov	(z[0-9]+\.d), #-129
**	smax	z0\.d, p0/m, z0\.d, \1
**	ret
*/
TEST_UNIFORM_Z (max_m129_s64_x, svint64_t,
		z0 = svmax_n_s64_x (p0, z0, -129),
		z0 = svmax_x (p0, z0, -129))
