//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatacatalog

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// ADCOperationsClient contains the methods for the ADCOperations group.
// Don't use this type directly, use NewADCOperationsClient() instead.
type ADCOperationsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewADCOperationsClient creates a new instance of ADCOperationsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewADCOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ADCOperationsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ADCOperationsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// List - Lists all the available Azure Data Catalog service operations.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-03-30
// options - ADCOperationsClientListOptions contains the optional parameters for the ADCOperationsClient.List method.
func (client *ADCOperationsClient) List(ctx context.Context, options *ADCOperationsClientListOptions) (ADCOperationsClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, options)
	if err != nil {
		return ADCOperationsClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ADCOperationsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ADCOperationsClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *ADCOperationsClient) listCreateRequest(ctx context.Context, options *ADCOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.DataCatalog/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ADCOperationsClient) listHandleResponse(resp *http.Response) (ADCOperationsClientListResponse, error) {
	result := ADCOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationEntityListResult); err != nil {
		return ADCOperationsClientListResponse{}, err
	}
	return result, nil
}
