// Code generated by smithy-go-codegen DO NOT EDIT.

package codeartifact

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codeartifact/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of packages associated with the requested package group. For
// information package group association and matching, see [Package group definition syntax and matching behavior]in the CodeArtifact
// User Guide.
//
// [Package group definition syntax and matching behavior]: https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html
func (c *Client) ListAssociatedPackages(ctx context.Context, params *ListAssociatedPackagesInput, optFns ...func(*Options)) (*ListAssociatedPackagesOutput, error) {
	if params == nil {
		params = &ListAssociatedPackagesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAssociatedPackages", params, optFns, c.addOperationListAssociatedPackagesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAssociatedPackagesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAssociatedPackagesInput struct {

	//  The name of the domain that contains the package group from which to list
	// associated packages.
	//
	// This member is required.
	Domain *string

	//  The pattern of the package group from which to list associated packages.
	//
	// This member is required.
	PackageGroup *string

	//  The 12-digit account number of the Amazon Web Services account that owns the
	// domain. It does not include dashes or spaces.
	DomainOwner *string

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	//  When this flag is included, ListAssociatedPackages will return a list of
	// packages that would be associated with a package group, even if it does not
	// exist.
	Preview *bool

	noSmithyDocumentSerde
}

type ListAssociatedPackagesOutput struct {

	//  The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	//  The list of packages associated with the requested package group.
	Packages []types.AssociatedPackage

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAssociatedPackagesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAssociatedPackages{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAssociatedPackages{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAssociatedPackages"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAssociatedPackagesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAssociatedPackages(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAssociatedPackagesAPIClient is a client that implements the
// ListAssociatedPackages operation.
type ListAssociatedPackagesAPIClient interface {
	ListAssociatedPackages(context.Context, *ListAssociatedPackagesInput, ...func(*Options)) (*ListAssociatedPackagesOutput, error)
}

var _ ListAssociatedPackagesAPIClient = (*Client)(nil)

// ListAssociatedPackagesPaginatorOptions is the paginator options for
// ListAssociatedPackages
type ListAssociatedPackagesPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAssociatedPackagesPaginator is a paginator for ListAssociatedPackages
type ListAssociatedPackagesPaginator struct {
	options   ListAssociatedPackagesPaginatorOptions
	client    ListAssociatedPackagesAPIClient
	params    *ListAssociatedPackagesInput
	nextToken *string
	firstPage bool
}

// NewListAssociatedPackagesPaginator returns a new ListAssociatedPackagesPaginator
func NewListAssociatedPackagesPaginator(client ListAssociatedPackagesAPIClient, params *ListAssociatedPackagesInput, optFns ...func(*ListAssociatedPackagesPaginatorOptions)) *ListAssociatedPackagesPaginator {
	if params == nil {
		params = &ListAssociatedPackagesInput{}
	}

	options := ListAssociatedPackagesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAssociatedPackagesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAssociatedPackagesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAssociatedPackages page.
func (p *ListAssociatedPackagesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAssociatedPackagesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAssociatedPackages(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAssociatedPackages(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAssociatedPackages",
	}
}
