---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Server-Side Template Injection

## Description

The application is vulnerable to Server-Side Template Injection (SSTI), which enables attackers to
manipulate templates on the server side. This vulnerability arises when untrusted user input is
directly used in server-side templates without adequate sanitization. Attackers can exploit this
weakness to inject and execute arbitrary code in templates, potentially compromising the
system's integrity and confidentiality.

## Remediation

User-controlled data should always have special elements neutralized when used as part of
constructing Expression Language statements. Consult the documentation for the template
system in use on how properly neutralize user-controlled data.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 1336.1 | false | 1336 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/1336.html)
- [Testing for Server-side Template Injection](https://owasp.org/www-project-web-security-testing-guide/stable/4-Web_Application_Security_Testing/07-Input_Validation_Testing/18-Testing_for_Server-side_Template_Injection)
