package rpmdb

var (
	// docker run --rm -it centos:5 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	CentOS5Plain = []*PackageInfo{
		{0, "setup", "2.5.58", "9.el5", "noarch", "setup-2.5.58-9.el5.src.rpm", 381527, "public domain", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "8.0", "5.1.1.el5.centos", "noarch", "basesystem-8.0-5.1.1.el5.centos.src.rpm", 0, "public domain", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.8.9", "3.3", "x86_64", "cracklib-2.8.9-3.3.src.rpm", 8043753, "Artistic", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2016c", "1.el5", "x86_64", "tzdata-2016c-1.el5.src.rpm", 1796593, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.5", "123.el5_11.3", "x86_64", "glibc-2.5-123.el5_11.3.src.rpm", 11690192, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.3", "7.el5", "x86_64", "zlib-1.2.3-7.el5.src.rpm", 88976, "BSD", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.10.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 142842, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.12.3", "4.el5_3.1", "x86_64", "glib2-2.12.3-4.el5_3.1.src.rpm", 2429701, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "1.8", "2.el5", "x86_64", "audit-1.8-2.el5.src.rpm", 156639, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "bash", "3.2", "33.el5_11.4", "x86_64", "bash-3.2-33.el5_11.4.src.rpm", 5235475, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "info", "4.8", "14.el5", "x86_64", "texinfo-4.8-14.el5.src.rpm", 285963, "GPL", "CentOS", "", nil, nil, nil},
		{0, "readline", "5.1", "3.el5", "x86_64", "readline-5.1-3.el5.src.rpm", 384289, "GPL", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.19.1", "4.el5_11", "x86_64", "nss-3.19.1-4.el5_11.src.rpm", 3568632, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.137", "3.el5", "x86_64", "elfutils-0.137-3.el5.src.rpm", 76000, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.32", "1.1", "x86_64", "attr-2.4.32-1.1.src.rpm", 15560, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.1.2", "55.el5", "x86_64", "gcc-4.1.2-55.el5.src.rpm", 973680, "GPL", "CentOS", "", nil, nil, nil},
		{0, "iproute", "2.6.18", "15.el5", "x86_64", "iproute-2.6.18-15.el5.src.rpm", 2165603, "GNU GPL", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.5.1", "55.el5", "x86_64", "grep-2.5.1-55.el5.src.rpm", 443427, "GPL", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "2.8.1", "16.el5", "x86_64", "diffutils-2.8.1-16.el5.src.rpm", 568548, "GPL", "CentOS", "", nil, nil, nil},
		{0, "gawk", "3.1.5", "16.el5", "x86_64", "gawk-3.1.5-16.el5.src.rpm", 4384895, "GPL", "CentOS", "", nil, nil, nil},
		{0, "less", "436", "9.el5", "x86_64", "less-436-9.el5.src.rpm", 191053, "GPL", "CentOS", "", nil, nil, nil},
		{0, "procps", "3.2.7", "26.el5", "x86_64", "procps-3.2.7-26.el5.src.rpm", 413100, "GPL", "CentOS", "", nil, nil, nil},
		{0, "crontabs", "1.10", "11.el5", "noarch", "crontabs-1.10-11.el5.src.rpm", 2056, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.6.26", "2.1.25.el5_11", "x86_64", "libxml2-2.6.26-2.1.25.el5_11.src.rpm", 1646329, "MIT", "CentOS", "", nil, nil, nil},
		{0, "sgpio", "1.2.0_10", "2.el5", "x86_64", "sgpio-1.2.0_10-2.el5.src.rpm", 15901, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mingetty", "1.07", "5.2.2", "x86_64", "mingetty-1.07-5.2.2.src.rpm", 32432, "GPL", "CentOS", "", nil, nil, nil},
		{0, "libcap", "1.10", "26", "x86_64", "libcap-1.10-26.src.rpm", 56330, "BSD-like and LGPL", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.2", "1.el5", "x86_64", "keyutils-1.2-1.el5.src.rpm", 33608, "GPL/LGPL", "CentOS", "", nil, nil, nil},
		{10, "centos-release", "5", "11.el5.centos", "x86_64", "centos-release-5-11.el5.centos.src.rpm", 45731, "GPL", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.4.3", "56.el5", "x86_64", "python-2.4.3-56.el5.src.rpm", 22018736, "PSF - see LICENSE", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.8.9", "3.3", "x86_64", "cracklib-2.8.9-3.3.src.rpm", 176409, "Artistic", "CentOS", "", nil, nil, nil},
		{0, "device-mapper-event", "1.02.67", "2.el5_11.1", "x86_64", "device-mapper-1.02.67-2.el5_11.1.src.rpm", 32432, "GPL", "CentOS", "", nil, nil, nil},
		{0, "net-tools", "1.60", "83.el5_10", "x86_64", "net-tools-1.60-83.el5_10.src.rpm", 798220, "GPL", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.4", "4.el5", "x86_64", "libutempter-1.1.4-4.el5.src.rpm", 40484, "LGPL", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.15.1", "32.el5_8", "x86_64", "tar-1.15.1-32.el5_8.src.rpm", 1671798, "GPL", "CentOS", "", nil, nil, nil},
		{0, "SysVinit", "2.86", "17.el5", "x86_64", "SysVinit-2.86-17.el5.src.rpm", 226009, "GPL", "CentOS", "", nil, nil, nil},
		{0, "e2fsprogs", "1.39", "37.el5", "x86_64", "e2fsprogs-1.39-37.el5.src.rpm", 1985776, "GPL", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.7", "64.el5_11", "x86_64", "device-mapper-multipath-0.4.7-64.el5_11.src.rpm", 983150, "GPL", "CentOS", "", nil, nil, nil},
		{0, "device-mapper-multipath", "0.4.7", "64.el5_11", "x86_64", "device-mapper-multipath-0.4.7-64.el5_11.src.rpm", 7193153, "GPL", "CentOS", "", nil, nil, nil},
		{0, "logrotate", "3.7.4", "14", "x86_64", "logrotate-3.7.4-14.src.rpm", 59821, "GPL", "CentOS", "", nil, nil, nil},
		{0, "MAKEDEV", "3.23", "1.2", "x86_64", "MAKEDEV-3.23-1.2.src.rpm", 660343, "GPL", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "5.97", "34.el5_8.1", "x86_64", "coreutils-5.97-34.el5_8.1.src.rpm", 9045871, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "udev", "095", "14.33.el5_11", "x86_64", "udev-095-14.33.el5_11.src.rpm", 5627184, "GPL", "CentOS", "", nil, nil, nil},
		{0, "module-init-tools", "3.3", "0.pre3.1.63.el5", "x86_64", "module-init-tools-3.3-0.pre3.1.63.el5.src.rpm", 907394, "GPL", "CentOS", "", nil, nil, nil},
		{0, "mcstrans", "0.2.11", "3.el5", "x86_64", "mcstrans-0.2.11-3.el5.src.rpm", 23099, "GPL", "CentOS", "", nil, nil, nil},
		{0, "initscripts", "8.45.45", "1.el5.centos", "x86_64", "initscripts-8.45.45-1.el5.centos.src.rpm", 5509410, "GPLv2 and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 2080256, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{30, "bind-libs", "9.3.6", "25.P1.el5_11.8", "x86_64", "bind-9.3.6-25.P1.el5_11.8.src.rpm", 2023624, "BSD-like", "CentOS", "", nil, nil, nil},
		{0, "python-elementtree", "1.2.6", "5", "x86_64", "python-elementtree-1.2.6-5.src.rpm", 311637, "PSF", "CentOS", "", nil, nil, nil},
		{0, "m2crypto", "0.16", "9.el5", "x86_64", "m2crypto-0.16-9.el5.src.rpm", 1829395, "BSDish", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.2", "4.el5", "x86_64", "yum-metadata-parser-1.1.2-4.el5.src.rpm", 55883, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.2.22", "40.el5.centos", "noarch", "yum-3.2.22-40.el5.centos.src.rpm", 3429595, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.54.7", "3.el5", "x86_64", "libuser-0.54.7-3.el5.src.rpm", 1647843, "LGPL", "CentOS", "", nil, nil, nil},
		{30, "bind-utils", "9.3.6", "25.P1.el5_11.8", "x86_64", "bind-9.3.6-25.P1.el5_11.8.src.rpm", 300911, "BSD-like", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.0.109", "7.2.el5", "x86_64", "vim-7.0.109-7.2.el5.src.rpm", 630565, "freeware", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "1.1.1", "noarch", "rootfiles-8.1-1.1.1.src.rpm", 620, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.1.2", "55.el5", "x86_64", "gcc-4.1.2-55.el5.src.rpm", 84728, "GPL", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "2.4.0", "3.el5.centos", "x86_64", "filesystem-2.4.0-3.el5.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nash", "5.1.19.6", "82.el5", "x86_64", "mkinitrd-5.1.19.6-82.el5.src.rpm", 2455441, "GPL", "CentOS", "", nil, nil, nil},
		{1, "termcap", "5.5", "1.20060701.1", "noarch", "termcap-5.5-1.20060701.1.src.rpm", 807103, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.5", "123.el5_11.3", "x86_64", "glibc-2.5-123.el5_11.3.src.rpm", 66738287, "LGPL", "CentOS", "", nil, nil, nil},
		{3, "mktemp", "1.5", "24.el5", "x86_64", "mktemp-1.5-24.el5.src.rpm", 15432, "BSD", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.3.30.2", "2.el5", "x86_64", "chkconfig-1.3.30.2-2.el5.src.rpm", 596588, "GPL", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.10.8", "2.el5_11", "x86_64", "nspr-4.10.8-2.el5_11.src.rpm", 258472, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.3", "6.el5_5", "x86_64", "bzip2-1.0.3-6.el5_5.src.rpm", 65528, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtermcap", "2.0.8", "46.1", "x86_64", "libtermcap-2.0.8-46.1.src.rpm", 13320, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.5", "24.20060715", "x86_64", "ncurses-5.5-24.20060715.src.rpm", 3022251, "distributable", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "1.15.2", "3.el5", "x86_64", "libsepol-1.15.2-3.el5.src.rpm", 245232, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.3.6", "7", "x86_64", "sqlite-3.3.6-7.src.rpm", 411302, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.1.5", "8.el5", "x86_64", "sed-4.1.5-8.el5.src.rpm", 335348, "GPL", "CentOS", "", nil, nil, nil},
		{0, "expat", "1.95.8", "11.el5_8", "x86_64", "expat-1.95.8-11.el5_8.src.rpm", 173262, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.39", "8.el5", "x86_64", "acl-2.2.39-8.el5.src.rpm", 25624, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "db4", "4.3.29", "10.el5_5.2", "x86_64", "db4-4.3.29-10.el5_5.2.src.rpm", 2118874, "GPL", "CentOS", "", nil, nil, nil},
		{0, "pcre", "6.6", "9.el5", "x86_64", "pcre-6.6-9.el5.src.rpm", 244957, "BSD", "CentOS", "", nil, nil, nil},
		{0, "hmaccalc", "0.9.6", "4.el5", "x86_64", "hmaccalc-0.9.6-4.el5.src.rpm", 93006, "MIT", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.17.50.0.6", "26.el5", "x86_64", "binutils-2.17.50.0.6-26.el5.src.rpm", 7416670, "GPL", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.6", "26.el5", "x86_64", "cpio-2.6-26.el5.src.rpm", 285951, "GPL", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.3.5", "13.el5.centos", "x86_64", "gzip-1.3.5-13.el5.centos.src.rpm", 181411, "GPL", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20020927", "46.el5", "x86_64", "iputils-20020927-46.el5.src.rpm", 284557, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libsysfs", "2.1.0", "1.el5", "x86_64", "sysfsutils-2.1.0-1.el5.src.rpm", 144141, "LGPL", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.22", "7.el5_8.1", "x86_64", "cyrus-sasl-2.1.22-7.el5_8.1.src.rpm", 303193, "Freely Distributable", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.8.0", "28.el5", "x86_64", "gdbm-1.8.0-28.el5.src.rpm", 47658, "GPL", "CentOS", "", nil, nil, nil},
		{0, "ethtool", "6", "4.el5", "x86_64", "ethtool-6-4.el5.src.rpm", 152180, "GPL", "CentOS", "", nil, nil, nil},
		{0, "centos-release-notes", "5.11", "0", "x86_64", "centos-release-notes-5.11-0.src.rpm", 52622, "GPL", "CentOS", "", nil, nil, nil},
		{0, "openssl", "0.9.8e", "39.el5_11", "x86_64", "openssl-0.9.8e-39.el5_11.src.rpm", 4171441, "BSDish", "CentOS", "", nil, nil, nil},
		{0, "python", "2.4.3", "56.el5", "x86_64", "python-2.4.3-56.el5.src.rpm", 74377, "PSF - see LICENSE", "CentOS", "", nil, nil, nil},
		{0, "iscsi-initiator-utils", "6.2.0.872", "16.el5", "x86_64", "iscsi-initiator-utils-6.2.0.872-16.el5.src.rpm", 3137545, "GPL", "CentOS", "", nil, nil, nil},
		{0, "dmraid-events", "1.0.0.rc13", "65.el5", "x86_64", "dmraid-1.0.0.rc13-65.el5.src.rpm", 8788, "GPL", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.0.17", "23.el5", "x86_64", "shadow-utils-4.0.17-23.el5.src.rpm", 2785766, "BSD", "CentOS", "", nil, nil, nil},
		{0, "psmisc", "22.2", "11", "x86_64", "psmisc-22.2-11.src.rpm", 162941, "BSD/GPL", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.2.27", "6.el5", "x86_64", "findutils-4.2.27-6.el5.src.rpm", 686644, "GPL", "CentOS", "", nil, nil, nil},
		{0, "e2fsprogs-libs", "1.39", "37.el5", "x86_64", "e2fsprogs-1.39-37.el5.src.rpm", 233240, "GPL", "CentOS", "", nil, nil, nil},
		{0, "lvm2", "2.02.88", "13.el5", "x86_64", "lvm2-2.02.88-13.el5.src.rpm", 9619149, "GPL", "CentOS", "", nil, nil, nil},
		{0, "dmraid", "1.0.0.rc13", "65.el5", "x86_64", "dmraid-1.0.0.rc13-65.el5.src.rpm", 1697084, "GPL", "CentOS", "", nil, nil, nil},
		{0, "device-mapper", "1.02.67", "2.el5_11.1", "x86_64", "device-mapper-1.02.67-2.el5_11.1.src.rpm", 2173856, "GPL", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "1.33.4", "5.7.el5.centos", "x86_64", "libselinux-1.33.4-5.7.el5.centos.src.rpm", 92976, "Public domain (uncopyrighted)", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.6.1", "80.el5_11", "x86_64", "krb5-1.6.1-80.el5_11.src.rpm", 1467909, "MIT, freely distributable.", "CentOS", "", nil, nil, nil},
		{0, "pam", "0.99.6.2", "14.el5_11", "x86_64", "pam-0.99.6.2-14.el5_11.src.rpm", 2590520, "GPL or BSD", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.13", "0.59.el5_8", "x86_64", "util-linux-2.13-0.59.el5_8.src.rpm", 4813548, "distributable", "CentOS", "", nil, nil, nil},
		{0, "mkinitrd", "5.1.19.6", "82.el5", "x86_64", "mkinitrd-5.1.19.6-82.el5.src.rpm", 955929, "GPL", "CentOS", "", nil, nil, nil},
		{0, "rsyslog", "3.22.1", "7.el5", "x86_64", "rsyslog-3.22.1-7.el5.src.rpm", 1277211, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 3754335, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 133812, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.2.3", "6.el5", "noarch", "python-iniparse-0.2.3-6.el5.src.rpm", 134606, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-sqlite", "1.1.7", "1.2.1", "x86_64", "python-sqlite-1.1.7-1.2.1.src.rpm", 120728, "GPL", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.1.0", "6.el5", "noarch", "python-urlgrabber-3.1.0-6.el5.src.rpm", 478912, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-fastestmirror", "1.1.16", "21.el5.centos", "noarch", "yum-utils-1.1.16-21.el5.centos.src.rpm", 48064, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.3.43", "29.el5_11", "x86_64", "openldap-2.3.43-29.el5_11.src.rpm", 618899, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.73", "2", "x86_64", "passwd-0.73-2.src.rpm", 27293, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "1.33.4", "5.7.el5.centos", "x86_64", "libselinux-1.33.4-5.7.el5.centos.src.rpm", 52008, "Public domain (uncopyrighted)", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// yum groupinstall -y "Development tools"
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS6DevTools = []*PackageInfo{
		{0, "iproute", "2.6.32", "57.el6", "x86_64", "iproute-2.6.32-57.el6.src.rpm", 963477, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20071127", "24.el6", "x86_64", "iputils-20071127-24.el6.src.rpm", 297243, "BSD with advertising and GPLv2+ and Rdisc", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "util-linux-ng", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 6139437, "GPLv1+ and GPLv2 and GPLv2+ and LGPLv2+ and MIT and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "udev", "147", "2.73.el6_8.2", "x86_64", "udev-147-2.73.el6_8.2.src.rpm", 1280842, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 1352442, "BSD", "CentOS", "", nil, nil, nil},
		{0, "git", "1.7.1", "9.el6_9", "x86_64", "git-1.7.1-9.el6_9.src.rpm", 15290753, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-devel", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 6327079, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{0, "hicolor-icon-theme", "0.11", "1.1.el6", "noarch", "hicolor-icon-theme-0.11-1.1.el6.src.rpm", 45406, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgcj", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 65012480, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "intltool", "0.41.0", "1.1.el6", "noarch", "intltool-0.41.0-1.1.el6.src.rpm", 167585, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "subversion", "1.6.11", "15.el6_7", "x86_64", "subversion-1.6.11-15.el6_7.src.rpm", 12105530, "ASL 1.1", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gcc-gfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 14473805, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 323213, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "flex", "2.5.35", "9.el6", "x86_64", "flex-2.5.35-9.el6.src.rpm", 736081, "BSD", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cscope", "15.6", "7.el6", "x86_64", "cscope-15.6-7.el6.src.rpm", 466265, "BSD", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rcs", "5.7", "37.el6", "x86_64", "rcs-5.7-37.el6.src.rpm", 709927, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", nil, nil, nil},
		{0, "diffstat", "1.51", "2.el6", "x86_64", "diffstat-1.51-2.el6.src.rpm", 45568, "MIT", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", nil, nil, nil},
		{1, "doxygen", "1.6.1", "6.el6", "x86_64", "doxygen-1.6.1-6.el6.src.rpm", 9446190, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", nil, nil, nil},
		{0, "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", nil, nil, nil},
		{0, "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", nil, nil, nil},
		{0, "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", nil, nil, nil},
		{32, "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "c105b9de", "4e0fd3a3", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "glibc-common", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 112434659, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fontconfig", "2.8.0", "5.el6", "x86_64", "fontconfig-2.8.0-5.el6.src.rpm", 450597, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libproxy-bin", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 6800, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libproxy", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 118439, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "2.4.1", "6.el6", "x86_64", "mpfr-2.4.1-6.el6.src.rpm", 377376, "LGPLv2+ and GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{2, "libpng", "1.2.49", "2.el6_7", "x86_64", "libpng-1.2.49-2.el6_7.src.rpm", 654803, "zlib", "CentOS", "", nil, nil, nil},
		{0, "libtiff", "3.9.4", "21.el6_8", "x86_64", "libtiff-3.9.4-21.el6_8.src.rpm", 966899, "libtiff", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "1.el6_7.1", "x86_64", "zip-3.0-1.el6_7.1.src.rpm", 823164, "BSD", "CentOS", "", nil, nil, nil},
		{0, "apr", "1.3.9", "5.el6_9.1", "x86_64", "apr-1.3.9-5.el6_9.1.src.rpm", 303173, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "sysvinit-tools", "2.87", "6.dsf.el6", "x86_64", "sysvinit-2.87-6.dsf.el6.src.rpm", 114115, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atk", "1.30.0", "1.el6", "x86_64", "atk-1.30.0-1.el6.src.rpm", 957484, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libICE", "1.0.6", "1.el6", "x86_64", "libICE-1.0.6-1.el6.src.rpm", 117691, "MIT", "CentOS", "", nil, nil, nil},
		{0, "hwdata", "0.233", "20.1.el6", "noarch", "hwdata-0.233-20.1.el6.src.rpm", 5894683, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libSM", "1.2.1", "2.el6", "x86_64", "libSM-1.2.1-2.el6.src.rpm", 78264, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xz-lzma-compat", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 21146, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 677800, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", nil, nil, nil},
		{0, "jasper-libs", "1.900.1", "22.el6", "x86_64", "jasper-1.900.1-22.el6.src.rpm", 341232, "JasPer", "CentOS", "", nil, nil, nil},
		{0, "neon", "0.29.3", "3.el6_4", "x86_64", "neon-0.29.3-3.el6_4.src.rpm", 297415, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "alsa-lib", "1.1.0", "4.el6", "x86_64", "alsa-lib-1.1.0-4.el6.src.rpm", 1277969, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libart_lgpl", "2.3.20", "5.1.el6", "x86_64", "libart_lgpl-2.3.20-5.1.el6.src.rpm", 129211, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 28163, "BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 21092, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.13", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 476776, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{3, "perl-version", "0.77", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 51960, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-URI", "1.40", "2.el6", "noarch", "perl-URI-1.40-2.el6.src.rpm", 256097, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.63", "5.1.el6", "noarch", "autoconf-2.63-5.1.el6.src.rpm", 2605343, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "perl-Compress-Raw-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 146581, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 372202, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "9.0.3", "51.el6.centos", "noarch", "redhat-rpm-config-9.0.3-51.el6.centos.src.rpm", 138592, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "perl-HTML-Parser", "3.64", "2.el6", "x86_64", "perl-HTML-Parser-3.64-2.el6.src.rpm", 226598, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 6369345, "GPLv3 and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxcb", "1.12", "4.el6", "x86_64", "libxcb-1.12-4.el6.src.rpm", 886960, "MIT", "CentOS", "", nil, nil, nil},
		{0, "ppl", "0.10.2", "11.el6", "x86_64", "ppl-0.10.2-11.el6.src.rpm", 4637284, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rsync", "3.0.6", "12.el6", "x86_64", "rsync-3.0.6-12.el6.src.rpm", 698678, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 278832, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 988064, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 2776718, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 990251, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 9728819, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libX11", "1.6.4", "3.el6", "x86_64", "libX11-1.6.4-3.el6.src.rpm", 1301928, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXext", "1.3.3", "1.el6", "x86_64", "libXext-1.3.3-1.el6.src.rpm", 85590, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXfixes", "5.0.3", "1.el6", "x86_64", "libXfixes-5.0.3-1.el6.src.rpm", 23375, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXi", "1.7.8", "1.el6", "x86_64", "libXi-1.7.8-1.el6.src.rpm", 66523, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXtst", "1.2.3", "1.el6", "x86_64", "libXtst-1.2.3-1.el6.src.rpm", 27778, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXcursor", "1.1.14", "2.1.el6", "x86_64", "libXcursor-1.1.14-2.1.el6.src.rpm", 41934, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXft", "2.3.2", "1.el6", "x86_64", "libXft-2.3.2-1.el6.src.rpm", 120045, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXcomposite", "0.4.3", "4.el6", "x86_64", "libXcomposite-0.4.3-4.el6.src.rpm", 31878, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-libwww-perl", "5.833", "5.el6", "noarch", "perl-libwww-perl-5.833-5.el6.src.rpm", 903654, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "redhat-logos", "60.0.14", "12.el6.centos", "noarch", "redhat-logos-60.0.14-12.el6.centos.src.rpm", 15816517, "Copyright 1999-2010 the CentOS Project.  All rights reserved.", "CentOS", "", nil, nil, nil},
		{0, "iptables", "1.4.7", "19.el6", "x86_64", "iptables-1.4.7-19.el6.src.rpm", 861752, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libdrm", "2.4.65", "2.el6", "x86_64", "libdrm-2.4.65-2.el6.src.rpm", 306787, "MIT", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "plymouth", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 193924, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "initscripts", "9.03.61", "1.el6.centos", "x86_64", "initscripts-9.03.61-1.el6.centos.src.rpm", 5735427, "GPLv2 and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openssh", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 787618, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "1.7.1", "9.el6_9", "noarch", "git-1.7.1-9.el6_9.src.rpm", 35913, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kernel-devel", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 27015877, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-client", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 12275931, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "gtk2", "2.24.23", "9.el6", "x86_64", "gtk2-2.24.23-9.el6.src.rpm", 12426003, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gettext-devel", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 635713, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "systemtap", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 30373, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 11429003, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool", "2.2.6", "15.5.el6", "x86_64", "libtool-2.2.6-15.5.el6.src.rpm", 1998350, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "patchutils", "0.3.1", "3.1.el6", "x86_64", "patchutils-0.3.1-3.1.el6.src.rpm", 241488, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "bison", "2.4.1", "5.el6", "x86_64", "bison-2.4.1-5.el6.src.rpm", 2081518, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "ctags", "5.8", "2.el6", "x86_64", "ctags-5.8-2.el6.src.rpm", 347508, "GPLv2+ or Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", nil, nil, nil},
		{0, "swig", "1.3.40", "6.el6", "x86_64", "swig-1.3.40-6.el6.src.rpm", 4290828, "GPLv2+ and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "indent", "2.2.10", "7.el6", "x86_64", "indent-2.2.10-7.el6.src.rpm", 252872, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", nil, nil, nil},
		{0, "byacc", "1.9.20070509", "7.el6", "x86_64", "byacc-1.9.20070509-7.el6.src.rpm", 87968, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", nil, nil, nil},
		{0, "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", nil, nil, nil},
		{1, "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", nil, nil, nil},
		{0, "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{2, "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "freetype", "2.3.11", "17.el6", "x86_64", "freetype-2.3.11-17.el6.src.rpm", 836907, "FTL or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo", "1.2.1", "3.el6_5", "x86_64", "libjpeg-turbo-1.2.1-3.el6_5.src.rpm", 476782, "wxWidgets", "CentOS", "", nil, nil, nil},
		{0, "libproxy-python", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 8320, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.13", "5.el6", "x86_64", "m4-1.4.13-5.el6.src.rpm", 560949, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 648199, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "avahi-libs", "0.6.25", "17.el6", "x86_64", "avahi-0.6.25-17.el6.src.rpm", 114824, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "gnutls", "2.12.23", "22.el6", "x86_64", "gnutls-2.12.23-22.el6.src.rpm", 1167530, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xz", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 488160, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 9831328, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "5.el6", "x86_64", "unzip-6.0-5.el6.src.rpm", 331766, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 127982, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.6", "8.el6_9", "x86_64", "patch-2.6-8.el6_9.src.rpm", 179790, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libpciaccess", "0.13.4", "1.el6", "x86_64", "libpciaccess-0.13.4-1.el6.src.rpm", 40777, "MIT", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.3.9", "3.el6_0.1", "x86_64", "apr-util-1.3.9-3.el6_0.1.src.rpm", 202360, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{1, "cups-libs", "1.4.2", "81.el6_10", "x86_64", "cups-1.4.2-81.el6_10.src.rpm", 667768, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "cpp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 10012603, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "pakchois", "0.4", "3.2.el6", "x86_64", "pakchois-0.4-3.2.el6.src.rpm", 50156, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.86", "6.el6", "x86_64", "dbus-glib-0.86-6.el6.src.rpm", 579611, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-runtime", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 616098, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 10353, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pixman", "0.32.8", "1.el6", "x86_64", "pixman-0.32.8-1.el6.src.rpm", 721560, "MIT", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1485896, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Module-Pluggable", "3.90", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 31033, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 35282834, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17015", "4.el6", "noarch", "perl-Error-0.17015-4.el6.src.rpm", 47372, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.11.1", "4.el6", "noarch", "automake-1.11.1-4.el6.src.rpm", 1520636, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Compress-Base", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 138661, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 52519, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-HTML-Tagset", "3.20", "4.el6", "noarch", "perl-HTML-Tagset-3.20-4.el6.src.rpm", 19692, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "cvs", "1.11.23", "16.el6", "x86_64", "cvs-1.11.23-16.el6.src.rpm", 1590583, "GPL+ and GPLv2+ and LGPL+", "CentOS", "", nil, nil, nil},
		{0, "libXau", "1.0.6", "4.el6", "x86_64", "libXau-1.0.6-4.el6.src.rpm", 40009, "MIT", "CentOS", "", nil, nil, nil},
		{0, "upstart", "0.6.5", "17.el6", "x86_64", "upstart-0.6.5-17.el6.src.rpm", 567729, "GPLv2 and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cloog-ppl", "0.15.7", "1.2.el6", "x86_64", "cloog-0.15.7-1.2.el6.src.rpm", 185386, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdb", "7.2", "92.el6", "x86_64", "gdb-7.2-92.el6.src.rpm", 5545845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and GFDL and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libthai", "0.1.12", "3.el6", "x86_64", "libthai-0.1.12-3.el6.src.rpm", 694712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libedit", "2.11", "4.20080712cvs.1.el6", "x86_64", "libedit-2.11-4.20080712cvs.1.el6.src.rpm", 185648, "BSD", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 2146171, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 19499265, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libX11-common", "1.6.4", "3.el6", "noarch", "libX11-1.6.4-3.el6.src.rpm", 1341368, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXrender", "0.9.10", "1.el6", "x86_64", "libXrender-0.9.10-1.el6.src.rpm", 40515, "MIT", "CentOS", "", nil, nil, nil},
		{0, "cairo", "1.8.8", "6.el6_6", "x86_64", "cairo-1.8.8-6.el6_6.src.rpm", 797873, "LGPLv2 or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "libXrandr", "1.5.1", "1.el6", "x86_64", "libXrandr-1.5.1-1.el6.src.rpm", 43834, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gdk-pixbuf2", "2.24.1", "6.el6_7", "x86_64", "gdk-pixbuf2-2.24.1-6.el6_7.src.rpm", 2637837, "LGPLv2+ and (LGPLv2+ or MPLv1.1) and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libXdamage", "1.1.3", "4.el6", "x86_64", "libXdamage-1.1.3-4.el6.src.rpm", 24896, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXinerama", "1.1.3", "2.1.el6", "x86_64", "libXinerama-1.1.3-2.1.el6.src.rpm", 12039, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pango", "1.28.1", "11.el6", "x86_64", "pango-1.28.1-11.el6.src.rpm", 1041857, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mailcap", "2.1.31", "2.el6", "noarch", "mailcap-2.1.31-2.el6.src.rpm", 52877, "Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-XML-Parser", "2.36", "7.el6", "x86_64", "perl-XML-Parser-2.36-7.el6.src.rpm", 652307, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils", "2.0.83", "30.1.el6_8", "x86_64", "policycoreutils-2.0.83-30.1.el6_8.src.rpm", 3596110, "GPLv2+", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// yum groupinstall -y "Development tools"
	// yum install -y rpm-build redhat-rpm-config asciidoc hmaccalc perl-ExtUtils-Embed pesign xmlto
	// yum install -y audit-libs-devel binutils-devel elfutils-devel elfutils-libelf-devel java-devel
	// yum install -y ncurses-devel newt-devel numactl-devel pciutils-devel python-devel zlib-devel
	// yum install -y net-tools bc
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS6Many = []*PackageInfo{
		{0, "iproute", "2.6.32", "57.el6", "x86_64", "iproute-2.6.32-57.el6.src.rpm", 963477, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20071127", "24.el6", "x86_64", "iputils-20071127-24.el6.src.rpm", 297243, "BSD with advertising and GPLv2+ and Rdisc", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "util-linux-ng", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 6139437, "GPLv1+ and GPLv2 and GPLv2+ and LGPLv2+ and MIT and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "udev", "147", "2.73.el6_8.2", "x86_64", "udev-147-2.73.el6_8.2.src.rpm", 1280842, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 1352442, "BSD", "CentOS", "", nil, nil, nil},
		{0, "git", "1.7.1", "9.el6_9", "x86_64", "git-1.7.1-9.el6_9.src.rpm", 15290753, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-devel", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 6327079, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{0, "hicolor-icon-theme", "0.11", "1.1.el6", "noarch", "hicolor-icon-theme-0.11-1.1.el6.src.rpm", 45406, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgcj", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 65012480, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "intltool", "0.41.0", "1.1.el6", "noarch", "intltool-0.41.0-1.1.el6.src.rpm", 167585, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "subversion", "1.6.11", "15.el6_7", "x86_64", "subversion-1.6.11-15.el6_7.src.rpm", 12105530, "ASL 1.1", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gcc-gfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 14473805, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 323213, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "flex", "2.5.35", "9.el6", "x86_64", "flex-2.5.35-9.el6.src.rpm", 736081, "BSD", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cscope", "15.6", "7.el6", "x86_64", "cscope-15.6-7.el6.src.rpm", 466265, "BSD", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rcs", "5.7", "37.el6", "x86_64", "rcs-5.7-37.el6.src.rpm", 709927, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", nil, nil, nil},
		{0, "diffstat", "1.51", "2.el6", "x86_64", "diffstat-1.51-2.el6.src.rpm", 45568, "MIT", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", nil, nil, nil},
		{1, "doxygen", "1.6.1", "6.el6", "x86_64", "doxygen-1.6.1-6.el6.src.rpm", 9446190, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxslt", "1.1.26", "2.el6_3.1", "x86_64", "libxslt-1.1.26-2.el6_3.1.src.rpm", 2223955, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", nil, nil, nil},
		{0, "db4-cxx", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1647216, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdbm-devel", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 22251, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "perl-ExtUtils-ParseXS", "2.2003.0", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 62208, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-MakeMaker", "6.55", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 622462, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "docbook-dtds", "1.0", "51.el6", "noarch", "docbook-dtds-1.0-51.el6.src.rpm", 4571574, "Copyright only", "CentOS", "", nil, nil, nil},
		{0, "centos-indexhtml", "6", "2.el6.centos", "noarch", "centos-indexhtml-6-2.el6.centos.src.rpm", 92560, "Distributable", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xmlto", "0.0.23", "3.el6", "x86_64", "xmlto-0.0.23-3.el6.src.rpm", 99317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-Embed", "1.28", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 17130, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "libogg", "1.1.4", "2.1.el6", "x86_64", "libogg-1.1.4-2.1.el6.src.rpm", 30454, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libXfont", "1.5.1", "2.el6", "x86_64", "libXfont-1.5.1-2.el6.src.rpm", 336333, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "libvorbis", "1.2.3", "5.el6_9.1", "x86_64", "libvorbis-1.2.3-5.el6_9.1.src.rpm", 2152680, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsndfile", "1.0.20", "5.el6", "x86_64", "libsndfile-1.0.20-5.el6.src.rpm", 770762, "LGPLv2+ and GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "giflib", "4.1.6", "3.1.el6", "x86_64", "giflib-4.1.6-3.1.el6.src.rpm", 81932, "MIT", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.6.4", "3.el6_0.1", "x86_64", "libcap-ng-0.6.4-3.el6_0.1.src.rpm", 45214, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "ConsoleKit-libs", "0.4.1", "6.el6", "x86_64", "ConsoleKit-0.4.1-6.el6.src.rpm", 22061, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libIDL", "0.8.13", "2.1.el6", "x86_64", "libIDL-0.8.13-2.1.el6.src.rpm", 214847, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "zlib-devel", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 117496, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "pcsc-lite-libs", "1.5.2", "16.el6", "x86_64", "pcsc-lite-1.5.2-16.el6.src.rpm", 44912, "BSD", "CentOS", "", nil, nil, nil},
		{0, "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", nil, nil, nil},
		{0, "ttmkfdir", "3.0.9", "32.1.el6", "x86_64", "ttmkfdir-3.0.9-32.1.el6.src.rpm", 101747, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", nil, nil, nil},
		{0, "eggdbus", "0.6", "3.el6", "x86_64", "eggdbus-0.6-3.el6.src.rpm", 321013, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", nil, nil, nil},
		{0, "ConsoleKit", "0.4.1", "6.el6", "x86_64", "ConsoleKit-0.4.1-6.el6.src.rpm", 273094, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libasyncns", "0.8", "1.1.el6", "x86_64", "libasyncns-0.8-1.1.el6.src.rpm", 52778, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "tzdata-java", "2019a", "1.el6", "noarch", "tzdata-2019a-1.el6.src.rpm", 374277, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "java-1.7.0-openjdk", "1.7.0.221", "2.6.18.0.el6_10", "x86_64", "java-1.7.0-openjdk-1.7.0.221-2.6.18.0.el6_10.src.rpm", 96821020, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv1.1 and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{0, "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-devel", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 305553, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "slang", "2.2.1", "1.el6", "x86_64", "slang-2.2.1-1.el6.src.rpm", 1800725, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "slang-devel", "2.2.1", "1.el6", "x86_64", "slang-2.2.1-1.el6.src.rpm", 395444, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "numactl", "2.0.9", "2.el6", "x86_64", "numactl-2.0.9-2.el6.src.rpm", 175404, "LGPLv2/GPLv2", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "pciutils-devel", "3.1.10", "4.el6", "x86_64", "pciutils-3.1.10-4.el6.src.rpm", 74324, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-devel", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 467448, "Python", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", nil, nil, nil},
		{0, "bc", "1.06.95", "1.el6", "x86_64", "bc-1.06.95-1.el6.src.rpm", 217289, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", nil, nil, nil},
		{32, "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "c105b9de", "4e0fd3a3", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "glibc-common", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 112434659, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fontconfig", "2.8.0", "5.el6", "x86_64", "fontconfig-2.8.0-5.el6.src.rpm", 450597, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libproxy-bin", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 6800, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libproxy", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 118439, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "2.4.1", "6.el6", "x86_64", "mpfr-2.4.1-6.el6.src.rpm", 377376, "LGPLv2+ and GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{2, "libpng", "1.2.49", "2.el6_7", "x86_64", "libpng-1.2.49-2.el6_7.src.rpm", 654803, "zlib", "CentOS", "", nil, nil, nil},
		{0, "libtiff", "3.9.4", "21.el6_8", "x86_64", "libtiff-3.9.4-21.el6_8.src.rpm", 966899, "libtiff", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "1.el6_7.1", "x86_64", "zip-3.0-1.el6_7.1.src.rpm", 823164, "BSD", "CentOS", "", nil, nil, nil},
		{0, "apr", "1.3.9", "5.el6_9.1", "x86_64", "apr-1.3.9-5.el6_9.1.src.rpm", 303173, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "sysvinit-tools", "2.87", "6.dsf.el6", "x86_64", "sysvinit-2.87-6.dsf.el6.src.rpm", 114115, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atk", "1.30.0", "1.el6", "x86_64", "atk-1.30.0-1.el6.src.rpm", 957484, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libICE", "1.0.6", "1.el6", "x86_64", "libICE-1.0.6-1.el6.src.rpm", 117691, "MIT", "CentOS", "", nil, nil, nil},
		{0, "hwdata", "0.233", "20.1.el6", "noarch", "hwdata-0.233-20.1.el6.src.rpm", 5894683, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libSM", "1.2.1", "2.el6", "x86_64", "libSM-1.2.1-2.el6.src.rpm", 78264, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xz-lzma-compat", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 21146, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 677800, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", nil, nil, nil},
		{0, "jasper-libs", "1.900.1", "22.el6", "x86_64", "jasper-1.900.1-22.el6.src.rpm", 341232, "JasPer", "CentOS", "", nil, nil, nil},
		{0, "neon", "0.29.3", "3.el6_4", "x86_64", "neon-0.29.3-3.el6_4.src.rpm", 297415, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "alsa-lib", "1.1.0", "4.el6", "x86_64", "alsa-lib-1.1.0-4.el6.src.rpm", 1277969, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libart_lgpl", "2.3.20", "5.1.el6", "x86_64", "libart_lgpl-2.3.20-5.1.el6.src.rpm", 129211, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 28163, "BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 21092, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.13", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 476776, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{3, "perl-version", "0.77", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 51960, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-URI", "1.40", "2.el6", "noarch", "perl-URI-1.40-2.el6.src.rpm", 256097, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.63", "5.1.el6", "noarch", "autoconf-2.63-5.1.el6.src.rpm", 2605343, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "perl-Compress-Raw-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 146581, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 372202, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "9.0.3", "51.el6.centos", "noarch", "redhat-rpm-config-9.0.3-51.el6.centos.src.rpm", 138592, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "perl-HTML-Parser", "3.64", "2.el6", "x86_64", "perl-HTML-Parser-3.64-2.el6.src.rpm", 226598, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 6369345, "GPLv3 and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxcb", "1.12", "4.el6", "x86_64", "libxcb-1.12-4.el6.src.rpm", 886960, "MIT", "CentOS", "", nil, nil, nil},
		{0, "ppl", "0.10.2", "11.el6", "x86_64", "ppl-0.10.2-11.el6.src.rpm", 4637284, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rsync", "3.0.6", "12.el6", "x86_64", "rsync-3.0.6-12.el6.src.rpm", 698678, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 278832, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 988064, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 2776718, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 990251, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 9728819, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libX11", "1.6.4", "3.el6", "x86_64", "libX11-1.6.4-3.el6.src.rpm", 1301928, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXext", "1.3.3", "1.el6", "x86_64", "libXext-1.3.3-1.el6.src.rpm", 85590, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXfixes", "5.0.3", "1.el6", "x86_64", "libXfixes-5.0.3-1.el6.src.rpm", 23375, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXi", "1.7.8", "1.el6", "x86_64", "libXi-1.7.8-1.el6.src.rpm", 66523, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXtst", "1.2.3", "1.el6", "x86_64", "libXtst-1.2.3-1.el6.src.rpm", 27778, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXcursor", "1.1.14", "2.1.el6", "x86_64", "libXcursor-1.1.14-2.1.el6.src.rpm", 41934, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXft", "2.3.2", "1.el6", "x86_64", "libXft-2.3.2-1.el6.src.rpm", 120045, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXcomposite", "0.4.3", "4.el6", "x86_64", "libXcomposite-0.4.3-4.el6.src.rpm", 31878, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-libwww-perl", "5.833", "5.el6", "noarch", "perl-libwww-perl-5.833-5.el6.src.rpm", 903654, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "redhat-logos", "60.0.14", "12.el6.centos", "noarch", "redhat-logos-60.0.14-12.el6.centos.src.rpm", 15816517, "Copyright 1999-2010 the CentOS Project.  All rights reserved.", "CentOS", "", nil, nil, nil},
		{0, "iptables", "1.4.7", "19.el6", "x86_64", "iptables-1.4.7-19.el6.src.rpm", 861752, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libdrm", "2.4.65", "2.el6", "x86_64", "libdrm-2.4.65-2.el6.src.rpm", 306787, "MIT", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "plymouth", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 193924, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "initscripts", "9.03.61", "1.el6.centos", "x86_64", "initscripts-9.03.61-1.el6.centos.src.rpm", 5735427, "GPLv2 and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openssh", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 787618, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "1.7.1", "9.el6_9", "noarch", "git-1.7.1-9.el6_9.src.rpm", 35913, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kernel-devel", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 27015877, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-client", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 12275931, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "gtk2", "2.24.23", "9.el6", "x86_64", "gtk2-2.24.23-9.el6.src.rpm", 12426003, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gettext-devel", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 635713, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "systemtap", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 30373, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 11429003, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool", "2.2.6", "15.5.el6", "x86_64", "libtool-2.2.6-15.5.el6.src.rpm", 1998350, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "patchutils", "0.3.1", "3.1.el6", "x86_64", "patchutils-0.3.1-3.1.el6.src.rpm", 241488, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "bison", "2.4.1", "5.el6", "x86_64", "bison-2.4.1-5.el6.src.rpm", 2081518, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "ctags", "5.8", "2.el6", "x86_64", "ctags-5.8-2.el6.src.rpm", 347508, "GPLv2+ or Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", nil, nil, nil},
		{0, "swig", "1.3.40", "6.el6", "x86_64", "swig-1.3.40-6.el6.src.rpm", 4290828, "GPLv2+ and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "indent", "2.2.10", "7.el6", "x86_64", "indent-2.2.10-7.el6.src.rpm", 252872, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", nil, nil, nil},
		{0, "byacc", "1.9.20070509", "7.el6", "x86_64", "byacc-1.9.20070509-7.el6.src.rpm", 87968, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "xml-common", "0.6.3", "33.el6", "noarch", "sgml-common-0.6.3-33.el6.src.rpm", 20624, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "db4-devel", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 25205066, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-Test-Harness", "3.17", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 408795, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{4, "perl-devel", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1870563, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "sgml-common", "0.6.3", "33.el6", "noarch", "sgml-common-0.6.3-33.el6.src.rpm", 135735, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "docbook-style-xsl", "1.75.2", "6.el6", "noarch", "docbook-style-xsl-1.75.2-6.el6.src.rpm", 16030288, "Copyright only", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lynx", "2.8.6", "27.el6", "x86_64", "lynx-2.8.6-27.el6.src.rpm", 4934856, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "asciidoc", "8.4.5", "4.1.el6", "noarch", "asciidoc-8.4.5-4.1.el6.src.rpm", 645180, "GPL+ and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", nil, nil, nil},
		{0, "hmaccalc", "0.9.12", "2.el6", "x86_64", "hmaccalc-0.9.12-2.el6.src.rpm", 86101, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libfontenc", "1.1.2", "3.el6", "x86_64", "libfontenc-1.1.2-3.el6.src.rpm", 50316, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", nil, nil, nil},
		{1, "xorg-x11-font-utils", "7.2", "11.el6", "x86_64", "xorg-x11-font-utils-7.2-11.el6.src.rpm", 300562, "MIT", "CentOS", "", nil, nil, nil},
		{0, "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", nil, nil, nil},
		{0, "flac", "1.2.1", "7.el6_6", "x86_64", "flac-1.2.1-7.el6_6.src.rpm", 722062, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "jpackage-utils", "1.7.5", "3.16.el6", "noarch", "jpackage-utils-1.7.5-3.16.el6.src.rpm", 168662, "BSD", "CentOS", "", nil, nil, nil},
		{0, "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf-devel", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 26454, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 498105, "GPLv2+ or AFL", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", nil, nil, nil},
		{0, "tcp_wrappers-libs", "7.6", "58.el6", "x86_64", "tcp_wrappers-7.6-58.el6.src.rpm", 131475, "BSD", "CentOS", "", nil, nil, nil},
		{0, "ORBit2", "2.14.17", "7.el6", "x86_64", "ORBit2-2.14.17-7.el6.src.rpm", 603232, "LGPLv2+ and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", nil, nil, nil},
		{0, "lksctp-tools", "1.0.10", "7.el6", "x86_64", "lksctp-tools-1.0.10-7.el6.src.rpm", 210697, "GPLv2 and GPLv2+ and LGPLv2 and BSD", "CentOS", "", nil, nil, nil},
		{1, "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "copy-jdk-configs", "3.3", "9.el6", "noarch", "copy-jdk-configs-3.3-9.el6.src.rpm", 16172, "BSD", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xorg-x11-fonts-Type1", "7.2", "11.el6", "noarch", "xorg-x11-fonts-7.2-11.el6.src.rpm", 883992, "MIT and Lucida and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", nil, nil, nil},
		{0, "polkit", "0.96", "11.el6_10.1", "x86_64", "polkit-0.96-11.el6_10.1.src.rpm", 646341, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "GConf2", "2.28.0", "7.el6", "x86_64", "GConf2-2.28.0-7.el6.src.rpm", 6076626, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "pulseaudio-libs", "0.9.21", "26.el6", "x86_64", "pulseaudio-0.9.21-26.el6.src.rpm", 2700180, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "java-1.7.0-openjdk-devel", "1.7.0.221", "2.6.18.0.el6_10", "x86_64", "java-1.7.0-openjdk-1.7.0.221-2.6.18.0.el6_10.src.rpm", 37629764, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv1.1 and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "binutils-devel", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 3125929, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "audit-libs-devel", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 78382, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "newt", "0.52.11", "4.el6", "x86_64", "newt-0.52.11-4.el6.src.rpm", 173237, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "pciutils-libs", "3.1.10", "4.el6", "x86_64", "pciutils-3.1.10-4.el6.src.rpm", 48992, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "numactl-devel", "2.0.9", "2.el6", "x86_64", "numactl-2.0.9-2.el6.src.rpm", 98470, "LGPLv2/GPLv2", "CentOS", "", nil, nil, nil},
		{2, "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "newt-devel", "0.52.11", "4.el6", "x86_64", "newt-0.52.11-4.el6.src.rpm", 127322, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-devel", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 1795830, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "freetype", "2.3.11", "17.el6", "x86_64", "freetype-2.3.11-17.el6.src.rpm", 836907, "FTL or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo", "1.2.1", "3.el6_5", "x86_64", "libjpeg-turbo-1.2.1-3.el6_5.src.rpm", 476782, "wxWidgets", "CentOS", "", nil, nil, nil},
		{0, "libproxy-python", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 8320, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.13", "5.el6", "x86_64", "m4-1.4.13-5.el6.src.rpm", 560949, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 648199, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "avahi-libs", "0.6.25", "17.el6", "x86_64", "avahi-0.6.25-17.el6.src.rpm", 114824, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "gnutls", "2.12.23", "22.el6", "x86_64", "gnutls-2.12.23-22.el6.src.rpm", 1167530, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xz", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 488160, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 9831328, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "5.el6", "x86_64", "unzip-6.0-5.el6.src.rpm", 331766, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 127982, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.6", "8.el6_9", "x86_64", "patch-2.6-8.el6_9.src.rpm", 179790, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libpciaccess", "0.13.4", "1.el6", "x86_64", "libpciaccess-0.13.4-1.el6.src.rpm", 40777, "MIT", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.3.9", "3.el6_0.1", "x86_64", "apr-util-1.3.9-3.el6_0.1.src.rpm", 202360, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{1, "cups-libs", "1.4.2", "81.el6_10", "x86_64", "cups-1.4.2-81.el6_10.src.rpm", 667768, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "cpp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 10012603, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "pakchois", "0.4", "3.2.el6", "x86_64", "pakchois-0.4-3.2.el6.src.rpm", 50156, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.86", "6.el6", "x86_64", "dbus-glib-0.86-6.el6.src.rpm", 579611, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-runtime", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 616098, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 10353, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pixman", "0.32.8", "1.el6", "x86_64", "pixman-0.32.8-1.el6.src.rpm", 721560, "MIT", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1485896, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Module-Pluggable", "3.90", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 31033, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 35282834, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17015", "4.el6", "noarch", "perl-Error-0.17015-4.el6.src.rpm", 47372, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.11.1", "4.el6", "noarch", "automake-1.11.1-4.el6.src.rpm", 1520636, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Compress-Base", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 138661, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 52519, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-HTML-Tagset", "3.20", "4.el6", "noarch", "perl-HTML-Tagset-3.20-4.el6.src.rpm", 19692, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "cvs", "1.11.23", "16.el6", "x86_64", "cvs-1.11.23-16.el6.src.rpm", 1590583, "GPL+ and GPLv2+ and LGPL+", "CentOS", "", nil, nil, nil},
		{0, "libXau", "1.0.6", "4.el6", "x86_64", "libXau-1.0.6-4.el6.src.rpm", 40009, "MIT", "CentOS", "", nil, nil, nil},
		{0, "upstart", "0.6.5", "17.el6", "x86_64", "upstart-0.6.5-17.el6.src.rpm", 567729, "GPLv2 and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cloog-ppl", "0.15.7", "1.2.el6", "x86_64", "cloog-0.15.7-1.2.el6.src.rpm", 185386, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdb", "7.2", "92.el6", "x86_64", "gdb-7.2-92.el6.src.rpm", 5545845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and GFDL and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libthai", "0.1.12", "3.el6", "x86_64", "libthai-0.1.12-3.el6.src.rpm", 694712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libedit", "2.11", "4.20080712cvs.1.el6", "x86_64", "libedit-2.11-4.20080712cvs.1.el6.src.rpm", 185648, "BSD", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 2146171, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 19499265, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libX11-common", "1.6.4", "3.el6", "noarch", "libX11-1.6.4-3.el6.src.rpm", 1341368, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXrender", "0.9.10", "1.el6", "x86_64", "libXrender-0.9.10-1.el6.src.rpm", 40515, "MIT", "CentOS", "", nil, nil, nil},
		{0, "cairo", "1.8.8", "6.el6_6", "x86_64", "cairo-1.8.8-6.el6_6.src.rpm", 797873, "LGPLv2 or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "libXrandr", "1.5.1", "1.el6", "x86_64", "libXrandr-1.5.1-1.el6.src.rpm", 43834, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gdk-pixbuf2", "2.24.1", "6.el6_7", "x86_64", "gdk-pixbuf2-2.24.1-6.el6_7.src.rpm", 2637837, "LGPLv2+ and (LGPLv2+ or MPLv1.1) and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libXdamage", "1.1.3", "4.el6", "x86_64", "libXdamage-1.1.3-4.el6.src.rpm", 24896, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXinerama", "1.1.3", "2.1.el6", "x86_64", "libXinerama-1.1.3-2.1.el6.src.rpm", 12039, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pango", "1.28.1", "11.el6", "x86_64", "pango-1.28.1-11.el6.src.rpm", 1041857, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mailcap", "2.1.31", "2.el6", "noarch", "mailcap-2.1.31-2.el6.src.rpm", 52877, "Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-XML-Parser", "2.36", "7.el6", "x86_64", "perl-XML-Parser-2.36-7.el6.src.rpm", 652307, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils", "2.0.83", "30.1.el6_8", "x86_64", "policycoreutils-2.0.83-30.1.el6_8.src.rpm", 3596110, "GPLv2+", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	CentOS6Plain = []*PackageInfo{
		{0, "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.12", "1.212.el6", "x86_64", "glibc-2.12-1.212.el6.src.rpm", 112436133, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.12", "1.212.el6", "x86_64", "glibc-2.12-1.212.el6.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{0, "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.20.51.0.2", "5.48.el6", "x86_64", "binutils-2.20.51.0.2-5.48.el6.src.rpm", 9831289, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", nil, nil, nil},
		{0, "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", nil, nil, nil},
		{0, "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", nil, nil, nil},
		{0, "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", nil, nil, nil},
		{32, "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", nil, nil, nil},
		{0, "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", nil, nil, nil},
		{0, "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", nil, nil, nil},
		{1, "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", nil, nil, nil},
		{0, "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{2, "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// yum groupinstall -y "Development tools"
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS7DevTools = []*PackageInfo{
		{0, "libproxy", "0.4.11", "11.el7", "x86_64", "libproxy-0.4.11-11.el7.src.rpm", 164014, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gnutls", "3.3.29", "9.el7_6", "x86_64", "gnutls-3.3.29-9.el7_6.src.rpm", 2097819, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{1, "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", nil, nil, nil},
		{0, "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "neon", "0.30.0", "3.el7", "x86_64", "neon-0.30.0-3.el7.src.rpm", 567772, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "mokutil", "15", "2.el7.centos", "x86_64", "shim-signed-15-2.el7.centos.src.rpm", 83521, "BSD", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", nil, nil, nil},
		{1, "emacs-filesystem", "24.3", "22.el7", "noarch", "emacs-24.3-22.el7.src.rpm", 0, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 7910669, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext-devel", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1492653, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "rpm-build", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 328409, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", nil, nil, nil},
		{0, "subversion", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 4844082, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", nil, nil, nil},
		{0, "flex", "2.5.37", "6.el7", "x86_64", "flex-2.5.37-6.el7.src.rpm", 757468, "BSD and LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", nil, nil, nil},
		{1, "doxygen", "1.8.5", "3.el7", "x86_64", "doxygen-1.8.5-3.el7.src.rpm", 15389684, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "diffstat", "1.57", "4.el7", "x86_64", "diffstat-1.57-4.el7.src.rpm", 54065, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "byacc", "1.9.20130304", "3.el7", "x86_64", "byacc-1.9.20130304-3.el7.src.rpm", 135161, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "indent", "2.2.11", "13.el7", "x86_64", "indent-2.2.11-13.el7.src.rpm", 359131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.8.1", "3.el7_5.1", "x86_64", "audit-2.8.1-3.el7_5.1.src.rpm", 256370, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.27", "28.base.el7_5.1", "x86_64", "binutils-2.27-28.base.el7_5.1.src.rpm", 25149789, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 80907, "Python", "CentOS", "", nil, nil, nil},
		{0, "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "glibc-common", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 120497983, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", nil, nil, nil},
		{0, "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "boost-system", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 32538, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", nil, nil, nil},
		{0, "avahi-libs", "0.6.31", "19.el7", "x86_64", "avahi-0.6.31-19.el7.src.rpm", 123808, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-XML-Parser", "2.41", "10.el7", "x86_64", "perl-XML-Parser-2.41-10.el7.src.rpm", 642973, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "trousers", "0.3.14", "2.el7", "x86_64", "trousers-0.3.14-2.el7.src.rpm", 836873, "BSD", "CentOS", "", nil, nil, nil},
		{0, "systemd-sysv", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 3979, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdwarf", "20130207", "4.el7", "x86_64", "libdwarf-20130207-4.el7.src.rpm", 291679, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "boost-date-time", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 139706, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "systemtap-runtime", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 1142954, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libmodman", "2.0.1", "8.el7", "x86_64", "libmodman-2.0.1-8.el7.src.rpm", 58871, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nettle", "2.7.1", "8.el7", "x86_64", "nettle-2.7.1-8.el7.src.rpm", 765042, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "pakchois", "0.4", "10.el7", "x86_64", "pakchois-0.4-10.el7.src.rpm", 29489, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "subversion-libs", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 2615823, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.7", "17.el7", "x86_64", "zlib-1.2.7-17.el7.src.rpm", 185710, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "efivar-libs", "36", "11.el7_6.1", "x86_64", "efivar-36-11.el7_6.1.src.rpm", 252096, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "systemtap-client", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 10146436, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-common-devel", "0.19.8.1", "2.el7", "noarch", "gettext-0.19.8.1-2.el7.src.rpm", 397912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", nil, nil, nil},
		{0, "intltool", "0.50.2", "7.el7", "noarch", "intltool-0.50.2-7.el7.src.rpm", 170106, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemtap", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 206577, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 2323761, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cscope", "15.8", "10.el7", "x86_64", "cscope-15.8-10.el7.src.rpm", 939744, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "patchutils", "0.3.3", "4.el7", "x86_64", "patchutils-0.3.3-4.el7.src.rpm", 260135, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bison", "3.0.4", "2.el7", "x86_64", "bison-3.0.4-2.el7.src.rpm", 2154174, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-sign", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 17397, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", nil, nil, nil},
		{0, "swig", "2.0.10", "5.el7", "x86_64", "swig-2.0.10-5.el7.src.rpm", 4926232, "GPLv3+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rcs", "5.9.0", "5.el7", "x86_64", "rcs-5.9.0-5.el7.src.rpm", 624710, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "ctags", "5.8", "13.el7", "x86_64", "ctags-5.8-13.el7.src.rpm", 359724, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 24713084, "Python", "CentOS", "", nil, nil, nil},
		{0, "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 14346480, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", nil, nil, nil},
		{0, "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "kernel-debug-devel", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 39270753, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "boost-thread", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 95658, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", nil, nil, nil},
		{0, "elfutils", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 811817, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", nil, nil, nil},
		{0, "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 67448, "BSD", "CentOS", "", nil, nil, nil},
		{0, "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dyninst", "9.3.1", "2.el7", "x86_64", "dyninst-9.3.1-2.el7.src.rpm", 13049000, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos/httpd-24-centos7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS7Httpd24 = []*PackageInfo{
		{32, "bind-license", "9.9.4", "73.el7_6", "noarch", "bind-9.9.4-73.el7_6.src.rpm", 26831, "ISC", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.2.46", "31.el7", "x86_64", "bash-4.2.46-31.el7.src.rpm", 3667773, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 120499441, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 14346456, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 60489, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.8.5", "36.el7", "x86_64", "gcc-4.8.5-36.el7.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 217874, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 2200985, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 20326, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 278173, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.5.11", "6.el7", "x86_64", "findutils-4.5.11-6.el7.src.rpm", 1855882, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2425024, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2069587, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.56.1", "1.el7", "x86_64", "gobject-introspection-1.56.1-1.el7.src.rpm", 854207, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 91848, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.3", "12.el7", "x86_64", "libssh2-1.4.3-12.el7.src.rpm", 341886, "BSD", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 540293, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.26", "35.el7", "x86_64", "tar-1.26-35.el7.src.rpm", 2838510, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsmartcols", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 164608, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 302329, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 24713067, "Python", "CentOS", "", nil, nil, nil},
		{0, "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.10", "9.el7", "noarch", "python-urlgrabber-3.10-9.el7.src.rpm", 503349, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.10", "23.el7", "x86_64", "procps-ng-3.3.10-23.el7.src.rpm", 760565, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 339987, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kmod", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 243559, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.172", "2.el7", "noarch", "elfutils-0.172-2.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 53895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-utils", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 345277, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 917744, "Vim", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "lzo", "2.06", "8.el7", "x86_64", "lzo-2.06-8.el7.src.rpm", 165360, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "libarchive", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 745291, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-release-scl-rh", "2", "3.el7.centos", "noarch", "centos-release-scl-rh-2-3.el7.centos.src.rpm", 20015, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "epel-release", "7", "11", "noarch", "epel-release-7-11.src.rpm", 24834, "GPLv2", "Fedora Project", "", nil, nil, nil},
		{0, "gpg-pubkey", "352c64e5", "52ae6884", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{32, "bind-libs", "9.9.4", "73.el7_6", "x86_64", "bind-9.9.4-73.el7_6.src.rpm", 2720960, "ISC", "CentOS", "", nil, nil, nil},
		{0, "lasso", "2.5.1", "2.el7", "x86_64", "lasso-2.5.1-2.el7.src.rpm", 570546, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcgroup", "0.41", "20.el7", "x86_64", "libcgroup-0.41-20.el7.src.rpm", 137210, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "jansson", "2.10", "1.el7", "x86_64", "jansson-2.10-1.el7.src.rpm", 74998, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 172645, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libsemanage-python", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 451817, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-IPy", "0.75", "6.el7", "noarch", "python-IPy-0.75-6.el7.src.rpm", 121946, "BSD", "CentOS", "", nil, nil, nil},
		{0, "centos-logos", "70.0.6", "3.el7.centos", "noarch", "centos-logos-70.0.6-3.el7.centos.src.rpm", 22548401, "Copyright © 2014 The CentOS Project.  All rights reserved.", "CentOS", "", nil, nil, nil},
		{0, "audit-libs-python", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 327265, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-runtime", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 20989, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-libnghttp2", "1.7.1", "7.el7", "x86_64", "httpd24-nghttp2-1.7.1-7.el7.src.rpm", 142738, "MIT", "CentOS", "", nil, nil, nil},
		{0, "httpd24-httpd", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 4739300, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{1, "httpd24-mod_ssl", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 241612, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "nss_wrapper", "1.1.5", "1.el7", "x86_64", "nss_wrapper-1.1.5-1.el7.src.rpm", 75009, "BSD", "Fedora Project", "", nil, nil, nil},
		{0, "libgcc", "4.8.5", "36.el7", "x86_64", "gcc-4.8.5-36.el7.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018i", "1.el7", "noarch", "tzdata-2018i-1.el7.src.rpm", 2007607, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.71", "10.el7", "noarch", "setup-2.8.71-10.el7.src.rpm", 696893, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.1.el7_6", "x86_64", "nss-util-3.36.0-1.1.el7_6.src.rpm", 199008, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 686640, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.22", "23.el7", "x86_64", "coreutils-8.22-23.el7.src.rpm", 14588674, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "7", "6.1810.2.el7.centos", "x86_64", "centos-release-7-6.1810.2.el7.centos.src.rpm", 41271, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 265973, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.56.1", "2.el7", "x86_64", "glib2-2.56.1-2.el7.src.rpm", 12166425, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-pem", "1.0.3", "5.el7", "x86_64", "nss-pem-1.0.3-5.el7.src.rpm", 205539, "MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 14067, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", nil, nil, nil},
		{0, "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 435192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 1037424, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "25.el7", "x86_64", "shadow-utils-4.1.5.1-25.el7.src.rpm", 3540592, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 80907, "Python", "CentOS", "", nil, nil, nil},
		{0, "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 8447471, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.9", "123.el7", "x86_64", "device-mapper-multipath-0.4.9-123.el7.src.rpm", 41363, "GPL+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper-libs", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 400607, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "dracut", "033", "554.el7", "x86_64", "dracut-033-554.el7.src.rpm", 903230, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 362560, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 595210, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.4.3", "161.el7.centos", "noarch", "yum-3.4.3-161.el7.centos.src.rpm", 5824869, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 22399, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "bsdtar", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 110459, "BSD", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", nil, nil, nil},
		{0, "scl-utils", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 25141, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release-scl", "2", "3.el7.centos", "noarch", "centos-release-scl-2-3.el7.centos.src.rpm", 20042, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f2ee9d55", "560cfc0a", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{1, "openssl-libs", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3204708, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xmlsec1", "1.2.20", "7.el7_4", "x86_64", "xmlsec1-1.2.20-7.el7_4.src.rpm", 568638, "MIT", "CentOS", "", nil, nil, nil},
		{0, "GeoIP", "1.5.0", "13.el7", "x86_64", "GeoIP-1.5.0-13.el7.src.rpm", 3912607, "LGPLv2+ and GPLv2+ and CC-BY-SA", "CentOS", "", nil, nil, nil},
		{0, "xmlsec1-openssl", "1.2.20", "7.el7_4", "x86_64", "xmlsec1-1.2.20-7.el7_4.src.rpm", 245128, "MIT", "CentOS", "", nil, nil, nil},
		{1, "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{1, "openssl", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 833657, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "cmake", "2.8.12.2", "2.el7", "x86_64", "cmake-2.8.12.2-2.el7.src.rpm", 28036363, "BSD and MIT and zlib", "CentOS", "", nil, nil, nil},
		{0, "libselinux-python", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 603236, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 5321515, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "setools-libs", "3.3.8", "4.el7", "x86_64", "setools-3.3.8-4.el7.src.rpm", 1917790, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.5", "8.el7", "x86_64", "checkpolicy-2.5-8.el7.src.rpm", 1288327, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "mailcap", "2.1.41", "2.el7", "noarch", "mailcap-2.1.41-2.el7.src.rpm", 63360, "Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils-python", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 1299284, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "httpd24-libcurl", "7.61.1", "1.el7", "x86_64", "httpd24-curl-7.61.1-1.el7.src.rpm", 545704, "MIT", "CentOS", "", nil, nil, nil},
		{0, "httpd24-httpd-tools", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 177148, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "httpd24-mod_auth_mellon", "0.13.1", "2.el7", "x86_64", "httpd24-mod_auth_mellon-0.13.1-2.el7.src.rpm", 1108011, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 0, "GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-utils", "9.9.4", "73.el7_6", "x86_64", "bind-9.9.4-73.el7_6.src.rpm", 441412, "ISC", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// yum groupinstall -y "Development tools"
	// yum install -y rpm-build redhat-rpm-config asciidoc hmaccalc perl-ExtUtils-Embed pesign xmlto
	// yum install -y audit-libs-devel binutils-devel elfutils-devel elfutils-libelf-devel java-devel
	// yum install -y ncurses-devel newt-devel numactl-devel pciutils-devel python-devel zlib-devel
	// yum install -y net-tools bc
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS7Many = []*PackageInfo{
		{0, "gnutls", "3.3.29", "9.el7_6", "x86_64", "gnutls-3.3.29-9.el7_6.src.rpm", 2097819, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", nil, nil, nil},
		{0, "neon", "0.30.0", "3.el7", "x86_64", "neon-0.30.0-3.el7.src.rpm", 567772, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mokutil", "15", "2.el7.centos", "x86_64", "shim-signed-15-2.el7.centos.src.rpm", 83521, "BSD", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 7910669, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gettext-devel", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1492653, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "subversion", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 4844082, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "diffstat", "1.57", "4.el7", "x86_64", "diffstat-1.57-4.el7.src.rpm", 54065, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "indent", "2.2.11", "13.el7", "x86_64", "indent-2.2.11-13.el7.src.rpm", 359131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libICE", "1.0.9", "9.el7", "x86_64", "libICE-1.0.9-9.el7.src.rpm", 152213, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", nil, nil, nil},
		{1, "cups-libs", "1.6.3", "35.el7", "x86_64", "cups-1.6.3-35.el7.src.rpm", 734207, "LGPLv2 and zlib", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atk", "2.28.1", "1.el7", "x86_64", "atk-2.28.1-1.el7.src.rpm", 1273762, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dejavu-fonts-common", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 130455, "Bitstream Vera and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libfontenc", "1.1.3", "3.el7", "x86_64", "libfontenc-1.1.3-3.el7.src.rpm", 55701, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{2, "vim-filesystem", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 0, "Vim", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libusbx", "1.0.21", "1.el7", "x86_64", "libusbx-1.0.21-1.el7.src.rpm", 143429, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "opensc", "0.16.0", "10.20170227git777e2a3.el7", "x86_64", "opensc-0.16.0-10.20170227git777e2a3.el7.src.rpm", 3260615, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "poppler-data", "0.4.6", "3.el7", "noarch", "poppler-data-0.4.6-3.el7.src.rpm", 12013394, "BSD and GPLv2 and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "hicolor-icon-theme", "0.12", "7.el7", "noarch", "hicolor-icon-theme-0.12-7.el7.src.rpm", 45788, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "libX11-common", "1.6.5", "2.el7", "noarch", "libX11-1.6.5-2.el7.src.rpm", 1335662, "MIT", "CentOS", "", nil, nil, nil},
		{0, "lynx", "2.8.8", "0.3.dev15.el7", "x86_64", "lynx-2.8.8-0.3.dev15.el7.src.rpm", 5618384, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libdrm", "2.4.91", "3.el7", "x86_64", "libdrm-2.4.91-3.el7.src.rpm", 371903, "MIT", "CentOS", "", nil, nil, nil},
		{0, "docbook-style-xsl", "1.78.1", "3.el7", "noarch", "docbook-style-xsl-1.78.1-3.el7.src.rpm", 16671587, "DMIT", "CentOS", "", nil, nil, nil},
		{0, "libXext", "1.3.3", "3.el7", "x86_64", "libXext-1.3.3-3.el7.src.rpm", 87102, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXt", "1.1.5", "3.el7", "x86_64", "libXt-1.1.5-3.el7.src.rpm", 430105, "MIT", "CentOS", "", nil, nil, nil},
		{7, "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libXaw", "1.0.13", "4.el7", "x86_64", "libXaw-1.0.13-4.el7.src.rpm", 498789, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXcursor", "1.1.15", "1.el7", "x86_64", "libXcursor-1.1.15-1.el7.src.rpm", 47039, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXinerama", "1.1.3", "2.1.el7", "x86_64", "libXinerama-1.1.3-2.1.el7.src.rpm", 14967, "MIT", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXcomposite", "0.4.4", "4.1.el7", "x86_64", "libXcomposite-0.4.4-4.1.el7.src.rpm", 35184, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "fribidi", "1.0.2", "1.el7", "x86_64", "fribidi-1.0.2-1.el7.src.rpm", 309831, "LGPLv2+ and UCD", "CentOS", "", nil, nil, nil},
		{0, "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-MakeMaker", "6.68", "3.el7", "noarch", "perl-ExtUtils-MakeMaker-6.68-3.el7.src.rpm", 650532, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "asciidoc", "8.6.8", "5.el7", "noarch", "asciidoc-8.6.8-5.el7.src.rpm", 976747, "GPL+ and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "python-javapackages", "3.4.1", "11.el7", "noarch", "javapackages-tools-3.4.1-11.el7.src.rpm", 66505, "BSD", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXtst", "1.2.3", "1.el7", "x86_64", "libXtst-1.2.3-1.el7.src.rpm", 29938, "MIT", "CentOS", "", nil, nil, nil},
		{0, "alsa-lib", "1.1.6", "2.el7", "x86_64", "alsa-lib-1.1.6-2.el7.src.rpm", 1433094, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "audit-libs-devel", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 88847, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 24714266, "Python", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 120497983, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "slang-devel", "2.2.4", "11.el7", "x86_64", "slang-2.2.4-11.el7.src.rpm", 356429, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "newt-devel", "0.52.15", "4.el7", "x86_64", "newt-0.52.15-4.el7.src.rpm", 127322, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "bc", "1.06.95", "13.el7", "x86_64", "bc-1.06.95-13.el7.src.rpm", 219830, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "systemd-sysv", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 3979, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "boost-date-time", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 139706, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "libmodman", "2.0.1", "8.el7", "x86_64", "libmodman-2.0.1-8.el7.src.rpm", 58871, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nettle", "2.7.1", "8.el7", "x86_64", "nettle-2.7.1-8.el7.src.rpm", 765042, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "pakchois", "0.4", "10.el7", "x86_64", "pakchois-0.4-10.el7.src.rpm", 29489, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "subversion-libs", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 2615823, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "efivar-libs", "36", "11.el7_6.1", "x86_64", "efivar-36-11.el7_6.1.src.rpm", 252096, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "systemtap-client", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 10146436, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-common-devel", "0.19.8.1", "2.el7", "noarch", "gettext-0.19.8.1-2.el7.src.rpm", 397912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", nil, nil, nil},
		{0, "intltool", "0.50.2", "7.el7", "noarch", "intltool-0.50.2-7.el7.src.rpm", 170106, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemtap", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 206577, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 2323761, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cscope", "15.8", "10.el7", "x86_64", "cscope-15.8-10.el7.src.rpm", 939744, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "patchutils", "0.3.3", "4.el7", "x86_64", "patchutils-0.3.3-4.el7.src.rpm", 260135, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bison", "3.0.4", "2.el7", "x86_64", "bison-3.0.4-2.el7.src.rpm", 2154174, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-sign", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 17397, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", nil, nil, nil},
		{0, "swig", "2.0.10", "5.el7", "x86_64", "swig-2.0.10-5.el7.src.rpm", 4926232, "GPLv3+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", nil, nil, nil},
		{0, "rcs", "5.9.0", "5.el7", "x86_64", "rcs-5.9.0-5.el7.src.rpm", 624710, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "ctags", "5.8", "13.el7", "x86_64", "ctags-5.8-13.el7.src.rpm", 359724, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", nil, nil, nil},
		{2, "libpng", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 616101, "zlib", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 350499, "IJG", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libSM", "1.2.2", "2.el7", "x86_64", "libSM-1.2.2-2.el7.src.rpm", 81546, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcsc-lite-libs", "1.8.8", "8.el7", "x86_64", "pcsc-lite-1.8.8-8.el7.src.rpm", 46708, "BSD", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "libglvnd", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 666456, "MIT", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "xml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 46969, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libwayland-server", "1.15.0", "1.el7", "x86_64", "wayland-1.15.0-1.el7.src.rpm", 81084, "MIT", "CentOS", "", nil, nil, nil},
		{0, "dejavu-sans-fonts", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 5395167, "Bitstream Vera and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "jasper-libs", "1.900.1", "33.el7", "x86_64", "jasper-1.900.1-33.el7.src.rpm", 350690, "JasPer", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "xorg-x11-font-utils", "7.5", "21.el7", "x86_64", "xorg-x11-font-utils-7.5-21.el7.src.rpm", 361874, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ghostscript-fonts", "5.50", "32.el7", "noarch", "ghostscript-fonts-5.50-32.el7.src.rpm", 636425, "GPLv2+ and Hershey and MIT and OFL and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "lcms2", "2.6", "3.el7", "x86_64", "lcms2-2.6-3.el7.src.rpm", 377192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "libtiff", "4.0.3", "27.el7_3", "x86_64", "libtiff-4.0.3-27.el7_3.src.rpm", 494377, "libtiff", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcsc-lite-ccid", "1.4.10", "14.el7", "x86_64", "pcsc-lite-ccid-1.4.10-14.el7.src.rpm", 562872, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "coolkey", "1.1.0", "40.el7", "x86_64", "coolkey-1.1.0-40.el7.src.rpm", 304556, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libthai", "0.1.14", "9.el7", "x86_64", "libthai-0.1.14-9.el7.src.rpm", 704340, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-sdt-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 178425, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libicu", "50.1.2", "17.el7", "x86_64", "icu-50.1.2-17.el7.src.rpm", 25217861, "MIT and UCD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "source-highlight", "3.1.6", "6.el7", "x86_64", "source-highlight-3.1.6-6.el7.src.rpm", 3024049, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "gdbm-devel", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 42866, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-Manifest", "1.61", "244.el7", "noarch", "perl-ExtUtils-Manifest-1.61-244.el7.src.rpm", 85359, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "graphite2", "1.3.10", "1.el7_3", "x86_64", "graphite2-1.3.10-1.el7_3.src.rpm", 254548, "(LGPLv2+ or GPLv2+ or MPL) and (Netscape or GPLv2+ or LGPLv2+)", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", nil, nil, nil},
		{0, "centos-indexhtml", "7", "9.el7.centos", "noarch", "centos-indexhtml-7-9.el7.centos.src.rpm", 92560, "Distributable", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pixman", "0.34.0", "1.el7", "x86_64", "pixman-0.34.0-1.el7.src.rpm", 698744, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libpciaccess", "0.14", "1.el7", "x86_64", "libpciaccess-0.14-1.el7.src.rpm", 45649, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mesa-libgbm", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 58336, "MIT", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "docbook-dtds", "1.0", "60.el7", "noarch", "docbook-dtds-1.0-60.el7.src.rpm", 4634764, "Copyright only", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXau", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 55529, "MIT", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{0, "libX11", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1325648, "MIT", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXrender", "0.9.10", "1.el7", "x86_64", "libXrender-0.9.10-1.el7.src.rpm", 46979, "MIT", "CentOS", "", nil, nil, nil},
		{1, "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "gdk-pixbuf2", "2.36.12", "3.el7", "x86_64", "gdk-pixbuf2-2.36.12-3.el7.src.rpm", 2927994, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libXpm", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 116599, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "libXdamage", "1.1.4", "4.1.el7", "x86_64", "libXdamage-1.1.4-4.1.el7.src.rpm", 29688, "MIT", "CentOS", "", nil, nil, nil},
		{7, "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "gd", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 554528, "MIT", "CentOS", "", nil, nil, nil},
		{0, "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gtk-update-icon-cache", "3.22.30", "3.el7", "x86_64", "gtk3-3.22.30-3.el7.src.rpm", 59878, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXrandr", "1.5.1", "2.el7", "x86_64", "libXrandr-1.5.1-2.el7.src.rpm", 48626, "MIT", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXi", "1.7.9", "1.el7", "x86_64", "libXi-1.7.9-1.el7.src.rpm", 70019, "MIT", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libXxf86vm", "1.1.4", "1.el7", "x86_64", "libXxf86vm-1.1.4-1.el7.src.rpm", 25680, "MIT", "CentOS", "", nil, nil, nil},
		{0, "mesa-libGL", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 493744, "MIT", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "libglvnd-egl", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 84096, "MIT", "CentOS", "", nil, nil, nil},
		{0, "cairo", "1.15.12", "3.el7", "x86_64", "cairo-1.15.12-3.el7.src.rpm", 1894412, "LGPLv2 or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "pango", "1.42.4", "1.el7", "x86_64", "pango-1.42.4-1.el7.src.rpm", 755391, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gtk2", "2.24.31", "1.el7", "x86_64", "gtk2-2.24.31-1.el7.src.rpm", 13494501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "graphviz", "2.30.1", "21.el7", "x86_64", "graphviz-2.30.1-21.el7.src.rpm", 4019006, "EPL", "CentOS", "", nil, nil, nil},
		{0, "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{1, "perl-ExtUtils-ParseXS", "3.18", "3.el7", "noarch", "perl-ExtUtils-ParseXS-3.18-3.el7.src.rpm", 178634, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-Install", "1.58", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 76408, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-ExtUtils-Embed", "1.30", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 17136, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xmlto", "0.0.25", "7.el7", "x86_64", "xmlto-0.0.25-7.el7.src.rpm", 108322, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "hmaccalc", "0.9.13", "4.el7", "x86_64", "hmaccalc-0.9.13-4.el7.src.rpm", 102013, "BSD", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zlib-devel", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 135536, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-lxml", "3.2.1", "4.el7", "x86_64", "python-lxml-3.2.1-4.el7.src.rpm", 2722705, "BSD", "CentOS", "", nil, nil, nil},
		{0, "javapackages-tools", "3.4.1", "11.el7", "noarch", "javapackages-tools-3.4.1-11.el7.src.rpm", 160151, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xorg-x11-fonts-Type1", "7.5", "9.el7", "noarch", "xorg-x11-fonts-7.5-9.el7.src.rpm", 883992, "MIT and Lucida and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xz-devel", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 168793, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", nil, nil, nil},
		{0, "lksctp-tools", "1.0.17", "2.el7", "x86_64", "lksctp-tools-1.0.17-2.el7.src.rpm", 232487, "GPLv2 and GPLv2+ and LGPLv2 and MIT", "CentOS", "", nil, nil, nil},
		{0, "copy-jdk-configs", "3.3", "10.el7_5", "noarch", "copy-jdk-configs-3.3-10.el7_5.src.rpm", 16264, "BSD", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "slang", "2.2.4", "11.el7", "x86_64", "slang-2.2.4-11.el7.src.rpm", 1881912, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 14346480, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", nil, nil, nil},
		{0, "net-tools", "2.0", "0.24.20131004git.el7", "x86_64", "net-tools-2.0-0.24.20131004git.el7.src.rpm", 939930, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", nil, nil, nil},
		{0, "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "kernel-debug-devel", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 39270753, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "boost-thread", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 95658, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", nil, nil, nil},
		{0, "elfutils", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 811817, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", nil, nil, nil},
		{0, "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 67448, "BSD", "CentOS", "", nil, nil, nil},
		{0, "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dyninst", "9.3.1", "2.el7", "x86_64", "dyninst-9.3.1-2.el7.src.rpm", 13049000, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "giflib", "4.1.6", "9.el7", "x86_64", "giflib-4.1.6-9.el7.src.rpm", 90124, "MIT", "CentOS", "", nil, nil, nil},
		{1, "java-1.8.0-openjdk-devel", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 42212373, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{0, "elfutils-devel", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 306300, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pciutils-libs", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 72691, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 80907, "Python", "CentOS", "", nil, nil, nil},
		{0, "newt", "0.52.15", "4.el7", "x86_64", "newt-0.52.15-4.el7.src.rpm", 185196, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "numactl-devel", "2.0.9", "7.el7", "x86_64", "numactl-2.0.9-7.el7.src.rpm", 25174, "LGPLv2 and GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-devel", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 1104386, "Python", "CentOS", "", nil, nil, nil},
		{0, "ncurses-devel", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 2253171, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libproxy", "0.4.11", "11.el7", "x86_64", "libproxy-0.4.11-11.el7.src.rpm", 164014, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", nil, nil, nil},
		{1, "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", nil, nil, nil},
		{0, "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{1, "emacs-filesystem", "24.3", "22.el7", "noarch", "emacs-24.3-22.el7.src.rpm", 0, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", nil, nil, nil},
		{0, "rpm-build", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 328409, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", nil, nil, nil},
		{0, "flex", "2.5.37", "6.el7", "x86_64", "flex-2.5.37-6.el7.src.rpm", 757468, "BSD and LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", nil, nil, nil},
		{1, "doxygen", "1.8.5", "3.el7", "x86_64", "doxygen-1.8.5-3.el7.src.rpm", 15389684, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "byacc", "1.9.20130304", "3.el7", "x86_64", "byacc-1.9.20130304-3.el7.src.rpm", 135161, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "freetype", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 824497, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "mesa-libglapi", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 204320, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxshmfence", "1.2", "1.el7", "x86_64", "libxshmfence-1.2-1.el7.src.rpm", 11160, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "fontpackages-filesystem", "1.44", "8.el7", "noarch", "fontpackages-1.44-8.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "fontconfig", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 666475, "MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "urw-fonts", "2.4", "16.el7", "noarch", "urw-fonts-2.4-16.el7.src.rpm", 4389400, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "jbigkit-libs", "2.0", "11.el7", "x86_64", "jbigkit-2.0-11.el7.src.rpm", 105882, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pcsc-lite", "1.8.8", "8.el7", "x86_64", "pcsc-lite-1.8.8-8.el7.src.rpm", 634433, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pyparsing", "1.5.6", "9.el7", "noarch", "pyparsing-1.5.6-9.el7.src.rpm", 375948, "MIT", "CentOS", "", nil, nil, nil},
		{0, "boost-regex", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 2122578, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libwayland-client", "1.15.0", "1.el7", "x86_64", "wayland-1.15.0-1.el7.src.rpm", 64076, "MIT", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "harfbuzz", "1.7.5", "2.el7", "x86_64", "harfbuzz-1.7.5-2.el7.src.rpm", 709362, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "hwdata", "0.252", "9.1.el7", "x86_64", "hwdata-0.252-9.1.el7.src.rpm", 13726739, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "sgml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 170882, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxcb", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 1011680, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXfixes", "5.0.3", "1.el7", "x86_64", "libXfixes-5.0.3-1.el7.src.rpm", 26903, "MIT", "CentOS", "", nil, nil, nil},
		{0, "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXmu", "1.1.2", "2.el7", "x86_64", "libXmu-1.1.2-2.el7.src.rpm", 172054, "MIT", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ghostscript", "9.07", "31.el7_6.10", "x86_64", "ghostscript-9.07-31.el7_6.10.src.rpm", 17357534, "AGPLv3+ and Redistributable, no modification permitted", "CentOS", "", nil, nil, nil},
		{0, "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXft", "2.3.2", "2.el7", "x86_64", "libXft-2.3.2-2.el7.src.rpm", 125933, "MIT", "CentOS", "", nil, nil, nil},
		{1, "libglvnd-glx", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 657304, "MIT", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mesa-libEGL", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 232401, "MIT", "CentOS", "", nil, nil, nil},
		{0, "librsvg2", "2.40.20", "1.el7", "x86_64", "librsvg2-2.40.20-1.el7.src.rpm", 308951, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdb-devel", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 129076, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{4, "perl-devel", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1930081, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pesign", "0.109", "10.el7", "x86_64", "pesign-0.109-10.el7.src.rpm", 368213, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf-devel", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 32387, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "ttmkfdir", "3.0.9", "42.el7", "x86_64", "ttmkfdir-3.0.9-42.el7.src.rpm", 105418, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "tzdata-java", "2019a", "1.el7", "noarch", "tzdata-2019a-1.el7.src.rpm", 374277, "Public Domain", "CentOS", "", nil, nil, nil},
		{1, "java-1.8.0-openjdk-headless", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 108711819, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{1, "java-1.8.0-openjdk", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 541844, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{0, "binutils-devel", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 4540848, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "pciutils", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 200397, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "numactl-libs", "2.0.9", "7.el7", "x86_64", "numactl-2.0.9-7.el7.src.rpm", 50752, "LGPLv2 and GPLv2", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pciutils-devel", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 78345, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "boost-system", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 32538, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "avahi-libs", "0.6.31", "19.el7", "x86_64", "avahi-0.6.31-19.el7.src.rpm", 123808, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", nil, nil, nil},
		{1, "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-XML-Parser", "2.41", "10.el7", "x86_64", "perl-XML-Parser-2.41-10.el7.src.rpm", 642973, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "trousers", "0.3.14", "2.el7", "x86_64", "trousers-0.3.14-2.el7.src.rpm", 836873, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libdwarf", "20130207", "4.el7", "x86_64", "libdwarf-20130207-4.el7.src.rpm", 291679, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "systemtap-runtime", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 1142954, "GPLv2+", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	CentOS7Plain = []*PackageInfo{
		{0, "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.17", "222.el7", "x86_64", "glibc-2.17-222.el7.src.rpm", 120325207, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.17", "222.el7", "x86_64", "glibc-2.17-222.el7.src.rpm", 14223248, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", nil, nil, nil},
		{1, "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.8.1", "3.el7_5.1", "x86_64", "audit-2.8.1-3.el7_5.1.src.rpm", 256370, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.11", "33.el7", "x86_64", "file-5.11-33.el7.src.rpm", 3077690, "BSD", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.27", "28.base.el7_5.1", "x86_64", "binutils-2.27-28.base.el7_5.1.src.rpm", 25149789, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 611384, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "1.7.4", "4.el7", "x86_64", "cryptsetup-1.7.4-4.el7.src.rpm", 969908, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "219", "57.el7_5.3", "x86_64", "systemd-219-57.el7_5.3.src.rpm", 1263552, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "systemd", "219", "57.el7_5.3", "x86_64", "systemd-219-57.el7_5.3.src.rpm", 24402038, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 80907, "Python", "CentOS", "", nil, nil, nil},
		{0, "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 149714, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.8.5", "28.el7_5.1", "x86_64", "gcc-4.8.5-28.el7_5.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.7", "17.el7", "x86_64", "zlib-1.2.7-17.el7.src.rpm", 185710, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.8.5", "28.el7_5.1", "x86_64", "gcc-4.8.5-28.el7_5.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.170", "4.el7", "x86_64", "elfutils-0.170-4.el7.src.rpm", 936931, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 2621900, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.170", "4.el7", "x86_64", "elfutils-0.170-4.el7.src.rpm", 747527, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 24713084, "Python", "CentOS", "", nil, nil, nil},
		{0, "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 166664, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{32, "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos/python-35-centos7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS7Python35 = []*PackageInfo{
		{0, "fontconfig-devel", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 111050, "MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{32, "bind-license", "9.9.4", "73.el7_6", "noarch", "bind-9.9.4-73.el7_6.src.rpm", 26831, "ISC", "CentOS", "", nil, nil, nil},
		{0, "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libxml2-devel", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 9213393, "MIT", "CentOS", "", nil, nil, nil},
		{0, "bash", "4.2.46", "31.el7", "x86_64", "bash-4.2.46-31.el7.src.rpm", 3667773, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 8460215, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc-common", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 120499441, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "glibc", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 14346456, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libX11-common", "1.6.5", "2.el7", "noarch", "libX11-1.6.5-2.el7.src.rpm", 1335662, "MIT", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXpm", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 116599, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 60489, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gd", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 554528, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXt", "1.1.5", "3.el7", "x86_64", "libXt-1.1.5-3.el7.src.rpm", 430105, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libkadm5", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 221096, "MIT", "CentOS", "", nil, nil, nil},
		{0, "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs-devel", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 29186, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt-devel", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 220369, "LGPLv2+ and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 217874, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", nil, nil, nil},
		{0, "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libselinux-devel", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 194101, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", nil, nil, nil},
		{0, "krb5-devel", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 796853, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", nil, nil, nil},
		{1, "mariadb-devel", "5.5.60", "1.el7_5", "x86_64", "mariadb-5.5.60-1.el7_5.src.rpm", 3478237, "GPLv2 with exceptions and LGPLv2 and BSD", "CentOS", "", nil, nil, nil},
		{0, "gd-devel", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 300168, "MIT", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 2200985, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "lsof", "4.87", "6.el7", "x86_64", "lsof-4.87-6.el7.src.rpm", 949035, "zlib and Sendmail and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "which", "2.20", "7.el7", "x86_64", "which-2.20-7.el7.src.rpm", 76962, "GPLv3", "CentOS", "", nil, nil, nil},
		{0, "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "apr-devel", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 789433, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python-libs", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 40247447, "Python", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.5.11", "6.el7", "x86_64", "findutils-4.5.11-6.el7.src.rpm", 1855882, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python-pip", "7.1.0", "2.el7", "noarch", "rh-python35-python-pip-7.1.0-2.el7.src.rpm", 8198956, "MIT", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libmnl", "1.0.3", "7.el7", "x86_64", "libmnl-1.0.3-7.el7.src.rpm", 51847, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", nil, nil, nil},
		{0, "iptables", "1.4.21", "28.el7", "x86_64", "iptables-1.4.21-28.el7.src.rpm", 1555961, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atlas", "3.10.1", "12.el7", "x86_64", "atlas-3.10.1-12.el7.src.rpm", 21813025, "BSD", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "apr-util-ldap", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 11408, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "hunspell", "1.3.2", "15.el7", "x86_64", "hunspell-1.3.2-15.el7.src.rpm", 583000, "LGPLv2+ or GPLv2+ or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2425024, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 5321515, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libcgroup", "0.41", "20.el7", "x86_64", "libcgroup-0.41-20.el7.src.rpm", 137210, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "iso-codes", "3.46", "2.el7", "noarch", "iso-codes-3.46-2.el7.src.rpm", 14504447, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsemanage-python", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 451817, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2069587, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "jansson", "2.10", "1.el7", "x86_64", "jansson-2.10-1.el7.src.rpm", 74998, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.56.1", "1.el7", "x86_64", "gobject-introspection-1.56.1-1.el7.src.rpm", 854207, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "scl-utils-build", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 18361, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python-virtualenv", "13.1.2", "2.el7", "noarch", "rh-python35-python-virtualenv-13.1.2-2.el7.src.rpm", 2764777, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 91848, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "initscripts", "9.49.46", "1.el7", "x86_64", "initscripts-9.49.46-1.el7.src.rpm", 1519938, "GPLv2 and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libssh2", "1.4.3", "12.el7", "x86_64", "libssh2-1.4.3-12.el7.src.rpm", 341886, "BSD", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-devel", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 1024214, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 540293, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libdb-devel", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 129076, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "mailcap", "2.1.41", "2.el7", "noarch", "mailcap-2.1.41-2.el7.src.rpm", 63360, "Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "audit-libs-python", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 327265, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.26", "35.el7", "x86_64", "tar-1.26-35.el7.src.rpm", 2838510, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-runtime", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 20989, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-libnghttp2", "1.7.1", "7.el7", "x86_64", "httpd24-nghttp2-1.7.1-7.el7.src.rpm", 142738, "MIT", "CentOS", "", nil, nil, nil},
		{0, "httpd24-httpd", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 4739300, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 302329, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "httpd24-mod_ssl", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 241612, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-mod_session", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 110671, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-httpd-devel", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 836817, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "python-libs", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 24713067, "Python", "CentOS", "", nil, nil, nil},
		{1, "enchant", "1.6.0", "8.el7", "x86_64", "enchant-1.6.0-8.el7.src.rpm", 130894, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atlas-devel", "3.10.1", "12.el7", "x86_64", "atlas-3.10.1-12.el7.src.rpm", 2201996, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "python-urlgrabber", "3.10", "9.el7", "noarch", "python-urlgrabber-3.10-9.el7.src.rpm", 503349, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.10", "23.el7", "x86_64", "procps-ng-3.3.10-23.el7.src.rpm", 760565, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 339987, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kmod", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 243559, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.172", "2.el7", "noarch", "elfutils-0.172-2.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-fastestmirror", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 53895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-utils", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 345277, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 917744, "Vim", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "lzo", "2.06", "8.el7", "x86_64", "lzo-2.06-8.el7.src.rpm", 165360, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "libarchive", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 745291, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-release-scl-rh", "2", "3.el7.centos", "noarch", "centos-release-scl-rh-2-3.el7.centos.src.rpm", 20015, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "f2ee9d55", "560cfc0a", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{0, "libuuid", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 20326, "BSD", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{2, "libpng", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 616101, "zlib", "CentOS", "", nil, nil, nil},
		{2, "libpng-devel", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 216267, "zlib", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 265973, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 350499, "IJG", "CentOS", "", nil, nil, nil},
		{0, "rh-nodejs10-runtime", "3.2", "2.el7", "x86_64", "rh-nodejs10-3.2-2.el7.src.rpm", 3921, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXau", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 55529, "MIT", "CentOS", "", nil, nil, nil},
		{0, "xorg-x11-proto-devel", "2018.4", "1.el7", "noarch", "xorg-x11-proto-devel-2018.4-1.el7.src.rpm", 1835516, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libxcb-devel", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 2717470, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rh-nodejs10-npm", "6.4.1", "10.10.0.2.el7", "x86_64", "rh-nodejs10-nodejs-10.10.0-2.el7.src.rpm", 16465524, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "dejavu-fonts-common", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 130455, "Bitstream Vera and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "fontconfig", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 666475, "MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "postgresql", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 16706464, "PostgreSQL", "CentOS", "", nil, nil, nil},
		{0, "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", nil, nil, nil},
		{0, "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "expat-devel", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 182002, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libcom_err-devel", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 17196, "MIT", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2018i", "1.el7", "noarch", "tzdata-2018i-1.el7.src.rpm", 2007607, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "xz-devel", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 168793, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsmartcols", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 164608, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.8.71", "10.el7", "noarch", "setup-2.8.71-10.el7.src.rpm", 696893, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "pcre-devel", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1505771, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.36.0", "1.1.el7_6", "x86_64", "nss-util-3.36.0-1.1.el7_6.src.rpm", 199008, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libX11", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1325648, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libX11-devel", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1100103, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXext", "1.3.3", "3.el7", "x86_64", "libXext-1.3.3-3.el7.src.rpm", 87102, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXpm-devel", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 68654, "MIT", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libsepol", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 686640, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgpg-error-devel", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 29702, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libsepol-devel", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 126580, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libverto-devel", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 25871, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "openssl-devel", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3268426, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libxslt-devel", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 2502662, "MIT", "CentOS", "", nil, nil, nil},
		{0, "coreutils", "8.22", "23.el7", "x86_64", "coreutils-8.22-23.el7.src.rpm", 14588674, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "7", "6.1810.2.el7.centos", "x86_64", "centos-release-7-6.1810.2.el7.centos.src.rpm", 41271, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "postgresql-devel", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 4147268, "PostgreSQL", "CentOS", "", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", nil, nil, nil},
		{0, "wget", "1.14", "18.el7", "x86_64", "wget-1.14-18.el7.src.rpm", 2055557, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libcurl-devel", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 638377, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", nil, nil, nil},
		{0, "sqlite-devel", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 374846, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-runtime", "2.0", "2.el7", "x86_64", "rh-python35-2.0-2.el7.src.rpm", 21152, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.56.1", "2.el7", "x86_64", "glib2-2.56.1-2.el7.src.rpm", 12166425, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python-setuptools", "18.0.1", "2.el7", "noarch", "rh-python35-python-setuptools-18.0.1-2.el7.src.rpm", 1785163, "Python or ZPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 42812, "Python", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libnfnetlink", "1.0.1", "4.el7", "x86_64", "libnfnetlink-1.0.1-4.el7.src.rpm", 47123, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libnetfilter_conntrack", "1.0.6", "1.el7_3", "x86_64", "libnetfilter_conntrack-1.0.6-1.el7_3.src.rpm", 143566, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "iproute", "4.11.0", "14.el7", "x86_64", "iproute-4.11.0-14.el7.src.rpm", 1788731, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "apr-util-openssl", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 19896, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "nss-pem", "1.0.3", "5.el7", "x86_64", "nss-pem-1.0.3-5.el7.src.rpm", 205539, "MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "hunspell-en-US", "0.20121024", "6.el7", "noarch", "hunspell-en-0.20121024-6.el7.src.rpm", 549311, "LGPLv2+ and LGPLv2 and BSD", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 14067, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 172645, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", nil, nil, nil},
		{0, "xml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 46969, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libselinux-python", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 603236, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.5", "8.el7", "x86_64", "checkpolicy-2.5-8.el7.src.rpm", 1288327, "GPLv2", "CentOS", "", nil, nil, nil},
		{1, "openssl", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 833657, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "python-IPy", "0.75", "6.el7", "noarch", "python-IPy-0.75-6.el7.src.rpm", 121946, "BSD", "CentOS", "", nil, nil, nil},
		{1, "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "rh-python35-python-devel", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 600179, "Python", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "sysvinit-tools", "2.88", "14.dsf.el7", "x86_64", "sysvinit-2.88-14.dsf.el7.src.rpm", 109118, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 144492, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "libcurl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 435192, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openldap-devel", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 3847489, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "apr-util-devel", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 298354, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 1037424, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "setools-libs", "3.3.8", "4.el7", "x86_64", "setools-3.3.8-4.el7.src.rpm", 1917790, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils-python", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 1299284, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-libcurl", "7.61.1", "1.el7", "x86_64", "httpd24-curl-7.61.1-1.el7.src.rpm", 545704, "MIT", "CentOS", "", nil, nil, nil},
		{0, "httpd24-httpd-tools", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 177148, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", nil, nil, nil},
		{0, "httpd24-mod_auth_kerb", "5.4", "33.el7", "x86_64", "httpd24-mod_auth_kerb-5.4-33.el7.src.rpm", 67371, "BSD and MIT and ASL 2.0", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.1.5.1", "25.el7", "x86_64", "shadow-utils-4.1.5.1-25.el7.src.rpm", 3540592, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "httpd24-mod_ldap", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 134213, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{1, "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "httpd24", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 0, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rh-python35", "2.0", "2.el7", "x86_64", "rh-python35-2.0-2.el7.src.rpm", 0, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 80907, "Python", "CentOS", "", nil, nil, nil},
		{0, "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss_wrapper", "1.0.3", "1.el7", "x86_64", "nss_wrapper-1.0.3-1.el7.src.rpm", 61024, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libffi-devel", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 27170, "MIT and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", nil, nil, nil},
		{0, "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kpartx", "0.4.9", "123.el7", "x86_64", "device-mapper-multipath-0.4.9-123.el7.src.rpm", 41363, "GPL+", "CentOS", "", nil, nil, nil},
		{7, "device-mapper-libs", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 400607, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "dracut", "033", "554.el7", "x86_64", "dracut-033-554.el7.src.rpm", 903230, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 362560, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 595210, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum", "3.4.3", "161.el7.centos", "noarch", "yum-3.4.3-161.el7.centos.src.rpm", 5824869, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "yum-plugin-ovl", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 22399, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "bsdtar", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 110459, "BSD", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", nil, nil, nil},
		{0, "scl-utils", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 25141, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "centos-release-scl", "2", "3.el7.centos", "noarch", "centos-release-scl-2-3.el7.centos.src.rpm", 20042, "GPLv2", "CentOS", "", nil, nil, nil},
		{1, "openssl-libs", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3204708, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "zlib-devel", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 135536, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "freetype", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 824497, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", nil, nil, nil},
		{0, "freetype-devel", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 2980705, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", nil, nil, nil},
		{0, "postgresql-libs", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 683495, "PostgreSQL", "CentOS", "", nil, nil, nil},
		{0, "fontpackages-filesystem", "1.44", "8.el7", "noarch", "fontpackages-1.44-8.el7.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libICE", "1.0.9", "9.el7", "x86_64", "libICE-1.0.9-9.el7.src.rpm", 152213, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libxcb", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 1011680, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libXau-devel", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 6519, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libSM", "1.2.2", "2.el7", "x86_64", "libSM-1.2.2-2.el7.src.rpm", 81546, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rh-nodejs10-nodejs", "10.10.0", "2.el7", "x86_64", "rh-nodejs10-nodejs-10.10.0-2.el7.src.rpm", 28549171, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "", nil, nil, nil},
		{0, "dejavu-sans-fonts", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 5395167, "Bitstream Vera and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo-devel", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 321845, "IJG", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 278173, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "mariadb-libs", "5.5.60", "1.el7_5", "x86_64", "mariadb-5.5.60-1.el7_5.src.rpm", 4615006, "GPLv2 with exceptions and LGPLv2 and BSD", "CentOS", "", nil, nil, nil},
		{0, "libuuid-devel", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 17258, "BSD", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
	}

	// docker run --rm -it centos:8 bash
	// yum module install -y container-tools
	// yum groupinstall -y "Development tools"
	// yum -y install nodejs podman-docker
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"%{MODULARITYLABEL}\", nil, nil, nil\},\n" | sed "s/^{(none)/{0/g" | sed "s/(none)//g"
	CentOS8Modularitylabel = []*PackageInfo{
		{0, "strace", "4.24", "9.el8", "x86_64", "strace-4.24-9.el8.src.rpm", 2176244, "LGPL-2.1+ and GPL-2.0+", "CentOS", "", nil, nil, nil},
		{0, "libxcb", "1.13.1", "1.el8", "x86_64", "libxcb-1.13.1-1.el8.src.rpm", 1028472, "MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-gpg-keys", "8.2", "2.2004.0.1.el8", "noarch", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 3370, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "byacc", "1.9.20170709", "4.el8", "x86_64", "byacc-1.9.20170709-4.el8.src.rpm", 253862, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libXrender", "0.9.10", "7.el8", "x86_64", "libXrender-0.9.10-7.el8.src.rpm", 52595, "MIT", "CentOS", "", nil, nil, nil},
		{0, "filesystem", "3.8", "2.el8", "x86_64", "filesystem-3.8-2.el8.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "python3-gobject", "3.28.3", "1.el8", "x86_64", "pygobject3-3.28.3-1.el8.src.rpm", 16432, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "pcre2", "10.32", "1.el8", "x86_64", "pcre2-10.32-1.el8.src.rpm", 667046, "BSD", "CentOS", "", nil, nil, nil},
		{0, "containernetworking-plugins", "0.8.3", "5.module_el8.2.0+305+5e198a41", "x86_64", "containernetworking-plugins-0.8.3-5.module_el8.2.0+305+5e198a41.src.rpm", 74349750, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "glibc-common", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 9531204, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{0, "toolbox", "0.0.7", "1.module_el8.2.0+305+5e198a41", "noarch", "toolbox-0.0.7-1.module_el8.2.0+305+5e198a41.src.rpm", 18199, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "zlib", "1.2.11", "13.el8", "x86_64", "zlib-1.2.11-13.el8.src.rpm", 195551, "zlib and Boost", "CentOS", "", nil, nil, nil},
		{0, "udica", "0.2.1", "2.module_el8.2.0+305+5e198a41", "noarch", "udica-0.2.1-2.module_el8.2.0+305+5e198a41.src.rpm", 106242, "GPLv3+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "libgpg-error", "1.31", "1.el8", "x86_64", "libgpg-error-1.31-1.el8.src.rpm", 902818, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-Carp", "1.42", "396.el8", "noarch", "perl-Carp-1.42-396.el8.src.rpm", 41852, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libxcrypt", "4.1.1", "4.el8", "x86_64", "libxcrypt-4.1.1-4.el8.src.rpm", 194420, "LGPLv2+ and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{3, "perl-Scalar-List-Utils", "1.49", "2.el8", "x86_64", "perl-Scalar-List-Utils-1.49-2.el8.src.rpm", 124632, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libstdc++", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 1855607, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libgomp", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 331057, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "readline", "7.0", "10.el8", "x86_64", "readline-7.0-10.el8.src.rpm", 466321, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "m4", "1.4.18", "7.el8", "x86_64", "m4-1.4.18-7.el8.src.rpm", 379304, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libacl", "2.2.53", "1.el8", "x86_64", "acl-2.2.53-1.el8.src.rpm", 59272, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "cups-libs", "2.2.6", "33.el8", "x86_64", "cups-2.2.6-33.el8.src.rpm", 947548, "LGPLv2 and zlib", "CentOS", "", nil, nil, nil},
		{0, "libmount", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 398154, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXcursor", "1.1.15", "3.el8", "x86_64", "libXcursor-1.1.15-3.el8.src.rpm", 48759, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsmartcols", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 244258, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXt", "1.1.5", "12.el8", "x86_64", "libXt-1.1.5-12.el8.src.rpm", 597617, "MIT", "CentOS", "", nil, nil, nil},
		{0, "p11-kit", "0.23.14", "5.el8_0", "x86_64", "p11-kit-0.23.14-5.el8_0.src.rpm", 1394732, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-Errno", "1.28", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 9495, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libunistring", "0.9.9", "3.el8", "x86_64", "libunistring-0.9.9-3.el8.src.rpm", 1855932, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Path", "2.15", "2.el8", "noarch", "perl-File-Path-2.15-2.el8.src.rpm", 64920, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "gdbm-libs", "1.18", "1.el8", "x86_64", "gdbm-1.18-1.el8.src.rpm", 135248, "GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "perl-threads", "2.21", "2.el8", "x86_64", "perl-threads-2.21-2.el8.src.rpm", 109155, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "lzo", "2.08", "14.el8", "x86_64", "lzo-2.08-14.el8.src.rpm", 198757, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Socket-IP", "0.39", "5.el8", "noarch", "perl-IO-Socket-IP-0.39-5.el8.src.rpm", 99525, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "dbus-libs", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 380576, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xml-common", "0.6.3", "50.el8", "noarch", "sgml-common-0.6.3-50.el8.src.rpm", 80250, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "procps-ng", "3.3.15", "1.el8", "x86_64", "procps-ng-3.3.15-1.el8.src.rpm", 938380, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "efivar-libs", "36", "1.el8", "x86_64", "efivar-36-1.el8.src.rpm", 250520, "LGPLv2.1", "CentOS", "", nil, nil, nil},
		{1, "gdbm", "1.18", "1.el8", "x86_64", "gdbm-1.18-1.el8.src.rpm", 399977, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "javapackages-filesystem", "5.3.0", "1.module_el8.0.0+11+5b8c10bd", "noarch", "javapackages-tools-5.3.0-1.module_el8.0.0+11+5b8c10bd.src.rpm", 1935, "BSD", "CentOS", "javapackages-runtime:201801:8000020190530193251:278695df", nil, nil, nil},
		{0, "libfdisk", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 438722, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "mokutil", "0.3.0", "9.el8", "x86_64", "mokutil-0.3.0-9.el8.src.rpm", 89577, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "snappy", "1.1.7", "5.el8", "x86_64", "snappy-1.1.7-5.el8.src.rpm", 58789, "BSD", "CentOS", "", nil, nil, nil},
		{1, "perl-Error", "0.17025", "2.el8", "noarch", "perl-Error-0.17025-2.el8.src.rpm", 71565, "(GPL+ or Artistic) and MIT", "CentOS", "", nil, nil, nil},
		{0, "libksba", "1.3.5", "7.el8", "x86_64", "libksba-1.3.5-7.el8.src.rpm", 342935, "(LGPLv3+ or GPLv2+) and GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Escapes", "1.07", "395.el8", "noarch", "perl-Pod-Escapes-1.07-395.el8.src.rpm", 25763, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libmnl", "1.0.4", "6.el8", "x86_64", "libmnl-1.0.4-6.el8.src.rpm", 53687, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "boost-timer", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 26226, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "libseccomp", "2.4.1", "1.el8", "x86_64", "libseccomp-2.4.1-1.el8.src.rpm", 402960, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "cpp", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 29644557, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libnsl2", "1.2.0", "2.20180605git4a062cf.el8", "x86_64", "libnsl2-1.2.0-2.20180605git4a062cf.el8.src.rpm", 147122, "BSD and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "jasper-libs", "2.0.14", "4.el8", "x86_64", "jasper-2.0.14-4.el8.src.rpm", 389890, "JasPer", "CentOS", "", nil, nil, nil},
		{0, "crypto-policies", "20191128", "2.git23e1bf1.el8", "noarch", "crypto-policies-20191128-2.git23e1bf1.el8.src.rpm", 190228, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "nss-sysinit", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 14402, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libdb", "5.3.28", "37.el8", "x86_64", "libdb-5.3.28-37.el8.src.rpm", 2515048, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "fipscheck-lib", "1.5.0", "4.el8", "x86_64", "fipscheck-1.5.0-4.el8.src.rpm", 12433, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gnutls", "3.6.8", "11.el8_2", "x86_64", "gnutls-3.6.8-11.el8_2.src.rpm", 2687433, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "docbook-dtds", "1.0", "69.el8", "noarch", "docbook-dtds-1.0-69.el8.src.rpm", 8665150, "Copyright only", "CentOS", "", nil, nil, nil},
		{0, "ima-evm-utils", "1.1", "5.el8", "x86_64", "ima-evm-utils-1.1-5.el8.src.rpm", 123538, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "dnf-plugins-core", "4.0.12", "4.el8_2", "noarch", "dnf-plugins-core-4.0.12-4.el8_2.src.rpm", 16900, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cyrus-sasl-lib", "2.1.27", "1.el8", "x86_64", "cyrus-sasl-2.1.27-1.el8.src.rpm", 734978, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "perl-Term-Cap", "1.17", "395.el8", "noarch", "perl-Term-Cap-1.17-395.el8.src.rpm", 29850, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{32, "bind-export-libs", "9.11.13", "5.el8_2", "x86_64", "bind-9.11.13-5.el8_2.src.rpm", 3067121, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libsecret", "0.18.6", "1.el8", "x86_64", "libsecret-0.18.6-1.el8.src.rpm", 520362, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsolv", "0.7.7", "1.el8", "x86_64", "libsolv-0.7.7-1.el8.src.rpm", 789176, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libicu", "60.3", "2.el8_1", "x86_64", "icu-60.3-2.el8_1.src.rpm", 33716339, "MIT and UCD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "gnupg2", "2.2.9", "1.el8", "x86_64", "gnupg2-2.2.9-1.el8.src.rpm", 9632671, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "git-core", "2.18.4", "2.el8_2", "x86_64", "git-2.18.4-2.el8_2.src.rpm", 24912186, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python3-libdnf", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 3666814, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libxcrypt-devel", "4.1.1", "4.el8", "x86_64", "libxcrypt-4.1.1-4.el8.src.rpm", 24771, "LGPLv2+ and BSD and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "dnf-data", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 36254, "GPLv2+ and GPLv2 and GPL", "CentOS", "", nil, nil, nil},
		{1, "perl-Pod-Simple", "3.35", "395.el8", "noarch", "perl-Pod-Simple-3.35-395.el8.src.rpm", 543719, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{8, "device-mapper", "1.02.169", "3.el8", "x86_64", "lvm2-2.03.08-3.el8.src.rpm", 355102, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "perl-Pod-Perldoc", "3.28", "396.el8", "noarch", "perl-Pod-Perldoc-3.28-396.el8.src.rpm", 169228, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libs", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 717567, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-URI", "1.73", "3.el8", "noarch", "perl-URI-1.73-3.el8.src.rpm", 216452, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "iputils", "20180629", "2.el8", "x86_64", "iputils-20180629-2.el8.src.rpm", 351665, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "git", "2.18.4", "2.el8_2", "x86_64", "git-2.18.4-2.el8_2.src.rpm", 399381, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "systemd-udev", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 7940076, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zstd", "1.4.2", "2.el8", "x86_64", "zstd-1.4.2-2.el8.src.rpm", 1550971, "BSD and GPLv2", "CentOS", "", nil, nil, nil},
		{0, "rpm-build-libs", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 215992, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "rust-srpm-macros", "5", "2.el8", "noarch", "rust-srpm-macros-5-2.el8.src.rpm", 1131, "MIT", "CentOS", "", nil, nil, nil},
		{0, "yum", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 70885, "GPLv2+ and GPLv2 and GPL", "CentOS", "", nil, nil, nil},
		{0, "perl-srpm-macros", "1", "25.el8", "noarch", "perl-srpm-macros-1-25.el8.src.rpm", 794, "GPLv3+", "CentOS", "", nil, nil, nil},
		{2, "vim-minimal", "8.0.1763", "13.el8", "x86_64", "vim-8.0.1763-13.el8.src.rpm", 1420484, "Vim and MIT", "CentOS", "", nil, nil, nil},
		{0, "lua", "5.3.4", "11.el8", "x86_64", "lua-5.3.4-11.el8.src.rpm", 638964, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rootfiles", "8.1", "22.el8", "noarch", "rootfiles-8.1-22.el8.src.rpm", 599, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libstdc++-devel", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 11807826, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{1, "nodejs", "10.21.0", "3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 31483781, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", nil, nil, nil},
		{0, "libipt", "1.6.1", "8.el8", "x86_64", "libipt-1.6.1-8.el8.src.rpm", 108543, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libnl3", "3.5.0", "1.el8", "x86_64", "libnl3-3.5.0-1.el8.src.rpm", 994296, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "xorg-x11-fonts-ISO8859-1-100dpi", "7.5", "19.el8", "noarch", "xorg-x11-fonts-7.5-19.el8.src.rpm", 1070824, "MIT and Lucida and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "slirp4netns", "0.4.2", "3.git21fdece.module_el8.2.0+305+5e198a41", "x86_64", "slirp4netns-0.4.2-3.git21fdece.module_el8.2.0+305+5e198a41.src.rpm", 173387, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "libatomic_ops", "7.6.2", "3.el8", "x86_64", "libatomic_ops-7.6.2-3.el8.src.rpm", 76822, "GPLv2 and MIT", "CentOS", "", nil, nil, nil},
		{0, "gdk-pixbuf2", "2.36.12", "5.el8", "x86_64", "gdk-pixbuf2-2.36.12-5.el8.src.rpm", 2657576, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXxf86vm", "1.1.4", "9.el8", "x86_64", "libXxf86vm-1.1.4-9.el8.src.rpm", 26424, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libnfnetlink", "1.0.1", "13.el8", "x86_64", "libnfnetlink-1.0.1-13.el8.src.rpm", 52395, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-c059-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1460348, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "abattis-cantarell-fonts", "0.0.25", "4.el8", "noarch", "abattis-cantarell-fonts-0.0.25-4.el8.src.rpm", 302227, "OFL", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-nimbus-roman-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1429675, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "audit", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 671305, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-z003-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 400088, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "libteam", "1.29", "1.el8_2.2", "x86_64", "libteam-1.29-1.el8_2.2.src.rpm", 106092, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "lcms2", "2.9", "2.el8", "x86_64", "lcms2-2.9-2.el8.src.rpm", 399313, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python3-slip", "0.6.4", "11.el8", "noarch", "python-slip-0.6.4-11.el8.src.rpm", 61396, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gdk-pixbuf2-modules", "2.36.12", "5.el8", "x86_64", "gdk-pixbuf2-2.36.12-5.el8.src.rpm", 315856, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-decorator", "4.2.1", "2.el8", "noarch", "python-decorator-4.2.1-2.el8.src.rpm", 47871, "BSD", "CentOS", "", nil, nil, nil},
		{0, "annobin", "8.90", "1.el8.0.1", "x86_64", "annobin-8.90-1.el8.0.1.src.rpm", 432502, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "mozjs60", "60.9.0", "4.el8", "x86_64", "mozjs60-60.9.0-4.el8.src.rpm", 23728688, "MPLv2.0 and MPLv1.1 and BSD and GPLv2+ and GPLv3+ and LGPLv2+ and AFL and ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "gtk-update-icon-cache", "3.22.30", "5.el8", "x86_64", "gtk3-3.22.30-5.el8.src.rpm", 60214, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libstemmer", "0", "10.585svn.el8", "x86_64", "libstemmer-0-10.585svn.el8.src.rpm", 361957, "BSD", "CentOS", "", nil, nil, nil},
		{0, "go-srpm-macros", "2", "16.el8", "noarch", "go-srpm-macros-2-16.el8.src.rpm", 18532, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libmodman", "2.0.1", "17.el8", "x86_64", "libmodman-2.0.1-17.el8.src.rpm", 69479, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gtk2", "2.24.32", "4.el8", "x86_64", "gtk2-2.24.32-4.el8.src.rpm", 13811558, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libsoup", "2.62.3", "1.el8", "x86_64", "libsoup-2.62.3-1.el8.src.rpm", 1594291, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "efi-srpm-macros", "3", "2.el8", "noarch", "efi-rpm-macros-3-2.el8.src.rpm", 39223, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "teamd", "1.29", "1.el8_2.2", "x86_64", "libteam-1.29-1.el8_2.2.src.rpm", 278854, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "source-highlight", "3.1.8", "16.el8", "x86_64", "source-highlight-3.1.8-16.el8.src.rpm", 3516067, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "diffutils", "3.6", "6.el8", "x86_64", "diffutils-3.6-6.el8.src.rpm", 1369962, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-runtime", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 1393756, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "selinux-policy-targeted", "3.14.3", "41.el8_2.8", "noarch", "selinux-policy-3.14.3-41.el8_2.8.src.rpm", 52586852, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "graphviz", "2.40.1", "40.el8", "x86_64", "graphviz-2.40.1-40.el8.src.rpm", 7807623, "EPL-1.0", "CentOS", "", nil, nil, nil},
		{0, "checkpolicy", "2.9", "1.el8", "x86_64", "checkpolicy-2.9-1.el8.src.rpm", 1768984, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gdb", "8.2", "11.el8", "x86_64", "gdb-8.2-11.el8.src.rpm", 363845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and LGPLv3+ and BSD and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{1, "NetworkManager-libnm", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 9207215, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "intltool", "0.51.0", "11.el8", "noarch", "intltool-0.51.0-11.el8.src.rpm", 173158, "GPLv2 with exceptions", "CentOS", "", nil, nil, nil},
		{0, "python3-psutil", "5.4.3", "10.el8", "x86_64", "python-psutil-5.4.3-10.el8.src.rpm", 2041226, "BSD", "CentOS", "", nil, nil, nil},
		{0, "patchutils", "0.3.4", "10.el8", "x86_64", "patchutils-0.3.4-10.el8.src.rpm", 285091, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "criu", "3.12", "9.module_el8.2.0+305+5e198a41", "x86_64", "criu-3.12-9.module_el8.2.0+305+5e198a41.src.rpm", 1332765, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "libgcc", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 190232, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libXau", "1.0.8", "13.el8", "x86_64", "libXau-1.0.8-13.el8.src.rpm", 59505, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python3-pip-wheel", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 1255748, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", nil, nil, nil},
		{0, "libX11-common", "1.6.8", "3.el8", "noarch", "libX11-1.6.8-3.el8.src.rpm", 1339608, "MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-release", "8.2", "2.2004.0.1.el8", "x86_64", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 25430, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libXext", "1.3.3", "9.el8", "x86_64", "libXext-1.3.3-9.el8.src.rpm", 97990, "MIT", "CentOS", "", nil, nil, nil},
		{0, "setup", "2.12.2", "5.el8", "noarch", "setup-2.12.2-5.el8.src.rpm", 724831, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cairo", "1.15.12", "3.el8", "x86_64", "cairo-1.15.12-3.el8.src.rpm", 1881396, "LGPLv2 or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "basesystem", "11", "5.el8", "noarch", "basesystem-11-5.el8.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "python3-cairo", "1.16.3", "6.el8", "x86_64", "pycairo-1.16.3-6.el8.src.rpm", 324125, "MPLv1.1 or LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "ncurses-base", "6.1", "7.20180224.el8", "noarch", "ncurses-6.1-7.20180224.el8.src.rpm", 290089, "MIT", "CentOS", "", nil, nil, nil},
		{0, "setroubleshoot-plugins", "3.3.11", "2.el8", "noarch", "setroubleshoot-plugins-3.3.11-2.el8.src.rpm", 2621479, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libselinux", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 305912, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "cockpit-system", "211.3", "1.el8", "noarch", "cockpit-211.3-1.el8.src.rpm", 2428779, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "glibc-minimal-langpack", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 0, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{2, "conmon", "2.0.6", "1.module_el8.2.0+305+5e198a41", "x86_64", "conmon-2.0.6-1.module_el8.2.0+305+5e198a41.src.rpm", 85817, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "glibc", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 17885631, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{0, "cockpit-podman", "12", "1.module_el8.2.0+305+5e198a41", "noarch", "cockpit-podman-12-1.module_el8.2.0+305+5e198a41.src.rpm", 4244724, "LGPLv2+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "libsepol", "2.9", "1.el8", "x86_64", "libsepol-2.9-1.el8.src.rpm", 996264, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "buildah", "1.11.6", "7.module_el8.2.0+305+5e198a41", "x86_64", "buildah-1.11.6-7.module_el8.2.0+305+5e198a41.src.rpm", 37059509, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "xz-libs", "5.2.4", "3.el8", "x86_64", "xz-5.2.4-3.el8.src.rpm", 194799, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "python-podman-api", "1.2.0", "0.2.gitd0a45fe.module_el8.2.0+305+5e198a41", "noarch", "python-podman-api-1.2.0-0.2.gitd0a45fe.module_el8.2.0+305+5e198a41.src.rpm", 120489, "LGPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "libcap", "2.26", "3.el8", "x86_64", "libcap-2.26-3.el8.src.rpm", 124170, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "podman-docker", "1.6.4", "10.module_el8.2.0+305+5e198a41", "noarch", "podman-1.6.4-10.module_el8.2.0+305+5e198a41.src.rpm", 5996, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "info", "6.5", "6.el8", "x86_64", "texinfo-6.5-6.el8.src.rpm", 386513, "GPLv3+", "CentOS", "", nil, nil, nil},
		{4, "perl-libs", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 6122645, "(GPL+ or Artistic) and HSRL and MIT and UCD", "CentOS", "", nil, nil, nil},
		{0, "libcom_err", "1.45.4", "3.el8", "x86_64", "e2fsprogs-1.45.4-3.el8.src.rpm", 61921, "MIT", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-fonts-common", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 38217, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "libxml2", "2.9.7", "7.el8", "x86_64", "libxml2-2.9.7-7.el8.src.rpm", 1752506, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss-util", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 220716, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "expat", "2.2.5", "3.el8", "x86_64", "expat-2.2.5-3.el8.src.rpm", 314068, "MIT", "CentOS", "", nil, nil, nil},
		{1, "perl-parent", "0.237", "1.el8", "noarch", "perl-parent-0.237-1.el8.src.rpm", 9187, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libuuid", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 34832, "BSD", "CentOS", "", nil, nil, nil},
		{0, "boost-system", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 21994, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "chkconfig", "1.11", "1.el8", "x86_64", "chkconfig-1.11-1.el8.src.rpm", 791234, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libICE", "1.0.9", "15.el8", "x86_64", "libICE-1.0.9-15.el8.src.rpm", 205821, "MIT", "CentOS", "", nil, nil, nil},
		{1, "gmp", "6.1.2", "10.el8", "x86_64", "gmp-6.1.2-10.el8.src.rpm", 1678740, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "unzip", "6.0", "43.el8", "x86_64", "unzip-6.0-43.el8.src.rpm", 423365, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libattr", "2.4.48", "3.el8", "x86_64", "attr-2.4.48-3.el8.src.rpm", 27346, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libcroco", "0.6.12", "4.el8_2.1", "x86_64", "libcroco-0.6.12-4.el8_2.1.src.rpm", 330811, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "coreutils-single", "8.30", "7.el8_2.1", "x86_64", "coreutils-8.30-7.el8_2.1.src.rpm", 1356273, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "avahi-libs", "0.7", "19.el8", "x86_64", "avahi-0.7-19.el8.src.rpm", 162712, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libblkid", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 339680, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libmpc", "1.0.2", "9.el8", "x86_64", "libmpc-1.0.2-9.el8.src.rpm", 154016, "LGPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libcap-ng", "0.7.9", "5.el8", "x86_64", "libcap-ng-0.7.9-5.el8.src.rpm", 51278, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXfixes", "5.0.3", "7.el8", "x86_64", "libXfixes-5.0.3-7.el8.src.rpm", 29263, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libffi", "3.1", "21.el8", "x86_64", "libffi-3.1-21.el8.src.rpm", 68404, "MIT", "CentOS", "", nil, nil, nil},
		{0, "gettext-libs", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 1612648, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libzstd", "1.4.2", "2.el8", "x86_64", "zstd-1.4.2-2.el8.src.rpm", 703765, "BSD and GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libSM", "1.2.3", "1.el8", "x86_64", "libSM-1.2.3-1.el8.src.rpm", 93427, "MIT", "CentOS", "", nil, nil, nil},
		{0, "lz4-libs", "1.8.1.2", "4.el8", "x86_64", "lz4-1.8.1.2-4.el8.src.rpm", 97367, "GPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "libXmu", "1.1.2", "12.el8", "x86_64", "libXmu-1.1.2-12.el8.src.rpm", 196334, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libgcrypt", "1.8.3", "4.el8", "x86_64", "libgcrypt-1.8.3-4.el8.src.rpm", 1547061, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{4, "perl-macros", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 5184, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "cracklib", "2.9.6", "15.el8", "x86_64", "cracklib-2.9.6-15.el8.src.rpm", 239047, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{4, "perl-Socket", "2.027", "3.el8", "x86_64", "perl-Socket-2.027-3.el8.src.rpm", 127014, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libidn2", "2.2.0", "1.el8", "x86_64", "libidn2-2.2.0-1.el8.src.rpm", 287762, "(GPLv2+ or LGPLv3+) and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-Unicode-Normalize", "1.25", "396.el8", "x86_64", "perl-Unicode-Normalize-1.25-396.el8.src.rpm", 637517, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "file-libs", "5.33", "13.el8", "x86_64", "file-5.33-13.el8.src.rpm", 6382974, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-IO", "1.38", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 140303, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "keyutils-libs", "1.5.10", "6.el8", "x86_64", "keyutils-1.5.10-6.el8.src.rpm", 43926, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-constant", "1.33", "396.el8", "noarch", "perl-constant-1.33-396.el8.src.rpm", 27104, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "p11-kit-trust", "0.23.14", "5.el8_0", "x86_64", "p11-kit-0.23.14-5.el8_0.src.rpm", 508547, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-threads-shared", "1.58", "2.el8", "x86_64", "perl-threads-shared-1.58-2.el8.src.rpm", 78170, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "pcre", "8.42", "4.el8", "x86_64", "pcre-8.42-4.el8.src.rpm", 518067, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-MIME-Base64", "3.15", "396.el8", "x86_64", "perl-MIME-Base64-3.15-396.el8.src.rpm", 41435, "(GPL+ or Artistic) and MIT", "CentOS", "", nil, nil, nil},
		{0, "systemd-libs", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 4497790, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{1, "perl-Time-Local", "1.280", "1.el8", "noarch", "perl-Time-Local-1.280-1.el8.src.rpm", 59906, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{1, "dbus-tools", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 125490, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-File-Temp", "0.230.600", "1.el8", "noarch", "perl-File-Temp-0.230.600-1.el8.src.rpm", 164723, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libusbx", "1.0.22", "1.el8", "x86_64", "libusbx-1.0.22-1.el8.src.rpm", 151177, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "patch", "2.7.6", "11.el8", "x86_64", "patch-2.7.6-11.el8.src.rpm", 266609, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "ca-certificates", "2019.2.32", "80.0.el8_1", "noarch", "ca-certificates-2019.2.32-80.0.el8_1.src.rpm", 993761, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "file", "5.33", "13.el8", "x86_64", "file-5.33-13.el8.src.rpm", 93224, "BSD", "CentOS", "", nil, nil, nil},
		{0, "squashfs-tools", "4.3", "19.el8", "x86_64", "squashfs-tools-4.3-19.el8.src.rpm", 502829, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXrandr", "1.5.1", "7.el8", "x86_64", "libXrandr-1.5.1-7.el8.src.rpm", 53138, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsemanage", "2.9", "2.el8", "x86_64", "libsemanage-2.9-2.el8.src.rpm", 477962, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXi", "1.7.9", "7.el8", "x86_64", "libXi-1.7.9-7.el8.src.rpm", 98363, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libutempter", "1.1.6", "14.el8", "x86_64", "libutempter-1.1.6-14.el8.src.rpm", 52637, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "atk", "2.28.1", "1.el8", "x86_64", "atk-2.28.1-1.el8.src.rpm", 1294970, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "acl", "2.2.53", "1.el8", "x86_64", "acl-2.2.53-1.el8.src.rpm", 205740, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "adobe-mappings-cmap-deprecated", "20171205", "3.el8", "noarch", "adobe-mappings-cmap-20171205-3.el8.src.rpm", 596942, "BSD", "CentOS", "", nil, nil, nil},
		{0, "nettle", "3.4.1", "1.el8", "x86_64", "nettle-3.4.1-1.el8.src.rpm", 683185, "LGPLv3+ or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-Digest", "1.17", "395.el8", "noarch", "perl-Digest-1.17-395.el8.src.rpm", 26685, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libcomps", "0.1.11", "4.el8", "x86_64", "libcomps-0.1.11-4.el8.src.rpm", 217067, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-Net-SSLeay", "1.88", "1.el8", "x86_64", "perl-Net-SSLeay-1.88-1.el8.src.rpm", 1368791, "Artistic 2.0", "CentOS", "", nil, nil, nil},
		{1, "findutils", "4.6.0", "20.el8", "x86_64", "findutils-4.6.0-20.el8.src.rpm", 1816673, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-TermReadKey", "2.37", "7.el8", "x86_64", "perl-TermReadKey-2.37-7.el8.src.rpm", 66206, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", nil, nil, nil},
		{0, "cpio", "2.12", "8.el8", "x86_64", "cpio-2.12-8.el8.src.rpm", 989536, "GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "valgrind", "3.15.0", "11.el8", "x86_64", "valgrind-3.15.0-11.el8.src.rpm", 32152354, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ipcalc", "0.2.4", "4.el8", "x86_64", "ipcalc-0.2.4-4.el8.src.rpm", 67705, "GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "perl-Storable", "3.11", "3.el8", "x86_64", "perl-Storable-3.11-3.el8.src.rpm", 221862, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "libnghttp2", "1.33.0", "3.el8_2.1", "x86_64", "nghttp2-1.33.0-3.el8_2.1.src.rpm", 168044, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-Mozilla-CA", "20160104", "7.el8", "noarch", "perl-Mozilla-CA-20160104-7.el8.src.rpm", 5716, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "iptables-libs", "1.8.4", "10.el8_2.1", "x86_64", "iptables-1.8.4-10.el8_2.1.src.rpm", 201920, "GPLv2 and Artistic 2.0 and ISC", "CentOS", "", nil, nil, nil},
		{0, "libXaw", "1.0.13", "10.el8", "x86_64", "libXaw-1.0.13-10.el8.src.rpm", 523837, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libsigsegv", "2.11", "5.el8", "x86_64", "libsigsegv-2.11-5.el8.src.rpm", 47034, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libXdamage", "1.1.4", "14.el8", "x86_64", "libXdamage-1.1.4-14.el8.src.rpm", 30432, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libverto", "0.3.0", "5.el8", "x86_64", "libverto-0.3.0-5.el8.src.rpm", 28244, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libidn", "1.34", "5.el8", "x86_64", "libidn-1.34-5.el8.src.rpm", 713211, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libtirpc", "1.1.4", "4.el8", "x86_64", "libtirpc-1.1.4-4.el8.src.rpm", 381964, "SISSL and BSD", "CentOS", "", nil, nil, nil},
		{0, "boost-thread", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 182682, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{1, "openssl-libs", "1.1.1c", "15.el8", "x86_64", "openssl-1.1.1c-15.el8.src.rpm", 3744176, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn-freebl", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 634614, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "platform-python-setuptools", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 2930163, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 1996163, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "python3-libs", "3.6.8", "23.el8", "x86_64", "python3-3.6.8-23.el8.src.rpm", 32187857, "Python", "CentOS", "", nil, nil, nil},
		{0, "nss-tools", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 2286837, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "libpwquality", "1.4.0", "9.el8", "x86_64", "libpwquality-1.4.0-9.el8.src.rpm", 384791, "BSD or GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-Term-ANSIColor", "4.06", "396.el8", "noarch", "perl-Term-ANSIColor-4.06-396.el8.src.rpm", 89627, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "util-linux", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 11560494, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "fipscheck", "1.5.0", "4.el8", "x86_64", "fipscheck-1.5.0-4.el8.src.rpm", 48547, "BSD", "CentOS", "", nil, nil, nil},
		{0, "glib2", "2.56.4", "8.el8", "x86_64", "glib2-2.56.4-8.el8.src.rpm", 12272168, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "sgml-common", "0.6.3", "50.el8", "noarch", "sgml-common-0.6.3-50.el8.src.rpm", 172077, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "iproute", "5.3.0", "1.el8", "x86_64", "iproute-5.3.0-1.el8.src.rpm", 1894954, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "docbook-style-xsl", "1.79.2", "7.el8", "noarch", "docbook-style-xsl-1.79.2-7.el8.src.rpm", 16311851, "DMIT", "CentOS", "", nil, nil, nil},
		{0, "kmod", "25", "16.el8", "x86_64", "kmod-25-16.el8.src.rpm", 243998, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-dnf-plugins-core", "4.0.12", "4.el8_2", "noarch", "dnf-plugins-core-4.0.12-4.el8_2.src.rpm", 663140, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "curl", "7.61.1", "12.el8", "x86_64", "curl-7.61.1-12.el8.src.rpm", 709006, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pkgconf-m4", "1.4.2", "1.el8", "noarch", "pkgconf-1.4.2-1.el8.src.rpm", 14187, "GPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "openldap", "2.4.46", "11.el8_1", "x86_64", "openldap-2.4.46-11.el8_1.src.rpm", 1388793, "OpenLDAP", "CentOS", "", nil, nil, nil},
		{0, "ncurses", "6.1", "7.20180224.el8", "x86_64", "ncurses-6.1-7.20180224.el8.src.rpm", 600396, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python3-libcomps", "0.1.11", "4.el8", "x86_64", "libcomps-0.1.11-4.el8.src.rpm", 147027, "GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "make", "4.2.1", "10.el8", "x86_64", "make-4.2.1-10.el8.src.rpm", 1435840, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libarchive", "3.3.2", "8.el8_1", "x86_64", "libarchive-3.3.2-8.el8_1.src.rpm", 1139914, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libxslt", "1.1.32", "4.el8", "x86_64", "libxslt-1.1.32-4.el8.src.rpm", 751661, "MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm-libs", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 722464, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", nil, nil, nil},
		{0, "libpkgconf", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 68093, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libyaml", "0.1.7", "5.el8", "x86_64", "libyaml-0.1.7-5.el8.src.rpm", 136478, "MIT", "CentOS", "", nil, nil, nil},
		{0, "npth", "1.5", "4.el8", "x86_64", "npth-1.5-4.el8.src.rpm", 47909, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gpgme", "1.10.0", "6.el8.0.1", "x86_64", "gpgme-1.10.0-6.el8.0.1.src.rpm", 741097, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdnf", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 2123765, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-hawkey", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 263176, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libreport-filesystem", "2.9.5", "10.el8", "x86_64", "libreport-2.9.5-10.el8.src.rpm", 0, "GPLv2+", "CentOS", "", nil, nil, nil},
		{12, "dhcp-common", "4.3.6", "40.el8", "noarch", "dhcp-4.3.6-40.el8.src.rpm", 301814, "ISC", "CentOS", "", nil, nil, nil},
		{1, "dbus-daemon", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 560056, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{8, "device-mapper-libs", "1.02.169", "3.el8", "x86_64", "lvm2-2.03.08-3.el8.src.rpm", 416167, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "elfutils-default-yama-scope", "0.178", "7.el8", "noarch", "elfutils-0.178-7.el8.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "systemd-pam", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 902504, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "dbus", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 0, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{12, "dhcp-client", "4.3.6", "40.el8", "x86_64", "dhcp-4.3.6-40.el8.src.rpm", 530732, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libkcapi-hmaccalc", "1.1.1", "16_1.el8", "x86_64", "libkcapi-1.1.1-16_1.el8.src.rpm", 35165, "BSD or GPLv2", "CentOS", "", nil, nil, nil},
		{0, "dracut", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 1046582, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dracut-squash", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 3054, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-rpm", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 430929, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dnf", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 1670640, "GPLv2+ and GPLv2 and GPL", "CentOS", "", nil, nil, nil},
		{0, "kexec-tools", "2.0.20", "14.el8", "x86_64", "kexec-tools-2.0.20-14.el8.src.rpm", 1222009, "GPLv2", "CentOS", "", nil, nil, nil},
		{2, "tar", "1.30", "4.el8", "x86_64", "tar-1.30-4.el8.src.rpm", 2914728, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "hostname", "3.20", "6.el8", "x86_64", "hostname-3.20-6.el8.src.rpm", 43979, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "langpacks-en", "1.0", "12.el8", "noarch", "langpacks-1.0-12.el8.src.rpm", 400, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gpg-pubkey", "8483c65d", "5ccc5b19", "", "", 0, "pubkey", "", "", nil, nil, nil},
		{1, "npm", "6.14.4", "1.10.21.0.3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 16351222, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", nil, nil, nil},
		{0, "python3-libselinux", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 894878, "Public Domain", "CentOS", "", nil, nil, nil},
		{2, "libpng", "1.6.34", "5.el8", "x86_64", "libpng-1.6.34-5.el8.src.rpm", 235304, "zlib", "CentOS", "", nil, nil, nil},
		{0, "freetype", "2.9.1", "4.el8", "x86_64", "freetype-2.9.1-4.el8.src.rpm", 828847, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", nil, nil, nil},
		{0, "gobject-introspection", "1.56.1", "1.el8", "x86_64", "gobject-introspection-1.56.1-1.el8.src.rpm", 880467, "GPLv2+, LGPLv2+, MIT", "CentOS", "", nil, nil, nil},
		{0, "libnl3-cli", "3.5.0", "1.el8", "x86_64", "libnl3-3.5.0-1.el8.src.rpm", 838214, "LGPLv2", "CentOS", "", nil, nil, nil},
		{0, "shared-mime-info", "1.9", "3.el8", "x86_64", "shared-mime-info-1.9-3.el8.src.rpm", 2442451, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-audit", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 333023, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libnftnl", "1.1.5", "4.el8", "x86_64", "libnftnl-1.1.5-4.el8.src.rpm", 222320, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "json-glib", "1.4.4", "1.el8", "x86_64", "json-glib-1.4.4-1.el8.src.rpm", 530243, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fontpackages-filesystem", "1.44", "22.el8", "noarch", "fontpackages-1.44-22.el8.src.rpm", 0, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "fontconfig", "2.13.1", "3.el8", "x86_64", "fontconfig-2.13.1-3.el8.src.rpm", 729249, "MIT and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "gsettings-desktop-schemas", "3.32.0", "4.el8", "x86_64", "gsettings-desktop-schemas-3.32.0-4.el8.src.rpm", 4216968, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libnetfilter_conntrack", "1.0.6", "5.el8", "x86_64", "libnetfilter_conntrack-1.0.6-5.el8.src.rpm", 165190, "GPLv2+", "CentOS", "", nil, nil, nil},
		{1, "nftables", "0.9.3", "12.el8_2.1", "x86_64", "nftables-0.9.3-12.el8_2.1.src.rpm", 811211, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "PackageKit-glib", "1.1.12", "4.el8", "x86_64", "PackageKit-1.1.12-4.el8.src.rpm", 635676, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-setools", "4.2.2", "2.el8", "x86_64", "setools-4.2.2-2.el8.src.rpm", 2691942, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "python3-six", "1.11.0", "8.el8", "noarch", "python-six-1.11.0-8.el8.src.rpm", 100282, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python3-libxml2", "2.9.7", "7.el8", "x86_64", "libxml2-2.9.7-7.el8.src.rpm", 1358319, "MIT", "CentOS", "", nil, nil, nil},
		{0, "platform-python-pip", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 7749727, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", nil, nil, nil},
		{0, "python3-pip", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 2856, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", nil, nil, nil},
		{0, "polkit", "0.115", "11.el8", "x86_64", "polkit-0.115-11.el8.src.rpm", 469075, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libvarlink", "18", "3.el8", "x86_64", "libvarlink-18-3.el8.src.rpm", 132453, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "libssh-config", "0.9.0", "4.el8", "noarch", "libssh-0.9.0-4.el8.src.rpm", 357, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libndp", "1.7", "3.el8", "x86_64", "libndp-1.7-3.el8.src.rpm", 80786, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libproxy", "0.4.15", "5.2.el8", "x86_64", "libproxy-0.4.15-5.2.el8.src.rpm", 201294, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "cockpit-bridge", "211.3", "1.el8", "x86_64", "cockpit-211.3-1.el8.src.rpm", 1062966, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libappstream-glib", "0.7.14", "3.el8", "x86_64", "libappstream-glib-0.7.14-3.el8.src.rpm", 1072064, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libdaemon", "0.14", "15.el8", "x86_64", "libdaemon-0.14-15.el8.src.rpm", 64469, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fuse3-libs", "3.2.1", "12.el8", "x86_64", "fuse-2.9.7-12.el8.src.rpm", 285282, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "containers-common", "0.1.40", "11.module_el8.2.0+377+92552693", "x86_64", "skopeo-0.1.40-11.module_el8.2.0+377+92552693.src.rpm", 44763, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200603213325:0d58ad57", nil, nil, nil},
		{0, "policycoreutils", "2.9", "9.el8", "x86_64", "policycoreutils-2.9-9.el8.src.rpm", 672959, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "selinux-policy", "3.14.3", "41.el8_2.8", "noarch", "selinux-policy-3.14.3-41.el8_2.8.src.rpm", 24923, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "dbus-glib", "0.110", "2.el8", "x86_64", "dbus-glib-0.110-2.el8.src.rpm", 367078, "AFL and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-slip-dbus", "0.6.4", "11.el8", "noarch", "python-slip-0.6.4-11.el8.src.rpm", 71273, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-policycoreutils", "2.9", "9.el8", "noarch", "policycoreutils-2.9-9.el8.src.rpm", 5632728, "GPLv2", "CentOS", "", nil, nil, nil},
		{2, "container-selinux", "2.124.0", "1.module_el8.2.0+305+5e198a41", "noarch", "container-selinux-2.124.0-1.module_el8.2.0+305+5e198a41.src.rpm", 45036, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{1, "NetworkManager", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 6568601, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-systemd", "234", "8.el8", "x86_64", "python-systemd-234-8.el8.src.rpm", 259121, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "protobuf-c", "1.3.0", "4.el8", "x86_64", "protobuf-c-1.3.0-4.el8.src.rpm", 57650, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libnet", "1.1.6", "15.el8", "x86_64", "libnet-1.1.6-15.el8.src.rpm", 174574, "BSD", "CentOS", "", nil, nil, nil},
		{0, "flex", "2.6.1", "9.el8", "x86_64", "flex-2.6.1-9.el8.src.rpm", 931867, "BSD and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-sign", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 18996, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "diffstat", "1.61", "7.el8", "x86_64", "diffstat-1.61-7.el8.src.rpm", 65815, "MIT", "CentOS", "", nil, nil, nil},
		{0, "pkgconf-pkg-config", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 3094, "ISC", "CentOS", "", nil, nil, nil},
		{0, "boost-regex", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 1185250, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "openssh-clients", "8.0p1", "4.el8_1", "x86_64", "openssh-8.0p1-4.el8_1.src.rpm", 3567696, "BSD", "CentOS", "", nil, nil, nil},
		{0, "git-core-doc", "2.18.4", "2.el8_2", "noarch", "git-2.18.4-2.el8_2.src.rpm", 11778148, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "glibc-headers", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 2029912, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{0, "glibc-devel", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 1273916, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{4, "perl-Encode", "2.97", "3.el8", "x86_64", "perl-Encode-2.97-3.el8.src.rpm", 10200695, "(GPL+ or Artistic) and Artistic 2.0 and UCD", "CentOS", "", nil, nil, nil},
		{1, "perl-Getopt-Long", "2.50", "4.el8", "noarch", "perl-Getopt-Long-2.50-4.el8.src.rpm", 139724, "GPLv2+ or Artistic", "CentOS", "", nil, nil, nil},
		{4, "perl-Pod-Usage", "1.69", "395.el8", "noarch", "perl-Pod-Usage-1.69-395.el8.src.rpm", 49721, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-HTTP-Tiny", "0.074", "1.el8", "noarch", "perl-HTTP-Tiny-0.074-1.el8.src.rpm", 149162, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "perl-libnet", "3.11", "3.el8", "noarch", "perl-libnet-3.11-3.el8.src.rpm", 277135, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "autoconf", "2.69", "27.el8", "noarch", "autoconf-2.69-27.el8.src.rpm", 2323003, "GPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-Git", "2.18.4", "2.el8_2", "noarch", "git-2.18.4-2.el8_2.src.rpm", 64807, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gettext-common-devel", "0.19.8.1", "17.el8", "noarch", "gettext-0.19.8.1-17.el8.src.rpm", 397912, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "bzip2", "1.0.6", "26.el8", "x86_64", "bzip2-1.0.6-26.el8.src.rpm", 93460, "BSD", "CentOS", "", nil, nil, nil},
		{2, "vim-filesystem", "8.0.1763", "13.el8", "noarch", "vim-8.0.1763-13.el8.src.rpm", 40, "Vim and MIT", "CentOS", "", nil, nil, nil},
		{0, "tbb", "2018.2", "9.el8", "x86_64", "tbb-2018.2-9.el8.src.rpm", 470470, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "qt5-srpm-macros", "5.12.5", "3.el8", "noarch", "qt5-5.12.5-3.el8.src.rpm", 0, "GPLv3", "CentOS", "", nil, nil, nil},
		{0, "python-srpm-macros", "3", "38.el8", "noarch", "python-rpm-macros-3-38.el8.src.rpm", 3747, "MIT", "CentOS", "", nil, nil, nil},
		{0, "openjpeg2", "2.3.1", "6.el8", "x86_64", "openjpeg2-2.3.1-6.el8.src.rpm", 356438, "BSD and MIT", "CentOS", "", nil, nil, nil},
		{0, "ocaml-srpm-macros", "5", "4.el8", "noarch", "ocaml-srpm-macros-5-4.el8.src.rpm", 737, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "copy-jdk-configs", "3.7", "1.el8", "noarch", "copy-jdk-configs-3.7-1.el8.src.rpm", 16774, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libwebp", "1.0.0", "1.el8", "x86_64", "libwebp-1.0.0-1.el8.src.rpm", 860976, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libpaper", "1.1.24", "22.el8", "x86_64", "libpaper-1.1.24-22.el8.src.rpm", 90939, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "mcpp", "2.7.2", "20.el8", "x86_64", "mcpp-2.7.2-20.el8.src.rpm", 53794, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libijs", "0.35", "5.el8", "x86_64", "libijs-0.35-5.el8.src.rpm", 60640, "AGPLv3+", "CentOS", "", nil, nil, nil},
		{1, "xorg-x11-font-utils", "7.5", "40.el8", "x86_64", "xorg-x11-font-utils-7.5-40.el8.src.rpm", 383068, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libdatrie", "0.2.9", "7.el8", "x86_64", "libdatrie-0.2.9-7.el8.src.rpm", 62583, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libbabeltrace", "1.5.4", "2.el8", "x86_64", "babeltrace-1.5.4-2.el8.src.rpm", 580059, "MIT and GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gc", "7.6.4", "3.el8", "x86_64", "gc-7.6.4-3.el8.src.rpm", 229024, "BSD", "CentOS", "", nil, nil, nil},
		{0, "gdb-headless", "8.2", "11.el8", "x86_64", "gdb-8.2-11.el8.src.rpm", 11897980, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and LGPLv3+ and BSD and Public Domain and GFDL", "CentOS", "", nil, nil, nil},
		{0, "libXxf86misc", "1.0.4", "1.el8", "x86_64", "libXxf86misc-1.0.4-1.el8.src.rpm", 32012, "MIT", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-bookman-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1428518, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-d050000l-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 86572, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-nimbus-mono-ps-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1099749, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-nimbus-sans-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 2469317, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-standard-symbols-ps-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 45184, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 5478, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "libXcomposite", "0.4.4", "14.el8", "x86_64", "libXcomposite-0.4.4-14.el8.src.rpm", 35952, "MIT", "CentOS", "", nil, nil, nil},
		{0, "jbigkit-libs", "2.1", "14.el8", "x86_64", "jbigkit-2.1-14.el8.src.rpm", 109677, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gd", "2.2.5", "6.el8", "x86_64", "gd-2.2.5-6.el8.src.rpm", 441251, "MIT", "CentOS", "", nil, nil, nil},
		{0, "jbig2dec-libs", "0.14", "4.el8_2", "x86_64", "jbig2dec-0.14-4.el8_2.src.rpm", 146739, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gcc", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 61698975, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "gcc-gdb-plugin", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 341891, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "hicolor-icon-theme", "0.17", "2.el8", "noarch", "hicolor-icon-theme-0.17-2.el8.src.rpm", 73932, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "graphite2", "1.3.10", "10.el8", "x86_64", "graphite2-1.3.10-10.el8.src.rpm", 270396, "(LGPLv2+ or GPLv2+ or MPL) and (Netscape or GPLv2+ or LGPLv2+)", "CentOS", "", nil, nil, nil},
		{0, "google-droid-sans-fonts", "20120715", "13.el8", "noarch", "google-droid-fonts-20120715-13.el8.src.rpm", 6229278, "ASL 2.0", "CentOS", "", nil, nil, nil},
		{0, "ghc-srpm-macros", "1.4.2", "7.el8", "noarch", "ghc-srpm-macros-1.4.2-7.el8.src.rpm", 414, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pango", "1.42.4", "6.el8", "x86_64", "pango-1.42.4-6.el8.src.rpm", 958244, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "librsvg2", "2.42.7", "3.el8", "x86_64", "librsvg2-2.42.7-3.el8.src.rpm", 1830479, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 2835784, "GPLv3+ and (GPLv2+ or LGPLv3+) and GFDL", "CentOS", "", nil, nil, nil},
		{0, "dwz", "0.12", "9.el8", "x86_64", "dwz-0.12-9.el8.src.rpm", 232103, "GPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "ctags", "5.8", "22.el8", "x86_64", "ctags-5.8-22.el8.src.rpm", 417116, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "boost-date-time", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 79610, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "dyninst", "10.1.0", "4.el8", "x86_64", "dyninst-10.1.0-4.el8.src.rpm", 14686061, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "systemtap-client", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 11184527, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libgs", "9.25", "5.el8_1.1", "x86_64", "ghostscript-9.25-5.el8_1.1.src.rpm", 20878358, "AGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "asciidoc", "8.6.10", "0.5.20180627gitf7c2274.el8", "noarch", "asciidoc-8.6.10-0.5.20180627gitf7c2274.el8.src.rpm", 808989, "GPL+ and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "rpm-build", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 299895, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gcc-c++", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 32170609, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "jna", "4.5.1", "5.el8", "x86_64", "jna-4.5.1-5.el8.src.rpm", 416128, "(LGPLv2 or ASL 2.0) and ASL 2.0", "CentOS", "", nil, nil, nil},
		{1, "valgrind-devel", "3.15.0", "11.el8", "x86_64", "valgrind-3.15.0-11.el8.src.rpm", 474728, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pesign", "0.112", "25.el8", "x86_64", "pesign-0.112-25.el8.src.rpm", 1060595, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "bison", "3.0.4", "10.el8", "x86_64", "bison-3.0.4-10.el8.src.rpm", 2199622, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "runc", "1.0.0", "65.rc10.module_el8.2.0+305+5e198a41", "x86_64", "runc-1.0.0-65.rc10.module_el8.2.0+305+5e198a41.src.rpm", 10250793, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "python3-setuptools-wheel", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 347696, "MIT", "CentOS", "", nil, nil, nil},
		{0, "ltrace", "0.7.91", "28.el8", "x86_64", "ltrace-0.7.91-28.el8.src.rpm", 339426, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libX11", "1.6.8", "3.el8", "x86_64", "libX11-1.6.8-3.el8.src.rpm", 1343952, "MIT", "CentOS", "", nil, nil, nil},
		{0, "centos-repos", "8.2", "2.2004.0.1.el8", "x86_64", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 9660, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "cairo-gobject", "1.15.12", "3.el8", "x86_64", "cairo-1.15.12-3.el8.src.rpm", 36928, "LGPLv2 or MPLv1.1", "CentOS", "", nil, nil, nil},
		{0, "tzdata", "2020a", "1.el8", "noarch", "tzdata-2020a-1.el8.src.rpm", 1904256, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "setroubleshoot-server", "3.3.22", "2.el8", "x86_64", "setroubleshoot-3.3.22-2.el8.src.rpm", 1347731, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "ncurses-libs", "6.1", "7.20180224.el8", "x86_64", "ncurses-6.1-7.20180224.el8.src.rpm", 1120040, "MIT", "CentOS", "", nil, nil, nil},
		{0, "podman", "1.6.4", "10.module_el8.2.0+305+5e198a41", "x86_64", "podman-1.6.4-10.module_el8.2.0+305+5e198a41.src.rpm", 57521087, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "bash", "4.4.19", "10.el8", "x86_64", "bash-4.4.19-10.el8.src.rpm", 6930068, "GPLv3+", "CentOS", "", nil, nil, nil},
		{1, "skopeo", "0.1.40", "11.module_el8.2.0+377+92552693", "x86_64", "skopeo-0.1.40-11.module_el8.2.0+377+92552693.src.rpm", 22732055, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200603213325:0d58ad57", nil, nil, nil},
		{0, "bzip2-libs", "1.0.6", "26.el8", "x86_64", "bzip2-1.0.6-26.el8.src.rpm", 77229, "BSD", "CentOS", "", nil, nil, nil},
		{0, "perl-Exporter", "5.72", "396.el8", "noarch", "perl-Exporter-5.72-396.el8.src.rpm", 55719, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "elfutils-libelf", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 920699, "GPLv2+ or LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "nspr", "4.25.0", "2.el8_2", "x86_64", "nspr-4.25.0-2.el8_2.src.rpm", 317302, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "sqlite-libs", "3.26.0", "6.el8", "x86_64", "sqlite-3.26.0-6.el8.src.rpm", 1162241, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libjpeg-turbo", "1.5.3", "10.el8", "x86_64", "libjpeg-turbo-1.5.3-10.el8.src.rpm", 638420, "IJG", "CentOS", "", nil, nil, nil},
		{0, "popt", "1.16", "14.el8", "x86_64", "popt-1.16-14.el8.src.rpm", 128374, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-ParseWords", "3.30", "395.el8", "noarch", "perl-Text-ParseWords-3.30-395.el8.src.rpm", 13101, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{0, "json-c", "0.13.1", "0.2.el8", "x86_64", "json-c-0.13.1-0.2.el8.src.rpm", 73898, "MIT", "CentOS", "", nil, nil, nil},
		{1, "emacs-filesystem", "26.1", "5.el8", "noarch", "emacs-26.1-5.el8.src.rpm", 0, "GPLv3+ and CC0-1.0", "CentOS", "", nil, nil, nil},
		{0, "sed", "4.5", "1.el8", "x86_64", "sed-4.5-1.el8.src.rpm", 776854, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libXpm", "3.5.12", "8.el8", "x86_64", "libXpm-3.5.12-8.el8.src.rpm", 120823, "MIT", "CentOS", "", nil, nil, nil},
		{0, "audit-libs", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 283708, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "zip", "3.0", "23.el8", "x86_64", "zip-3.0-23.el8.src.rpm", 842885, "BSD", "CentOS", "", nil, nil, nil},
		{0, "lua-libs", "5.3.4", "11.el8", "x86_64", "lua-5.3.4-11.el8.src.rpm", 351728, "MIT", "CentOS", "", nil, nil, nil},
		{0, "boost-chrono", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 38826, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "gzip", "1.9", "9.el8", "x86_64", "gzip-1.9-9.el8.src.rpm", 426515, "GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-Text-Tabs+Wrap", "2013.0523", "395.el8", "noarch", "perl-Text-Tabs+Wrap-2013.0523-395.el8.src.rpm", 24825, "TTWL", "CentOS", "", nil, nil, nil},
		{0, "libassuan", "2.5.1", "3.el8", "x86_64", "libassuan-2.5.1-3.el8.src.rpm", 202763, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-PathTools", "3.74", "1.el8", "x86_64", "perl-PathTools-3.74-1.el8.src.rpm", 182821, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{0, "libtasn1", "4.13", "3.el8", "x86_64", "libtasn1-4.13-3.el8.src.rpm", 168725, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{4, "perl-interpreter", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 14381705, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and BSD and Public Domain and UCD", "CentOS", "", nil, nil, nil},
		{0, "grep", "3.1", "6.el8", "x86_64", "grep-3.1-6.el8.src.rpm", 835205, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "perl-Data-Dumper", "2.167", "399.el8", "x86_64", "perl-Data-Dumper-2.167-399.el8.src.rpm", 106523, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{12, "dhcp-libs", "4.3.6", "40.el8", "x86_64", "dhcp-4.3.6-40.el8.src.rpm", 161256, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libtool-ltdl", "2.4.6", "25.el8", "x86_64", "libtool-2.4.6-25.el8.src.rpm", 71434, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "xz", "5.2.4", "3.el8", "x86_64", "xz-5.2.4-3.el8.src.rpm", 432832, "GPLv2+ and Public Domain", "CentOS", "", nil, nil, nil},
		{0, "libXinerama", "1.1.4", "1.el8", "x86_64", "libXinerama-1.1.4-1.el8.src.rpm", 15719, "MIT", "CentOS", "", nil, nil, nil},
		{2, "shadow-utils", "4.6", "8.el8", "x86_64", "shadow-utils-4.6-8.el8.src.rpm", 5368080, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "adobe-mappings-cmap", "20171205", "3.el8", "noarch", "adobe-mappings-cmap-20171205-3.el8.src.rpm", 13746679, "BSD", "CentOS", "", nil, nil, nil},
		{0, "mpfr", "3.1.6", "1.el8", "x86_64", "mpfr-3.1.6-1.el8.src.rpm", 612625, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", nil, nil, nil},
		{0, "perl-Digest-MD5", "2.55", "396.el8", "x86_64", "perl-Digest-MD5-2.55-396.el8.src.rpm", 56718, "(GPL+ or Artistic) and BSD", "CentOS", "", nil, nil, nil},
		{0, "libmetalink", "0.1.3", "7.el8", "x86_64", "libmetalink-0.1.3-7.el8.src.rpm", 76960, "MIT", "CentOS", "", nil, nil, nil},
		{0, "perl-XML-Parser", "2.44", "11.el8", "x86_64", "perl-XML-Parser-2.44-11.el8.src.rpm", 643439, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{2, "ethtool", "5.0", "2.el8", "x86_64", "ethtool-5.0-2.el8.src.rpm", 502623, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "perl-Thread-Queue", "3.13", "1.el8", "noarch", "perl-Thread-Queue-3.13-1.el8.src.rpm", 29787, "GPL+ or Artistic", "CentOS", "", nil, nil, nil},
		{14, "libpcap", "1.9.0", "3.el8", "x86_64", "libpcap-1.9.0-3.el8.src.rpm", 424251, "BSD with advertising", "CentOS", "", nil, nil, nil},
		{0, "gettext", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 5412553, "GPLv3+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "gawk", "4.2.1", "1.el8", "x86_64", "gawk-4.2.1-1.el8.src.rpm", 2717614, "GPLv3+ and GPLv2+ and LGPLv2+ and BSD", "CentOS", "", nil, nil, nil},
		{0, "boost-filesystem", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 113690, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "krb5-libs", "1.17", "18.el8", "x86_64", "krb5-1.17-18.el8.src.rpm", 2259532, "MIT", "CentOS", "", nil, nil, nil},
		{0, "nss-softokn", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 1917766, "MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "platform-python", "3.6.8", "23.el8", "x86_64", "python3-3.6.8-23.el8.src.rpm", 41790, "Python", "CentOS", "", nil, nil, nil},
		{0, "perl-Fedora-VSP", "0.001", "9.el8", "noarch", "perl-Fedora-VSP-0.001-9.el8.src.rpm", 40886, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "pam", "1.3.1", "8.el8", "x86_64", "pam-1.3.1-8.el8.src.rpm", 2857052, "BSD and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "openssh", "8.0p1", "4.el8_1", "x86_64", "openssh-8.0p1-4.el8_1.src.rpm", 2255675, "BSD", "CentOS", "", nil, nil, nil},
		{0, "kmod-libs", "25", "16.el8", "x86_64", "kmod-25-16.el8.src.rpm", 126640, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{1, "python3-dateutil", "2.6.1", "6.el8", "noarch", "python-dateutil-2.6.1-6.el8.src.rpm", 596677, "BSD", "CentOS", "", nil, nil, nil},
		{0, "libcurl-minimal", "7.61.1", "12.el8", "x86_64", "curl-7.61.1-12.el8.src.rpm", 551776, "MIT", "CentOS", "", nil, nil, nil},
		{1, "openssl", "1.1.1c", "15.el8", "x86_64", "openssl-1.1.1c-15.el8.src.rpm", 1175523, "OpenSSL", "CentOS", "", nil, nil, nil},
		{0, "libdb-utils", "5.3.28", "37.el8", "x86_64", "libdb-5.3.28-37.el8.src.rpm", 536911, "BSD and LGPLv2 and Sleepycat", "CentOS", "", nil, nil, nil},
		{0, "lksctp-tools", "1.0.18", "3.el8", "x86_64", "lksctp-tools-1.0.18-3.el8.src.rpm", 258226, "GPLv2 and GPLv2+ and LGPLv2 and MIT", "CentOS", "", nil, nil, nil},
		{0, "rpm", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 2084270, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "pkgconf", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 63271, "ISC", "CentOS", "", nil, nil, nil},
		{0, "libmodulemd1", "1.8.16", "0.2.8.2.1", "x86_64", "libmodulemd-2.8.2-1.el8.src.rpm", 546039, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libedit", "3.1", "23.20170329cvs.el8", "x86_64", "libedit-3.1-23.20170329cvs.el8.src.rpm", 247168, "BSD", "CentOS", "", nil, nil, nil},
		{0, "librepo", "1.11.0", "2.el8", "x86_64", "librepo-1.11.0-2.el8.src.rpm", 262664, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "kernel-headers", "4.18.0", "193.28.1.el8_2", "x86_64", "kernel-4.18.0-193.28.1.el8_2.src.rpm", 4958028, "GPLv2 and Redistributable, no modification permitted", "CentOS", "", nil, nil, nil},
		{0, "python3-gpg", "1.10.0", "6.el8.0.1", "x86_64", "gpgme-1.10.0-6.el8.0.1.src.rpm", 1295107, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "groff-base", "1.22.3", "18.el8", "x86_64", "groff-1.22.3-18.el8.src.rpm", 4216866, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", nil, nil, nil},
		{1, "dbus-common", "1.12.8", "10.el8_2", "noarch", "dbus-1.12.8-10.el8_2.src.rpm", 11131, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-podlators", "4.11", "1.el8", "noarch", "perl-podlators-4.11-1.el8.src.rpm", 287639, "(GPL+ or Artistic) and FSFAP", "CentOS", "", nil, nil, nil},
		{0, "cryptsetup-libs", "2.2.2", "1.el8", "x86_64", "cryptsetup-2.2.2-1.el8.src.rpm", 1871402, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-IO-Socket-SSL", "2.066", "4.el8", "noarch", "perl-IO-Socket-SSL-2.066-4.el8.src.rpm", 618705, "(GPL+ or Artistic) and MPLv2.0", "CentOS", "", nil, nil, nil},
		{0, "systemd", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 11073343, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "automake", "1.16.1", "6.el8", "noarch", "automake-1.16.1-6.el8.src.rpm", 1805946, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", nil, nil, nil},
		{0, "libkcapi", "1.1.1", "16_1.el8", "x86_64", "libkcapi-1.1.1-16_1.el8.src.rpm", 82828, "BSD or GPLv2", "CentOS", "", nil, nil, nil},
		{0, "gettext-devel", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 1552453, "LGPLv2+ and GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "dracut-network", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 160704, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "tzdata-java", "2020d", "1.el8", "noarch", "tzdata-2020d-1.el8.src.rpm", 374148, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "python3-dnf", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 1829655, "GPLv2+ and GPLv2 and GPL", "CentOS", "", nil, nil, nil},
		{0, "python3-rpm-macros", "3", "38.el8", "noarch", "python-rpm-macros-3-38.el8.src.rpm", 1888, "MIT", "CentOS", "", nil, nil, nil},
		{0, "binutils", "2.30", "73.el8", "x86_64", "binutils-2.30-73.el8.src.rpm", 24856745, "GPLv3+", "CentOS", "", nil, nil, nil},
		{0, "openblas-srpm-macros", "2", "2.el8", "noarch", "openblas-srpm-macros-2-2.el8.src.rpm", 104, "MIT", "CentOS", "", nil, nil, nil},
		{0, "less", "530", "1.el8", "x86_64", "less-530-1.el8.src.rpm", 344874, "GPLv3+ or BSD", "CentOS", "", nil, nil, nil},
		{1, "java-1.8.0-openjdk-headless", "1.8.0.272.b10", "1.el8_2", "x86_64", "java-1.8.0-openjdk-1.8.0.272.b10-1.el8_2.src.rpm", 122536636, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", nil, nil, nil},
		{1, "nodejs-full-i18n", "10.21.0", "3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 27531792, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", nil, nil, nil},
		{0, "libmcpp", "2.7.2", "20.el8", "x86_64", "mcpp-2.7.2-20.el8.src.rpm", 153388, "BSD", "CentOS", "", nil, nil, nil},
		{0, "polkit-libs", "0.115", "11.el8", "x86_64", "polkit-0.115-11.el8.src.rpm", 273132, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "libfontenc", "1.1.3", "8.el8", "x86_64", "libfontenc-1.1.3-8.el8.src.rpm", 57021, "MIT", "CentOS", "", nil, nil, nil},
		{0, "jansson", "2.11", "3.el8", "x86_64", "jansson-2.11-3.el8.src.rpm", 88783, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libthai", "0.1.27", "2.el8", "x86_64", "libthai-0.1.27-2.el8.src.rpm", 774997, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "python3-libsemanage", "2.9", "2.el8", "x86_64", "libsemanage-2.9-2.el8.src.rpm", 474221, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{5, "guile", "2.0.14", "7.el8", "x86_64", "guile-2.0.14-7.el8.src.rpm", 12159310, "LGPLv3+", "CentOS", "", nil, nil, nil},
		{0, "libselinux-utils", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 369120, "Public Domain", "CentOS", "", nil, nil, nil},
		{0, "xorg-x11-server-utils", "7.7", "27.el8", "x86_64", "xorg-x11-server-utils-7.7-27.el8.src.rpm", 502730, "MIT", "CentOS", "", nil, nil, nil},
		{0, "initscripts", "10.00.6", "1.el8_2.2", "x86_64", "initscripts-10.00.6-1.el8_2.2.src.rpm", 1086847, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-gothic-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1216672, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "pixman", "0.38.4", "1.el8", "x86_64", "pixman-0.38.4-1.el8.src.rpm", 693167, "MIT", "CentOS", "", nil, nil, nil},
		{0, "urw-base35-p052-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1557171, "AGPLv3", "CentOS", "", nil, nil, nil},
		{0, "iptables", "1.8.4", "10.el8_2.1", "x86_64", "iptables-1.8.4-10.el8_2.1.src.rpm", 1974841, "GPLv2 and Artistic 2.0 and ISC", "CentOS", "", nil, nil, nil},
		{0, "libXft", "2.3.2", "10.el8", "x86_64", "libXft-2.3.2-10.el8.src.rpm", 136069, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python3-gobject-base", "3.28.3", "1.el8", "x86_64", "pygobject3-3.28.3-1.el8.src.rpm", 1116879, "LGPLv2+ and MIT", "CentOS", "", nil, nil, nil},
		{0, "libtiff", "4.0.9", "17.el8", "x86_64", "libtiff-4.0.9-17.el8.src.rpm", 517321, "libtiff", "CentOS", "", nil, nil, nil},
		{0, "python3-setuptools", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 460967, "MIT", "CentOS", "", nil, nil, nil},
		{0, "isl", "0.16.1", "6.el8", "x86_64", "isl-0.16.1-6.el8.src.rpm", 3270833, "MIT", "CentOS", "", nil, nil, nil},
		{0, "python36", "3.6.8", "2.module_el8.1.0+245+c39af44f", "x86_64", "python36-3.6.8-2.module_el8.1.0+245+c39af44f.src.rpm", 13131, "Python", "CentOS", "python36:3.6:8010020191115015851:a920e634", nil, nil, nil},
		{0, "systemtap-devel", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 8837735, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "polkit-pkla-compat", "0.1", "12.el8", "x86_64", "polkit-pkla-compat-0.1-12.el8.src.rpm", 95728, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "harfbuzz", "1.7.5", "3.el8", "x86_64", "harfbuzz-1.7.5-3.el8.src.rpm", 802826, "MIT", "CentOS", "", nil, nil, nil},
		{0, "libssh", "0.9.0", "4.el8", "x86_64", "libssh-0.9.0-4.el8.src.rpm", 822758, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "fribidi", "1.0.4", "8.el8", "x86_64", "fribidi-1.0.4-8.el8.src.rpm", 319733, "LGPLv2+ and UCD", "CentOS", "", nil, nil, nil},
		{0, "glib-networking", "2.56.1", "1.1.el8", "x86_64", "glib-networking-2.56.1-1.1.el8.src.rpm", 531110, "LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "elfutils-debuginfod-client", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 35910, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", nil, nil, nil},
		{0, "PackageKit", "1.1.12", "4.el8", "x86_64", "PackageKit-1.1.12-4.el8.src.rpm", 2873887, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "redhat-rpm-config", "122", "1.el8", "noarch", "redhat-rpm-config-122-1.el8.src.rpm", 140370, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "fuse-overlayfs", "0.7.2", "5.module_el8.2.0+305+5e198a41", "x86_64", "fuse-overlayfs-0.7.2-5.module_el8.2.0+305+5e198a41.src.rpm", 119420, "GPLv3+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", nil, nil, nil},
		{0, "boost-atomic", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 8666, "Boost and MIT and Python", "CentOS", "", nil, nil, nil},
		{0, "rpm-plugin-selinux", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 11880, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "adobe-mappings-pdf", "20180407", "1.el8", "noarch", "adobe-mappings-pdf-20180407-1.el8.src.rpm", 4398414, "BSD", "CentOS", "", nil, nil, nil},
		{0, "python3-dbus", "1.2.4", "15.el8", "x86_64", "dbus-python-1.2.4-15.el8.src.rpm", 489189, "MIT", "CentOS", "", nil, nil, nil},
		{0, "systemtap", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 0, "GPLv2+", "CentOS", "", nil, nil, nil},
		{0, "policycoreutils-python-utils", "2.9", "9.el8", "noarch", "policycoreutils-2.9-9.el8.src.rpm", 140042, "GPLv2", "CentOS", "", nil, nil, nil},
		{0, "libtool", "2.4.6", "25.el8", "x86_64", "libtool-2.4.6-25.el8.src.rpm", 2687501, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", nil, nil, nil},
		{1, "NetworkManager-team", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 45480, "GPLv2+ and LGPLv2+", "CentOS", "", nil, nil, nil},
		{0, "perl-generators", "1.10", "9.el8", "noarch", "perl-generators-1.10-9.el8.src.rpm", 21852, "GPL+", "CentOS", "", nil, nil, nil},
		{0, "ostree-libs", "2019.6", "2.el8", "x86_64", "ostree-2019.6-2.el8.src.rpm", 981292, "LGPLv2+", "CentOS", "", nil, nil, nil},
	}

	// rpm -ql python --dbpath /path/to/testdata/centos5-plain | awk '{printf "\"%s\",\n", $1}'
	CentOS5PythonInstalledFiles = []string{
		"/usr/bin/pydoc",
		"/usr/bin/python",
		"/usr/bin/python2",
		"/usr/bin/python2.4",
		"/usr/share/doc/python-2.4.3",
		"/usr/share/doc/python-2.4.3/LICENSE",
		"/usr/share/doc/python-2.4.3/README",
		"/usr/share/man/man1/python.1.gz",
	}

	// rpm -ql glibc --dbpath /path/to/testdata/centos6-plain | awk '{printf "\"%s\",\n", $1}'
	CentOS6GlibcInstalledFiles = []string{
		"/etc/gai.conf",
		"/etc/ld.so.cache",
		"/etc/ld.so.conf",
		"/etc/ld.so.conf.d",
		"/etc/localtime",
		"/etc/nsswitch.conf",
		"/etc/rpc",
		"/lib64/ld-2.12.so",
		"/lib64/ld-linux-x86-64.so.2",
		"/lib64/libBrokenLocale-2.12.so",
		"/lib64/libBrokenLocale.so.1",
		"/lib64/libSegFault.so",
		"/lib64/libanl-2.12.so",
		"/lib64/libanl.so.1",
		"/lib64/libc-2.12.so",
		"/lib64/libc.so.6",
		"/lib64/libcidn-2.12.so",
		"/lib64/libcidn.so.1",
		"/lib64/libcrypt-2.12.so",
		"/lib64/libcrypt.so.1",
		"/lib64/libdl-2.12.so",
		"/lib64/libdl.so.2",
		"/lib64/libm-2.12.so",
		"/lib64/libm.so.6",
		"/lib64/libnsl-2.12.so",
		"/lib64/libnsl.so.1",
		"/lib64/libnss_compat-2.12.so",
		"/lib64/libnss_compat.so.2",
		"/lib64/libnss_dns-2.12.so",
		"/lib64/libnss_dns.so.2",
		"/lib64/libnss_files-2.12.so",
		"/lib64/libnss_files.so.2",
		"/lib64/libnss_hesiod-2.12.so",
		"/lib64/libnss_hesiod.so.2",
		"/lib64/libnss_nis-2.12.so",
		"/lib64/libnss_nis.so.2",
		"/lib64/libnss_nisplus-2.12.so",
		"/lib64/libnss_nisplus.so.2",
		"/lib64/libpthread-2.12.so",
		"/lib64/libpthread.so.0",
		"/lib64/libresolv-2.12.so",
		"/lib64/libresolv.so.2",
		"/lib64/librt-2.12.so",
		"/lib64/librt.so.1",
		"/lib64/libthread_db-1.0.so",
		"/lib64/libthread_db.so.1",
		"/lib64/libutil-2.12.so",
		"/lib64/libutil.so.1",
		"/lib64/rtkaio",
		"/lib64/rtkaio/librt.so.1",
		"/lib64/rtkaio/librtkaio-2.12.so",
		"/sbin/ldconfig",
		"/sbin/sln",
		"/usr/lib64/gconv",
		"/usr/lib64/gconv/ANSI_X3.110.so",
		"/usr/lib64/gconv/ARMSCII-8.so",
		"/usr/lib64/gconv/ASMO_449.so",
		"/usr/lib64/gconv/BIG5.so",
		"/usr/lib64/gconv/BIG5HKSCS.so",
		"/usr/lib64/gconv/BRF.so",
		"/usr/lib64/gconv/CP10007.so",
		"/usr/lib64/gconv/CP1125.so",
		"/usr/lib64/gconv/CP1250.so",
		"/usr/lib64/gconv/CP1251.so",
		"/usr/lib64/gconv/CP1252.so",
		"/usr/lib64/gconv/CP1253.so",
		"/usr/lib64/gconv/CP1254.so",
		"/usr/lib64/gconv/CP1255.so",
		"/usr/lib64/gconv/CP1256.so",
		"/usr/lib64/gconv/CP1257.so",
		"/usr/lib64/gconv/CP1258.so",
		"/usr/lib64/gconv/CP737.so",
		"/usr/lib64/gconv/CP775.so",
		"/usr/lib64/gconv/CP932.so",
		"/usr/lib64/gconv/CSN_369103.so",
		"/usr/lib64/gconv/CWI.so",
		"/usr/lib64/gconv/DEC-MCS.so",
		"/usr/lib64/gconv/EBCDIC-AT-DE-A.so",
		"/usr/lib64/gconv/EBCDIC-AT-DE.so",
		"/usr/lib64/gconv/EBCDIC-CA-FR.so",
		"/usr/lib64/gconv/EBCDIC-DK-NO-A.so",
		"/usr/lib64/gconv/EBCDIC-DK-NO.so",
		"/usr/lib64/gconv/EBCDIC-ES-A.so",
		"/usr/lib64/gconv/EBCDIC-ES-S.so",
		"/usr/lib64/gconv/EBCDIC-ES.so",
		"/usr/lib64/gconv/EBCDIC-FI-SE-A.so",
		"/usr/lib64/gconv/EBCDIC-FI-SE.so",
		"/usr/lib64/gconv/EBCDIC-FR.so",
		"/usr/lib64/gconv/EBCDIC-IS-FRISS.so",
		"/usr/lib64/gconv/EBCDIC-IT.so",
		"/usr/lib64/gconv/EBCDIC-PT.so",
		"/usr/lib64/gconv/EBCDIC-UK.so",
		"/usr/lib64/gconv/EBCDIC-US.so",
		"/usr/lib64/gconv/ECMA-CYRILLIC.so",
		"/usr/lib64/gconv/EUC-CN.so",
		"/usr/lib64/gconv/EUC-JISX0213.so",
		"/usr/lib64/gconv/EUC-JP-MS.so",
		"/usr/lib64/gconv/EUC-JP.so",
		"/usr/lib64/gconv/EUC-KR.so",
		"/usr/lib64/gconv/EUC-TW.so",
		"/usr/lib64/gconv/GB18030.so",
		"/usr/lib64/gconv/GBBIG5.so",
		"/usr/lib64/gconv/GBGBK.so",
		"/usr/lib64/gconv/GBK.so",
		"/usr/lib64/gconv/GEORGIAN-ACADEMY.so",
		"/usr/lib64/gconv/GEORGIAN-PS.so",
		"/usr/lib64/gconv/GOST_19768-74.so",
		"/usr/lib64/gconv/GREEK-CCITT.so",
		"/usr/lib64/gconv/GREEK7-OLD.so",
		"/usr/lib64/gconv/GREEK7.so",
		"/usr/lib64/gconv/HP-GREEK8.so",
		"/usr/lib64/gconv/HP-ROMAN8.so",
		"/usr/lib64/gconv/HP-ROMAN9.so",
		"/usr/lib64/gconv/HP-THAI8.so",
		"/usr/lib64/gconv/HP-TURKISH8.so",
		"/usr/lib64/gconv/IBM037.so",
		"/usr/lib64/gconv/IBM038.so",
		"/usr/lib64/gconv/IBM1004.so",
		"/usr/lib64/gconv/IBM1008.so",
		"/usr/lib64/gconv/IBM1008_420.so",
		"/usr/lib64/gconv/IBM1025.so",
		"/usr/lib64/gconv/IBM1026.so",
		"/usr/lib64/gconv/IBM1046.so",
		"/usr/lib64/gconv/IBM1047.so",
		"/usr/lib64/gconv/IBM1097.so",
		"/usr/lib64/gconv/IBM1112.so",
		"/usr/lib64/gconv/IBM1122.so",
		"/usr/lib64/gconv/IBM1123.so",
		"/usr/lib64/gconv/IBM1124.so",
		"/usr/lib64/gconv/IBM1129.so",
		"/usr/lib64/gconv/IBM1130.so",
		"/usr/lib64/gconv/IBM1132.so",
		"/usr/lib64/gconv/IBM1133.so",
		"/usr/lib64/gconv/IBM1137.so",
		"/usr/lib64/gconv/IBM1140.so",
		"/usr/lib64/gconv/IBM1141.so",
		"/usr/lib64/gconv/IBM1142.so",
		"/usr/lib64/gconv/IBM1143.so",
		"/usr/lib64/gconv/IBM1144.so",
		"/usr/lib64/gconv/IBM1145.so",
		"/usr/lib64/gconv/IBM1146.so",
		"/usr/lib64/gconv/IBM1147.so",
		"/usr/lib64/gconv/IBM1148.so",
		"/usr/lib64/gconv/IBM1149.so",
		"/usr/lib64/gconv/IBM1153.so",
		"/usr/lib64/gconv/IBM1154.so",
		"/usr/lib64/gconv/IBM1155.so",
		"/usr/lib64/gconv/IBM1156.so",
		"/usr/lib64/gconv/IBM1157.so",
		"/usr/lib64/gconv/IBM1158.so",
		"/usr/lib64/gconv/IBM1160.so",
		"/usr/lib64/gconv/IBM1161.so",
		"/usr/lib64/gconv/IBM1162.so",
		"/usr/lib64/gconv/IBM1163.so",
		"/usr/lib64/gconv/IBM1164.so",
		"/usr/lib64/gconv/IBM1166.so",
		"/usr/lib64/gconv/IBM1167.so",
		"/usr/lib64/gconv/IBM12712.so",
		"/usr/lib64/gconv/IBM1364.so",
		"/usr/lib64/gconv/IBM1371.so",
		"/usr/lib64/gconv/IBM1388.so",
		"/usr/lib64/gconv/IBM1390.so",
		"/usr/lib64/gconv/IBM1399.so",
		"/usr/lib64/gconv/IBM16804.so",
		"/usr/lib64/gconv/IBM256.so",
		"/usr/lib64/gconv/IBM273.so",
		"/usr/lib64/gconv/IBM274.so",
		"/usr/lib64/gconv/IBM275.so",
		"/usr/lib64/gconv/IBM277.so",
		"/usr/lib64/gconv/IBM278.so",
		"/usr/lib64/gconv/IBM280.so",
		"/usr/lib64/gconv/IBM281.so",
		"/usr/lib64/gconv/IBM284.so",
		"/usr/lib64/gconv/IBM285.so",
		"/usr/lib64/gconv/IBM290.so",
		"/usr/lib64/gconv/IBM297.so",
		"/usr/lib64/gconv/IBM420.so",
		"/usr/lib64/gconv/IBM423.so",
		"/usr/lib64/gconv/IBM424.so",
		"/usr/lib64/gconv/IBM437.so",
		"/usr/lib64/gconv/IBM4517.so",
		"/usr/lib64/gconv/IBM4899.so",
		"/usr/lib64/gconv/IBM4909.so",
		"/usr/lib64/gconv/IBM4971.so",
		"/usr/lib64/gconv/IBM500.so",
		"/usr/lib64/gconv/IBM5347.so",
		"/usr/lib64/gconv/IBM803.so",
		"/usr/lib64/gconv/IBM850.so",
		"/usr/lib64/gconv/IBM851.so",
		"/usr/lib64/gconv/IBM852.so",
		"/usr/lib64/gconv/IBM855.so",
		"/usr/lib64/gconv/IBM856.so",
		"/usr/lib64/gconv/IBM857.so",
		"/usr/lib64/gconv/IBM860.so",
		"/usr/lib64/gconv/IBM861.so",
		"/usr/lib64/gconv/IBM862.so",
		"/usr/lib64/gconv/IBM863.so",
		"/usr/lib64/gconv/IBM864.so",
		"/usr/lib64/gconv/IBM865.so",
		"/usr/lib64/gconv/IBM866.so",
		"/usr/lib64/gconv/IBM866NAV.so",
		"/usr/lib64/gconv/IBM868.so",
		"/usr/lib64/gconv/IBM869.so",
		"/usr/lib64/gconv/IBM870.so",
		"/usr/lib64/gconv/IBM871.so",
		"/usr/lib64/gconv/IBM874.so",
		"/usr/lib64/gconv/IBM875.so",
		"/usr/lib64/gconv/IBM880.so",
		"/usr/lib64/gconv/IBM891.so",
		"/usr/lib64/gconv/IBM901.so",
		"/usr/lib64/gconv/IBM902.so",
		"/usr/lib64/gconv/IBM903.so",
		"/usr/lib64/gconv/IBM9030.so",
		"/usr/lib64/gconv/IBM904.so",
		"/usr/lib64/gconv/IBM905.so",
		"/usr/lib64/gconv/IBM9066.so",
		"/usr/lib64/gconv/IBM918.so",
		"/usr/lib64/gconv/IBM921.so",
		"/usr/lib64/gconv/IBM922.so",
		"/usr/lib64/gconv/IBM930.so",
		"/usr/lib64/gconv/IBM932.so",
		"/usr/lib64/gconv/IBM933.so",
		"/usr/lib64/gconv/IBM935.so",
		"/usr/lib64/gconv/IBM937.so",
		"/usr/lib64/gconv/IBM939.so",
		"/usr/lib64/gconv/IBM943.so",
		"/usr/lib64/gconv/IBM9448.so",
		"/usr/lib64/gconv/IEC_P27-1.so",
		"/usr/lib64/gconv/INIS-8.so",
		"/usr/lib64/gconv/INIS-CYRILLIC.so",
		"/usr/lib64/gconv/INIS.so",
		"/usr/lib64/gconv/ISIRI-3342.so",
		"/usr/lib64/gconv/ISO-2022-CN-EXT.so",
		"/usr/lib64/gconv/ISO-2022-CN.so",
		"/usr/lib64/gconv/ISO-2022-JP-3.so",
		"/usr/lib64/gconv/ISO-2022-JP.so",
		"/usr/lib64/gconv/ISO-2022-KR.so",
		"/usr/lib64/gconv/ISO-IR-197.so",
		"/usr/lib64/gconv/ISO-IR-209.so",
		"/usr/lib64/gconv/ISO646.so",
		"/usr/lib64/gconv/ISO8859-1.so",
		"/usr/lib64/gconv/ISO8859-10.so",
		"/usr/lib64/gconv/ISO8859-11.so",
		"/usr/lib64/gconv/ISO8859-13.so",
		"/usr/lib64/gconv/ISO8859-14.so",
		"/usr/lib64/gconv/ISO8859-15.so",
		"/usr/lib64/gconv/ISO8859-16.so",
		"/usr/lib64/gconv/ISO8859-2.so",
		"/usr/lib64/gconv/ISO8859-3.so",
		"/usr/lib64/gconv/ISO8859-4.so",
		"/usr/lib64/gconv/ISO8859-5.so",
		"/usr/lib64/gconv/ISO8859-6.so",
		"/usr/lib64/gconv/ISO8859-7.so",
		"/usr/lib64/gconv/ISO8859-8.so",
		"/usr/lib64/gconv/ISO8859-9.so",
		"/usr/lib64/gconv/ISO8859-9E.so",
		"/usr/lib64/gconv/ISO_10367-BOX.so",
		"/usr/lib64/gconv/ISO_11548-1.so",
		"/usr/lib64/gconv/ISO_2033.so",
		"/usr/lib64/gconv/ISO_5427-EXT.so",
		"/usr/lib64/gconv/ISO_5427.so",
		"/usr/lib64/gconv/ISO_5428.so",
		"/usr/lib64/gconv/ISO_6937-2.so",
		"/usr/lib64/gconv/ISO_6937.so",
		"/usr/lib64/gconv/JOHAB.so",
		"/usr/lib64/gconv/KOI-8.so",
		"/usr/lib64/gconv/KOI8-R.so",
		"/usr/lib64/gconv/KOI8-RU.so",
		"/usr/lib64/gconv/KOI8-T.so",
		"/usr/lib64/gconv/KOI8-U.so",
		"/usr/lib64/gconv/LATIN-GREEK-1.so",
		"/usr/lib64/gconv/LATIN-GREEK.so",
		"/usr/lib64/gconv/MAC-CENTRALEUROPE.so",
		"/usr/lib64/gconv/MAC-IS.so",
		"/usr/lib64/gconv/MAC-SAMI.so",
		"/usr/lib64/gconv/MAC-UK.so",
		"/usr/lib64/gconv/MACINTOSH.so",
		"/usr/lib64/gconv/MIK.so",
		"/usr/lib64/gconv/NATS-DANO.so",
		"/usr/lib64/gconv/NATS-SEFI.so",
		"/usr/lib64/gconv/PT154.so",
		"/usr/lib64/gconv/RK1048.so",
		"/usr/lib64/gconv/SAMI-WS2.so",
		"/usr/lib64/gconv/SHIFT_JISX0213.so",
		"/usr/lib64/gconv/SJIS.so",
		"/usr/lib64/gconv/T.61.so",
		"/usr/lib64/gconv/TCVN5712-1.so",
		"/usr/lib64/gconv/TIS-620.so",
		"/usr/lib64/gconv/TSCII.so",
		"/usr/lib64/gconv/UHC.so",
		"/usr/lib64/gconv/UNICODE.so",
		"/usr/lib64/gconv/UTF-16.so",
		"/usr/lib64/gconv/UTF-32.so",
		"/usr/lib64/gconv/UTF-7.so",
		"/usr/lib64/gconv/VISCII.so",
		"/usr/lib64/gconv/gconv-modules",
		"/usr/lib64/gconv/gconv-modules.cache",
		"/usr/lib64/gconv/libCNS.so",
		"/usr/lib64/gconv/libGB.so",
		"/usr/lib64/gconv/libISOIR165.so",
		"/usr/lib64/gconv/libJIS.so",
		"/usr/lib64/gconv/libJISX0213.so",
		"/usr/lib64/gconv/libKSC.so",
		"/usr/lib64/libmemusage.so",
		"/usr/lib64/libpcprofile.so",
		"/usr/libexec/getconf",
		"/usr/libexec/getconf/POSIX_V6_LP64_OFF64",
		"/usr/libexec/getconf/POSIX_V7_LP64_OFF64",
		"/usr/sbin/glibc_post_upgrade.x86_64",
		"/usr/sbin/iconvconfig",
		"/usr/sbin/iconvconfig.x86_64",
		"/usr/share/doc/glibc-2.12",
		"/usr/share/doc/glibc-2.12/BUGS",
		"/usr/share/doc/glibc-2.12/CONFORMANCE",
		"/usr/share/doc/glibc-2.12/COPYING",
		"/usr/share/doc/glibc-2.12/COPYING.LIB",
		"/usr/share/doc/glibc-2.12/FAQ",
		"/usr/share/doc/glibc-2.12/INSTALL",
		"/usr/share/doc/glibc-2.12/LICENSES",
		"/usr/share/doc/glibc-2.12/NEWS",
		"/usr/share/doc/glibc-2.12/NOTES",
		"/usr/share/doc/glibc-2.12/PROJECTS",
		"/usr/share/doc/glibc-2.12/README",
		"/usr/share/doc/glibc-2.12/README.hesiod",
		"/usr/share/doc/glibc-2.12/README.libm",
		"/var/cache/ldconfig",
		"/var/cache/ldconfig/aux-cache",
	}

	CentOS8NodejsInstalledFiles = []string{
		"/usr/bin/node",
		"/usr/lib/.build-id",
		"/usr/lib/.build-id/4c",
		"/usr/lib/.build-id/4c/1f16ab7e1bbbf8f56dfbf1a098b6e6a6a9bbe4",
		"/usr/lib/node_modules",
		"/usr/lib/rpm/fileattrs/nodejs_native.attr",
		"/usr/lib/rpm/nodejs_native.req",
		"/usr/share/doc/nodejs",
		"/usr/share/doc/nodejs/AUTHORS",
		"/usr/share/doc/nodejs/CHANGELOG.md",
		"/usr/share/doc/nodejs/COLLABORATOR_GUIDE.md",
		"/usr/share/doc/nodejs/GOVERNANCE.md",
		"/usr/share/doc/nodejs/README.md",
		"/usr/share/licenses/nodejs",
		"/usr/share/licenses/nodejs/LICENSE",
		"/usr/share/man/man1/node.1.gz",
		"/usr/share/node",
		"/usr/share/systemtap",
		"/usr/share/systemtap/tapset",
		"/usr/share/systemtap/tapset/node.stp",
	}
)
