//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmaintenance.ClientFactory type.
type ServerFactory struct {
	ApplyUpdateForResourceGroupServer                ApplyUpdateForResourceGroupServer
	ApplyUpdatesServer                               ApplyUpdatesServer
	ConfigurationAssignmentsServer                   ConfigurationAssignmentsServer
	ConfigurationAssignmentsForResourceGroupServer   ConfigurationAssignmentsForResourceGroupServer
	ConfigurationAssignmentsForSubscriptionsServer   ConfigurationAssignmentsForSubscriptionsServer
	ConfigurationAssignmentsWithinSubscriptionServer ConfigurationAssignmentsWithinSubscriptionServer
	ConfigurationsServer                             ConfigurationsServer
	ConfigurationsForResourceGroupServer             ConfigurationsForResourceGroupServer
	OperationsServer                                 OperationsServer
	PublicMaintenanceConfigurationsServer            PublicMaintenanceConfigurationsServer
	UpdatesServer                                    UpdatesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmaintenance.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmaintenance.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                *ServerFactory
	trMu                                               sync.Mutex
	trApplyUpdateForResourceGroupServer                *ApplyUpdateForResourceGroupServerTransport
	trApplyUpdatesServer                               *ApplyUpdatesServerTransport
	trConfigurationAssignmentsServer                   *ConfigurationAssignmentsServerTransport
	trConfigurationAssignmentsForResourceGroupServer   *ConfigurationAssignmentsForResourceGroupServerTransport
	trConfigurationAssignmentsForSubscriptionsServer   *ConfigurationAssignmentsForSubscriptionsServerTransport
	trConfigurationAssignmentsWithinSubscriptionServer *ConfigurationAssignmentsWithinSubscriptionServerTransport
	trConfigurationsServer                             *ConfigurationsServerTransport
	trConfigurationsForResourceGroupServer             *ConfigurationsForResourceGroupServerTransport
	trOperationsServer                                 *OperationsServerTransport
	trPublicMaintenanceConfigurationsServer            *PublicMaintenanceConfigurationsServerTransport
	trUpdatesServer                                    *UpdatesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ApplyUpdateForResourceGroupClient":
		initServer(s, &s.trApplyUpdateForResourceGroupServer, func() *ApplyUpdateForResourceGroupServerTransport {
			return NewApplyUpdateForResourceGroupServerTransport(&s.srv.ApplyUpdateForResourceGroupServer)
		})
		resp, err = s.trApplyUpdateForResourceGroupServer.Do(req)
	case "ApplyUpdatesClient":
		initServer(s, &s.trApplyUpdatesServer, func() *ApplyUpdatesServerTransport { return NewApplyUpdatesServerTransport(&s.srv.ApplyUpdatesServer) })
		resp, err = s.trApplyUpdatesServer.Do(req)
	case "ConfigurationAssignmentsClient":
		initServer(s, &s.trConfigurationAssignmentsServer, func() *ConfigurationAssignmentsServerTransport {
			return NewConfigurationAssignmentsServerTransport(&s.srv.ConfigurationAssignmentsServer)
		})
		resp, err = s.trConfigurationAssignmentsServer.Do(req)
	case "ConfigurationAssignmentsForResourceGroupClient":
		initServer(s, &s.trConfigurationAssignmentsForResourceGroupServer, func() *ConfigurationAssignmentsForResourceGroupServerTransport {
			return NewConfigurationAssignmentsForResourceGroupServerTransport(&s.srv.ConfigurationAssignmentsForResourceGroupServer)
		})
		resp, err = s.trConfigurationAssignmentsForResourceGroupServer.Do(req)
	case "ConfigurationAssignmentsForSubscriptionsClient":
		initServer(s, &s.trConfigurationAssignmentsForSubscriptionsServer, func() *ConfigurationAssignmentsForSubscriptionsServerTransport {
			return NewConfigurationAssignmentsForSubscriptionsServerTransport(&s.srv.ConfigurationAssignmentsForSubscriptionsServer)
		})
		resp, err = s.trConfigurationAssignmentsForSubscriptionsServer.Do(req)
	case "ConfigurationAssignmentsWithinSubscriptionClient":
		initServer(s, &s.trConfigurationAssignmentsWithinSubscriptionServer, func() *ConfigurationAssignmentsWithinSubscriptionServerTransport {
			return NewConfigurationAssignmentsWithinSubscriptionServerTransport(&s.srv.ConfigurationAssignmentsWithinSubscriptionServer)
		})
		resp, err = s.trConfigurationAssignmentsWithinSubscriptionServer.Do(req)
	case "ConfigurationsClient":
		initServer(s, &s.trConfigurationsServer, func() *ConfigurationsServerTransport {
			return NewConfigurationsServerTransport(&s.srv.ConfigurationsServer)
		})
		resp, err = s.trConfigurationsServer.Do(req)
	case "ConfigurationsForResourceGroupClient":
		initServer(s, &s.trConfigurationsForResourceGroupServer, func() *ConfigurationsForResourceGroupServerTransport {
			return NewConfigurationsForResourceGroupServerTransport(&s.srv.ConfigurationsForResourceGroupServer)
		})
		resp, err = s.trConfigurationsForResourceGroupServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PublicMaintenanceConfigurationsClient":
		initServer(s, &s.trPublicMaintenanceConfigurationsServer, func() *PublicMaintenanceConfigurationsServerTransport {
			return NewPublicMaintenanceConfigurationsServerTransport(&s.srv.PublicMaintenanceConfigurationsServer)
		})
		resp, err = s.trPublicMaintenanceConfigurationsServer.Do(req)
	case "UpdatesClient":
		initServer(s, &s.trUpdatesServer, func() *UpdatesServerTransport { return NewUpdatesServerTransport(&s.srv.UpdatesServer) })
		resp, err = s.trUpdatesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
