/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2013 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/errno.h>
#include <libexplain/ac/grp.h>
#include <libexplain/ac/sys/types.h>

#include <libexplain/buffer/errno/getgrouplist.h>
#include <libexplain/common_message_buffer.h>
#include <libexplain/getgrouplist.h>


const char *
explain_getgrouplist(const char *user, gid_t group, gid_t *groups, int *ngroups)
{
    return explain_errno_getgrouplist(errno, user, group, groups, ngroups);
}


const char *
explain_errno_getgrouplist(int errnum, const char *user, gid_t group, gid_t
    *groups, int *ngroups)
{
    explain_message_errno_getgrouplist(explain_common_message_buffer,
        explain_common_message_buffer_size, errnum, user, group, groups,
        ngroups);
    return explain_common_message_buffer;
}


void
explain_message_getgrouplist(char *message, int message_size, const char *user,
    gid_t group, gid_t *groups, int *ngroups)
{
    explain_message_errno_getgrouplist(message, message_size, errno, user,
        group, groups, ngroups);
}


void
explain_message_errno_getgrouplist(char *message, int message_size, int errnum,
    const char *user, gid_t group, gid_t *groups, int *ngroups)
{
    explain_string_buffer_t sb;

    explain_string_buffer_init(&sb, message, message_size);
    explain_buffer_errno_getgrouplist(&sb, errnum, user, group, groups,
        ngroups);
}


/* vim: set ts=8 sw=4 et : */
