/*
 *  Copyright (C) 2018. Daniel H. Huson
 *
 *  (Some files contain contributions from other authors, who are then mentioned separately.)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *  TestSeater.java Copyright (C) 2020 Daniel H. Huson
 *
 *  (Some files contain contributions from other authors, who are then mentioned separately.)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package jloda.progs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class TestSeater {
    public static void main (String[] args) throws IOException {
        final BufferedReader inputReader=new BufferedReader(new InputStreamReader(System.in));

        System.out.print("Enter array length: ");
        String line=inputReader.readLine();
        final boolean[] array=new boolean[Integer.parseInt(line)];

        System.out.println("Enter ?number or +number to query or add number of seats, respectively, s to show array and q to quit");

        while((line=inputReader.readLine())!=null) {
            try {
                if (line.startsWith("?")) {
                    final int requestedSeats = Integer.parseInt(line.substring(1).trim());
                    if (requestedSeats > 0) {
                        boolean found=false;
                        for (int pos = 0; !found && pos < array.length; pos++) {
                            if (canSeat(array, pos, requestedSeats)) {
                                System.out.println("yes");
                                //System.out.println("can seat: " + pos + " - " + (pos + requestedSeats - 1));
                               found=true;
                            }
                        }
                        if(!found)
                            System.out.println("no");
                    }
                } else if (line.startsWith("+")) {
                    final int requestedSeats = Integer.parseInt(line.substring(1).trim());
                    if (requestedSeats > 0) {
                        boolean found=false;
                        for (int pos = 0; !found && pos < array.length; pos++) {
                            if (canSeat(array, pos, requestedSeats)) {
                                System.out.println("assigned");
                                //System.out.println("Added: " + pos + " - " + (pos + requestedSeats - 1));
                                for (int i = pos; i < pos + requestedSeats; i++)
                                    array[i] = true;
                               found=true;
                            }
                        }
                        if(!found)
                            System.out.println("failed");
                    }
                } else if (line.equals("s")) {
                    System.out.print("array: ");
                    int count = 0;
                    for (boolean b : array) {
                        if (b) {
                            System.out.print('O');
                            count++;
                        } else
                            System.out.print('.');
                    }
                    System.out.println();
                    //System.out.println("Count: " + count);
                } else if (line.equals("q"))
                    break;
                else
                    throw new IOException("Unknown command: "+line);
            }
            catch(Exception ex) {
                System.out.println("Error: "+ex.getMessage());
            }
        }
    }

    public static boolean canSeat (boolean[] array,int pos,int requestedSeats) {
        return true;
    }
}
