# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_reader import XMLReader


class PhyloXMLTreeReader(XMLReader):
    r"""
    PhyloXMLTreeReader - read Tree from phylo_xml formatted file
    
    Superclass: XMLReader
    
    PhyloXMLTreeReader is a source object that reads phylo_xml tree
    format files. The output of this reader is a single Tree data
    object.
    
    @warning
    This reader does not implement the entire phylo_xml specification. It
    currently only supports the following tags: phylogeny, name,
    description, confidence, property, clade, branch_length, color, red,
    green, and blue. This reader also only supports a single phylogeny
    per file.
    
    @sa
    Tree XMLReader PhyloXMLTreeWriter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPhyloXMLTreeReader, obj, update, **traits)
    
    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    output = traits.Property(_get_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self, idx=None):
        """
        get_output(self) -> Tree
        C++: Tree *get_output()
        get_output(self, idx:int) -> Tree
        C++: Tree *get_output(int idx)
        Get the output of this reader.
        """
        if idx is None:
            return wrap_vtk(self._vtk_obj.GetOutput())
        else:
            return wrap_vtk(self._vtk_obj.GetOutput(idx))

    _updateable_traits_ = \
    (('read_from_input_string', 'GetReadFromInputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('active_time_data_array_name', 'GetActiveTimeDataArrayName'),
    ('file_name', 'GetFileName'), ('time_step', 'GetTimeStep'),
    ('time_step_range', 'GetTimeStepRange'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'read_from_input_string', 'release_data_flag',
    'active_time_data_array_name', 'file_name', 'progress_text',
    'time_step', 'time_step_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PhyloXMLTreeReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PhyloXMLTreeReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['read_from_input_string'], [], ['active_time_data_array_name',
            'file_name', 'time_step', 'time_step_range']),
            title='Edit PhyloXMLTreeReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PhyloXMLTreeReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

