/*
 * DirectDraw driver interface
 * (DirectX 7 version)
 *
 * Copyright (C) 2001 Ove Kaaven
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __DDRAWI_INCLUDED__
#define __DDRAWI_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif

#define OBJECT_ISROOT           0x80000000

#include <ddraw.h>
#include <dvp.h>
#include <ddkernel.h>
#include <dmemmgr.h>

#define DDAPI WINAPI

#define VALID_ALIGNMENT(align) \
	   (!((align==0)||(align%2)!= 0 ))

/* the DirectDraw versions */
#define DD_VERSION		0x0200 /* compatibility version */
#define DD_RUNTIME_VERSION	0x0902 /* actual version */

/* the HAL version returned from QUERYESCSUPPORT - DCICOMMAND */
#define DD_HAL_VERSION	0x0100

/* more DCICOMMAND escapes */
#ifndef DCICOMMAND
#define DCICOMMAND 3075
#endif

#define DDCREATEDRIVEROBJECT	10
#define DDGET32BITDRIVERNAME	11
#define DDNEWCALLBACKFNS	12
#define DDVERSIONINFO		13


#define DDUNSUPPORTEDMODE  ((DWORD) -1)

#include "dciddi.h"

#ifndef CCHDEVICENAME
#define CCHDEVICENAME 32
#endif
#define MAX_DRIVER_NAME		CCHDEVICENAME

#define DDHAL_DRIVER_DLLNAME    "DDRAW16.DLL"
#define DDHAL_APP_DLLNAME   "DDRAW.DLL"


/* GUID */
#ifdef _WIN32
DEFINE_GUID(GUID_MiscellaneousCallbacks, 0xefd60cc0, 0x49e7, 0x11d0, 0x88, 0x9d, 0x00, 0xaa, 0x00, 0xbb, 0xb7, 0x6a);
DEFINE_GUID(GUID_VideoPortCallbacks,     0xefd60cc1, 0x49e7, 0x11d0, 0x88, 0x9d, 0x00, 0xaa, 0x00, 0xbb, 0xb7, 0x6a);
DEFINE_GUID(GUID_ColorControlCallbacks,  0xefd60cc2, 0x49e7, 0x11d0, 0x88, 0x9d, 0x00, 0xaa, 0x00, 0xbb, 0xb7, 0x6a);
DEFINE_GUID(GUID_VideoPortCaps,          0xefd60cc3, 0x49e7, 0x11d0, 0x88, 0x9d, 0x00, 0xaa, 0x00, 0xbb, 0xb7, 0x6a);
DEFINE_GUID(GUID_D3DCallbacks2,          0x0ba584e1, 0x70b6, 0x11d0, 0x88, 0x9d, 0x00, 0xaa, 0x00, 0xbb, 0xb7, 0x6a);
DEFINE_GUID(GUID_D3DCallbacks3,          0xddf41230, 0xec0a, 0x11d0, 0xa9, 0xb6, 0x00, 0xaa, 0x00, 0xc0, 0x99, 0x3e);
DEFINE_GUID(GUID_NonLocalVidMemCaps,     0x86c4fa80, 0x8d84, 0x11d0, 0x94, 0xe8, 0x00, 0xc0, 0x4f, 0xc3, 0x41, 0x37);
DEFINE_GUID(GUID_KernelCallbacks,        0x80863800, 0x6B06, 0x11D0, 0x9B, 0x06, 0x0, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(GUID_KernelCaps,             0xFFAA7540, 0x7AA8, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(GUID_D3DExtendedCaps,        0x7de41f80, 0x9d93, 0x11d0, 0x89, 0xab, 0x0, 0xa0, 0xc9, 0x5, 0x41, 0x29);
DEFINE_GUID(GUID_ZPixelFormats,          0x93869880, 0x36cf, 0x11d1, 0x9b, 0x1b, 0x0, 0xaa, 0x0, 0xbb, 0xb8, 0xae);
DEFINE_GUID(GUID_DDMoreSurfaceCaps,      0x3b8a0466, 0xf269, 0x11d1, 0x88, 0x0b, 0x0, 0xc0, 0x4f, 0xd9, 0x30, 0xc5);
DEFINE_GUID(GUID_DDStereoMode,           0xf828169c, 0xa8e8, 0x11d2, 0xa1, 0xf2, 0x0, 0xa0, 0xc9, 0x83, 0xea, 0xf6);
DEFINE_GUID(GUID_OptSurfaceKmodeInfo,    0xe05c8472, 0x51d4, 0x11d1, 0x8c, 0xce, 0x0, 0xa0, 0xc9, 0x6, 0x29, 0xa8);
DEFINE_GUID(GUID_OptSurfaceUmodeInfo,    0x9d792804, 0x5fa8, 0x11d1, 0x8c, 0xd0, 0x0, 0xa0, 0xc9, 0x6, 0x29, 0xa8);
DEFINE_GUID(GUID_UserModeDriverInfo,     0xf0b0e8e2, 0x5f97, 0x11d1, 0x8c, 0xd0, 0x0, 0xa0, 0xc9, 0x6, 0x29, 0xa8);
DEFINE_GUID(GUID_UserModeDriverPassword, 0x97f861b6, 0x60a1, 0x11d1, 0x8c, 0xd0, 0x0, 0xa0, 0xc9, 0x6, 0x29, 0xa8);
DEFINE_GUID(GUID_D3DParseUnknownCommandCallback,  0x2e04ffa0, 0x98e4, 0x11d1, 0x8c, 0xe1, 0x0, 0xa0, 0xc9, 0x6, 0x29, 0xa8);
DEFINE_GUID(GUID_MotionCompCallbacks,           0xb1122b40, 0x5dA5, 0x11d1, 0x8f, 0xcF, 0x00, 0xc0, 0x4f, 0xc2, 0x9b, 0x4e);
DEFINE_GUID(GUID_Miscellaneous2Callbacks,   0x406B2F00, 0x3E5A, 0x11D1, 0xB6, 0x40, 0x00, 0xAA, 0x00, 0xA1, 0xF9, 0x6A);
#endif

#ifndef _WIN32
#undef  E_NOTIMPL
#undef  E_OUTOFMEMORY
#undef  E_INVALIDARG
#undef  E_FAIL
#define E_NOTIMPL      0x80004001L
#define E_OUTOFMEMORY  0x8007000EL
#define E_INVALIDARG   0x80070057L
#define E_FAIL         0x80004005L
#endif


/*****************************************************************************
 * Initialization stuff
 */
typedef struct {
    char szName[260];
    char szEntryPoint[64];
    DWORD dwContext;
} DD32BITDRIVERDATA,*LPDD32BITDRIVERDATA;

typedef struct {
    DWORD dwHALVersion;
    ULONG_PTR dwReserved1;
    ULONG_PTR dwReserved2;
} DDVERSIONDATA,*LPDDVERSIONDATA;

typedef DWORD (PASCAL *LPDD32BITDRIVERINIT)(DWORD dwContext);



/* predeclare some structures */
typedef struct _DDHALINFO *LPDDHALINFO;
typedef struct _DDRAWI_DIRECTDRAW_INT *LPDDRAWI_DIRECTDRAW_INT;

#ifndef DDRAWI_DIRECTDRAW_DEFINED
typedef struct _DDRAWI_DIRECTDRAW_LCL *LPDDRAWI_DIRECTDRAW_LCL;
typedef struct _DDRAWI_DIRECTDRAW_GBL *LPDDRAWI_DIRECTDRAW_GBL;
#define DDRAWI_DIRECTDRAW_DEFINED
#endif

typedef struct _DDRAWI_DDRAWSURFACE_INT *LPDDRAWI_DDRAWSURFACE_INT;

#ifndef DDRAWI_DDRAWSURFACE_DEFINED
typedef struct _DDRAWI_DDRAWSURFACE_LCL *LPDDRAWI_DDRAWSURFACE_LCL;
#define DDRAWI_DDRAWSURFACE_DEFINED
#endif

typedef struct _DDRAWI_DDRAWSURFACE_GBL *LPDDRAWI_DDRAWSURFACE_GBL;
typedef struct _DDRAWI_DDRAWSURFACE_MORE *LPDDRAWI_DDRAWSURFACE_MORE;
typedef struct _DDRAWI_DDRAWSURFACE_GBL_MORE *LPDDRAWI_DDRAWSURFACE_GBL_MORE;
typedef struct _DDRAWI_DDRAWPALETTE_INT *LPDDRAWI_DDRAWPALETTE_INT;
typedef struct _DDRAWI_DDRAWPALETTE_LCL *LPDDRAWI_DDRAWPALETTE_LCL;
typedef struct _DDRAWI_DDRAWPALETTE_GBL *LPDDRAWI_DDRAWPALETTE_GBL;
typedef struct _DDRAWI_DDRAWCLIPPER_INT *LPDDRAWI_DDRAWCLIPPER_INT;
typedef struct _DDRAWI_DDRAWCLIPPER_LCL *LPDDRAWI_DDRAWCLIPPER_LCL;
typedef struct _DDRAWI_DDRAWCLIPPER_GBL *LPDDRAWI_DDRAWCLIPPER_GBL;
typedef struct _DDRAWI_DDVIDEOPORT_INT *LPDDRAWI_DDVIDEOPORT_INT;
typedef struct _DDRAWI_DDVIDEOPORT_LCL *LPDDRAWI_DDVIDEOPORT_LCL;
typedef struct _DDRAWI_DDMOTIONCOMP_INT *LPDDRAWI_DDMOTIONCOMP_INT;
typedef struct _DDRAWI_DDMOTIONCOMP_LCL *LPDDRAWI_DDMOTIONCOMP_LCL;

/*****************************************************************************
 * driver->ddraw callbacks
 */
typedef WINBOOL (DDAPI *LPDDHAL_SETINFO)(LPDDHALINFO lpDDHalInfo, WINBOOL reset);
typedef FLATPTR (DDAPI *LPDDHAL_VIDMEMALLOC)(LPDDRAWI_DIRECTDRAW_GBL lpDD, int heap, DWORD dwWidth, DWORD dwHeight);
typedef void    (DDAPI *LPDDHAL_VIDMEMFREE)(LPDDRAWI_DIRECTDRAW_GBL lpDD, int heap, FLATPTR fpMem);

typedef struct {
    DWORD		dwSize;
    LPDDHAL_SETINFO	lpSetInfo;
    LPDDHAL_VIDMEMALLOC	lpVidMemAlloc;
    LPDDHAL_VIDMEMFREE	lpVidMemFree;
} DDHALDDRAWFNS,*LPDDHALDDRAWFNS;

/*****************************************************************************
 * mode info structure
 */
typedef struct _DDHALMODEINFO {
    DWORD	dwWidth;
    DWORD	dwHeight;
    LONG	lPitch;
    DWORD	dwBPP;
    WORD	wFlags;
    WORD	wRefreshRate;
    DWORD	dwRBitMask;
    DWORD	dwGBitMask;
    DWORD	dwBBitMask;
    DWORD	dwAlphaBitMask;
} DDHALMODEINFO,*LPDDHALMODEINFO;


#define DDMODEINFO_PALETTIZED	0x0001
#define DDMODEINFO_MODEX	0x0002
#define DDMODEINFO_UNSUPPORTED	0x0004
#define DDMODEINFO_STANDARDVGA	0x0008
#define DDMODEINFO_MAXREFRESH	0x0010
#define DDMODEINFO_STEREO	0x0020

/*****************************************************************************
 * video memory info structure
 */
typedef struct _VIDMEM {
    DWORD	dwFlags;
    FLATPTR	fpStart;
    __GNU_EXTENSION union {
	FLATPTR		fpEnd;
	DWORD		dwWidth;
    };
    DDSCAPS	ddsCaps;
    DDSCAPS	ddsCapsAlt;
    __GNU_EXTENSION union {
	LPVMEMHEAP	lpHeap;
	DWORD		dwHeight;
    };
} VIDMEM;


#define VIDMEM_ISLINEAR			0x00000001l
#define VIDMEM_ISRECTANGULAR		0x00000002l
#define VIDMEM_ISHEAP			0x00000004l
#define VIDMEM_ISNONLOCAL		0x00000008l
#define VIDMEM_ISWC			0x00000010l
#define VIDMEM_HEAPDISABLED		0x00000020l

typedef struct _VIDMEMINFO {
    FLATPTR		fpPrimary;
    DWORD		dwFlags;
    DWORD		dwDisplayWidth;
    DWORD		dwDisplayHeight;
    LONG		lDisplayPitch;
    DDPIXELFORMAT	ddpfDisplay;
    DWORD		dwOffscreenAlign;
    DWORD		dwOverlayAlign;
    DWORD		dwTextureAlign;
    DWORD		dwZBufferAlign;
    DWORD		dwAlphaAlign;
    DWORD		dwNumHeaps;
    LPVIDMEM		pvmList;
} VIDMEMINFO,*LPVIDMEMINFO;


typedef struct _HEAPALIAS {
    FLATPTR	fpVidMem;
    LPVOID	lpAlias;
    DWORD	dwAliasSize;
} HEAPALIAS,*LPHEAPALIAS;

typedef struct _HEAPALIASINFO {
    DWORD	dwRefCnt;
    DWORD	dwFlags;
    DWORD	dwNumHeaps;
    LPHEAPALIAS	lpAliases;
} HEAPALIASINFO,*LPHEAPALIASINFO;

#define HEAPALIASINFO_MAPPEDREAL	0x00000001
#define HEAPALIASINFO_MAPPEDDUMMY	0x00000002

/*****************************************************************************
 * capabilities structures
 */
typedef struct _DDCORECAPS {
    DWORD	dwSize;
    DWORD	dwCaps;
    DWORD	dwCaps2;
    DWORD	dwCKeyCaps;
    DWORD	dwFXCaps;
    DWORD	dwFXAlphaCaps;
    DWORD	dwPalCaps;
    DWORD	dwSVCaps;
    DWORD	dwAlphaBltConstBitDepths;
    DWORD	dwAlphaBltPixelBitDepths;
    DWORD	dwAlphaBltSurfaceBitDepths;
    DWORD	dwAlphaOverlayConstBitDepths;
    DWORD	dwAlphaOverlayPixelBitDepths;
    DWORD	dwAlphaOverlaySurfaceBitDepths;
    DWORD	dwZBufferBitDepths;
    DWORD	dwVidMemTotal;
    DWORD	dwVidMemFree;
    DWORD	dwMaxVisibleOverlays;
    DWORD	dwCurrVisibleOverlays;
    DWORD	dwNumFourCCCodes;
    DWORD	dwAlignBoundarySrc;
    DWORD	dwAlignSizeSrc;
    DWORD	dwAlignBoundaryDest;
    DWORD	dwAlignSizeDest;
    DWORD	dwAlignStrideAlign;
    DWORD	dwRops[DD_ROP_SPACE];
    DDSCAPS	ddsCaps;
    DWORD	dwMinOverlayStretch;
    DWORD	dwMaxOverlayStretch;
    DWORD	dwMinLiveVideoStretch;
    DWORD	dwMaxLiveVideoStretch;
    DWORD	dwMinHwCodecStretch;
    DWORD	dwMaxHwCodecStretch;
    DWORD	dwReserved1;
    DWORD	dwReserved2;
    DWORD	dwReserved3;
    DWORD	dwSVBCaps;
    DWORD	dwSVBCKeyCaps;
    DWORD	dwSVBFXCaps;
    DWORD	dwSVBRops[DD_ROP_SPACE];
    DWORD	dwVSBCaps;
    DWORD	dwVSBCKeyCaps;
    DWORD	dwVSBFXCaps;
    DWORD	dwVSBRops[DD_ROP_SPACE];
    DWORD	dwSSBCaps;
    DWORD	dwSSBCKeyCaps;
    DWORD	dwSSBFXCaps;
    DWORD	dwSSBRops[DD_ROP_SPACE];
    DWORD	dwMaxVideoPorts;
    DWORD	dwCurrVideoPorts;
    DWORD	dwSVBCaps2;
} DDCORECAPS,*LPDDCORECAPS;

typedef struct _DDNONLOCALVIDMEMCAPS {
    DWORD	dwSize;
    DWORD	dwNLVBCaps;
    DWORD	dwNLVBCaps2;
    DWORD	dwNLVBCKeyCaps;
    DWORD	dwNLVBFXCaps;
    DWORD	dwNLVBRops[DD_ROP_SPACE];
} DDNONLOCALVIDMEMCAPS,*LPDDNONLOCALVIDMEMCAPS;


#define DDSCAPS_EXECUTEBUFFER		DDSCAPS_RESERVED2
#define DDSCAPS2_VERTEXBUFFER		DDSCAPS2_RESERVED1
#define DDSCAPS2_COMMANDBUFFER		DDSCAPS2_RESERVED2


/*****************************************************************************
 * ddraw->driver callbacks
 */
#define DDHAL_DRIVER_NOTHANDLED		0x00000000l
#define DDHAL_DRIVER_HANDLED		0x00000001l
#define DDHAL_DRIVER_NOCKEYHW		0x00000002l

typedef struct _DDHAL_DESTROYDRIVERDATA		*LPDDHAL_DESTROYDRIVERDATA;
typedef struct _DDHAL_CREATESURFACEDATA		*LPDDHAL_CREATESURFACEDATA;
typedef struct _DDHAL_DRVSETCOLORKEYDATA	*LPDDHAL_DRVSETCOLORKEYDATA;
typedef struct _DDHAL_SETMODEDATA		*LPDDHAL_SETMODEDATA;
typedef struct _DDHAL_WAITFORVERTICALBLANKDATA	*LPDDHAL_WAITFORVERTICALBLANKDATA;
typedef struct _DDHAL_CANCREATESURFACEDATA	*LPDDHAL_CANCREATESURFACEDATA;
typedef struct _DDHAL_CREATEPALETTEDATA		*LPDDHAL_CREATEPALETTEDATA;
typedef struct _DDHAL_GETSCANLINEDATA		*LPDDHAL_GETSCANLINEDATA;
typedef struct _DDHAL_SETEXCLUSIVEMODEDATA	*LPDDHAL_SETEXCLUSIVEMODEDATA;
typedef struct _DDHAL_FLIPTOGDISURFACEDATA	*LPDDHAL_FLIPTOGDISURFACEDATA;

typedef DWORD (PASCAL *LPDDHAL_DESTROYDRIVER)	    (LPDDHAL_DESTROYDRIVERDATA);
typedef DWORD (PASCAL *LPDDHAL_CREATESURFACE)	    (LPDDHAL_CREATESURFACEDATA);
typedef DWORD (PASCAL *LPDDHAL_SETCOLORKEY)	    (LPDDHAL_DRVSETCOLORKEYDATA);
typedef DWORD (PASCAL *LPDDHAL_SETMODE)		    (LPDDHAL_SETMODEDATA);
typedef DWORD (PASCAL *LPDDHAL_WAITFORVERTICALBLANK)(LPDDHAL_WAITFORVERTICALBLANKDATA);
typedef DWORD (PASCAL *LPDDHAL_CANCREATESURFACE)    (LPDDHAL_CANCREATESURFACEDATA );
typedef DWORD (PASCAL *LPDDHAL_CREATEPALETTE)	    (LPDDHAL_CREATEPALETTEDATA);
typedef DWORD (PASCAL *LPDDHAL_GETSCANLINE)	    (LPDDHAL_GETSCANLINEDATA);
typedef DWORD (PASCAL *LPDDHAL_SETEXCLUSIVEMODE)    (LPDDHAL_SETEXCLUSIVEMODEDATA);
typedef DWORD (PASCAL *LPDDHAL_FLIPTOGDISURFACE)    (LPDDHAL_FLIPTOGDISURFACEDATA);


typedef struct _DDHAL_DDCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHAL_DESTROYDRIVER		DestroyDriver;
    LPDDHAL_CREATESURFACE		CreateSurface;
    LPDDHAL_SETCOLORKEY			SetColorKey;
    LPDDHAL_SETMODE			SetMode;
    LPDDHAL_WAITFORVERTICALBLANK	WaitForVerticalBlank;
    LPDDHAL_CANCREATESURFACE		CanCreateSurface;
    LPDDHAL_CREATEPALETTE		CreatePalette;
    LPDDHAL_GETSCANLINE			GetScanLine;
    /* DirectX 2 */
    LPDDHAL_SETEXCLUSIVEMODE		SetExclusiveMode;
    LPDDHAL_FLIPTOGDISURFACE		FlipToGDISurface;
} DDHAL_DDCALLBACKS,*LPDDHAL_DDCALLBACKS;


typedef struct _DDHAL_DESTROYSURFACEDATA	*LPDDHAL_DESTROYSURFACEDATA;
typedef struct _DDHAL_FLIPDATA			*LPDDHAL_FLIPDATA;
typedef struct _DDHAL_SETCLIPLISTDATA		*LPDDHAL_SETCLIPLISTDATA;
typedef struct _DDHAL_LOCKDATA			*LPDDHAL_LOCKDATA;
typedef struct _DDHAL_UNLOCKDATA		*LPDDHAL_UNLOCKDATA;
typedef struct _DDHAL_BLTDATA			*LPDDHAL_BLTDATA;
typedef struct _DDHAL_SETCOLORKEYDATA		*LPDDHAL_SETCOLORKEYDATA;
typedef struct _DDHAL_ADDATTACHEDSURFACEDATA	*LPDDHAL_ADDATTACHEDSURFACEDATA;
typedef struct _DDHAL_GETBLTSTATUSDATA		*LPDDHAL_GETBLTSTATUSDATA;
typedef struct _DDHAL_GETFLIPSTATUSDATA		*LPDDHAL_GETFLIPSTATUSDATA;
typedef struct _DDHAL_UPDATEOVERLAYDATA		*LPDDHAL_UPDATEOVERLAYDATA;
typedef struct _DDHAL_SETOVERLAYPOSITIONDATA	*LPDDHAL_SETOVERLAYPOSITIONDATA;
typedef struct _DDHAL_SETPALETTEDATA		*LPDDHAL_SETPALETTEDATA;

typedef DWORD (PASCAL *LPDDHALSURFCB_DESTROYSURFACE)	(LPDDHAL_DESTROYSURFACEDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_FLIP)		(LPDDHAL_FLIPDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_SETCLIPLIST)	(LPDDHAL_SETCLIPLISTDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_LOCK)		(LPDDHAL_LOCKDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_UNLOCK)		(LPDDHAL_UNLOCKDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_BLT)		(LPDDHAL_BLTDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_SETCOLORKEY)	(LPDDHAL_SETCOLORKEYDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_ADDATTACHEDSURFACE)(LPDDHAL_ADDATTACHEDSURFACEDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_GETBLTSTATUS)	(LPDDHAL_GETBLTSTATUSDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_GETFLIPSTATUS)	(LPDDHAL_GETFLIPSTATUSDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_UPDATEOVERLAY)	(LPDDHAL_UPDATEOVERLAYDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_SETOVERLAYPOSITION)(LPDDHAL_SETOVERLAYPOSITIONDATA);
typedef DWORD (PASCAL *LPDDHALSURFCB_SETPALETTE)	(LPDDHAL_SETPALETTEDATA);

typedef struct _DDHAL_DDSURFACECALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALSURFCB_DESTROYSURFACE	DestroySurface;
    LPDDHALSURFCB_FLIP			Flip;
    LPDDHALSURFCB_SETCLIPLIST		SetClipList;
    LPDDHALSURFCB_LOCK			Lock;
    LPDDHALSURFCB_UNLOCK		Unlock;
    LPDDHALSURFCB_BLT			Blt;
    LPDDHALSURFCB_SETCOLORKEY		SetColorKey;
    LPDDHALSURFCB_ADDATTACHEDSURFACE	AddAttachedSurface;
    LPDDHALSURFCB_GETBLTSTATUS		GetBltStatus;
    LPDDHALSURFCB_GETFLIPSTATUS		GetFlipStatus;
    LPDDHALSURFCB_UPDATEOVERLAY		UpdateOverlay;
    LPDDHALSURFCB_SETOVERLAYPOSITION	SetOverlayPosition;
    LPVOID				reserved4;
    LPDDHALSURFCB_SETPALETTE		SetPalette;
} DDHAL_DDSURFACECALLBACKS,*LPDDHAL_DDSURFACECALLBACKS;



typedef struct _DDHAL_DESTROYPALETTEDATA	*LPDDHAL_DESTROYPALETTEDATA;
typedef struct _DDHAL_SETENTRIESDATA		*LPDDHAL_SETENTRIESDATA;

typedef DWORD (PASCAL *LPDDHALPALCB_DESTROYPALETTE)(LPDDHAL_DESTROYPALETTEDATA);
typedef DWORD (PASCAL *LPDDHALPALCB_SETENTRIES)    (LPDDHAL_SETENTRIESDATA);

typedef struct _DDHAL_DDPALETTECALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALPALCB_DESTROYPALETTE		DestroyPalette;
    LPDDHALPALCB_SETENTRIES		SetEntries;
} DDHAL_DDPALETTECALLBACKS,*LPDDHAL_DDPALETTECALLBACKS;

typedef DWORD (PASCAL *LPDDHALEXEBUFCB_CANCREATEEXEBUF)(LPDDHAL_CANCREATESURFACEDATA);
typedef DWORD (PASCAL *LPDDHALEXEBUFCB_CREATEEXEBUF)   (LPDDHAL_CREATESURFACEDATA);
typedef DWORD (PASCAL *LPDDHALEXEBUFCB_DESTROYEXEBUF)  (LPDDHAL_DESTROYSURFACEDATA);
typedef DWORD (PASCAL *LPDDHALEXEBUFCB_LOCKEXEBUF)     (LPDDHAL_LOCKDATA);
typedef DWORD (PASCAL *LPDDHALEXEBUFCB_UNLOCKEXEBUF)   (LPDDHAL_UNLOCKDATA);

typedef struct _DDHAL_DDEXEBUFCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALEXEBUFCB_CANCREATEEXEBUF	CanCreateExecuteBuffer;
    LPDDHALEXEBUFCB_CREATEEXEBUF	CreateExecuteBuffer;
    LPDDHALEXEBUFCB_DESTROYEXEBUF	DestroyExecuteBuffer;
    LPDDHALEXEBUFCB_LOCKEXEBUF		LockExecuteBuffer;
    LPDDHALEXEBUFCB_UNLOCKEXEBUF	UnlockExecuteBuffer;
} DDHAL_DDEXEBUFCALLBACKS,*LPDDHAL_DDEXEBUFCALLBACKS;

typedef struct _DDHAL_GETAVAILDRIVERMEMORYDATA	*LPDDHAL_GETAVAILDRIVERMEMORYDATA;
typedef struct _DDHAL_UPDATENONLOCALHEAPDATA	*LPDDHAL_UPDATENONLOCALHEAPDATA;
typedef struct _DDHAL_GETHEAPALIGNMENTDATA	*LPDDHAL_GETHEAPALIGNMENTDATA;

typedef DWORD (PASCAL *LPDDHAL_GETAVAILDRIVERMEMORY)(LPDDHAL_GETAVAILDRIVERMEMORYDATA);
typedef DWORD (PASCAL *LPDDHAL_UPDATENONLOCALHEAP)  (LPDDHAL_UPDATENONLOCALHEAPDATA);
typedef DWORD (PASCAL *LPDDHAL_GETHEAPALIGNMENT)    (LPDDHAL_GETHEAPALIGNMENTDATA);

typedef struct _DDHAL_DDMISCELLANEOUSCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHAL_GETAVAILDRIVERMEMORY	GetAvailDriverMemory;
    LPDDHAL_UPDATENONLOCALHEAP		UpdateNonLocalHeap;
    LPDDHAL_GETHEAPALIGNMENT		GetHeapAlignment;
    LPDDHALSURFCB_GETBLTSTATUS		GetSysmemBltStatus;
} DDHAL_DDMISCELLANEOUSCALLBACKS,*LPDDHAL_DDMISCELLANEOUSCALLBACKS;

typedef struct _DDHAL_CREATESURFACEEXDATA	*LPDDHAL_CREATESURFACEEXDATA;
typedef struct _DDHAL_GETDRIVERSTATEDATA	*LPDDHAL_GETDRIVERSTATEDATA;
typedef struct _DDHAL_DESTROYDDLOCALDATA	*LPDDHAL_DESTROYDDLOCALDATA;

typedef DWORD (PASCAL *LPDDHAL_CREATESURFACEEX)(LPDDHAL_CREATESURFACEEXDATA);
typedef DWORD (PASCAL *LPDDHAL_GETDRIVERSTATE) (LPDDHAL_GETDRIVERSTATEDATA);
typedef DWORD (PASCAL *LPDDHAL_DESTROYDDLOCAL) (LPDDHAL_DESTROYDDLOCALDATA);

typedef struct _DDHAL_DDMISCELLANEOUS2CALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPVOID				Reserved;
    LPDDHAL_CREATESURFACEEX		CreateSurfaceEx;
    LPDDHAL_GETDRIVERSTATE		GetDriverState;
    LPDDHAL_DESTROYDDLOCAL		DestroyDDLocal;
} DDHAL_DDMISCELLANEOUS2CALLBACKS,*LPDDHAL_DDMISCELLANEOUS2CALLBACKS;


typedef struct _DDHAL_CANCREATEVPORTDATA       *LPDDHAL_CANCREATEVPORTDATA;
typedef struct _DDHAL_CREATEVPORTDATA          *LPDDHAL_CREATEVPORTDATA;
typedef struct _DDHAL_FLIPVPORTDATA            *LPDDHAL_FLIPVPORTDATA;
typedef struct _DDHAL_GETVPORTCONNECTDATA      *LPDDHAL_GETVPORTCONNECTDATA;
typedef struct _DDHAL_GETVPORTBANDWIDTHDATA    *LPDDHAL_GETVPORTBANDWIDTHDATA;
typedef struct _DDHAL_GETVPORTINPUTFORMATDATA  *LPDDHAL_GETVPORTINPUTFORMATDATA;
typedef struct _DDHAL_GETVPORTOUTPUTFORMATDATA *LPDDHAL_GETVPORTOUTPUTFORMATDATA;
typedef struct _DDHAL_GETVPORTFIELDDATA        *LPDDHAL_GETVPORTFIELDDATA;
typedef struct _DDHAL_GETVPORTLINEDATA         *LPDDHAL_GETVPORTLINEDATA;
typedef struct _DDHAL_DESTROYVPORTDATA         *LPDDHAL_DESTROYVPORTDATA;
typedef struct _DDHAL_GETVPORTFLIPSTATUSDATA   *LPDDHAL_GETVPORTFLIPSTATUSDATA;
typedef struct _DDHAL_UPDATEVPORTDATA          *LPDDHAL_UPDATEVPORTDATA;
typedef struct _DDHAL_WAITFORVPORTSYNCDATA     *LPDDHAL_WAITFORVPORTSYNCDATA;
typedef struct _DDHAL_GETVPORTSIGNALDATA       *LPDDHAL_GETVPORTSIGNALDATA;
typedef struct _DDHAL_VPORTCOLORDATA           *LPDDHAL_VPORTCOLORDATA;

typedef DWORD (PASCAL *LPDDHALVPORTCB_CANCREATEVIDEOPORT)(LPDDHAL_CANCREATEVPORTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_CREATEVIDEOPORT)(LPDDHAL_CREATEVPORTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_FLIP)(LPDDHAL_FLIPVPORTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETBANDWIDTH)(LPDDHAL_GETVPORTBANDWIDTHDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETINPUTFORMATS)(LPDDHAL_GETVPORTINPUTFORMATDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETOUTPUTFORMATS)(LPDDHAL_GETVPORTOUTPUTFORMATDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETFIELD)(LPDDHAL_GETVPORTFIELDDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETLINE)(LPDDHAL_GETVPORTLINEDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETVPORTCONNECT)(LPDDHAL_GETVPORTCONNECTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_DESTROYVPORT)(LPDDHAL_DESTROYVPORTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETFLIPSTATUS)(LPDDHAL_GETVPORTFLIPSTATUSDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_UPDATE)(LPDDHAL_UPDATEVPORTDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_WAITFORSYNC)(LPDDHAL_WAITFORVPORTSYNCDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_GETSIGNALSTATUS)(LPDDHAL_GETVPORTSIGNALDATA);
typedef DWORD (PASCAL *LPDDHALVPORTCB_COLORCONTROL)(LPDDHAL_VPORTCOLORDATA);

typedef struct _DDHAL_DDVIDEOPORTCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALVPORTCB_CANCREATEVIDEOPORT	CanCreateVideoPort;
    LPDDHALVPORTCB_CREATEVIDEOPORT	CreateVideoPort;
    LPDDHALVPORTCB_FLIP			FlipVideoPort;
    LPDDHALVPORTCB_GETBANDWIDTH		GetVideoPortBandwidth;
    LPDDHALVPORTCB_GETINPUTFORMATS	GetVideoPortInputFormats;
    LPDDHALVPORTCB_GETOUTPUTFORMATS	GetVideoPortOutputFormats;
    LPVOID				lpReserved1;
    LPDDHALVPORTCB_GETFIELD		GetVideoPortField;
    LPDDHALVPORTCB_GETLINE		GetVideoPortLine;
    LPDDHALVPORTCB_GETVPORTCONNECT	GetVideoPortConnectInfo;
    LPDDHALVPORTCB_DESTROYVPORT		DestroyVideoPort;
    LPDDHALVPORTCB_GETFLIPSTATUS	GetVideoPortFlipStatus;
    LPDDHALVPORTCB_UPDATE		UpdateVideoPort;
    LPDDHALVPORTCB_WAITFORSYNC		WaitForVideoPortSync;
    LPDDHALVPORTCB_GETSIGNALSTATUS	GetVideoSignalStatus;
    LPDDHALVPORTCB_COLORCONTROL		ColorControl;
} DDHAL_DDVIDEOPORTCALLBACKS;


typedef struct _DDHAL_COLORCONTROLDATA *LPDDHAL_COLORCONTROLDATA;

typedef DWORD (PASCAL *LPDDHALCOLORCB_COLORCONTROL)(LPDDHAL_COLORCONTROLDATA);


typedef struct _DDHAL_DDCOLORCONTROLCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALCOLORCB_COLORCONTROL		ColorControl;
} DDHAL_DDCOLORCONTROLCALLBACKS;

typedef struct _DDHAL_SYNCSURFACEDATA   *LPDDHAL_SYNCSURFACEDATA;
typedef struct _DDHAL_SYNCVIDEOPORTDATA *LPDDHAL_SYNCVIDEOPORTDATA;

typedef DWORD (PASCAL *LPDDHALKERNELCB_SYNCSURFACE)(LPDDHAL_SYNCSURFACEDATA);
typedef DWORD (PASCAL *LPDDHALKERNELCB_SYNCVIDEOPORT)(LPDDHAL_SYNCVIDEOPORTDATA);

typedef struct _DDHAL_DDKERNELCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALKERNELCB_SYNCSURFACE		SyncSurfaceData;
    LPDDHALKERNELCB_SYNCVIDEOPORT	SyncVideoPortData;
} DDHAL_DDKERNELCALLBACKS, *LPDDHAL_DDKERNELCALLBACKS;

typedef struct _DDHAL_GETMOCOMPGUIDSDATA  *LPDDHAL_GETMOCOMPGUIDSDATA;
typedef struct _DDHAL_GETMOCOMPFORMATSDATA  *LPDDHAL_GETMOCOMPFORMATSDATA;
typedef struct _DDHAL_CREATEMOCOMPDATA  *LPDDHAL_CREATEMOCOMPDATA;
typedef struct _DDHAL_GETMOCOMPCOMPBUFFDATA  *LPDDHAL_GETMOCOMPCOMPBUFFDATA;
typedef struct _DDHAL_GETINTERNALMOCOMPDATA  *LPDDHAL_GETINTERNALMOCOMPDATA;
typedef struct _DDHAL_BEGINMOCOMPFRAMEDATA  *LPDDHAL_BEGINMOCOMPFRAMEDATA;
typedef struct _DDHAL_ENDMOCOMPFRAMEDATA  *LPDDHAL_ENDMOCOMPFRAMEDATA;
typedef struct _DDHAL_RENDERMOCOMPDATA  *LPDDHAL_RENDERMOCOMPDATA;
typedef struct _DDHAL_QUERYMOCOMPSTATUSDATA  *LPDDHAL_QUERYMOCOMPSTATUSDATA;
typedef struct _DDHAL_DESTROYMOCOMPDATA  *LPDDHAL_DESTROYMOCOMPDATA;

typedef DWORD (PASCAL *LPDDHALMOCOMPCB_GETGUIDS)( LPDDHAL_GETMOCOMPGUIDSDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_GETFORMATS)( LPDDHAL_GETMOCOMPFORMATSDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_CREATE)( LPDDHAL_CREATEMOCOMPDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_GETCOMPBUFFINFO)( LPDDHAL_GETMOCOMPCOMPBUFFDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_GETINTERNALINFO)( LPDDHAL_GETINTERNALMOCOMPDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_BEGINFRAME)( LPDDHAL_BEGINMOCOMPFRAMEDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_ENDFRAME)( LPDDHAL_ENDMOCOMPFRAMEDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_RENDER)( LPDDHAL_RENDERMOCOMPDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_QUERYSTATUS)( LPDDHAL_QUERYMOCOMPSTATUSDATA);
typedef DWORD (PASCAL *LPDDHALMOCOMPCB_DESTROY)( LPDDHAL_DESTROYMOCOMPDATA);

typedef struct _DDHAL_DDMOTIONCOMPCALLBACKS {
    DWORD				dwSize;
    DWORD				dwFlags;
    LPDDHALMOCOMPCB_GETGUIDS		GetMoCompGuids;
    LPDDHALMOCOMPCB_GETFORMATS		GetMoCompFormats;
    LPDDHALMOCOMPCB_CREATE		CreateMoComp;
    LPDDHALMOCOMPCB_GETCOMPBUFFINFO	GetMoCompBuffInfo;
    LPDDHALMOCOMPCB_GETINTERNALINFO	GetInternalMoCompInfo;
    LPDDHALMOCOMPCB_BEGINFRAME		BeginMoCompFrame;
    LPDDHALMOCOMPCB_ENDFRAME		EndMoCompFrame;
    LPDDHALMOCOMPCB_RENDER		RenderMoComp;
    LPDDHALMOCOMPCB_QUERYSTATUS		QueryMoCompStatus;
    LPDDHALMOCOMPCB_DESTROY		DestroyMoComp;
} DDHAL_DDMOTIONCOMPCALLBACKS, *LPDDHAL_DDMOTIONCOMPCALLBACKS;


typedef HRESULT (WINAPI *LPDDGAMMACALIBRATORPROC)(LPDDGAMMARAMP, LPBYTE);


/*****************************************************************************
 * driver info structure
 *
 * The HAL is queried for additional callbacks via the GetDriverInfo callback.
 */
typedef struct _DDHAL_GETDRIVERINFODATA *LPDDHAL_GETDRIVERINFODATA;
typedef DWORD (PASCAL *LPDDHAL_GETDRIVERINFO)(LPDDHAL_GETDRIVERINFODATA);


typedef struct _DDHAL_GETDRIVERINFODATA {
    DWORD	dwSize;
    DWORD	dwFlags;
    GUID	guidInfo;
    DWORD	dwExpectedSize;
    LPVOID	lpvData;
    DWORD	dwActualSize;
    HRESULT	ddRVal;
    ULONG_PTR	dwContext;
} DDHAL_GETDRIVERINFODATA;

typedef struct _DDHALINFO {
    DWORD			dwSize;
    LPDDHAL_DDCALLBACKS		lpDDCallbacks;
    LPDDHAL_DDSURFACECALLBACKS	lpDDSurfaceCallbacks;
    LPDDHAL_DDPALETTECALLBACKS	lpDDPaletteCallbacks;
    VIDMEMINFO			vmiData;
    DDCORECAPS			ddCaps;
    DWORD			dwMonitorFrequency;
    LPDDHAL_GETDRIVERINFO	GetDriverInfo;
    DWORD			dwModeIndex;
    LPDWORD			lpdwFourCC;
    DWORD			dwNumModes;
    LPDDHALMODEINFO		lpModeInfo;
    DWORD			dwFlags;
    LPVOID			lpPDevice;
    DWORD			hInstance;
    /* DirectX 2 */
    ULONG_PTR			lpD3DGlobalDriverData;
    ULONG_PTR			lpD3DHALCallbacks;
    LPDDHAL_DDEXEBUFCALLBACKS	lpDDExeBufCallbacks;
} DDHALINFO;


#define DDPALETTECALLBACKSSIZE		sizeof(DDHAL_DDPALETTECALLBACKS)
#define DDSURFACECALLBACKSSIZE		sizeof(DDHAL_DDSURFACECALLBACKS)
#define DDMISCELLANEOUSCALLBACKSSIZE	sizeof(DDHAL_DDMISCELLANEOUSCALLBACKS)
#define DDMISCELLANEOUS2CALLBACKSSIZE	sizeof(DDHAL_DDMISCELLANEOUS2CALLBACKS)
#define DDEXEBUFCALLBACKSSIZE		sizeof(DDHAL_DDEXEBUFCALLBACKS)
#define DDVIDEOPORTCALLBACKSSIZE	sizeof(DDHAL_DDVIDEOPORTCALLBACKS)
#define DDCOLORCONTROLCALLBACKSSIZE	sizeof(DDHAL_DDCOLORCONTROLCALLBACKS)
#define DDKERNELCALLBACKSSIZE		sizeof(DDHAL_DDKERNELCALLBACKS)
#define DDMOTIONCOMPCALLBACKSSIZE	sizeof(DDHAL_DDMOTIONCOMPCALLBACKS)

#define MAX_PALETTE_SIZE		256

#define MAX_AUTOFLIP_BUFFERS		10
#define DDSCAPS2_INDEXBUFFER		DDSCAPS2_RESERVED3
#define DDSCAPS3_VIDEO			DDSCAPS3_RESERVED2
#define D3DFMT_INTERNAL_D32		71
#define D3DFMT_INTERNAL_S1D15		72
#define D3DFMT_INTERNAL_D15S1		73
#define D3DFMT_INTERNAL_S8D24		74
#define D3DFMT_INTERNAL_D24S8		75
#define D3DFMT_INTERNAL_X8D24		76
#define D3DFMT_INTERNAL_D24X8		77

#define DDHAL_PLEASEALLOC_BLOCKSIZE		0x00000002l
#define DDHAL_PLEASEALLOC_LINEARSIZE		0x00000003l

#define DDHAL_CB32_DESTROYDRIVER		0x00000001l
#define DDHAL_CB32_CREATESURFACE		0x00000002l
#define DDHAL_CB32_SETCOLORKEY			0x00000004l
#define DDHAL_CB32_SETMODE			0x00000008l
#define DDHAL_CB32_WAITFORVERTICALBLANK		0x00000010l
#define DDHAL_CB32_CANCREATESURFACE		0x00000020l
#define DDHAL_CB32_CREATEPALETTE		0x00000040l
#define DDHAL_CB32_GETSCANLINE			0x00000080l
#define DDHAL_CB32_SETEXCLUSIVEMODE		0x00000100l
#define DDHAL_CB32_FLIPTOGDISURFACE		0x00000200l
#define DDHAL_PALCB32_DESTROYPALETTE		0x00000001l
#define DDHAL_PALCB32_SETENTRIES		0x00000002l

#define DDHALINFO_ISPRIMARYDISPLAY		0x00000001
#define DDHALINFO_MODEXILLEGAL			0x00000002
#define DDHALINFO_GETDRIVERINFOSET		0x00000004
#define DDHALINFO_GETDRIVERINFO2		0x00000008

#define DDRAWI_VPORTSTART			0x0001
#define DDRAWI_VPORTSTOP			0x0002
#define DDRAWI_VPORTUPDATE			0x0003
#define DDRAWI_VPORTGETCOLOR			0x0001
#define DDRAWI_VPORTSETCOLOR			0x0002

#define DDHAL_SURFCB32_DESTROYSURFACE		0x00000001
#define DDHAL_SURFCB32_FLIP			0x00000002
#define DDHAL_SURFCB32_SETCLIPLIST		0x00000004
#define DDHAL_SURFCB32_LOCK			0x00000008
#define DDHAL_SURFCB32_UNLOCK			0x00000010
#define DDHAL_SURFCB32_BLT			0x00000020
#define DDHAL_SURFCB32_SETCOLORKEY		0x00000040
#define DDHAL_SURFCB32_ADDATTACHEDSURFACE	0x00000080
#define DDHAL_SURFCB32_GETBLTSTATUS		0x00000100
#define DDHAL_SURFCB32_GETFLIPSTATUS		0x00000200
#define DDHAL_SURFCB32_UPDATEOVERLAY		0x00000400
#define DDHAL_SURFCB32_SETOVERLAYPOSITION	0x00000800
#define DDHAL_SURFCB32_RESERVED4		0x00001000
#define DDHAL_SURFCB32_SETPALETTE		0x00002000

#define DDHAL_MISCCB32_GETAVAILDRIVERMEMORY	0x00000001
#define DDHAL_MISCCB32_UPDATENONLOCALHEAP	0x00000002
#define DDHAL_MISCCB32_GETHEAPALIGNMENT		0x00000004
#define DDHAL_MISCCB32_GETSYSMEMBLTSTATUS	0x00000008
#define DDHAL_MISC2CB32_ALPHABLT		0x00000001
#define DDHAL_MISC2CB32_CREATESURFACEEX		0x00000002
#define DDHAL_MISC2CB32_GETDRIVERSTATE		0x00000004
#define DDHAL_MISC2CB32_DESTROYDDLOCAL		0x00000008

#define DDHAL_EXEBUFCB32_CANCREATEEXEBUF	0x00000001l
#define DDHAL_EXEBUFCB32_CREATEEXEBUF		0x00000002l
#define DDHAL_EXEBUFCB32_DESTROYEXEBUF		0x00000004l
#define DDHAL_EXEBUFCB32_LOCKEXEBUF		0x00000008l
#define DDHAL_EXEBUFCB32_UNLOCKEXEBUF		0x00000010l

#define DDHAL_VPORT32_CANCREATEVIDEOPORT	0x00000001
#define DDHAL_VPORT32_CREATEVIDEOPORT		0x00000002
#define DDHAL_VPORT32_FLIP			0x00000004
#define DDHAL_VPORT32_GETBANDWIDTH		0x00000008
#define DDHAL_VPORT32_GETINPUTFORMATS		0x00000010
#define DDHAL_VPORT32_GETOUTPUTFORMATS		0x00000020
#define DDHAL_VPORT32_GETFIELD			0x00000080
#define DDHAL_VPORT32_GETLINE			0x00000100
#define DDHAL_VPORT32_GETCONNECT		0x00000200
#define DDHAL_VPORT32_DESTROY			0x00000400
#define DDHAL_VPORT32_GETFLIPSTATUS		0x00000800
#define DDHAL_VPORT32_UPDATE			0x00001000
#define DDHAL_VPORT32_WAITFORSYNC		0x00002000
#define DDHAL_VPORT32_GETSIGNALSTATUS		0x00004000
#define DDHAL_VPORT32_COLORCONTROL		0x00008000

#define DDHAL_COLOR_COLORCONTROL		0x00000001

#define DDHAL_KERNEL_SYNCSURFACEDATA		0x00000001l
#define DDHAL_KERNEL_SYNCVIDEOPORTDATA		0x00000002l

#define DDHAL_MOCOMP32_GETGUIDS			0x00000001
#define DDHAL_MOCOMP32_GETFORMATS		0x00000002
#define DDHAL_MOCOMP32_CREATE			0x00000004
#define DDHAL_MOCOMP32_GETCOMPBUFFINFO		0x00000008
#define DDHAL_MOCOMP32_GETINTERNALINFO		0x00000010
#define DDHAL_MOCOMP32_BEGINFRAME		0x00000020
#define DDHAL_MOCOMP32_ENDFRAME			0x00000040
#define DDHAL_MOCOMP32_RENDER			0x00000080
#define DDHAL_MOCOMP32_QUERYSTATUS		0x00000100
#define DDHAL_MOCOMP32_DESTROY			0x00000200


/* where the high-level ddraw implementation stores the callbacks */
typedef struct _DDHAL_CALLBACKS {
    DDHAL_DDCALLBACKS			cbDDCallbacks;
    DDHAL_DDSURFACECALLBACKS		cbDDSurfaceCallbacks;
    DDHAL_DDPALETTECALLBACKS		cbDDPaletteCallbacks;
    DDHAL_DDCALLBACKS			HALDD;
    DDHAL_DDSURFACECALLBACKS		HALDDSurface;
    DDHAL_DDPALETTECALLBACKS		HALDDPalette;
    DDHAL_DDCALLBACKS			HELDD;
    DDHAL_DDSURFACECALLBACKS		HELDDSurface;
    DDHAL_DDPALETTECALLBACKS		HELDDPalette;
    DDHAL_DDEXEBUFCALLBACKS		cbDDExeBufCallbacks;
    DDHAL_DDEXEBUFCALLBACKS		HALDDExeBuf;
    DDHAL_DDEXEBUFCALLBACKS		HELDDExeBuf;
    DDHAL_DDVIDEOPORTCALLBACKS		cbDDVideoPortCallbacks;
    DDHAL_DDVIDEOPORTCALLBACKS		HALDDVideoPort;
    DDHAL_DDCOLORCONTROLCALLBACKS	cbDDColorControlCallbacks;
    DDHAL_DDCOLORCONTROLCALLBACKS	HALDDColorControl;
    DDHAL_DDMISCELLANEOUSCALLBACKS	cbDDMiscellaneousCallbacks;
    DDHAL_DDMISCELLANEOUSCALLBACKS	HALDDMiscellaneous;
    DDHAL_DDKERNELCALLBACKS		cbDDKernelCallbacks;
    DDHAL_DDKERNELCALLBACKS		HALDDKernel;
    DDHAL_DDMOTIONCOMPCALLBACKS		cbDDMotionCompCallbacks;
    DDHAL_DDMOTIONCOMPCALLBACKS		HALDDMotionComp;
} DDHAL_CALLBACKS,*LPDDHAL_CALLBACKS;

/*****************************************************************************
 * parameter structures
 */
typedef struct _DDHAL_DESTROYDRIVERDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    HRESULT			ddRVal;
    LPDDHAL_DESTROYDRIVER	DestroyDriver;
} DDHAL_DESTROYDRIVERDATA;

typedef struct _DDHAL_SETMODEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwModeIndex;
    HRESULT			ddRVal;
    LPDDHAL_SETMODE		SetMode;
    WINBOOL			inexcl;
    WINBOOL			useRefreshRate;
} DDHAL_SETMODEDATA;

typedef struct _DDHAL_CREATESURFACEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDSURFACEDESC		lpDDSurfaceDesc;
    LPDDRAWI_DDRAWSURFACE_LCL *	lplpSList;
    DWORD			dwSCnt;
    HRESULT			ddRVal;
    LPDDHAL_CREATESURFACE	CreateSurface;
} DDHAL_CREATESURFACEDATA;

typedef struct _DDHAL_CANCREATESURFACEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDSURFACEDESC		lpDDSurfaceDesc;
    DWORD			bIsDifferentPixelFormat;
    HRESULT			ddRVal;
    LPDDHAL_CANCREATESURFACE	CanCreateSurface;
} DDHAL_CANCREATESURFACEDATA;

typedef struct _DDHAL_CREATEPALETTEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWPALETTE_GBL	lpDDPalette;
    LPPALETTEENTRY		lpColorTable;
    HRESULT			ddRVal;
    LPDDHAL_CREATEPALETTE	CreatePalette;
    WINBOOL			is_excl;
} DDHAL_CREATEPALETTEDATA;

typedef struct _DDHAL_SETEXCLUSIVEMODEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwEnterExcl;
    DWORD			dwReserved;
    HRESULT			ddRVal;
    LPDDHAL_SETEXCLUSIVEMODE	SetExclusiveMode;
} DDHAL_SETEXCLUSIVEMODEDATA;

/* surfaces */
typedef struct _DDHAL_DESTROYSURFACEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    HRESULT			ddRVal;
    LPDDHALSURFCB_DESTROYSURFACE DestroySurface;
} DDHAL_DESTROYSURFACEDATA;

typedef struct _DDHAL_FLIPDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurfCurr;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurfTarg;
    DWORD			dwFlags;
    HRESULT			ddRVal;
    LPDDHALSURFCB_FLIP		Flip;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurfCurrLeft;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurfTargLeft;
} DDHAL_FLIPDATA;

typedef struct _DDHAL_LOCKDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    DWORD			bHasRect;
    RECTL			rArea;
    LPVOID			lpSurfData;
    HRESULT			ddRVal;
    LPDDHALSURFCB_LOCK		Lock;
    DWORD			dwFlags;
} DDHAL_LOCKDATA;

typedef struct _DDHAL_UNLOCKDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    HRESULT			ddRVal;
    LPDDHALSURFCB_UNLOCK	Unlock;
} DDHAL_UNLOCKDATA;

typedef struct _DDHAL_BLTDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDDestSurface;
    RECTL			rDest;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSrcSurface;
    RECTL			rSrc;
    DWORD			dwFlags;
    DWORD			dwROPFlags;
    DDBLTFX			bltFX;
    HRESULT			ddRVal;
    LPDDHALSURFCB_BLT		Blt;
    WINBOOL			IsClipped;
    RECTL			rOrigDest;
    RECTL			rOrigSrc;
    DWORD			dwRectCnt;
    LPRECT			prDestRects;
} DDHAL_BLTDATA;

typedef struct _DDHAL_SETPALETTEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    LPDDRAWI_DDRAWPALETTE_GBL	lpDDPalette;
    HRESULT			ddRVal;
    LPDDHALSURFCB_SETPALETTE	SetPalette;
    WINBOOL			Attach;
} DDHAL_SETPALETTEDATA;

/* palettes */
typedef struct _DDHAL_DESTROYPALETTEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWPALETTE_GBL	lpDDPalette;
    HRESULT			ddRVal;
    LPDDHALPALCB_DESTROYPALETTE	DestroyPalette;
} DDHAL_DESTROYPALETTEDATA;

typedef struct _DDHAL_SETENTRIESDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWPALETTE_GBL	lpDDPalette;
    DWORD			dwBase;
    DWORD			dwNumEntries;
    LPPALETTEENTRY		lpEntries;
    HRESULT			ddRVal;
    LPDDHALPALCB_SETENTRIES	SetEntries;
} DDHAL_SETENTRIESDATA;


typedef struct _DDHAL_CANCREATEVPORTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDVIDEOPORTDESC			lpDDVideoPortDesc;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_CANCREATEVIDEOPORT	CanCreateVideoPort;
} DDHAL_CANCREATEVPORTDATA;

typedef struct _DDHAL_CREATEVPORTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDVIDEOPORTDESC			lpDDVideoPortDesc;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_CREATEVIDEOPORT	CreateVideoPort;
} DDHAL_CREATEVPORTDATA;

typedef struct _DDHAL_GETVPORTBANDWIDTHDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    LPDDPIXELFORMAT			lpddpfFormat;
    DWORD				dwWidth;
    DWORD				dwHeight;
    DWORD				dwFlags;
    LPDDVIDEOPORTBANDWIDTH		lpBandwidth;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETBANDWIDTH		GetVideoPortBandwidth;
} DDHAL_GETVPORTBANDWIDTHDATA;

typedef struct _DDHAL_GETVPORTINPUTFORMATDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwFlags;
    LPDDPIXELFORMAT			lpddpfFormat;
    DWORD				dwNumFormats;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETINPUTFORMATS	GetVideoPortInputFormats;
} DDHAL_GETVPORTINPUTFORMATDATA;

typedef struct _DDHAL_GETVPORTFIELDDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    WINBOOL				bField;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETFIELD		GetVideoPortField;
} DDHAL_GETVPORTFIELDDATA;

typedef struct _DDHAL_GETVPORTOUTPUTFORMATDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwFlags;
    LPDDPIXELFORMAT			lpddpfInputFormat;
    LPDDPIXELFORMAT			lpddpfOutputFormats;
    DWORD				dwNumFormats;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETOUTPUTFORMATS	GetVideoPortOutputFormats;
} DDHAL_GETVPORTOUTPUTFORMATDATA;

typedef struct _DDHAL_GETVPORTLINEDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwLine;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETLINE		GetVideoPortLine;
} DDHAL_GETVPORTLINEDATA;

typedef struct _DDHAL_DESTROYVPORTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_DESTROYVPORT		DestroyVideoPort;
} DDHAL_DESTROYVPORTDATA;

typedef struct _DDHAL_GETVPORTFLIPSTATUSDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    FLATPTR				fpSurface;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETFLIPSTATUS	GetVideoPortFlipStatus;
} DDHAL_GETVPORTFLIPSTATUSDATA;

typedef struct _DDHAL_UPDATEVPORTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    LPDDRAWI_DDRAWSURFACE_INT		*lplpDDSurface;
    LPDDRAWI_DDRAWSURFACE_INT		*lplpDDVBISurface;
    LPDDVIDEOPORTINFO			lpVideoInfo;
    DWORD				dwFlags;
    DWORD				dwNumAutoflip;
    DWORD				dwNumVBIAutoflip;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_UPDATE		UpdateVideoPort;
} DDHAL_UPDATEVPORTDATA;

typedef struct _DDHAL_WAITFORVPORTSYNCDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwFlags;
    DWORD				dwLine;
    DWORD				dwTimeOut;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_WAITFORSYNC		WaitForVideoPortSync;
} DDHAL_WAITFORVPORTSYNCDATA;

typedef struct _DDHAL_GETVPORTSIGNALDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwStatus;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETSIGNALSTATUS	GetVideoSignalStatus;
} DDHAL_GETVPORTSIGNALDATA;

typedef struct _DDHAL_VPORTCOLORDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwFlags;
    LPDDCOLORCONTROL			lpColorData;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_COLORCONTROL		ColorControl;
} DDHAL_VPORTCOLORDATA;

typedef struct _DDHAL_FLIPVPORTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    LPDDRAWI_DDRAWSURFACE_LCL		lpSurfCurr;
    LPDDRAWI_DDRAWSURFACE_LCL		lpSurfTarg;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_FLIP			FlipVideoPort;
} DDHAL_FLIPVPORTDATA;

typedef struct _DDHAL_GETVPORTCONNECTDATA {
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    DWORD				dwPortId;
    LPDDVIDEOPORTCONNECT		lpConnect;
    DWORD				dwNumEntries;
    HRESULT				ddRVal;
    LPDDHALVPORTCB_GETVPORTCONNECT	GetVideoPortConnectInfo;
} DDHAL_GETVPORTCONNECTDATA;

typedef struct _DDHAL_SYNCSURFACEDATA {
    DWORD				dwSize;
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL		lpDDSurface;
    DWORD				dwSurfaceOffset;
    ULONG_PTR				fpLockPtr;
    LONG				lPitch;
    DWORD				dwOverlayOffset;
    DWORD				dwOverlaySrcWidth;
    DWORD				dwOverlaySrcHeight;
    DWORD				dwOverlayDestWidth;
    DWORD				dwOverlayDestHeight;
    ULONG_PTR				dwDriverReserved1;
    ULONG_PTR				dwDriverReserved2;
    ULONG_PTR				dwDriverReserved3;
    HRESULT				ddRVal;
} DDHAL_SYNCSURFACEDATA;

typedef struct _DDHAL_SYNCVIDEOPORTDATA {
    DWORD				dwSize;
    LPDDRAWI_DIRECTDRAW_LCL		lpDD;
    LPDDRAWI_DDVIDEOPORT_LCL		lpVideoPort;
    DWORD				dwOriginOffset;
    DWORD				dwHeight;
    DWORD				dwVBIHeight;
    ULONG_PTR				dwDriverReserved1;
    ULONG_PTR				dwDriverReserved2;
    ULONG_PTR				dwDriverReserved3;
    HRESULT				ddRVal;
} DDHAL_SYNCVIDEOPORTDATA;

typedef struct _DDHAL_DESTROYDDLOCALDATA {
    DWORD				dwFlags;
    LPDDRAWI_DIRECTDRAW_LCL		pDDLcl;
    HRESULT				ddRVal;
} DDHAL_DESTROYDDLOCALDATA;

typedef struct _DDHAL_CREATESURFACEEXDATA {
    DWORD				dwFlags;
    LPDDRAWI_DIRECTDRAW_LCL		lpDDLcl;
    LPDDRAWI_DDRAWSURFACE_LCL		lpDDSLcl;
    HRESULT				ddRVal;
} DDHAL_CREATESURFACEEXDATA;

typedef struct _DDHAL_GETHEAPALIGNMENTDATA {
    ULONG_PTR				dwInstance;
    DWORD				dwHeap;
    HRESULT				ddRVal;
    LPDDHAL_GETHEAPALIGNMENT		GetHeapAlignment;
    HEAPALIGNMENT			Alignment;
} DDHAL_GETHEAPALIGNMENTDATA;


typedef struct _DDMORESURFACECAPS {
    DWORD	dwSize;
    DDSCAPSEX	ddsCapsMore;
    struct tagExtendedHeapRestrictions {
      DDSCAPSEX		ddsCapsEx;
      DDSCAPSEX		ddsCapsExAlt;
    } ddsExtendedHeapRestrictions[1];
} DDMORESURFACECAPS, *LPDDMORESURFACECAPS;

typedef struct _DDSTEREOMODE {
    DWORD	dwSize;
    DWORD	dwHeight;
    DWORD	dwWidth;
    DWORD	dwBpp;
    DWORD	dwRefreshRate;
    WINBOOL	bSupported;
} DDSTEREOMODE, *LPDDSTEREOMODE;

/*****************************************************************************
 * high-level ddraw implementation structures
 */
typedef struct _IUNKNOWN_LIST {
    struct _IUNKNOWN_LIST *	lpLink;
    LPGUID			lpGuid;
#ifndef _NO_COM
    IUnknown *			lpIUnknown;
#else
    LPVOID			lpIUnknown;
#endif /* _NO_COM */
} IUNKNOWN_LIST, *LPIUNKNOWN_LIST;


typedef struct _PROCESS_LIST {
    struct _PROCESS_LIST *	lpLink;
    DWORD			dwProcessId;
    DWORD			dwRefCnt;
    DWORD			dwAlphaDepth;
    DWORD			dwZDepth;
} PROCESS_LIST,*LPPROCESS_LIST;

typedef struct _ATTACHLIST {
    DWORD			dwFlags;
    struct _ATTACHLIST *	lpLink;
    LPDDRAWI_DDRAWSURFACE_LCL	lpAttached;
    LPDDRAWI_DDRAWSURFACE_INT	lpIAttached;
} ATTACHLIST,*LPATTACHLIST;

#define DDAL_IMPLICIT			0x00000001

typedef struct _ACCESSRECTLIST {
    struct _ACCESSRECTLIST *	lpLink;
    RECT			rDest;
    LPDDRAWI_DIRECTDRAW_LCL	lpOwner;
    LPVOID			lpSurfaceData;
    DWORD			dwFlags;
    LPHEAPALIASINFO		lpHeapAliasInfo;
} ACCESSRECTLIST,*LPACCESSRECTLIST;

#define ACCESSRECT_VRAMSTYLE		0x00000001
#define ACCESSRECT_NOTHOLDINGWIN16LOCK	0x00000002
#define ACCESSRECT_BROKEN		0x00000004

typedef struct _DBLNODE {
    struct _DBLNODE *		next;
    struct _DBLNODE *		prev;
    LPDDRAWI_DDRAWSURFACE_LCL	object;
    LPDDRAWI_DDRAWSURFACE_INT	object_int;
} DBLNODE,*LPDBLNODE;

typedef struct _DDRAWI_DIRECTDRAW_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DIRECTDRAW_LCL	lpLcl;
    LPDDRAWI_DIRECTDRAW_INT	lpLink;
    DWORD			dwIntRefCnt;
} DDRAWI_DIRECTDRAW_INT;


typedef struct _DDRAWI_DIRECTDRAW_LCL {
    DWORD			lpDDMore;
    LPDDRAWI_DIRECTDRAW_GBL	lpGbl;
    DWORD			dwUnused0;
    DWORD			dwLocalFlags;
    DWORD			dwLocalRefCnt;
    DWORD			dwProcessId;
#ifndef _NO_COM
    IUnknown *			pUnkOuter;
#else
    PVOID			pUnkOuter;
#endif
    DWORD			dwObsolete1;
    ULONG_PTR			hWnd;
    ULONG_PTR			hDC;
    DWORD			dwErrorMode;
    LPDDRAWI_DDRAWSURFACE_INT	lpPrimary;
    LPDDRAWI_DDRAWSURFACE_INT	lpCB;
    DWORD			dwPreferredMode;
    /* DirectX 2 */
    HINSTANCE			hD3DInstance;
#ifndef _NO_COM
    IUnknown *			pD3DIUnknown;
#else
    PVOID			pD3DIUnknown;
#endif
    LPDDHAL_CALLBACKS		lpDDCB;
    ULONG_PTR			hDDVxd;
    /* DirectX 5.0 */
    DWORD			dwAppHackFlags;
    /* DirectX 5.0A */
    ULONG_PTR			hFocusWnd;
    DWORD			dwHotTracking;
    DWORD			dwIMEState;
    /* DirectX 6.0 */
    ULONG_PTR			hWndPopup;
    ULONG_PTR			hDD;
    ULONG_PTR			hGammaCalibrator;
    LPDDGAMMACALIBRATORPROC	lpGammaCalibrator;
} DDRAWI_DIRECTDRAW_LCL;


#define DDRAWILCL_HASEXCLUSIVEMODE	0x00000001
#define DDRAWILCL_ISFULLSCREEN		0x00000002
#define DDRAWILCL_SETCOOPCALLED		0x00000004
#define DDRAWILCL_ACTIVEYES		0x00000008
#define DDRAWILCL_ACTIVENO		0x00000010
#define DDRAWILCL_HOOKEDHWND		0x00000020
#define DDRAWILCL_ALLOWMODEX		0x00000040
#define DDRAWILCL_V1SCLBEHAVIOUR	0x00000080
#define DDRAWILCL_MODEHASBEENCHANGED	0x00000100
#define DDRAWILCL_CREATEDWINDOW		0x00000200
#define DDRAWILCL_DIRTYDC		0x00000400
#define DDRAWILCL_DISABLEINACTIVATE	0x00000800
#define DDRAWILCL_CURSORCLIPPED		0x00001000
#define DDRAWILCL_EXPLICITMONITOR	0x00002000
#define DDRAWILCL_MULTITHREADED		0x00004000
#define DDRAWILCL_FPUSETUP		0x00008000
#define DDRAWILCL_POWEREDDOWN		0x00010000
#define DDRAWILCL_DIRECTDRAW7		0x00020000
#define DDRAWILCL_ATTEMPTEDD3DCONTEXT	0x00040000
#define DDRAWILCL_FPUPRESERVE		0x00080000
#define DDRAWILCL_DX8DRIVER		0x00100000
#define DDRAWILCL_DIRECTDRAW8		0x00200000


typedef struct _DDRAWI_DIRECTDRAW_GBL {
    DWORD			dwRefCnt;
    DWORD			dwFlags;
    FLATPTR			fpPrimaryOrig;
    DDCORECAPS			ddCaps;
    DWORD			dwInternal1;
    DWORD			dwUnused1[9];
    LPDDHAL_CALLBACKS		lpDDCBtmp;
    LPDDRAWI_DDRAWSURFACE_INT	dsList;
    LPDDRAWI_DDRAWPALETTE_INT	palList;
    LPDDRAWI_DDRAWCLIPPER_INT	clipperList;
    LPDDRAWI_DIRECTDRAW_GBL	lp16DD;
    DWORD			dwMaxOverlays;
    DWORD			dwCurrOverlays;
    DWORD			dwMonitorFrequency;
    DDCORECAPS			ddHELCaps;
    DWORD			dwUnused2[50];
    DDCOLORKEY			ddckCKDestOverlay;
    DDCOLORKEY			ddckCKSrcOverlay;
    VIDMEMINFO			vmiData;
    LPVOID			lpDriverHandle;
    LPDDRAWI_DIRECTDRAW_LCL	lpExclusiveOwner;
    DWORD			dwModeIndex;
    DWORD			dwModeIndexOrig;
    DWORD			dwNumFourCC;
    LPDWORD			lpdwFourCC;
    DWORD			dwNumModes;
    LPDDHALMODEINFO		lpModeInfo;
    PROCESS_LIST		plProcessList;
    DWORD			dwSurfaceLockCount;
    DWORD			dwAliasedLockCnt;
    ULONG_PTR			dwReserved3;
    ULONG_PTR			hDD;
    char			cObsolete[12];
    DWORD			dwReserved1;
    DWORD			dwReserved2;
    DBLNODE			dbnOverlayRoot;
    volatile LPWORD		lpwPDeviceFlags;
    DWORD			dwPDevice;
    DWORD			dwWin16LockCnt;
    DWORD			dwUnused3;
    DWORD			hInstance;
    DWORD			dwEvent16;
    DWORD			dwSaveNumModes;
    /* DirectX 2 */
    ULONG_PTR			lpD3DGlobalDriverData;
    ULONG_PTR			lpD3DHALCallbacks;
    DDCORECAPS			ddBothCaps;
    /* DirectX 5.0 */
    LPDDVIDEOPORTCAPS		lpDDVideoPortCaps;
    LPDDRAWI_DDVIDEOPORT_INT	dvpList;
    ULONG_PTR			lpD3DHALCallbacks2;
    RECT			rectDevice;
    DWORD			cMonitors;
    LPVOID			gpbmiSrc;
    LPVOID			gpbmiDest;
    LPHEAPALIASINFO		phaiHeapAliases;
    ULONG_PTR			hKernelHandle;
    ULONG_PTR			pfnNotifyProc;
    LPDDKERNELCAPS		lpDDKernelCaps;
    LPDDNONLOCALVIDMEMCAPS	lpddNLVCaps;
    LPDDNONLOCALVIDMEMCAPS	lpddNLVHELCaps;
    LPDDNONLOCALVIDMEMCAPS	lpddNLVBothCaps;
    ULONG_PTR			lpD3DExtendedCaps;
    /* DirectX 5.0A */
    DWORD			dwDOSBoxEvent;
    RECT			rectDesktop;
    char			cDriverName[MAX_DRIVER_NAME];
    /* DirectX 6.0 */
    ULONG_PTR			lpD3DHALCallbacks3;
    DWORD			dwNumZPixelFormats;
    LPDDPIXELFORMAT		lpZPixelFormats;
    LPDDRAWI_DDMOTIONCOMP_INT	mcList;
    DWORD			hDDVxd;
    DDSCAPSEX			ddsCapsMore;
} DDRAWI_DIRECTDRAW_GBL;

#define DDRAWI_xxxxxxxxx1			0x00000001
#define DDRAWI_xxxxxxxxx2			0x00000002
#define DDRAWI_VIRTUALDESKTOP			0x00000008
#define DDRAWI_MODEX				0x00000010
#define DDRAWI_DISPLAYDRV			0x00000020
#define DDRAWI_FULLSCREEN			0x00000040
#define DDRAWI_MODECHANGED			0x00000080
#define DDRAWI_NOHARDWARE			0x00000100
#define DDRAWI_PALETTEINIT			0x00000200
#define DDRAWI_NOEMULATION			0x00000400
#define DDRAWI_HASCKEYDESTOVERLAY		0x00000800
#define DDRAWI_HASCKEYSRCOVERLAY		0x00001000
#define DDRAWI_HASGDIPALETTE			0x00002000
#define DDRAWI_EMULATIONINITIALIZED		0x00004000
#define DDRAWI_HASGDIPALETTE_EXCLUSIVE		0x00008000
#define DDRAWI_MODEXILLEGAL			0x00010000
#define DDRAWI_FLIPPEDTOGDI			0x00020000
#define DDRAWI_NEEDSWIN16FORVRAMLOCK		0x00040000
#define DDRAWI_PDEVICEVRAMBITCLEARED		0x00080000
#define DDRAWI_STANDARDVGA			0x00100000
#define DDRAWI_EXTENDEDALIGNMENT		0x00200000
#define DDRAWI_CHANGINGMODE			0x00400000
#define DDRAWI_GDIDRV				0x00800000
#define DDRAWI_ATTACHEDTODESKTOP		0x01000000
#define DDRAWI_UMODELOADED			0x02000000
#define DDRAWI_DDRAWDATANOTFETCHED		0x04000000
#define DDRAWI_SECONDARYDRIVERLOADED		0x08000000
#define DDRAWI_TESTINGMODES			0x10000000
#define DDRAWI_DRIVERINFO2			0x20000000
#define DDRAWI_BADPDEV				0x40000000


/* surfaces */
typedef struct _DDRAWI_DDRAWSURFACE_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DDRAWSURFACE_LCL	lpLcl;
    LPDDRAWI_DDRAWSURFACE_INT	lpLink;
    DWORD			dwIntRefCnt;
} DDRAWI_DDRAWSURFACE_INT;

typedef struct _DDRAWI_DDRAWSURFACE_GBL {
    DWORD			dwRefCnt;
    DWORD			dwGlobalFlags;
    __GNU_EXTENSION union {
	LPACCESSRECTLIST	lpRectList;
	DWORD			    dwBlockSizeY;
	LONG                lSlicePitch;
    };
    __GNU_EXTENSION union {
	LPVMEMHEAP		lpVidMemHeap;
	DWORD			dwBlockSizeX;
    };
    __GNU_EXTENSION union {
	LPDDRAWI_DIRECTDRAW_GBL	lpDD;
	LPVOID			lpDDHandle;
    };
    FLATPTR			fpVidMem;
    __GNU_EXTENSION union {
	LONG			lPitch;
	DWORD			dwLinearSize;
    };
    WORD			wHeight;
    WORD			wWidth;
    DWORD			dwUsageCount;
    ULONG_PTR			dwReserved1;
    DDPIXELFORMAT		ddpfSurface;
} DDRAWI_DDRAWSURFACE_GBL;

#define DDRAWISURFGBL_MEMFREE			0x00000001L
#define DDRAWISURFGBL_SYSMEMREQUESTED		0x00000002L
#define DDRAWISURFGBL_ISGDISURFACE		0x00000004L
#define DDRAWISURFGBL_SOFTWAREAUTOFLIP		0x00000008L
#define DDRAWISURFGBL_LOCKNOTHOLDINGWIN16LOCK	0x00000010L
#define DDRAWISURFGBL_LOCKVRAMSTYLE		0x00000020L
#define DDRAWISURFGBL_LOCKBROKEN		0x00000040L
#define DDRAWISURFGBL_IMPLICITHANDLE		0x00000080L
#define DDRAWISURFGBL_ISCLIENTMEM		0x00000100L
#define DDRAWISURFGBL_HARDWAREOPSOURCE		0x00000200L
#define DDRAWISURFGBL_HARDWAREOPDEST		0x00000400L
#define DDRAWISURFGBL_HARDWAREOPSTARTED		(DDRAWISURFGBL_HARDWAREOPSOURCE|DDRAWISURFGBL_HARDWAREOPDEST)
#define DDRAWISURFGBL_VPORTINTERLEAVED		0x00000800L
#define DDRAWISURFGBL_VPORTDATA			0x00001000L
#define DDRAWISURFGBL_LATEALLOCATELINEAR	0x00002000L
#define DDRAWISURFGBL_SYSMEMEXECUTEBUFFER	0x00004000L
#define DDRAWISURFGBL_FASTLOCKHELD		0x00008000L
#define DDRAWISURFGBL_READONLYLOCKHELD		0x00010000L
#define DDRAWISURFGBL_DX8SURFACE		0x00080000L
#define DDRAWISURFGBL_DDHELDONTFREE		0x00100000L
#define DDRAWISURFGBL_NOTIFYWHENUNLOCKED	0x00200000L
#define DDRAWISURFGBL_RESERVED0			0x80000000L /* Reserved flag */

typedef struct _DDRAWI_DDRAWSURFACE_GBL_MORE {
    DWORD			dwSize;
    __GNU_EXTENSION union {
	DWORD			dwPhysicalPageTable;
	FLATPTR			fpPhysicalVidMem;
    };
    LPDWORD			pPageTable;
    DWORD			cPages;
    ULONG_PTR			dwSavedDCContext;
    FLATPTR			fpAliasedVidMem;
    ULONG_PTR			dwDriverReserved;
    ULONG_PTR			dwHELReserved;
    DWORD			cPageUnlocks;
    ULONG_PTR			hKernelSurface;
    DWORD			dwKernelRefCnt;
    LPDDCOLORCONTROL		lpColorInfo;
    FLATPTR			fpNTAlias;
    DWORD			dwContentsStamp;
    LPVOID			lpvUnswappedDriverReserved;
    LPVOID			lpDDRAWReserved2;
    DWORD			dwDDRAWReserved1;
    DWORD			dwDDRAWReserved2;
    FLATPTR			fpAliasOfVidMem;
} DDRAWI_DDRAWSURFACE_GBL_MORE;

/* the MS version of this macro was somewhat obfuscated and unreadable
 * (possibly because of mediocre MS coders)... so I simplified it...
 * (and so I commit no copyright violations either, hah) */
#define GET_LPDDRAWSURFACE_GBL_MORE(psurf_gbl) \
    (*(((LPDDRAWI_DDRAWSURFACE_GBL_MORE *)(psurf_gbl)) - 1))

#define SURFACE_PHYSICALVIDMEM( psurf_gbl ) \
    ( GET_LPDDRAWSURFACE_GBL_MORE(psurf_gbl )->fpPhysicalVidMem )


typedef struct  _DISPLAYMODEINFO {
    WORD		wWidth;
    WORD		wHeight;
    BYTE		wBPP;
    BYTE		wMonitorsAttachedToDesktop;
    WORD		wRefreshRate;
} DISPLAYMODEINFO, *LPDISPLAYMODEINFO;

#define EQUAL_DISPLAYMODE ( A, B ) (0 == memcmp(&(A), &(B), sizeof (DISPLAYMODEINFO)))


typedef struct _DDRAWI_DDRAWSURFACE_MORE {
    DWORD			dwSize;
    IUNKNOWN_LIST *		lpIUnknowns;
    LPDDRAWI_DIRECTDRAW_LCL	lpDD_lcl;
    DWORD			dwPageLockCount;
    DWORD			dwBytesAllocated;
    LPDDRAWI_DIRECTDRAW_INT	lpDD_int;
    DWORD			dwMipMapCount;
    LPDDRAWI_DDRAWCLIPPER_INT	lpDDIClipper;
    /* DirectX 5.0 */
    LPHEAPALIASINFO		lpHeapAliasInfo;
    DWORD			dwOverlayFlags;
    VOID			*rgjunc;
    LPDDRAWI_DDVIDEOPORT_LCL	lpVideoPort;
    LPDDOVERLAYFX		lpddOverlayFX;
    DDSCAPSEX			ddsCapsEx;
    DWORD			dwTextureStage;
    LPVOID			lpDDRAWReserved;
    LPVOID			lpDDRAWReserved2;
    LPVOID			lpDDrawReserved3;
    DWORD			dwDDrawReserved4;
    LPVOID			lpDDrawReserved5;
    LPDWORD			lpGammaRamp;
    LPDWORD			lpOriginalGammaRamp;
    LPVOID			lpDDrawReserved6;
# ifndef WIN95
    DISPLAYMODEINFO dmiDDrawReserved7;
# endif
    DWORD			dwSurfaceHandle;
    DWORD			qwDDrawReserved8[2];
    LPVOID			lpDDrawReserved9;
    DWORD			cSurfaces;
    LPDDSURFACEDESC2		pCreatedDDSurfaceDesc2;
    LPDDRAWI_DDRAWSURFACE_LCL	*slist;
    DWORD			dwFVF;
    LPVOID			lpVB;
} DDRAWI_DDRAWSURFACE_MORE;


typedef struct _DDRAWI_DDRAWSURFACE_LCL {
    LPDDRAWI_DDRAWSURFACE_MORE	lpSurfMore;
    LPDDRAWI_DDRAWSURFACE_GBL	lpGbl;
    ULONG_PTR			hDDSurface;
    LPATTACHLIST		lpAttachList;
    LPATTACHLIST		lpAttachListFrom;
    DWORD			dwLocalRefCnt;
    DWORD			dwProcessId;
    DWORD			dwFlags;
    DDSCAPS			ddsCaps;
    __GNU_EXTENSION union {
      LPDDRAWI_DDRAWPALETTE_INT	lpDDPalette;
      LPDDRAWI_DDRAWPALETTE_INT	lp16DDPalette;
    };
    __GNU_EXTENSION union  {
      LPDDRAWI_DDRAWCLIPPER_LCL	lpDDClipper;
      LPDDRAWI_DDRAWCLIPPER_INT	lp16DDClipper;
    };
    DWORD			dwModeCreatedIn;
    DWORD			dwBackBufferCount;
    DDCOLORKEY			ddckCKDestBlt;
    DDCOLORKEY			ddckCKSrcBlt;
    ULONG_PTR			hDC;
    ULONG_PTR			dwReserved1;
    DDCOLORKEY			ddckCKSrcOverlay;
    DDCOLORKEY			ddckCKDestOverlay;
    LPDDRAWI_DDRAWSURFACE_INT	lpSurfaceOverlaying;
    DBLNODE			dbnOverlayNode;
    RECT			rcOverlaySrc;
    RECT			rcOverlayDest;
    DWORD			dwClrXparent;
    DWORD			dwAlpha;
    LONG			lOverlayX;
    LONG			lOverlayY;
} DDRAWI_DDRAWSURFACE_LCL;

#define DDRAWISURF_ATTACHED		0x00000001L
#define DDRAWISURF_IMPLICITCREATE	0x00000002L
#define DDRAWISURF_ISFREE		0x00000004L
#define DDRAWISURF_ATTACHED_FROM	0x00000008L
#define DDRAWISURF_IMPLICITROOT		0x00000010L
#define DDRAWISURF_PARTOFPRIMARYCHAIN	0x00000020L
#define DDRAWISURF_DATAISALIASED	0x00000040L
#define DDRAWISURF_HASDC		0x00000080L
#define DDRAWISURF_HASCKEYDESTOVERLAY	0x00000100L
#define DDRAWISURF_HASCKEYDESTBLT	0x00000200L
#define DDRAWISURF_HASCKEYSRCOVERLAY	0x00000400L
#define DDRAWISURF_HASCKEYSRCBLT	0x00000800L
#define DDRAWISURF_LOCKEXCLUDEDCURSOR	0x00001000L
#define DDRAWISURF_HASPIXELFORMAT	0x00002000L
#define DDRAWISURF_HASOVERLAYDATA	0x00004000L
#define DDRAWISURF_SETGAMMA		0x00008000L
#define DDRAWISURF_SW_CKEYDESTOVERLAY	0x00010000L
#define DDRAWISURF_SW_CKEYDESTBLT	0x00020000L
#define DDRAWISURF_SW_CKEYSRCOVERLAY	0x00040000L
#define DDRAWISURF_SW_CKEYSRCBLT	0x00080000L
#define DDRAWISURF_HW_CKEYDESTOVERLAY	0x00100000L
#define DDRAWISURF_HW_CKEYDESTBLT	0x00200000L
#define DDRAWISURF_HW_CKEYSRCOVERLAY	0x00400000L
#define DDRAWISURF_HW_CKEYSRCBLT	0x00800000L
#define DDRAWISURF_INMASTERSPRITELIST	0x01000000L
#define DDRAWISURF_HELCB		0x02000000L
#define DDRAWISURF_FRONTBUFFER		0x04000000L
#define DDRAWISURF_BACKBUFFER		0x08000000L
#define DDRAWISURF_INVALID		0x10000000L
#define DDRAWISURF_DCIBUSY		0x20000000L
#define DDRAWISURF_GETDCNULL		0x40000000L
#define DDRAWISURF_STEREOSURFACELEFT	0x20000000L
#define DDRAWISURF_DRIVERMANAGED	0x40000000L
#define DDRAWISURF_DCILOCK		0x80000000L

/* palettes */
typedef struct _DDRAWI_DDRAWPALETTE_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DDRAWPALETTE_LCL	lpLcl;
    LPDDRAWI_DDRAWPALETTE_INT	lpLink;
    DWORD			dwIntRefCnt;
} DDRAWI_DDRAWPALETTE_INT;

typedef struct _DDRAWI_DDRAWPALETTE_GBL {
    DWORD			dwRefCnt;
    DWORD			dwFlags;
    LPDDRAWI_DIRECTDRAW_LCL	lpDD_lcl;
    DWORD			dwProcessId;
    LPPALETTEENTRY		lpColorTable;
    __GNU_EXTENSION union {
	ULONG_PTR		dwReserved1;
	HPALETTE		hHELGDIPalette;
    };
    DWORD			dwDriverReserved;
    DWORD			dwContentsStamp;
    DWORD			dwSaveStamp;
    DWORD			dwHandle;
} DDRAWI_DDRAWPALETTE_GBL;

#define DDRAWIPAL_256				0x00000001
#define DDRAWIPAL_16				0x00000002
#define DDRAWIPAL_GDI				0x00000004
#define DDRAWIPAL_STORED_8			0x00000008
#define DDRAWIPAL_STORED_16			0x00000010
#define DDRAWIPAL_STORED_24			0x00000020
#define DDRAWIPAL_EXCLUSIVE			0x00000040
#define DDRAWIPAL_INHEL				0x00000080
#define DDRAWIPAL_DIRTY				0x00000100
#define DDRAWIPAL_ALLOW256			0x00000200
#define DDRAWIPAL_4				0x00000400
#define DDRAWIPAL_2				0x00000800
#define DDRAWIPAL_STORED_8INDEX			0x00001000
#define DDRAWIPAL_ALPHA				0x00002000

#define D3DFORMAT_OP_TEXTURE			0x00000001L
#define D3DFORMAT_OP_VOLUMETEXTURE		0x00000002L
#define D3DFORMAT_OP_CUBETEXTURE		0x00000004L
#define D3DFORMAT_OP_OFFSCREEN_RENDERTARGET	0x00000008L
#define D3DFORMAT_OP_SAME_FORMAT_RENDERTARGET	0x00000010L
#define D3DFORMAT_OP_ZSTENCIL			0x00000040L
#define D3DFORMAT_OP_ZSTENCIL_WITH_ARBITRARY_COLOR_DEPTH  0x00000080L
#define D3DFORMAT_OP_SAME_FORMAT_UP_TO_ALPHA_RENDERTARGET 0x00000100L
#define D3DFORMAT_OP_DISPLAYMODE		0x00000400L
#define D3DFORMAT_OP_3DACCELERATION		0x00000800L
#define D3DFORMAT_OP_PIXELSIZE			0x00001000L
#define D3DFORMAT_OP_CONVERT_TO_ARGB		0x00002000L
#define D3DFORMAT_OP_OFFSCREENPLAIN		0x00004000L
#define D3DFORMAT_OP_SRGBREAD			0x00008000L
#define D3DFORMAT_OP_BUMPMAP			0x00010000L
#define D3DFORMAT_OP_NOFILTER			0x00040000L

#define DDPF_D3DFORMAT				0x00200000l
#define DDPF_NOVEL_TEXTURE_FORMAT		0x00100000l

#define D3DFORMAT_MEMBEROFGROUP_ARGB		0x00080000L
#define D3DFORMAT_OP_SRGBWRITE			0x00100000L
#define D3DFORMAT_OP_NOALPHABLEND		0x00200000L
#define D3DFORMAT_OP_AUTOGENMIPMAP		0x00400000L
#define D3DFORMAT_OP_VERTEXTEXTURE		0x00800000L
#define D3DFORMAT_OP_NOTEXCOORDWRAPNORMIP	0x01000000L

#define DELETED_OK				0
#define DELETED_LASTONE				1
#define DELETED_NOTFOUND			2

#define DDCALLBACKSSIZE_V1			( offsetof(DDHAL_DDCALLBACKS, SetExclusiveMode) )
#define DDCALLBACKSSIZE				sizeof(DDHAL_DDCALLBACKS)

#define DDRAWICLIP_WATCHWINDOW			0x00000001
#define DDRAWICLIP_ISINITIALIZED		0x00000002
#define DDRAWICLIP_INMASTERSPRITELIST		0x00000004

#define PFINDEX_UNINITIALIZED			(0UL)
#define PFINDEX_UNSUPPORTED			(~0UL)

#define ROP_HAS_SOURCE				0x00000001l
#define ROP_HAS_PATTERN				0x00000002l
#define ROP_HAS_SOURCEPATTERN			ROP_HAS_SOURCE | ROP_HAS_PATTERN

#define DDRAWIVPORT_ON				0x00000001
#define DDRAWIVPORT_SOFTWARE_AUTOFLIP		0x00000002
#define DDRAWIVPORT_COLORKEYANDINTERP		0x00000004
#define DDRAWIVPORT_NOKERNELHANDLES		0x00000008
#define DDRAWIVPORT_SOFTWARE_BOB		0x00000010
#define DDRAWIVPORT_VBION			0x00000020
#define DDRAWIVPORT_VIDEOON			0x00000040

#define DDRAWI_GETCOLOR				0x0001
#define DDRAWI_SETCOLOR				0x0002

#define DDMCQUERY_READ				0x00000001
#define DDWAITVB_I_TESTVB			0x80000006

#define DDBLT_ANYALPHA							\
	(DDBLT_ALPHASRCSURFACEOVERRIDE | DDBLT_ALPHASRCCONSTOVERRIDE |	\
	 DDBLT_ALPHASRC | DDBLT_ALPHADESTSURFACEOVERRIDE |		\
	 DDBLT_ALPHADESTCONSTOVERRIDE | DDBLT_ALPHADEST)

#define DDHAL_ALIGNVALIDCAPS						\
	(DDSCAPS_OFFSCREENPLAIN | DDSCAPS_EXECUTEBUFFER |		\
	 DDSCAPS_OVERLAY | DDSCAPS_TEXTURE |				\
	 DDSCAPS_ZBUFFER | DDSCAPS_ALPHA | DDSCAPS_FLIP)

#define DDHALINFOSIZE_V2 sizeof(DDHALINFO)

#define DDOVER_ANYALPHA							\
	(DDOVER_ALPHASRCSURFACEOVERRIDE | DDOVER_ALPHASRCCONSTOVERRIDE |\
	 DDOVER_ALPHASRC | DDOVER_ALPHADESTSURFACEOVERRIDE |		\
	 DDOVER_ALPHADESTCONSTOVERRIDE | DDOVER_ALPHADEST)


typedef struct _DDRAWI_DDRAWPALETTE_LCL {
    DWORD			lpPalMore;
    LPDDRAWI_DDRAWPALETTE_GBL	lpGbl;
    ULONG_PTR			dwUnused0;
    DWORD			dwLocalRefCnt;
#ifndef _NO_COM
    IUnknown *			pUnkOuter;
#else
    PVOID			pUnkOuter;
#endif
    LPDDRAWI_DIRECTDRAW_LCL	lpDD_lcl;
    ULONG_PTR			dwReserved1;
    /* DirectX 6.0 */
    ULONG_PTR			dwDDRAWReserved1;
    ULONG_PTR			dwDDRAWReserved2;
    ULONG_PTR			dwDDRAWReserved3;
} DDRAWI_DDRAWPALETTE_LCL;


typedef struct _DDMCCOMPBUFFERINFO {
    DWORD			dwSize;
    DWORD			dwNumCompBuffers;
    DWORD			dwWidthToCreate;
    DWORD			dwHeightToCreate;
    DWORD			dwBytesToAllocate;
    DDSCAPS2			ddCompCaps;
    DDPIXELFORMAT		ddPixelFormat;
} DDMCCOMPBUFFERINFO, *LPDDMCCOMPBUFFERINFO;

typedef struct _DDMCBUFFERINFO {
    DWORD			dwSize;
    LPDDRAWI_DDRAWSURFACE_LCL	lpCompSurface;
    DWORD			dwDataOffset;
    DWORD			dwDataSize;
    LPVOID			lpPrivate;
} DDMCBUFFERINFO, *LPDDMCBUFFERINFO;

typedef struct _DDHAL_GETDRIVERSTATEDATA {
    DWORD			dwFlags;
    __GNU_EXTENSION union {
	ULONG_PTR		dwhContext;
    };
    LPDWORD			lpdwStates;
    DWORD			dwLength;
    HRESULT			ddRVal;
} DDHAL_GETDRIVERSTATEDATA;

typedef struct _DDHAL_ADDATTACHEDSURFACEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurfAttached;
    HRESULT				ddRVal;
    LPDDHALSURFCB_ADDATTACHEDSURFACE	AddAttachedSurface;
} DDHAL_ADDATTACHEDSURFACEDATA;


typedef struct _DDHAL_BEGINMOCOMPFRAMEDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDestSurface;
    DWORD			dwInputDataSize;
    LPVOID			lpInputData;
    DWORD			dwOutputDataSize;
    LPVOID			lpOutputData;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_BEGINFRAME	BeginMoCompFrame;
} DDHAL_BEGINMOCOMPFRAMEDATA;

typedef struct _DDHAL_COLORCONTROLDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    LPDDCOLORCONTROL		lpColorData;
    DWORD			dwFlags;
    HRESULT			ddRVal;
    LPDDHALCOLORCB_COLORCONTROL	ColorControl;
} DDHAL_COLORCONTROLDATA;

typedef struct _DDHAL_CREATEMOCOMPDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    LPGUID			lpGuid;
    DWORD			dwUncompWidth;
    DWORD			dwUncompHeight;
    DDPIXELFORMAT		ddUncompPixelFormat;
    LPVOID			lpData;
    DWORD			dwDataSize;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_CREATE	CreateMoComp;
} DDHAL_CREATEMOCOMPDATA;

typedef struct _DDHAL_DESTROYMOCOMPDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_DESTROY	DestroyMoComp;
} DDHAL_DESTROYMOCOMPDATA;

typedef struct _DDHAL_ENDMOCOMPFRAMEDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    LPVOID			lpInputData;
    DWORD			dwInputDataSize;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_ENDFRAME	EndMoCompFrame;
} DDHAL_ENDMOCOMPFRAMEDATA;

typedef struct _DDHAL_FLIPTOGDISURFACEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwToGDI;
    DWORD			dwReserved;
    HRESULT			ddRVal;
    LPDDHAL_FLIPTOGDISURFACE	FlipToGDISurface;
} DDHAL_FLIPTOGDISURFACEDATA;

typedef struct _DDHAL_GETAVAILDRIVERMEMORYDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DDSCAPS			DDSCaps;
    DWORD			dwTotal;
    DWORD			dwFree;
    HRESULT			ddRVal;
    LPDDHAL_GETAVAILDRIVERMEMORY GetAvailDriverMemory;
    DDSCAPSEX			ddsCapsEx;
} DDHAL_GETAVAILDRIVERMEMORYDATA;

typedef struct _DDHAL_GETBLTSTATUSDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    DWORD			dwFlags;
    HRESULT			ddRVal;
    LPDDHALSURFCB_GETBLTSTATUS	GetBltStatus;
} DDHAL_GETBLTSTATUSDATA;

typedef struct _DDHAL_GETFLIPSTATUSDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    DWORD			dwFlags;
    HRESULT			ddRVal;
    LPDDHALSURFCB_GETFLIPSTATUS	GetFlipStatus;
} DDHAL_GETFLIPSTATUSDATA;

typedef struct _DDHAL_GETINTERNALMOCOMPDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPGUID			lpGuid;
    DWORD			dwWidth;
    DWORD			dwHeight;
    DDPIXELFORMAT		ddPixelFormat;
    DWORD			dwScratchMemAlloc;
    HRESULT				ddRVal;
    LPDDHALMOCOMPCB_GETINTERNALINFO GetInternalMoCompInfo;
} DDHAL_GETINTERNALMOCOMPDATA;

typedef struct _DDHAL_GETMOCOMPCOMPBUFFDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPGUID			lpGuid;
    DWORD			dwWidth;
    DWORD			dwHeight;
    DDPIXELFORMAT		ddPixelFormat;
    DWORD			dwNumTypesCompBuffs;
    LPDDMCCOMPBUFFERINFO	lpCompBuffInfo;
    HRESULT				ddRVal;
    LPDDHALMOCOMPCB_GETCOMPBUFFINFO GetMoCompBuffInfo;
} DDHAL_GETMOCOMPCOMPBUFFDATA;

typedef struct _DDHAL_GETMOCOMPGUIDSDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    DWORD			dwNumGuids;
    LPGUID			lpGuids;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_GETGUIDS	GetMoCompGuids;
} DDHAL_GETMOCOMPGUIDSDATA;

typedef struct _DDHAL_GETMOCOMPFORMATSDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPGUID			lpGuid;
    DWORD			dwNumFormats;
    LPDDPIXELFORMAT		lpFormats;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_GETFORMATS	GetMoCompFormats;
} DDHAL_GETMOCOMPFORMATSDATA;

typedef struct _DDHAL_GETSCANLINEDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwScanLine;
    HRESULT			ddRVal;
    LPDDHAL_GETSCANLINE		GetScanLine;
} DDHAL_GETSCANLINEDATA;

typedef struct _DDHAL_QUERYMOCOMPSTATUSDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    LPDDRAWI_DDRAWSURFACE_LCL	lpSurface;
    DWORD			dwFlags;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_QUERYSTATUS	QueryMoCompStatus;
} DDHAL_QUERYMOCOMPSTATUSDATA;

typedef struct _DDHAL_RENDERMOCOMPDATA {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpMoComp;
    DWORD			dwNumBuffers;
    LPDDMCBUFFERINFO		lpBufferInfo;
    DWORD			dwFunction;
    LPVOID			lpInputData;
    DWORD			dwInputDataSize;
    LPVOID			lpOutputData;
    DWORD			dwOutputDataSize;
    HRESULT			ddRVal;
    LPDDHALMOCOMPCB_RENDER	RenderMoComp;
} DDHAL_RENDERMOCOMPDATA;

typedef struct _DDHAL_SETCOLORKEYDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    DWORD			dwFlags;
    DDCOLORKEY			ckNew;
    HRESULT			ddRVal;
    LPDDHALSURFCB_SETCOLORKEY	SetColorKey;
} DDHAL_SETCOLORKEYDATA;

typedef struct _DDHAL_SETOVERLAYPOSITIONDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSrcSurface;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDDestSurface;
    LONG				lXPos;
    LONG				lYPos;
    HRESULT				ddRVal;
    LPDDHALSURFCB_SETOVERLAYPOSITION SetOverlayPosition;
} DDHAL_SETOVERLAYPOSITIONDATA;

typedef struct _DDHAL_UPDATEOVERLAYDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDDestSurface;
    RECTL			rDest;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSrcSurface;
    RECTL			rSrc;
    DWORD			dwFlags;
    DDOVERLAYFX			overlayFX;
    HRESULT			ddRVal;
    LPDDHALSURFCB_UPDATEOVERLAY	UpdateOverlay;
} DDHAL_UPDATEOVERLAYDATA;

typedef struct _DDHAL_WAITFORVERTICALBLANKDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwFlags;
    DWORD			bIsInVB;
    ULONG_PTR			hEvent;
    HRESULT			ddRVal;
    LPDDHAL_WAITFORVERTICALBLANK WaitForVerticalBlank;
} DDHAL_WAITFORVERTICALBLANKDATA;

typedef struct _DDHAL_DRVSETCOLORKEYDATA {
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    DWORD			dwFlags;
    DDCOLORKEY			ckNew;
    HRESULT			ddRVal;
    LPDDHAL_SETCOLORKEY		SetColorKey;
} DDHAL_DRVSETCOLORKEYDATA;

typedef struct _DDMONITORINFO {
    WORD		Manufacturer;
    WORD		Product;
    DWORD		SerialNumber;
    GUID		DeviceIdentifier;
    int			Mode640x480;
    int			Mode800x600;
    int			Mode1024x768;
    int			Mode1280x1024;
    int			Mode1600x1200;
    int			ModeReserved1;
    int			ModeReserved2;
    int			ModeReserved3;
} DDMONITORINFO, FAR *LPDDMONITORINFO;

typedef struct _DDRAWI_DDRAWCLIPPER_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DDRAWCLIPPER_LCL	lpLcl;
    LPDDRAWI_DDRAWCLIPPER_INT	lpLink;
    DWORD		   dwIntRefCnt;
} DDRAWI_DDRAWCLIPPER_INT;

typedef struct _DDHAL_UPDATENONLOCALHEAPDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwHeap;
    FLATPTR			fpGARTLin;
    FLATPTR			fpGARTDev;
    ULONG_PTR			ulPolicyMaxBytes;
    HRESULT			ddRVal;
    LPDDHAL_UPDATENONLOCALHEAP	UpdateNonLocalHeap;
} DDHAL_UPDATENONLOCALHEAPDATA;

typedef struct _DDHAL_SETCLIPLISTDATA {
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    LPDDRAWI_DDRAWSURFACE_LCL	lpDDSurface;
    HRESULT			ddRVal;
    LPDDHALSURFCB_SETCLIPLIST	SetClipList;
} DDHAL_SETCLIPLISTDATA;

typedef struct _DDRAWI_DDMOTIONCOMP_LCL {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    GUID			guid;
    DWORD			dwUncompWidth;
    DWORD			dwUncompHeight;
    DDPIXELFORMAT		ddUncompPixelFormat;
    DWORD			dwInternalFlags;
    DWORD			dwRefCnt;
    DWORD			dwProcessId;
    HANDLE			hMoComp;
    DWORD		dwDriverReserved1;
    DWORD		dwDriverReserved2;
    DWORD		dwDriverReserved3;
    LPVOID		lpDriverReserved1;
    LPVOID		lpDriverReserved2;
    LPVOID		lpDriverReserved3;
} DDRAWI_DDMOTIONCOMP_LCL;

typedef struct _DDRAWI_DDMOTIONCOMP_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DDMOTIONCOMP_LCL	lpLcl;
    LPDDRAWI_DDMOTIONCOMP_INT	lpLink;
    DWORD			dwIntRefCnt;
} DDRAWI_DDMOTIONCOMP_INT;


typedef struct _DDRAWI_DDVIDEOPORT_LCL {
    LPDDRAWI_DIRECTDRAW_LCL	lpDD;
    DDVIDEOPORTDESC		ddvpDesc;
    DDVIDEOPORTINFO		ddvpInfo;
    LPDDRAWI_DDRAWSURFACE_INT	lpSurface;
    LPDDRAWI_DDRAWSURFACE_INT	lpVBISurface;
    LPDDRAWI_DDRAWSURFACE_INT	*lpFlipInts;
    DWORD			dwNumAutoflip;
    DWORD			dwProcessID;
    DWORD			dwStateFlags;
    DWORD			dwFlags;
    DWORD			dwRefCnt;
    FLATPTR			fpLastFlip;
    ULONG_PTR			dwReserved1;
    ULONG_PTR			dwReserved2;
    HANDLE			hDDVideoPort;
    DWORD			dwNumVBIAutoflip;
    LPDDVIDEOPORTDESC		lpVBIDesc;
    LPDDVIDEOPORTDESC		lpVideoDesc;
    LPDDVIDEOPORTINFO		lpVBIInfo;
    LPDDVIDEOPORTINFO		lpVideoInfo;
    DWORD			dwVBIProcessID;
    LPDDRAWI_DDVIDEOPORT_INT	lpVPNotify;
} DDRAWI_DDVIDEOPORT_LCL;


typedef struct _DDRAWI_DDVIDEOPORT_INT {
    LPVOID			lpVtbl;
    LPDDRAWI_DDVIDEOPORT_LCL	lpLcl;
    LPDDRAWI_DDVIDEOPORT_INT	lpLink;
    DWORD			dwIntRefCnt;
    DWORD			dwFlags;
} DDRAWI_DDVIDEOPORT_INT;


typedef struct _DDRAWI_DDRAWCLIPPER_LCL {
    DWORD			lpClipMore;
    LPDDRAWI_DDRAWCLIPPER_GBL	lpGbl;
    LPDDRAWI_DIRECTDRAW_LCL	lpDD_lcl;
    DWORD			dwLocalRefCnt;
#ifndef _NO_COM
    IUnknown *			pUnkOuter;
#else
    PVOID			pUnkOuter;
#endif
    LPDDRAWI_DIRECTDRAW_INT	lpDD_int;
    ULONG_PTR			dwReserved1;
#ifndef _NO_COM
    IUnknown *			pAddrefedThisOwner;
#else
    PVOID			pAddrefedThisOwner;
#endif
} DDRAWI_DDRAWCLIPPER_LCL;


typedef struct _DDRAWI_DDRAWCLIPPER_GBL {
    DWORD			dwRefCnt;
    DWORD			dwFlags;
    LPDDRAWI_DIRECTDRAW_GBL	lpDD;
    DWORD			dwProcessId;
    ULONG_PTR			dwReserved1;
    ULONG_PTR			hWnd;
    LPRGNDATA			lpStaticClipList;
} DDRAWI_DDRAWCLIPPER_GBL;

typedef WINBOOL (PASCAL *LPDDHEL_INIT)(LPDDRAWI_DIRECTDRAW_GBL,WINBOOL);

extern HRESULT DDAPI
       LateAllocateSurfaceMem(
                              LPDIRECTDRAWSURFACE lpSurface,
                              DWORD dwPleaseAllocType,
                              DWORD dwWidthInBytesOrSize,
                              DWORD dwHeight);

       LPDIRECTDRAWSURFACE GetNextMipMap(
                           LPDIRECTDRAWSURFACE lpLevel);


typedef struct IDirectDrawClipperVtbl DIRECTDRAWCLIPPERCALLBACKS;
typedef struct IDirectDrawPaletteVtbl DIRECTDRAWPALETTECALLBACKS;
typedef struct IDirectDrawSurfaceVtbl DIRECTDRAWSURFACECALLBACKS;
typedef struct IDirectDrawSurface2Vtbl DIRECTDRAWSURFACE2CALLBACKS;
typedef struct IDirectDrawSurface3Vtbl DIRECTDRAWSURFACE3CALLBACKS;
typedef struct IDirectDrawSurface4Vtbl DIRECTDRAWSURFACE4CALLBACKS;
typedef struct IDirectDrawSurface7Vtbl DIRECTDRAWSURFACE7CALLBACKS;
typedef struct IDirectDrawColorControlVtbl DIRECTDRAWCOLORCONTROLCALLBACKS;
typedef struct IDirectDrawVtbl DIRECTDRAWCALLBACKS;
typedef struct IDirectDraw2Vtbl DIRECTDRAW2CALLBACKS;
typedef struct IDirectDraw4Vtbl DIRECTDRAW4CALLBACKS;
typedef struct IDirectDraw7Vtbl DIRECTDRAW7CALLBACKS;
typedef struct IDirectDrawKernelVtbl DIRECTDRAWKERNELCALLBACKS;
typedef struct IDirectDrawSurfaceKernelVtbl DIRECTDRAWSURFACEKERNELCALLBACKS;
typedef struct IDirectDrawGammaControlVtbl DIRECTDRAWGAMMACONTROLCALLBACKS;

typedef DIRECTDRAWCLIPPERCALLBACKS  *LPDIRECTDRAWCLIPPERCALLBACKS;
typedef DIRECTDRAWPALETTECALLBACKS  *LPDIRECTDRAWPALETTECALLBACKS;
typedef DIRECTDRAWSURFACECALLBACKS  *LPDIRECTDRAWSURFACECALLBACKS;
typedef DIRECTDRAWCALLBACKS  *LPDIRECTDRAWCALLBACKS;


HRESULT CALLBACK
        D3DParseUnknownCommand (LPVOID lpvCommands,
                                LPVOID *lplpvReturnedCommand);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __DDRAWI_INCLUDED__ */

