#ifndef INOTIFY_WATCHERPARTIAL_H
#define INOTIFY_WATCHERPARTIAL_H

#include <stdint.h>

#include <string>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches a directory that could become a Maildir and creates a
// watcher_maildir if this happens
class watcher_partial : public watcher
{
  public:
	watcher_partial(struct inotify_state* state, const std::string& partial_maildir);
	virtual ~watcher_partial();

	virtual void process_event(const struct inotify_event& event);

  private:
	static const uint32_t notify = IN_MOVE | IN_CREATE | IN_DELETE | IN_DELETE_SELF;

	struct inotify_state* state;
	const std::string partial_maildir;

	int wd;
	bool cur_exists, new_exists;

	bool dir_exists(const char* dir) const;
	void transition_to_maildir();
	int start_watch(const char* dir);
	void stop_watch(int wd);
};

#endif // INOTIFY_WATCHERPARTIAL_H
