---
id: fast-foundation.textfield
title: TextField class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [TextField](./fast-foundation.textfield.md)

## TextField class

A Text Field Custom HTML Element. Based largely on the [&lt;input type="text" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/text)<!-- -->.


start - Content which can be provided before the number field input


end - Content which can be provided after the number field input


- The default slot for the label


label - The label


root - The element wrapping the control, including start and end slots


control - The text field element


change - Fires a custom 'change' event when the value has changed

<b>Signature:</b>

```typescript
export declare class TextField extends FormAssociatedTextField 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [autofocus](./fast-foundation.textfield.autofocus.md) |  | boolean | Indicates that this element should get focus after the page finishes loading. See [autofocus HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautofocus) for more information. |
|  [list](./fast-foundation.textfield.list.md) |  | string | Allows associating a [datalist](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist) to the element by [https://developer.mozilla.org/en-US/docs/Web/API/Element/id](https://developer.mozilla.org/en-US/docs/Web/API/Element/id)<!-- -->. |
|  [maxlength](./fast-foundation.textfield.maxlength.md) |  | number | The maximum number of characters a user can enter. |
|  [minlength](./fast-foundation.textfield.minlength.md) |  | number | The minimum number of characters a user can enter. |
|  [pattern](./fast-foundation.textfield.pattern.md) |  | string | A regular expression that the value must match to pass validation. |
|  [placeholder](./fast-foundation.textfield.placeholder.md) |  | string | Sets the placeholder value of the element, generally used to provide a hint to the user. |
|  [readOnly](./fast-foundation.textfield.readonly.md) |  | boolean | When true, the control will be immutable by user interaction. See [readonly HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly) for more information. |
|  [size](./fast-foundation.textfield.size.md) |  | number | Sets the width of the element to a specified number of characters. |
|  [spellcheck](./fast-foundation.textfield.spellcheck.md) |  | boolean | Controls whether or not to enable spell checking for the input field, or if the default spell checking configuration should be used. |
|  [type](./fast-foundation.textfield.type.md) |  | [TextFieldType](./fast-foundation.textfieldtype.md) | Allows setting a type or mode of text. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [select()](./fast-foundation.textfield.select.md) |  | Selects all the text in the text field |
