# getDirectoryToWatchFailedLookupLocationAtTypes

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                                     | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                                      | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                                       | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                                      | true      |

## RootDirForResolution: /folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                                    | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                                     | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                                     | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1                                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1                                                                             | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                                      | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                                      | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1                                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1                                                                              | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                                       | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                                       | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1                                                                               | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: /home

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                                      | true      |

## RootDirForResolution: /home/username

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                                      | true      |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| /user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/node_modules                                                                         | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| /usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                  |           |
| /usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                  |           |
| /usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                  |           |
| /usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/node_modules                                                                          | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| /home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                  |           |
| /home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                  |           |
| /home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                  |           |
| /home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                  |           |
| /home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                  |           |
| /home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/node_modules                                                                         | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1                                                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1                                                                              | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                                         | getDirectoryToWatchFailedLookupLocation                                                                          | Recursive |
| ---------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | --------- |
| /node_modules/@types/somefile.d.ts                                                                               |                                                                                                                  |           |
| /node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                  |           |
| /node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                  |           |
| /folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                  |           |
| /folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                  |           |
| /folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| /users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                  |           |
| /users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                  |           |
| /users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                  |           |
| /users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                  |           |
| /users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                  |           |
| /users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/node_modules                                                                        | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder