/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.core.component;

import org.apache.turbine.util.Log;
import org.chefproject.core.Event;
import org.chefproject.core.NotificationAction;
import org.chefproject.util.Email;
import org.chefproject.util.StringUtil;
import org.w3c.dom.Element;

public class EmailNotification
implements NotificationAction {
    protected String m_subject = null;
    protected String m_message = null;
    protected String m_from = null;
    protected String m_to = null;

    public EmailNotification() {
    }

    public void set(Element el) {
        this.m_subject = StringUtil.trimToNull(el.getAttribute("subject"));
        this.m_message = StringUtil.trimToNull(el.getAttribute("message"));
        this.m_from = StringUtil.trimToNull(el.getAttribute("from"));
        this.m_to = StringUtil.trimToNull(el.getAttribute("to"));
    }

    public void set(NotificationAction other) {
        EmailNotification eOther = (EmailNotification)other;
        this.m_subject = eOther.m_subject;
        this.m_message = eOther.m_message;
        this.m_from = eOther.m_from;
        this.m_to = eOther.m_to;
    }

    public NotificationAction getClone() {
        EmailNotification clone = new EmailNotification();
        clone.set(this);
        return clone;
    }

    public void toXml(Element el) {
        if (this.m_subject != null) {
            el.setAttribute("subject", this.m_subject);
        }
        if (this.m_message != null) {
            el.setAttribute("message", this.m_message);
        }
        if (this.m_from != null) {
            el.setAttribute("from", this.m_from);
        }
        if (this.m_to != null) {
            el.setAttribute("to", this.m_to);
        }
    }

    public EmailNotification(String from, String to, String subject, String message) {
        this.m_from = from;
        this.m_to = to;
        this.m_subject = subject;
        this.m_message = message;
    }

    public void notify(Event event) {
        String from = this.getFrom();
        String to = this.getTo();
        String subject = this.getSubject();
        String message = this.getMessage();
        String headerTo = this.getHeaderTo();
        String replyTo = this.getReplyTo();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + " sending email to: " + to);
        }
        Email.send(from, to, subject, message, headerTo, replyTo);
    }

    public String getFrom() {
        return this.m_from;
    }

    public String getTo() {
        return this.m_to;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getHeaderTo() {
        return null;
    }

    public String getReplyTo() {
        return null;
    }
}

