// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type RebuildInstanceRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 云主机ID  */
    InstanceId string `json:"instanceId"`

    /* 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。  */
    Password string `json:"password"`

    /* 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。 (Optional) */
    ImageId *string `json:"imageId"`

    /* 密钥对名称；当前只支持一个。仅Linux系统支持指定。 (Optional) */
    KeyNames []string `json:"keyNames"`
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 * param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewRebuildInstanceRequest(
    regionId string,
    instanceId string,
    password string,
) *RebuildInstanceRequest {

	return &RebuildInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        Password: password,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 * param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Required)
 * param imageId: 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。 (Optional)
 * param keyNames: 密钥对名称；当前只支持一个。仅Linux系统支持指定。 (Optional)
 */
func NewRebuildInstanceRequestWithAllParams(
    regionId string,
    instanceId string,
    password string,
    imageId *string,
    keyNames []string,
) *RebuildInstanceRequest {

    return &RebuildInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        Password: password,
        ImageId: imageId,
        KeyNames: keyNames,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewRebuildInstanceRequestWithoutParam() *RebuildInstanceRequest {

    return &RebuildInstanceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *RebuildInstanceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: 云主机ID(Required) */
func (r *RebuildInstanceRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。(Required) */
func (r *RebuildInstanceRequest) SetPassword(password string) {
    r.Password = password
}

/* param imageId: 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。(Optional) */
func (r *RebuildInstanceRequest) SetImageId(imageId string) {
    r.ImageId = &imageId
}

/* param keyNames: 密钥对名称；当前只支持一个。仅Linux系统支持指定。(Optional) */
func (r *RebuildInstanceRequest) SetKeyNames(keyNames []string) {
    r.KeyNames = keyNames
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r RebuildInstanceRequest) GetRegionId() string {
    return r.RegionId
}

type RebuildInstanceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result RebuildInstanceResult `json:"result"`
}

type RebuildInstanceResult struct {
}