% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildExhaustive.R
\name{buildExhaustive}
\alias{buildExhaustive}
\title{Prepare data for an exhaustive search}
\usage{
buildExhaustive(
  X,
  transposed = FALSE,
  distance = c("Euclidean", "Manhattan", "Cosine")
)
}
\arguments{
\item{X}{A numeric matrix where rows correspond to data points 
and columns correspond to variables (i.e., dimensions).}

\item{transposed}{Logical scalar indicating whether \code{X} is transposed, 
i.e., rows are variables and columns are data points.}

\item{distance}{String specifying the type of distance to use.}
}
\value{
An \linkS4class{ExhaustiveIndex} object containing indexed data.
}
\description{
Transform data in preparation for an exhaustive (i.e., brute-force) search.
}
\details{
This algorithm is largely provided as a baseline for comparing against the other algorithms.
On rare occasions, it may actually be useful in, e.g., very high-dimensional data 
where the indexing step of other algorithms adds computational overhead for no benefit.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
out <- buildExhaustive(Y)
out

}
\seealso{
\linkS4class{ExhaustiveIndex}, for details on the output class.

\code{\link{findExhaustive}} and \code{\link{queryExhaustive}}, for dependent functions.
}
\author{
Allison Vuong
}
