% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_models.R
\name{genSmoothCurveResiduals}
\alias{genSmoothCurveResiduals}
\title{Fit smooth spline curves and return the residuals matrix}
\usage{
genSmoothCurveResiduals(cds, trend_formula = "~sm.ns(Pseudotime, df = 3)",
  relative_expr = T, residual_type = "response", cores = 1)
}
\arguments{
\item{cds}{a CellDataSet object upon which to perform this operation}

\item{trend_formula}{a formula string specifying the model formula used in fitting the spline curve for each gene/feature.}

\item{relative_expr}{a logic flag to determine whether or not the relative gene expression should be used}

\item{residual_type}{the response desired, as accepted by VGAM's predict function}

\item{cores}{the number of cores to be used while testing each gene for differential expression}
}
\value{
a data frame containing the data for the fitted spline curves.
}
\description{
This function will fit smooth spline curves for the gene expression dynamics along pseudotime in a gene-wise manner and return
the corresponding residuals matrix. This function is build on other functions (fit_models and residualsMatrix)
}
