% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{makeDegenerate5merSub}
\alias{makeDegenerate5merSub}
\title{Make a degenerate 5-mer substitution model based on a 1-mer substitution model}
\usage{
makeDegenerate5merSub(sub1mer, extended = FALSE)
}
\arguments{
\item{sub1mer}{a 4x4 matrix containing (normalized) substitution rates.
Row names should correspond to nucleotides to mutate from.
Column names should correspond to nucleotides to mutate into.
Nucleotides should include "A", "T", "G", and "C" 
(case-insensitive).}

\item{extended}{whether to return the unextended (\code{extended=FALSE}) or 
extended (\code{extended=TRUE}) 5-mer substitution model. 
Default is \code{FALSE}.}
}
\value{
For \code{extended=FALSE}, a 4x1024 matrix. For \code{extended=TRUE}, a 5x3125 
          matrix.
}
\description{
\code{makeDegenerate5merSub} populates substitution rates from a 1-mer substitution model
into 5-mers with corresponding central 1-mers.
}
\details{
As a concrete example, consider a 1-mer substitution model in which substitution
          rates from "A" to "T", "G", and "C" are, respectively, 0.1, 0.6, and 0.3. In the 
          resultant degenerate 5-mer substitution model, all the 5-mers (columns) that have 
          an "A" as their central 1-mer would have substitution rates (rows) of 0.1, 0.6, and 
          0.3 to "T", "G", and "C" respectively. 
          
          When \code{extended=TRUE}, \code{extendSubstitutionMatrix} is called to extend
          the 4x1024 substitution matrix.
}
\examples{
# Make a degenerate 5-mer model (4x1024) based on HKL_S1F (4x4)
# Note: not to be confused with HKL_S5F@substitution, which is non-degenerate
degenerate5merSub <- makeDegenerate5merSub(sub1mer = HKL_S1F)

# Look at a few 5-mers
degenerate5merSub[, c("AAAAT", "AACAT", "AAGAT", "AATAT")]

}
\seealso{
See \link{makeAverage1merSub} for making a 1-mer substitution model by taking
          the average of a 5-mer substitution model. See \link{extendSubstitutionMatrix}
          for extending the substitution matrix.
}
