% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGeneSet.R
\name{loadGeneSet}
\alias{loadGeneSet}
\title{Load gene set data}
\usage{
loadGeneSet(
  organism = "hsapiens",
  enrichDatabase = NULL,
  enrichDatabaseFile = NULL,
  enrichDatabaseType = NULL,
  enrichDatabaseDescriptionFile = NULL,
  cache = NULL,
  hostName = "https://www.webgestalt.org/"
)
}
\arguments{
\item{organism}{Currently, WebGestaltR supports 12 organisms. Users can use the function
\code{listOrganism} to check available organisms. Users can also input \code{others} to
perform the enrichment analysis for other organisms not supported by WebGestaltR. For
other organisms, users need to provide the functional categories, interesting list and
reference list (for ORA method). Because WebGestaltR does not perform the ID mapping for
the other organisms, the above data should have the same ID type.}

\item{enrichDatabase}{The functional categories for the enrichment analysis. Users can use
the function \code{listGeneSet} to check the available functional databases for the
selected organism. Multiple databases in a vector are supported for ORA and GSEA.}

\item{enrichDatabaseFile}{Users can provide one or more GMT files as the functional
category for enrichment analysis. The extension of the file should be \code{gmt} and the
first column of the file is the category ID, the second one is the external link for the
category. Genes annotated to the category are from the third column. All columns are
separated by tabs. The GMT files will be combined with \code{enrichDatabase}.}

\item{enrichDatabaseType}{The ID type of the genes in the \code{enrichDatabaseFile}.
If users set \code{organism} as \code{others}, users do not need to set this ID type because
WebGestaltR will not perform ID mapping for other organisms. The supported ID types of
WebGestaltR for the selected organism can be found by the function \code{listIdType}.}

\item{enrichDatabaseDescriptionFile}{Users can also provide description files for the custom
\code{enrichDatabaseFile}. The extension of the description file should be \code{des}. The
description file contains two columns: the first column is the category ID that should be
exactly the same as the category ID in the custom \code{enrichDatabaseFile} and the second
column is the description of the category. All columns are separated by tabs.}

\item{cache}{A directory to save data cache for reuse. Defaults to \code{NULL} and disabled.}

\item{hostName}{The server URL for accessing data. Mostly for development purposes.}
}
\value{
A list of \code{geneSet}, \code{geneSetDes}, \code{geneSetDag}, \code{geneSetNet}, \code{standardId}.
\describe{
 \item{geneSet}{Gene set: A data frame with columns of "geneSet", "description", "genes"}
 \item{geneSetDes}{Description: A data frame with columns of two columns of gene set ID and description}
 \item{geneSetDag}{DAG: A edge list data frame of two columns of parent and child. Or a list of data frames if multilple databases are given.}
 \item{geneSetNet}{Network: A edge list data frame of two columns connecting nodes. Or a list of data frames if multilple databases are given.}
 \item{standardId}{The standard ID of the gene set}
}
}
\description{
Load gene set data
}
