RabbitMQ `3.10.2` is a maintenance release in the `3.10.x` release series.

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires at least Erlang 23.2, and supports Erlang 24 and 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * 40 to 50% throughput improvement for some workloads where AMQP 0-9-1 clients
   consumed from a [stream](https://rabbitmq.com/stream.html).

   GitHub issue: [#4811](https://github.com/rabbitmq/rabbitmq-server/pull/4811)

 * Configuration of fallback secrets for Shovel and Federation credential obfuscation.
   This feature allows for secret rotation during rolling cluster node restarts.

   Contributed by Lajos @luos Gerecs.

   GitHub issue: [#4847](https://github.com/rabbitmq/rabbitmq-server/pull/4847)

 * Reduced memory footprint of individual [consumer acknowledgements](https://rabbitmq.com/confirms.html) of quorum queue consumers.

   GitHub issue: [#4801](https://github.com/rabbitmq/rabbitmq-server/pull/4801)

 * Reduced filesystem I/O contention for workloads where a large number of classic
   queues v2 (CQv2) were concurrently deleted.

   GitHub issue: [#4844](https://github.com/rabbitmq/rabbitmq-server/pull/4844)

#### Bug Fixes

 * Default log level used a four-character severity abbreviation instead of more
   common longer format, for example, `warn` instead of `warning`.

   GitHub issue: [#4800](https://github.com/rabbitmq/rabbitmq-server/pull/4800)

### CLI Tools

#### Enhancements

 * `rabbitmq-diagnostics status` now reports crypto library (OpenSSL, LibreSSL, etc)
   used by the runtime, as well as its version details.

   GitHub issue: [#4799](https://github.com/rabbitmq/rabbitmq-server/issues/4799)

#### Bug Fixes

 * CLI tools failed to run on Erlang 25 because of an old version of Elixir (compiled on Erlang 21)
   was used in the release pipeline. Erlang 25 no longer loads modules
   compiled on Erlang 21 or older.

 * `rabbitmqctl set_log_level` documentation clarification.

   Contributed by Péter @gomoripeti Gömöri (CloudAMQP).

   GitHub issue: [#4794](https://github.com/rabbitmq/rabbitmq-server/pull/4794)


## Dependency Upgrades

 * `credentials_obfuscation` was upgraded [from v3.0.0 to v3.1.0](https://github.com/rabbitmq/credentials-obfuscation/compare/v3.0.0...v3.1.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.2.tar.xz`
instead of the source tarball produced by GitHub.
