#! /bin/sh

# Test fk visualisation in tables using dedicated (denormalised) views
# that provide information for human-friendly fk representation. Uses
# configuration provided in 'fmttable'.

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=test_fmttable.db
TMP_DB_FILE=${TMP_DB_DIR}/${TMP_TEST_DB}
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

# Create databases with data and metatdata, insert some values:

sqlite3 ${TMP_DB_FILE} <<EOF

create table 'sample' ( id integer primary key autoincrement, label varchar(15) not null unique, name text, mw float );

create table 'batch' ( id integer primary key autoincrement, label varchar(15) not null unique, description text, sample_id integer not null );

create table 'experiment' ( 
    id integer primary key autoincrement,
    batch_id integer not null unique,
    label varchar(15) not null unique,
    exp_date date,
    xvalue float, yvalue float
);

create view batch_sample as
   select 
       batch.id as id,   
       batch.label as batch_label,
       sample.id as sample_id,
       sample.label as sample_label,
       sample.name as sample_name,
       sample.mw as mw
   from
       batch
       join sample on batch.sample_id = sample.id
;

insert into sample values (1,'S-SG0001','Some protein',130);
insert into sample values (2,'S-SG0002','Larger protein',283.4);
insert into sample values (3,'S-SG0004','Complex I',600.3);

insert into batch values (1,'B-SG0001','Batch A',1);
insert into batch values (2,'B-SG0002','Batch B',1);
insert into batch values (3,'B-SG0003','Batch C',1);
insert into batch values (4,'B-SG0014','Batch X',2);
insert into batch values (5,'B-SG0015','Batch Y',2);

insert into experiment values (1,1,'LIBS-001','2017-12-23',8.31,NULL);
insert into experiment values (2,2,'EXAFS-02','2017-12-23',18.4,0.02);
insert into experiment values (3,5,'SCXRD-01','2017-12-23',18.4,0.02);

EOF

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<EOF

insert into description (id,dbname, dbtable, dbcolumn, coltype) values (1,'${TMP_DB_FILE_ABS}', 'batch', 'id', 'id');
insert into description (dbname, dbtable, dbcolumn, coltype, fk_target, relation) values ('${TMP_DB_FILE_ABS}', 'experiment', 'batch_id', 'fk', 1, 'N');
insert into fk_format (dbname, dbtable,fmttable,format) values 
    ('${TMP_DB_FILE_ABS}', 'batch', 'batch_sample', '%(batch_label)s (%(sample_label)s "%(sample_name)s", %(mw)4.1f kDa)');

EOF

# Set up the environment as the Web server would set it and run the
# tested CGI script:

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/experiment"
export REQUEST_METHOD=get
export HTTP_HOST=test.domain.net

${INPUT_SCRIPT}

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
