<?php

require_once(__DIR__ . '/DealabsBridge.php');
class MydealsBridge extends PepperBridgeAbstract {

	const NAME = 'Mydeals bridge';
	const URI = 'https://www.mydealz.de/';
	const DESCRIPTION = 'Zeigt die Deals von mydeals.de';
	const MAINTAINER = 'sysadminstory';
	const PARAMETERS = array(
		'Suche nach Stichworten' => array (
			'q' => array(
				'name' => 'Stichworten',
				'type' => 'text',
				'required' => true
			),
			'hide_expired' => array(
				'name' => 'Abgelaufenes ausblenden',
				'type' => 'checkbox',
			),
			'hide_local' => array(
				'name' => 'Lokales ausblenden',
				'type' => 'checkbox',
				'title' => 'Deals im physischen Geschäft ausblenden',
			),
			'priceFrom' => array(
				'name' => 'Minimaler Preis',
				'type' => 'text',
				'title' => 'Minmaler Preis in Euros',
				'required' => false
			),
			'priceTo' => array(
				'name' => 'Maximaler Preis',
				'type' => 'text',
				'title' => 'maximaler Preis in Euro',
				'required' => false
			),
		),

		'Deals pro Gruppen' => array(
			'group' => array(
				'name' => 'Gruppen',
				'type' => 'list',
				'title' => 'Gruppe, deren Deals angezeigt werden müssen',
				'values' => array(
					'1Password' => '1password',
					'3D Drucker' => '3d-drucker',
					'4K Fernseher' => '4k-fernseher',
					'4K Monitore' => '4k-monitor',
					'4K Ultra HD Blu-ray' => 'ultra-hd-blu-ray',
					'8K Fernseher' => '8k-fernseher',
					'32 Zoll Fernseher' => '32-zoll-fernseher',
					'55 Zoll Fernseher' => '55-zoll-fernseher',
					'65 Zoll Fernseher' => '65-zoll-fernseher',
					'75 Zoll Fernseher' => '75-zoll-fernseher',
					'1151 Mainboard' => '1151-mainboard',
					'Abus' => 'abus',
					'ABUS Fahrradschlösser' => 'abus-fahrradschloss',
					'Accessoires' => 'accessoires',
					'Acer' => 'acer',
					'Acer Aspire' => 'acer-aspire',
					'Acer Laptops' => 'acer-laptop',
					'Acer Monitore' => 'acer-monitor',
					'Acer Predator' => 'acer-predator',
					'Action Cameras' => 'actioncam',
					'Actionfiguren' => 'actionfiguren',
					'adidas' => 'adidas',
					'adidas Essentials' => 'adidas-neo',
					'adidas Iniki' => 'adidas-iniki',
					'adidas NMD' => 'adidas-nmd',
					'adidas Originals' => 'adidas-originals',
					'adidas Schuhe' => 'adidas-schuhe',
					'adidas Superstar' => 'adidas-superstar',
					'adidas Ultraboost' => 'adidas-ultraboost',
					'adidas ZX Flux' => 'adidas-zx-flux',
					'Adventskalender' => 'adventskalender',
					'AEG' => 'aeg',
					'AEG Waschmaschinen' => 'aeg-waschmaschine',
					'Age of Empires' => 'age-of-empires',
					'AiO Wasserkühlung' => 'aio-wasserkuehlung',
					'AKG' => 'akg',
					'Akkus' => 'akkus',
					'Akkuschrauber' => 'akkuschrauber',
					'Alfa Romeo' => 'alfa-romeo',
					'Alienware' => 'alienware',
					'Alkohol' => 'alkohol',
					'All Inclusive Reisen' => 'all-inclusive',
					'All in One PCs' => 'all-in-one-pcs',
					'AM4 Mainboard' => 'am4-mainboard',
					'Amazfit' => 'xiaomi-amazfit',
					'Amazfit Bip' => 'amazfit-bip',
					'Amazfit GTS' => 'amazfit-gts',
					'Amazon Echo' => 'amazon-echo',
					'Amazon Echo Dot' => 'amazon-echo-dot',
					'Amazon Echo Plus' => 'amazon-echo-plus',
					'Amazon Echo Show' => 'amazon-echo-show',
					'Amazon Echo Show 5' => 'amazon-echo-show-5',
					'Amazon Echo Show 8' => 'amazon-echo-show-8',
					'Amazon Echo Spot' => 'amazon-echo-spot',
					'Amazon Fire TV Cube' => 'fire-tv-cube',
					'Amazon Fire TV Stick' => 'fire-tv',
					'Amazon Fire TV Stick 4K' => 'fire-tv-stick-4k',
					'Amazon Tablets' => 'amazon-tablet',
					'Amazon Warehouse Deals' => 'amazon-warehouse-deals',
					'AMD' => 'amd',
					'AMD Radeon' => 'amd-radeon',
					'AMD Radeon VII' => 'vega-7',
					'AMD RX Vega' => 'amd-vega',
					'AMD Ryzen' => 'amd-ryzen',
					'AMD Ryzen 9 5900X' => 'amd-ryzen-9-5900x',
					'American Express' => 'american-express',
					'amiibo' => 'amiibo',
					'Analoguhren' => 'analoguhren',
					'Android Apps' => 'android-apps',
					'Android Smartphones' => 'android-smartphones',
					'Angelzubehör' => 'angelsport',
					'Animal Crossing' => 'animal-crossing',
					'Animal Crossing: New Horizons' => 'animal-crossing-new-horizons',
					'Anime' => 'anime',
					'Ankündigungen' => 'ankundigungen',
					'Anno 1800' => 'anno-1800',
					'Anthem' => 'anthem',
					'Anzug' => 'anzug',
					'AOC' => 'aoc',
					'Apex Legends' => 'apex-legends',
					'Apotheke' => 'apotheke',
					'Apple' => 'apple',
					'Apple AirPods' => 'airpods',
					'Apple AirPods 2' => 'airpods-2',
					'Apple AirPods Max' => 'airpods-max',
					'Apple AirPods Pro' => 'airpods-pro',
					'Apple EarPods' => 'apple-earpods',
					'Apple HomePod' => 'homepod',
					'Apple HomePod mini' => 'apple-homepod-mini',
					'Apple Kopfhörer' => 'apple-kopfhoerer',
					'Apple Magic Mouse 2' => 'apple-magic-mouse-2',
					'Apple Pencil' => 'apple-pencil',
					'Apple Pencil 2' => 'apple-pencil-2',
					'Apple TV' => 'apple-tv',
					'Apple Watch' => 'apple-watch',
					'Apple Watch 3' => 'apple-watch-3',
					'Apple Watch 4' => 'apple-watch-4',
					'Apple Watch 5' => 'apple-watch-5',
					'Apple Watch 6' => 'apple-watch-6',
					'Apple Watch SE' => 'apple-watch-se',
					'Apps' => 'apps',
					'Aquaristik' => 'aquaristik',
					'Arbeitsspeicher' => 'arbeitsspeicher',
					'Arbeitszimmermöbel' => 'arbeitszimmer',
					'ASICS' => 'asics',
					'Assassin&#039;s Creed' => 'assassins-creed',
					'Assassin&#039;s Creed: Valhalla' => 'assassins-creed-valhalla',
					'Assassin&#039;s Creed Odyssey' => 'assassins-creed-odyssey',
					'Assassin&#039;s Creed Origins' => 'assassins-creed-origins',
					'ASTRO Gaming A50' => 'astro-gaming-a50',
					'ASUS' => 'asus',
					'ASUS Laptops' => 'asus-laptop',
					'Asus Mainboard' => 'asus-mainboard',
					'Asus Monitore' => 'asus-monitor',
					'ASUS ROG' => 'asus-rog',
					'ASUS Smartphones' => 'asus-smartphones',
					'Asus ZenBook' => 'asus-zenbook',
					'ASUS ZenFone 5' => 'asus-zenfone-5',
					'ASUS ZenFone 5Z' => 'asus-zenfone-5z',
					'Audi' => 'audi',
					'Audio &amp; HiFi' => 'audio-hifi',
					'Audioverstärker' => 'audioverstaerker',
					'Audio Zubehör' => 'audio-zubehoer',
					'Aukey' => 'aukey',
					'Außenleuchten' => 'aussenleuchten',
					'Auto &amp; Motorrad' => 'auto-motorrad',
					'Auto Bild' => 'auto-bild',
					'Auto Leasing' => 'auto-leasing',
					'Auto Leasing Gewerbe' => 'gewerbe-leasing',
					'Auto Leasing Privat' => 'privat-leasing',
					'Automatikuhren' => 'automatikuhr',
					'auto motor und sport' => 'auto-motor-sport',
					'Autoradio' => 'autoradio',
					'Auto Teile' => 'autoteile',
					'Autowäsche' => 'autowaesche',
					'Auto Zubehör' => 'auto',
					'AVM FRITZ!Box' => 'avm-fritz-box',
					'AVM FRITZ!Box 7490' => 'avm-fritz-box-7490',
					'AVM FRITZ!Box 7530' => 'avm-fritz-box-7530',
					'AVM FRITZ!Box 7580' => 'avm-fritz-box-7580',
					'AVM FRITZ!Box 7590' => 'avm-fritz-box-7590',
					'AVM FRITZ! DECT 301' => 'avm-fritz-dect-301',
					'AV Receiver' => 'av-receiver',
					'Baby &amp; Kind' => 'kinder',
					'Baby-Erstausstattung' => 'baby-erstausstattung',
					'Babybetten' => 'babybetten',
					'Baby Born' => 'baby-born',
					'Babykleidung' => 'babybekleidung',
					'Babynahrung' => 'babynahrung',
					'Babyphone' => 'babyphone',
					'Backofen &amp; Herd' => 'backofen-herd',
					'Backwaren' => 'backwaren',
					'Backzubehör' => 'backzubehoer',
					'Bademode' => 'bademode',
					'Badmöbel' => 'badezimmer',
					'Bahn-Tickets' => 'bahntickets',
					'Bahncard' => 'bahncard',
					'Balkonmöbel' => 'balkonmoebel',
					'Ballerinas' => 'ballerinas',
					'Bang &amp; Olufsen' => 'bang-olufsen',
					'Bank' => 'bank',
					'Barbie' => 'barbie',
					'Barclaycard' => 'barclaycard',
					'Bartschneider' => 'bartschneider',
					'Batterien' => 'batterien',
					'Battle.net' => 'battle-net',
					'Battlefield' => 'battlefield',
					'Battlefield 1' => 'battlefield-1',
					'Battlefield 5' => 'battlefield-5',
					'Bauknecht' => 'bauknecht',
					'Bauknecht Waschmaschinen' => 'bauknecht-waschmaschine',
					'Baumarkt' => 'baumarkt',
					'Bayonetta' => 'bayonetta',
					'Bayonetta 2' => 'bayonetta-2',
					'Beamer' => 'beamer',
					'Beamer Leinwand' => 'beamer-leinwand',
					'Beats by Dre' => 'beats-by-dre',
					'Beats Solo3' => 'beats-solo3',
					'Beats Solo Pro' => 'beats-solo-pro',
					'Beats Studio3' => 'beats-studio3',
					'Beauty &amp; Gesundheit' => 'beauty',
					'Beko' => 'beko',
					'Beleuchtung' => 'beleuchtung',
					'Belkin' => 'belkin',
					'Ben &amp; Jerry&#039;s' => 'ben-jerrys',
					'Bench' => 'bench',
					'BenQ' => 'benq',
					'BenQ Monitore' => 'benq-monitor',
					'be quiet!' => 'be-quiet',
					'be quiet! Netzteile' => 'be-quiet-netzteil',
					'Besteck' => 'besteck',
					'Bethesda' => 'bethesda',
					'Betten' => 'betten',
					'Bettwäsche' => 'bettwaesche',
					'beyerdynamic' => 'beyerdynamic',
					'Beyerdynamic MMX 300' => 'beyerdynamic-mmx-300',
					'BHs' => 'bhs',
					'Bier' => 'bier',
					'Biking &amp; Urban Sport' => 'biking-urban-sport',
					'Bildbearbeitungsprogramme' => 'bildbearbeitungsprogramme',
					'Birkenstock' => 'birkenstock',
					'Black &amp; Decker' => 'black-and-decker',
					'Blackberry Smartphones' => 'blackberry',
					'Black Desert Online' => 'black-desert-online',
					'Blazer' => 'blazer',
					'Blood &amp; Truth' => 'blood-truth',
					'Blu-ray' => 'blu-ray',
					'Blu-ray Player' => 'blu-ray-player',
					'Bluetooth Kopfhörer' => 'bluetooth-kopfhoerer',
					'Bluetooth Lautsprecher' => 'bluetooth-lautsprecher',
					'Blumen' => 'blumen',
					'Blusen' => 'blusen',
					'BMW' => 'bmw',
					'Bodenbelag' => 'bodenbelag',
					'Boho-Chic wohnen' => 'boho-chich-wohnen',
					'Bohrer' => 'bohrer',
					'Bohrhämmer' => 'bohrhaemmer',
					'Bohrmaschinen' => 'bohrmaschinen',
					'Bollerwagen' => 'bollerwagen',
					'Bombay Gin' => 'bombay',
					'Borderlands' => 'borderlands',
					'Borderlands 3' => 'borderlands-3',
					'Bosch' => 'bosch',
					'Bosch Akkuschrauber' => 'bosch-akkuschrauber',
					'Bosch Geschirrspüler' => 'bosch-geschirrspueler',
					'Bosch Kühlschränke' => 'bosch-kuehlschrank',
					'Bosch Waschmaschinen' => 'bosch-waschmaschine',
					'Bose' => 'bose',
					'Bose Headphones 700' => 'bose-headphones-700',
					'Bose Home Speaker 500' => 'bose-home-speaker-500',
					'Bose Kopfhörer' => 'bose-kopfhoerer',
					'Bose QuietComfort' => 'bose-quietcomfort',
					'Bose QuietComfort 35 II' => 'bose-quiet-comfort-35-ii',
					'Bose Solo 5' => 'bose-solo-5',
					'Bose SoundLink' => 'bose-soundlink',
					'Bose SoundTouch' => 'bose-soundtouch',
					'BOSS' => 'boss',
					'Bourbon' => 'bourbon',
					'Bowers &amp; Wilkins' => 'bowers-wilkins',
					'Boxershorts' => 'boxershorts',
					'Boxspringbetten' => 'boxspringbetten',
					'Braun' => 'braun',
					'Braun Rasierer' => 'braun-rasierer',
					'Braun Series 3' => 'braun-series-3',
					'Braun Series 5' => 'braun-series-5',
					'Braun Series 7' => 'braun-series-7',
					'Braun Series 9' => 'braun-series-9',
					'Bridgekameras' => 'bridgekamera',
					'Brigitte' => 'brigitte',
					'Brillen &amp; Kontaktlinsen' => 'brillen',
					'Brita' => 'brita',
					'Britax Römer' => 'britax-roemer',
					'Brotaufstrich' => 'brotaufstrich',
					'Brother Drucker' => 'brother-drucker',
					'Bücher' => 'buecher',
					'Bücher, Magazine &amp; Zeitschriften' => 'buecher-zeitschriften',
					'bugatti' => 'bugatti',
					'Bügeleisen' => 'buegeleisen',
					'Bügeln' => 'buegeln',
					'Buggy' => 'buggy',
					'Burger' => 'burger',
					'BURNHARD' => 'burnhard',
					'Bürobedarf' => 'buerobedarf',
					'Bürostühle' => 'buerostuhl',
					'Bus &amp; Bahn' => 'bus-bahn',
					'Business Mode' => 'business-mode',
					'c&#039;t  – Magazin für Computertechnik' => 'ct-magazin-computertechnik',
					'Cafissimo' => 'cafissimo',
					'Call of Duty' => 'call-of-duty',
					'Call of Duty: Black Ops 4' => 'call-of-duty-black-ops-4',
					'Call of Duty: Black Ops Cold War' => 'call-of-duty-black-ops-cold-war',
					'Call of Duty: Infinite Warfare' => 'call-of-duty-infinite-warfare',
					'Call of Duty: Modern Warfare' => 'call-of-duty-modern-warfare',
					'Call of Duty: Warzone' => 'call-of-duty-warzone',
					'Call of Duty: WW2' => 'call-of-duty-ww2',
					'Calvin Klein' => 'calvin-klein',
					'Camcorder' => 'camcorder',
					'Campen' => 'campen',
					'Canon' => 'canon',
					'Canon Drucker' => 'canon-drucker',
					'Canon EOS' => 'canon-eos',
					'Canon Kameras' => 'canon-kameras',
					'Canon PowerShot' => 'canon-powershot',
					'CANTON' => 'canton',
					'Caps' => 'caps',
					'Captain Toad: Treasure Tracker' => 'captain-toad-treasure-tracker',
					'Capture One' => 'capture-one',
					'Carhartt' => 'carhartt',
					'Carsharing' => 'carsharing',
					'Casio' => 'casio',
					'Cheap Monday' => 'cheapmonday',
					'Chevrolet' => 'chevrolet',
					'China Handys' => 'china-handys',
					'Chip (Magazin)' => 'chip-magazin',
					'Chips' => 'chips',
					'Christbaumschmuck' => 'christbaumschmuck',
					'Christbaumständer' => 'christbaumstaender',
					'Chromebook' => 'chromebook',
					'Chronographen' => 'chronograph',
					'Chucks' => 'chucks',
					'Citroen' => 'citroen',
					'Coca-Cola' => 'coca-cola',
					'Comics' => 'comics',
					'Computer' => 'computer',
					'Computer &amp; Tablets' => 'computer-tablet',
					'Computer Bild' => 'computer-bild',
					'Controller' => 'controller',
					'Converse' => 'converse',
					'Convertibles' => 'convertibles',
					'Corsair' => 'corsair',
					'Corsair VOID PRO' => 'corsair-void-pro',
					'Couchtische' => 'couchtische',
					'Coupons' => 'coupons',
					'CPU-Kühler' => 'cpu-kuehler',
					'Craghoppers' => 'craghoppers',
					'Crocs' => 'crocs',
					'Crucial' => 'crucial',
					'Cupra' => 'cupra',
					'Cyberpunk 2077' => 'cyberpunk-2077',
					'cybex' => 'cybex',
					'D-Link' => 'd-link',
					'DAB Radios' => 'dab-radios',
					'Dacia' => 'dacia',
					'Damenbekleidung' => 'fashion-frauen',
					'Damenschuhe' => 'damenschuhe',
					'Dampfbügelstation' => 'dampfbuegelstation',
					'Dampfgarer' => 'dampfgarer',
					'Dampfreiniger' => 'dampfreiniger',
					'Dark Souls' => 'dark-souls',
					'Dashcam' => 'dashcam',
					'Datentarif' => 'datentarif',
					'Daypack' => 'daypack',
					'Days Gone' => 'days-gone',
					'DC Shoes' => 'dc-shoes',
					'DDR3 RAM' => 'ddr3-ram',
					'DDR4 RAM' => 'ddr4-ram',
					'De&#039;Longhi' => 'delonghi',
					'Death Stranding' => 'death-stranding',
					'Deckenlampen' => 'deckenlampen',
					'DECT Telefone' => 'telefone',
					'Dekoration' => 'dekoration',
					'Dell' => 'dell',
					'Dell Laptops' => 'dell-laptop',
					'Dell Monitore' => 'dell-monitor',
					'Dell XPS' => 'dell-xps',
					'Denon' => 'denon',
					'Deo' => 'deo',
					'Depot' => 'depot',
					'DER SPIEGEL' => 'der-spiegel',
					'Designermöbel' => 'designermoebel',
					'Desigual' => 'desigual',
					'Desinfektionsmittel' => 'desinfektionsmittel',
					'Desktop PCs' => 'desktop-pc',
					'Dessous' => 'dessous',
					'Destiny' => 'destiny',
					'Destiny 2' => 'destiny-2',
					'Deus Ex' => 'deus-ex',
					'Deus Ex: Mankind' => 'deus-ex-mankind',
					'Deuter' => 'deuter',
					'DeutschlandCard' => 'deutschlandcard',
					'devolo' => 'devolo',
					'DeWalt' => 'dewalt',
					'Die drei Fragezeichen' => 'die-drei-fragezeichen',
					'Die Eiskönigin' => 'die-eiskoenigin',
					'Dienstleistungen &amp; Verträge' => 'dienstleistungen-vertraege',
					'Dies &amp; Das' => 'dies-das',
					'Diesel' => 'diesel',
					'Die Sims' => 'die-sims',
					'Die Sims 4' => 'die-sims-4',
					'Die Zeit' => 'die-zeit',
					'Digitalreceiver' => 'digitalreceiver',
					'Digitaluhren' => 'digitaluhr',
					'Direktflüge' => 'direktfluege',
					'Dirt Devil' => 'dirt-devil',
					'Dishonored' => 'dishonored',
					'Dishonored 2: Das Vermächtnis der Maske' => 'dishonored-2',
					'Disney' => 'disney',
					'Disney+' => 'disney-plus',
					'DJI' => 'dji',
					'DJI Osmo Pocket' => 'dji-osmo-pocket',
					'Dockers' => 'dockers',
					'Dolce Gusto' => 'dolce-gusto',
					'DOOM Eternal' => 'doom-eternal',
					'Douglas Adventskalender' => 'douglas-adventskalender',
					'Dr. Martens' => 'dr-martens',
					'Dragon Ball' => 'dragon-ball',
					'Dragon Ball FighterZ' => 'dragon-ball-fighterz',
					'Dragon Ball Z: Kakarot' => 'dragon-ball-z-kakarot',
					'Dragon Quest Builders' => 'dragon-quest-builders',
					'Dragon Quest Builders 2' => 'dragon-quest-builders-2',
					'Dreame Staubsauger' => 'xiaomi-staubsauger',
					'Dreame T20' => 'dreame-t20',
					'Dreame V9' => 'xiaomi-dreame-v9',
					'Dreame V10' => 'xiaomi-dreame-v10',
					'Dreame V11' => 'xiaomi-dreame-v11',
					'Drohnen' => 'drohnen',
					'Drucker' => 'drucker',
					'Druckerpatronen' => 'druckerpatronen',
					'Druckerzubehör' => 'druckerzubehoer',
					'DSL &amp; Kabel' => 'dsl',
					'Dunstabzugshauben' => 'dunstabzugshauben',
					'Durex' => 'durex',
					'Duscharmaturen' => 'duscharmaturen',
					'Duschgel' => 'duschgel',
					'Duschköpfe' => 'duschkoepfe',
					'DVD' => 'dvd',
					'Dyson' => 'dyson',
					'Dyson Staubsauger' => 'dyson-staubsauger',
					'Dyson V6' => 'dyson-v6',
					'Dyson V7' => 'dyson-v7',
					'Dyson V8' => 'dyson-v8',
					'Dyson V10' => 'dyson-v10',
					'Dyson V11' => 'dyson-v11',
					'Dyson V11 Absolute' => 'dyson-v11-absolute',
					'Dyson V11 Animal' => 'dyson-v11-animal',
					'E-Bikes' => 'e-bikes',
					'E-Scooter' => 'e-scooter',
					'E-Scooter Sharing' => 'e-scooter-sharing',
					'E-Zigaretten' => 'e-zigaretten',
					'Eastpak' => 'eastpak',
					'eBook Reader' => 'ebook-reader',
					'eBooks' => 'ebooks',
					'Ecovacs' => 'ecovacs',
					'Ecovacs Deebot 900' => 'ecovacs-deebot-900',
					'Ecovacs Deebot OZMO 930' => 'ecovacs-deebot-ozmo-930',
					'Edifier' => 'edifier',
					'Edifier R1280DB' => 'edifier-r1280db',
					'Edifier R1280T' => 'edifier-r1280t',
					'Einhell' => 'einhell',
					'Eis' => 'eis',
					'Elektrische Zahnbürsten' => 'elektrische-zahnbuersten',
					'Elektrogrills' => 'elektrogrill',
					'Elektroheizungen' => 'elektroheizungen',
					'Elektronik' => 'elektronik',
					'Elektronik Zubehör' => 'elektronikzubehoer',
					'Elektrorasierer' => 'elektrorasierer',
					'Elektroroller' => 'elektroroller',
					'Elektrowerkzeuge' => 'elektrowerkzeug',
					'Elephone' => 'elephone',
					'ELLE' => 'elle',
					'Emsa' => 'emsa',
					'Energy Drinks' => 'energy-drinks',
					'Entsafter' => 'entsafter',
					'Epilierer' => 'epilierer',
					'Epson' => 'epson',
					'Epson Drucker' => 'epson-drucker',
					'Erotik' => 'erotik',
					'Error Fare' => 'error-fare',
					'Espressomaschinen' => 'espressomaschinen',
					'Esprit' => 'esprit',
					'Esstische' => 'esstisch',
					'Esszimmer' => 'esszimmer',
					'Eterna' => 'eterna',
					'EUROtronic Comet DECT' => 'eurotronic-comet-dect',
					'Externe Festplatten' => 'externe-festplatten',
					'F1 2017' => 'f1-2017',
					'F1 2019' => 'f1-2019',
					'F1 2020' => 'f1-2020',
					'Fahrräder' => 'fahrraeder',
					'Fahrradhelme' => 'fahrradhelme',
					'Fahrradrucksäcke' => 'fahrradrucksack',
					'Fahrradschlösser' => 'fahrradschloss',
					'Fahrradteile' => 'fahrradteile',
					'Fahrradträger' => 'fahrradtraeger',
					'Fahrradzubehör' => 'fahrradzubehoer',
					'Fahrzeuge' => 'fahrzeuge',
					'Falke' => 'falke',
					'Fallout' => 'fallout',
					'Fallout 4' => 'fallout-4',
					'Fallout 76' => 'fallout-76',
					'Family &amp; Kids' => 'family-kids',
					'Far Cry' => 'far-cry',
					'Far Cry 5' => 'far-cry-5',
					'Far Cry New Dawn' => 'far-cry-new-dawn',
					'Fashion &amp; Accessoires' => 'fashion-accessoires',
					'Fast Food' => 'fast-food',
					'Felgen' => 'felgen',
					'Fenstersauger' => 'fenstersauger',
					'Fernbus-Tickets' => 'fernbus',
					'Fernseher' => 'fernseher',
					'Fertiggerichte' => 'fertiggerichte',
					'Festplatten' => 'festplatten',
					'Festplattengehäuse' => 'festplattengehaeuse',
					'FFP2 Masken' => 'ffp2-masken',
					'Fiat' => 'fiat',
					'FIFA' => 'fifa',
					'FIFA 17' => 'fifa-17',
					'FIFA 18' => 'fifa-18',
					'FIFA 19' => 'fifa-19',
					'FIFA 20' => 'fifa-20',
					'FIFA 21' => 'fifa-21',
					'FILA' => 'fila',
					'Filme &amp; Serien' => 'filme-serien',
					'Filterkaffeemaschinen' => 'filterkaffeemaschinen',
					'Final Fantasy' => 'final-fantasy',
					'Final Fantasy 7' => 'final-fantasy-7',
					'Finanzen- und Steuersoftware' => 'finanzen-und-steuersoftware',
					'Finish' => 'finish',
					'Fisch &amp; Meeresfrüchte' => 'fisch-meeresfruechte',
					'Fischertechnik' => 'fischertechnik',
					'Fisher-Price' => 'fisher-price',
					'Fiskars' => 'fiskars',
					'Fissler' => 'fissler',
					'fitbit' => 'fitbit',
					'Fitness &amp; Running' => 'fitness',
					'Fitness Apps' => 'fitness-apps',
					'Fitnessstudio' => 'fitnessstudio',
					'Fitnesstracker' => 'fitnesstracker',
					'Fjällräven' => 'fjaellraeven',
					'Fleisch &amp; Wurst' => 'fleisch-wurst',
					'Fliesenschneider' => 'fliesenschneider',
					'Flüge' => 'fluege',
					'Flurmöbel' => 'flurmoebel',
					'FOCUS' => 'focus',
					'Ford' => 'ford',
					'For Honor' => 'for-honor',
					'Formel 1 Games' => 'formel-1',
					'Fortnite' => 'fortnite',
					'Forza' => 'forza',
					'Forza Horizon' => 'forza-horizon',
					'Forza Horizon 4' => 'forza-horizon-4',
					'Forza Motorsport' => 'forza-motorsport',
					'Forza Motorsport 7' => 'forza-7',
					'Fossil' => 'fossil',
					'Foto &amp; Kamera' => 'foto-video',
					'Foto Apps' => 'foto-apps',
					'Fotobücher' => 'fotobuecher',
					'Fototapete' => 'fototapete',
					'Fragen &amp; Gesuche' => 'gesuche',
					'Frankfurter Allgemeine Zeitung (F.A.Z.)' => 'frankfurter-allgemeine-zeitung',
					'FreeSync Monitore' => 'freesync-monitor',
					'Freizeitpark-Tickets' => 'freizeitpark',
					'Freizeitsport' => 'freizeitsport',
					'Fritteusen' => 'fritteusen',
					'Frontlader' => 'frontlader',
					'Frühlingsdeko' => 'fruehlingsdeko',
					'Frühstücksflocken' => 'fruehstuecksflocken',
					'Fruit of the Loom' => 'fruit-of-the-loom',
					'Fujifilm' => 'fujifilm',
					'Füller' => 'fueller',
					'Full HD-Beamer' => 'full-hd-beamer',
					'Fun Factory' => 'fun-factory',
					'FurReal Friends' => 'furreal-friends',
					'Fußball' => 'fussball',
					'Fußball-Trikots' => 'fussball-trikots',
					'Fußballschuhe' => 'fussballschuhe',
					'G-Star' => 'g-star',
					'G-Sync Monitore' => 'g-sync-monitor',
					'Game of Thrones' => 'game-of-thrones',
					'Gaming' => 'gaming',
					'Gaming Headsets' => 'gaming-headset',
					'Gaming Laptops' => 'gaming-laptop',
					'Gaming Mäuse' => 'gaming-maus',
					'Gaming Monitore' => 'gaming-monitor',
					'Gaming PCs' => 'gaming-pc',
					'Gaming Stühle' => 'gaming-stuhl',
					'Gaming Tastaturen' => 'gaming-tastatur',
					'Gaming Zubehör' => 'spielekonsolen-zubehoer',
					'Ganzjahresreifen' => 'ganzjahresreifen',
					'GAP' => 'gap',
					'Gardena' => 'gardena',
					'Garderobe' => 'garderobe',
					'Garmin' => 'garmin',
					'Garmin Fenix' => 'garmin-fenix',
					'Garten' => 'garten',
					'Garten &amp; Baumarkt' => 'garten-baumarkt',
					'Gartenarbeit' => 'gartenarbeit',
					'Gartenbank' => 'gartenbank',
					'Gartenliegen' => 'sonnenliegen',
					'Gartenmöbel' => 'gartenmoebel',
					'Gartenstühle' => 'gartenstuehle',
					'Gartentische' => 'gartentische',
					'Gasgrills' => 'gasgrill',
					'Gastarif' => 'gastarif',
					'Gears 5' => 'gears-5',
					'Gears of War' => 'gears-of-war',
					'Gefrierschränke' => 'gefrierschrank',
					'Geld-zurück-Aktionen' => 'geld-zurueck',
					'Geldbörsen' => 'geldboersen',
					'Gemüse' => 'gemuese',
					'Geox' => 'geox',
					'Geschirr' => 'geschirr',
					'Geschirrspüler' => 'geschirrspueler',
					'Gesellschaftsspiele' => 'gesellschaftsspiele',
					'Gesichtspflege' => 'gesichtspflege',
					'Gesundheit' => 'gesundheit',
					'Getränke' => 'getraenke',
					'Gewinnspiele' => 'gewinnspiele',
					'GHD' => 'ghd',
					'Ghost of Tsushima' => 'ghost-of-tsushima',
					'GIGABYTE' => 'gigabyte',
					'Gigaset' => 'gigaset',
					'Gillette' => 'gillette',
					'Gillette Rasierer' => 'gillette-rasierer',
					'Gin' => 'gin',
					'Girokonto' => 'konto',
					'Glamour' => 'glamour',
					'Glamourös wohnen' => 'glamouroes-wohnen',
					'Gläser' => 'glaeser',
					'Glätteisen' => 'glaetteisen',
					'Gleitgel' => 'gleitgel',
					'Glühwein' => 'gluehwein',
					'God of War' => 'god-of-war',
					'Google Chromecast' => 'chromecast',
					'Google Chromecast mit Google TV' => 'chromecast-mit-google-tv',
					'Google Chromecast Ultra' => 'chromecast-ultra',
					'Google Home' => 'google-home',
					'Google Home Max' => 'google-home-max',
					'Google Home Mini' => 'google-home-mini',
					'Google Nest Hub' => 'google-nest-hub',
					'Google Pixel' => 'google-pixel',
					'Google Pixel 2' => 'google-pixel-2',
					'Google Pixel 3' => 'google-pixel-3',
					'Google Pixel 4' => 'google-pixel-4',
					'Google Pixel 4 XL' => 'google-pixel-4xl',
					'Google Pixel 4a' => 'google-pixel-4a',
					'Google Pixel 4a 5G' => 'google-pixel-4a-5g',
					'Google Pixel 5' => 'google-pixel-5',
					'Google Smartphones' => 'google-smartphones',
					'Google Stadia Konsolen' => 'google-stadia',
					'GoPro Action Cameras' => 'gopro',
					'GoPro HERO 7' => 'gopro-hero-7',
					'GoPro HERO 8' => 'gopro-hero-8',
					'GoPro HERO 9' => 'gopro-hero-9',
					'Gorenje' => 'gorenje',
					'Grafikkarten' => 'grafikkarten',
					'Gran Turismo' => 'gran-turismo',
					'Gran Turismo Sport' => 'gran-turismo-sport',
					'Grazia' => 'grazia',
					'Grills' => 'grill',
					'Grillzubehör' => 'grillzubehoer',
					'Grundig' => 'grundig',
					'GTA' => 'gta',
					'GTA V' => 'gta-v',
					'GTX 1060' => 'gtx-1060',
					'GTX 1070' => 'gtx-1070',
					'GTX 1080' => 'gtx-1080',
					'GTX 1080 Ti' => 'gtx-1080-ti',
					'GTX 1660' => 'gtx-1660',
					'GTX 1660 Ti' => 'gtx-1660-ti',
					'Gucci' => 'gucci',
					'Gummistiefel' => 'gummistiefel',
					'Gürtel' => 'guertel',
					'Gutscheinfehler' => 'gutscheinfehler',
					'Haarentfernung' => 'haarentfernung',
					'Haargel' => 'haargel',
					'Haarpflege' => 'haarpflege',
					'Haarschneidemaschinen' => 'haarschneidemaschinen',
					'Haarspray' => 'haarspray',
					'Haartrockner' => 'haartrockner',
					'Haftpflichtversicherung' => 'haftpflichtversicherung',
					'Hama' => 'hama',
					'Handelsblatt' => 'handelsblatt',
					'Handmixer' => 'handmixer',
					'Handtaschen' => 'handtaschen',
					'Handtücher' => 'handtuecher',
					'Handwerkzeuge' => 'handwerkzeug',
					'Handy &amp; Smartphone Zubehör' => 'smartphone-zubehoer',
					'Handyhalterung' => 'handyhalterung',
					'Handyhüllen' => 'handyhuelle',
					'Handys mit Vertrag' => 'handys-mit-vertrag',
					'Handys ohne Vertrag' => 'handys-ohne-vertrag',
					'Handyversicherung' => 'handyversicherung',
					'Handyverträge' => 'handyvertraege',
					'Handyverträge 3 Monate Kündigungsfrist' => 'handyvertraege-3-monate-kuendigungsfrist',
					'Handyverträge monatlich kündbar' => 'handyvertraege-monatlich-kuendbar',
					'Hängematten' => 'haengematten',
					'Hanteln' => 'hanteln',
					'Haribo' => 'haribo',
					'Harman Kardon' => 'harman-kardon',
					'Harry Potter' => 'harry-potter',
					'Hasbro' => 'hasbro',
					'Haushaltsartikel' => 'haushaltsartikel',
					'Haushaltsgeräte' => 'haushaltsgeraete',
					'Haushaltswaren' => 'haushaltswaren',
					'Hausratversicherung' => 'hausratsversicherung',
					'Hausschuhe' => 'hausschuhe',
					'Haustier' => 'haustier',
					'Hautpflege' => 'hautpflege',
					'Head &amp; Shoulders' => 'head-and-shoulders',
					'Heckenscheren' => 'heckenschere',
					'Heimkino' => 'heimkino',
					'Heimtextilien' => 'heimtextilien',
					'Heißluftfritteusen' => 'heissluftfriteuse',
					'Heizkörperthermostat' => 'heizkoerperthermostat',
					'Heizungen' => 'heizungen',
					'Hemden' => 'hemden',
					'Hendrick&#039;s Gin' => 'hendricks-gin',
					'Herbstdeko' => 'herbstdeko',
					'Herrenbekleidung' => 'fashion-maenner',
					'Herrenschuhe' => 'herrenschuhe',
					'HiPP' => 'hipp',
					'Hisense' => 'hisense',
					'Hochbetten' => 'hochbetten',
					'Hochdruckreiniger' => 'hochdruckreiniger',
					'Hochstuhl' => 'hochstuhl',
					'Hollywoodschaukel' => 'hollywoodschaukel',
					'Home &amp; Living' => 'home-living',
					'homee' => 'homee',
					'Honda' => 'honda',
					'Honor' => 'honor',
					'Honor 5' => 'honor-5',
					'Honor 6' => 'honor-6',
					'Honor 7X' => 'honor-7',
					'Honor 8' => 'honor-8',
					'Honor 9' => 'honor-9',
					'Honor 20' => 'honor-20',
					'Honor 20 Lite' => 'honor-20-lite',
					'Honor Band 4' => 'honor-band-4',
					'Honor Band 5' => 'honor-band-5',
					'Honor Play' => 'honor-play',
					'Honor Smartphones' => 'honor-smartphones',
					'Honor View 10' => 'honor-view-10',
					'Honor View 20' => 'honor-view-20',
					'Hoodies' => 'hoodies',
					'Hörbücher' => 'hoerbuecher',
					'Horizon Zero Dawn' => 'horizon-zero-dawn',
					'Hörspiele' => 'hoerspiele',
					'Hörzu' => 'hoerzu',
					'Hosen' => 'hosen',
					'Hotels &amp; Unterkünfte' => 'hotel',
					'Hot Wheels' => 'hot-wheels',
					'Hoverboards' => 'hoverboards',
					'HP' => 'hp',
					'HP Drucker' => 'hp-drucker',
					'HP Laptops' => 'hp-laptop',
					'HP OMEN' => 'hp-omen',
					'HP Pavilion' => 'hp-pavilion',
					'HTC 10' => 'htc-10',
					'HTC Desire 12' => 'htc-desire',
					'HTC Smartphones' => 'htc-smartphones',
					'HTC U11' => 'htc-u11',
					'HTC Vive' => 'htc-vive',
					'Huawei' => 'huawei',
					'Huawei Kopfhörer' => 'huawei-kopfhoerer',
					'Huawei Mate 9' => 'huawei-mate-9',
					'Huawei Mate 10' => 'huawei-mate-10',
					'Huawei Mate 20' => 'huawei-mate-20',
					'Huawei Mate 20 Lite' => 'huawei-mate-20-lite',
					'Huawei Mate 20 Pro' => 'huawei-mate-20-pro',
					'Huawei Mate 30 Pro' => 'huawei-mate-30-pro',
					'Huawei MateBook' => 'huawei-matebook',
					'Huawei P10' => 'huawei-p10',
					'Huawei P20' => 'huawei-p20',
					'Huawei P30' => 'huawei-p30',
					'Huawei P30 Lite' => 'huawei-p30-lite',
					'Huawei P30 Pro' => 'huawei-p30-pro',
					'Huawei P40' => 'huawei-p40',
					'Huawei P40 Lite' => 'huawei-p40-lite',
					'Huawei P40 Pro' => 'huawei-p40-pro',
					'Huawei P Smart' => 'huawei-p-smart',
					'Huawei Smartphones' => 'huawei-smartphones',
					'Huawei Tablets' => 'huawei-mediapad',
					'Huawei Watch GT2' => 'huawei-watch-gt2',
					'Huawei Y7' => 'huawei-y7',
					'Hunde' => 'hunde',
					'Hundefutter' => 'hundefutter',
					'Hüte &amp; Mützen' => 'huete-muetzen',
					'Hyrule Warriors' => 'hyrule-warriors',
					'Hyrule Warriors: Zeit der Verheerung' => 'hyrule-warriors-zeit-der-verheerung',
					'Hyundai' => 'hyundai',
					'iMac' => 'imac',
					'Immortals Fenyx Rising' => 'immortals-fenyx-rising',
					'In-Ear Kopfhörer' => 'in-ear-kopfhoerer',
					'Industrial Style' => 'industrial-style',
					'Inline Skates' => 'inline-skates',
					'Instax Mini' => 'instax-mini',
					'Intel Core i9-9900K' => 'intel-core-i9-9900k',
					'Intel i3' => 'intel-i3',
					'Intel i5' => 'intel-i5',
					'Intel i7' => 'intel-i7',
					'Intel i9' => 'intel-i9',
					'Intenso' => 'intenso',
					'Internet Security' => 'internet-security',
					'Intimpflege' => 'intimpflege',
					'iOS Apps' => 'ios-apps',
					'iPad' => 'ipad',
					'iPad 2019' => 'ipad-2019',
					'iPad 2020' => 'ipad-2020',
					'iPad Air' => 'ipad-air-2',
					'iPad Air 2019' => 'ipad-air-2019',
					'iPad Air 2020' => 'ipad-air-2020',
					'iPad mini' => 'ipad-mini',
					'iPad Pro' => 'ipad-pro',
					'iPad Pro 11' => 'ipad-pro-11',
					'iPad Pro 12.9' => 'ipad-pro-12-9',
					'iPad Pro 2020' => 'ipad-pro-2020',
					'iPhone' => 'iphone',
					'iPhone 6' => 'iphone-6',
					'iPhone 6 Plus' => 'iphone-6-plus',
					'iPhone 6s' => 'iphone-6s',
					'iPhone 6s Plus' => 'iphone-6s-plus',
					'iPhone 7' => 'iphone-7',
					'iPhone 7 Plus' => 'iphone-7-plus',
					'iPhone 8' => 'iphone-8',
					'iPhone 8 Plus' => 'iphone-8-plus',
					'iPhone 11' => 'iphone-11',
					'iPhone 11 Pro' => 'iphone-11-pro',
					'iPhone 11 Pro Max' => 'iphone-11-pro-max',
					'iPhone 12' => 'iphone-12',
					'iPhone 12 mini' => 'iphone-12-mini',
					'iPhone 12 Pro' => 'iphone-12-pro',
					'iPhone 12 Pro Max' => 'iphone-12-pro-max',
					'iPhone SE' => 'iphone-se',
					'iPhone X' => 'iphone-x',
					'iPhone Xr' => 'iphone-xr',
					'iPhone Xs' => 'iphone-xs',
					'iPhone Xs Max' => 'iphone-xs-max',
					'iPhone Zubehör' => 'iphone-zubehoer',
					'Irish Whiskey' => 'irish-whiskey',
					'iRobot' => 'irobot',
					'iRobot Roomba' => 'irobot-roomba',
					'iRobot Roomba 980' => 'irobot-roomba-980',
					'iRobot Roomba i7' => 'irobot-roomba-i7',
					'Isomatten' => 'isomatten',
					'iTunes Guthaben' => 'itunes-guthaben',
					'Jabra Elite 75t' => 'jabra-elite-75t',
					'Jabra Elite 85h' => 'jabra-elite-85h',
					'Jabra Elite 85t' => 'jabra-elite-85t',
					'Jabra Elite Active 75t' => 'jabra-elite-active-75t',
					'Jabra Kopfhörer' => 'jabra-kopfhoerer',
					'JACK &amp; JONES' => 'jack-jones',
					'Jacken' => 'jacken',
					'JACK WOLFSKIN' => 'jack-wolfskin',
					'Jagdzubehör' => 'jagdzubehoer',
					'JBL' => 'jbl',
					'JBL Charge 4' => 'jbl-charge-4',
					'JBL Flip' => 'jbl-flip',
					'JBL GO' => 'jbl-go',
					'Jeans' => 'jeans',
					'Jim Beam' => 'jim-beam',
					'Jogginghosen' => 'jogginghosen',
					'Joghurt' => 'joghurt',
					'Johnnie Walker' => 'johnnie-walker',
					'Jura Kaffeemaschinen' => 'jura',
					'Just Cause' => 'just-cause',
					'Just Cause 4' => 'just-cause-4',
					'Kaffee' => 'kaffee',
					'Kaffeekapseln' => 'kaffeekapseln',
					'Kaffeemaschinen' => 'kaffeemaschinen',
					'Kaffeemühlen' => 'kaffeemuehlen',
					'Kaffeepadmaschinen' => 'kaffeepadmaschinen',
					'Kaffeepads' => 'kaffeepads',
					'Kaffeevollautomaten' => 'kaffeevollautomaten',
					'Kameras' => 'kamera',
					'Kamera Zubehör' => 'kamerazubehoer',
					'Kamine' => 'kamine',
					'Kapselmaschinen' => 'kapselmaschinen',
					'Kärcher' => 'kaercher',
					'Kärcher Fenstersauger' => 'kaercher-fenstersauger',
					'Kärcher Hochdruckreiniger' => 'kaercher-hochdruckreiniger',
					'Kartenspiele' => 'kartenspiel',
					'Käse' => 'kaese',
					'Katzen' => 'katzen',
					'Katzenfutter' => 'katzenfutter',
					'Kaufen im Ausland' => 'kaufen-ausland',
					'Ketchup' => 'ketchup',
					'KFZ Versicherung' => 'kfz-versicherung',
					'KIA' => 'kia',
					'kiddy' => 'kiddy',
					'Kinder Adventskalender' => 'kinder-adventskalender',
					'Kinderbekleidung' => 'kinderkleidung',
					'Kinderbetten' => 'kinderbett',
					'Kinderfahrräder' => 'kinderfahrrad',
					'Kinderschuhe' => 'kinderschuhe',
					'Kindersitz' => 'kindersitz',
					'Kinderwagen' => 'kinderwagen',
					'Kinderwagen &amp; Autositze' => 'baby-transport',
					'Kinderzimmermöbel' => 'kinderzimmer',
					'Kindle' => 'kindle',
					'Kindle Oasis' => 'kindle-oasis',
					'Kindle Paperwhite' => 'kindle-paperwhite',
					'Kingdom Come: Deliverance' => 'kingdom-come-deliverance',
					'Kingdom Hearts' => 'kingdom-hearts',
					'Kingdom Hearts 3' => 'kingdom-hearts-3',
					'Kingston HyperX Cloud Flight' => 'kingston-hyperx-cloud-flight',
					'Kingston HyperX Cloud II' => 'hyperx-cloud-ii',
					'Kino' => 'kino',
					'KitchenAid' => 'kitchenaid',
					'Kleider' => 'kleider',
					'Kleiderschränke' => 'kleiderschraenke',
					'Kleidung' => 'kleidung',
					'Klemmbausteine' => 'klemmbausteine',
					'Klimaanlagen' => 'klimaanlagen',
					'Klimatechnik' => 'klimatechnik',
					'Klipsch' => 'klipsch',
					'Kochgeräte' => 'kochgeraete',
					'Kodak' => 'kodak',
					'Koffer' => 'koffer',
					'Kohlenmonoxidmelder' => 'kohlenmonoxidmelder',
					'Kolonialstil' => 'kolonialstil',
					'Kommoden &amp; Sideboards' => 'kommoden-sideboards',
					'Kondome' => 'kondome',
					'König der Löwen Musical' => 'koenig-der-loewen-musical',
					'Kontaktgrills' => 'kontaktgrill',
					'Konto &amp; Kreditkarten' => 'konto-kreditkarten',
					'Konzert-Tickets' => 'konzerte',
					'Kopfhörer' => 'kopfhoerer',
					'Körperpflege &amp; Hygiene' => 'koerperpflege',
					'Kosmetik' => 'kosmetik',
					'Kostüme' => 'kostuem',
					'Kraftstoffe &amp; Betriebsstoffe' => 'kraftstoffe-betriebsstoffe',
					'Krafttraining' => 'krafttraining',
					'Kredit' => 'kredit',
					'Kreditkarten' => 'kreditkarten',
					'Kreissägen' => 'kreissaegen',
					'Kreuzfahrten' => 'kreuzfahrten',
					'Krups' => 'krups',
					'Küche' => 'kueche',
					'Küchengeräte' => 'kuechengeraete',
					'Küchenhelfer' => 'kuechenhelfer',
					'Küchenmaschinen' => 'kuechenmaschinen',
					'Küchenmesser' => 'messer',
					'Küchenutensilien' => 'kuechenutensilien',
					'Kugelschreiber' => 'kugelschreiber',
					'Kühl-Gefrierkombinationen' => 'kuehl-gefrierkombination',
					'Kühlboxen' => 'kuehlboxen',
					'Kühlschränke' => 'kuehlschrank',
					'Kultur &amp; Freizeit' => 'kultur-freizeit',
					'Kunst &amp; Hobby' => 'hobby',
					'Kurse &amp; Trainings' => 'kurse-trainings',
					'Lacoste' => 'lacoste',
					'Ladegeräte' => 'ladegeraete',
					'Lampen' => 'lampen',
					'Landhausstil' => 'landhausstil',
					'Landwirtschafts-Simulator' => 'landwirtschafts-simulator',
					'Laptops' => 'laptop',
					'Laserdrucker' => 'laserdrucker',
					'Last Minute Reisen' => 'last-minute',
					'Lattenroste' => 'lattenroste',
					'Laubsauger' => 'laubsauger',
					'Laufräder' => 'laufraeder',
					'Laufschuhe' => 'laufschuhe',
					'Laufsport' => 'laufsport',
					'Lautsprecher' => 'lautsprecher',
					'Lavazza' => 'lavazza',
					'Lay-Z-Spa Whirlpools' => 'lay-z-spa-whirlpools',
					'Lebensmittel' => 'lebensmittel',
					'Lebensmittel &amp; Haushalt' => 'food',
					'LED Lampen' => 'led-lampen',
					'LEGO' => 'lego',
					'LEGO Adventskalender' => 'lego-adventskalender',
					'LEGO Architecture' => 'lego-architecture',
					'LEGO Batman' => 'lego-batman',
					'LEGO City' => 'lego-city',
					'LEGO Creator' => 'lego-creator',
					'LEGO Dimensions' => 'lego-dimensions',
					'LEGO DUPLO' => 'lego-duplo',
					'LEGO Friends' => 'lego-friends',
					'LEGO Harry Potter' => 'lego-harry-potter',
					'LEGO Marvel Super Heroes' => 'lego-marvel-super-heroes',
					'LEGO Nexo Knights' => 'lego-nexo-knights',
					'LEGO NINJAGO' => 'lego-ninjago',
					'LEGO Star Wars' => 'lego-star-wars',
					'LEGO Star Wars Millennium Falcon' => 'lego-star-wars-millennium-falcon',
					'LEGO Super Mario' => 'lego-super-mario',
					'LEGO Technic' => 'lego-technic',
					'LEGO The Simpsons' => 'lego-simpsons',
					'Leifheit' => 'leifheit',
					'Lenovo' => 'lenovo',
					'Lenovo Laptops' => 'lenovo-laptop',
					'Lenovo Tablets' => 'lenovo-tablet',
					'Lenovo ThinkPad' => 'lenovo-thinkpad',
					'Lenovo Yoga' => 'lenovo-yoga',
					'Leonardo' => 'leonardo',
					'Leuchtmittel' => 'leuchten',
					'Levi&#039;s' => 'levis',
					'Lexar' => 'lexar',
					'Lexmark' => 'lexmark',
					'LG' => 'lg',
					'LG Fernseher' => 'lg-fernsher',
					'LG G5' => 'lg-g5',
					'LG G6' => 'lg-g6',
					'LG G7 ThinQ' => 'lg-g7-thinq',
					'LG OLED Fernseher' => 'lg-oled-tv',
					'LG Smartphones' => 'lg-smartphones',
					'LG V30' => 'lg-v30',
					'Lichterketten' => 'lichterketten',
					'Liebeskind' => 'liebeskind',
					'Lieferservice' => 'lieferservice',
					'Lindt' => 'lindt',
					'Lindt Adventskalender' => 'lindt-adventskalender',
					'Logitech' => 'logitech',
					'Logitech G413' => 'logitech-g413',
					'Logitech G430' => 'logitech-g430',
					'Logitech G502 Proteus Spectrum' => 'logitech-g502',
					'Logitech G513' => 'logitech-g513',
					'Logitech G533' => 'logitech-g533',
					'Logitech G633 Artemis Spectrum' => 'logitech-g633',
					'Logitech G703' => 'logitech-g703',
					'Logitech G903' => 'logitech-g903',
					'Logitech G910 Orion Spectrum' => 'logitech-g910',
					'Logitech G915' => 'logitech-g915',
					'Logitech G933 Artemis Spectrum' => 'logitech-g933',
					'Logitech Harmony' => 'logitech-harmony',
					'Logitech Mäuse' => 'logitech-maeuse',
					'Logitech MX Master' => 'logitech-mx-master',
					'Logitech MX Master 2S' => 'logitech-mx-master-2s',
					'Logitech Tastaturen' => 'logitech-tastaturen',
					'Logitech Z333' => 'logitech-z333',
					'Logitech Z337' => 'logitech-z337',
					'Logitech Z906' => 'logitech-z906',
					'Luftbefeuchter' => 'luftbefeuchter',
					'Luftentfeuchter' => 'luftentfeuchter',
					'Luftmatratzen' => 'luftmatratzen',
					'Luftreiniger' => 'luftreiniger',
					'Luigi&#039;s Mansion' => 'luigis-mansion',
					'Luigi&#039;s Mansion 3' => 'luigis-mansion-3',
					'Lustiges Taschenbuch' => 'lustiges-taschenbuch',
					'M.2 SSD' => 'm2-ssd',
					'MacBook' => 'macbook',
					'MacBook Air' => 'macbook-air',
					'MacBook Pro' => 'macbook-pro',
					'MacBook Pro 13' => 'macbook-pro-13',
					'MacBook Pro 15' => 'macbook-pro-15',
					'MacBook Pro 16' => 'macbook-pro-16',
					'Mac mini' => 'mac-mini',
					'Mac Software' => 'mac-software',
					'Madden NFL' => 'madden-nfl',
					'Magazine' => 'magazine',
					'Magnat' => 'magnat',
					'Magnum Eis' => 'magnum-eis',
					'Mähroboter' => 'maehroboter',
					'Mainboards' => 'mainboards',
					'Make Up Adventskalender' => 'make-up-adventskalender',
					'Makita' => 'makita',
					'Makita Akkuschrauber' => 'makita-akkuschrauber',
					'Malerwerkzeuge' => 'malerpinsel',
					'Mangas' => 'mangas',
					'Marantz' => 'marantz',
					'Mario Kart' => 'mario-kart',
					'Mario Kart 8 Deluxe' => 'mario-kart-8-deluxe',
					'Marken' => 'marken',
					'Marvel' => 'marvel',
					'Marvel&#039;s Spider-Man: Miles Morales' => 'marvels-spider-man-miles-morales',
					'Mass Effect' => 'mass-effect',
					'Mass Effect: Andromeda' => 'mass-effect-andromeda',
					'Massivholzmöbel' => 'massivholzmoebel',
					'Mastercard' => 'mastercard',
					'Matratzen' => 'matratzen',
					'Maxi Cosi' => 'maxi-cosi',
					'Mazda' => 'mazda',
					'Medion' => 'medion',
					'Mercedes-Benz' => 'mercedes-benz',
					'Mesh WLAN Router' => 'mesh-wlan-router',
					'Metabo' => 'metabo',
					'Metro (Spiel)' => 'metro',
					'Metro Exodus' => 'metro-exodus',
					'Michael Kors' => 'michael-kors',
					'microSD' => 'microsd',
					'microSDHC' => 'microsdhc',
					'microSDXC' => 'microsdxc',
					'Microsoft Flight Simulator' => 'microsoft-flight-simulator',
					'Microsoft Software' => 'microsoft-software',
					'Microsoft Surface Notebooks' => 'microsoft-surface-notebooks',
					'Microsoft Surface Pro 4' => 'surface-pro-4',
					'Microsoft Surface Pro 6' => 'surface-pro-6',
					'Microsoft Surface Pro 7' => 'microsoft-surface-pro-7',
					'Microsoft Surface Tablets' => 'microsoft-surface',
					'Miele' => 'miele',
					'Miele Geschirrspüler' => 'miele-geschirrspueler',
					'Miele Staubsauger' => 'miele-staubsauger',
					'Miele Waschmaschinen' => 'miele-waschmaschine',
					'Mietwagen' => 'mietwagen',
					'Mikrofone' => 'mikrofone',
					'Mikrowellen' => 'mikrowelle',
					'Milchaufschäumer' => 'milchaufschaeumer',
					'Milka' => 'milka',
					'Minecraft' => 'minecraft',
					'Mineralwasser' => 'mineralwasser',
					'Minions' => 'minions',
					'Mini PCs' => 'mini-pc',
					'Mitsubishi' => 'mitsubishi',
					'Mittelerde' => 'middle-earth',
					'Mittelerde: Mordors Schatten' => 'mittelerde-mordors-schatten',
					'Mittelerde: Schatten des Krieges' => 'mittelerde-schatten-des-krieges',
					'Mixer &amp; Rührer' => 'mixer',
					'Möbel' => 'moebel-deko',
					'Modellbau' => 'modellbau',
					'Modern wohnen' => 'modern-wohnen',
					'Monitore' => 'monitor',
					'Monkey 47' => 'monkey-47',
					'Monopoly' => 'monopoly',
					'Monster Hunter' => 'monster-hunter',
					'Monster Hunter: World' => 'monster-hunter-world',
					'Mortal Kombat' => 'mortal-kombat',
					'Mortal Kombat 11' => 'mortal-kombat-11',
					'Motorola' => 'motorola',
					'Motorola Smartphones' => 'motorola-smartphones',
					'Motorradbekleidung' => 'motorradbekleidung',
					'Motorradhelm' => 'motorradhelm',
					'Motorrad Zubehör' => 'motorrad',
					'Moto Z' => 'moto-z',
					'Mountainbikes' => 'mountainbikes',
					'MSI' => 'msi',
					'Mülleimer' => 'muelleimer',
					'Multifunktionsdrucker' => 'multifunktionsdrucker',
					'Multiroom Speaker' => 'multiroom',
					'Mund- &amp; Zahnpflege' => 'mund-zahnpflege',
					'Mundschutzmasken' => 'mundschutzmasken',
					'Museums-Tickets' => 'museum',
					'Musical Tickets' => 'musical',
					'Musik' => 'musik',
					'Musik Apps' => 'musik-apps',
					'Musikinstrumente' => 'musikinstrumente',
					'Musik Streaming' => 'musik-streaming',
					'Müsli' => 'muesli',
					'Mustang' => 'mustang',
					'Mützen' => 'muetzen',
					'Nachtwäsche' => 'nachtwaesche',
					'Nähbedarf' => 'naehen',
					'Nähmaschinen' => 'naehmaschine',
					'Nahrungsergänzungsmittel' => 'nahrungsergaenzungsmittel',
					'Nahverkehr' => 'nahverkehr',
					'Naketano' => 'naketano',
					'NAS' => 'nas',
					'Nassrasierer' => 'rasierer',
					'Navigationsgeräte' => 'navigationsgeraete',
					'Neato' => 'neato',
					'Neato Robotics Botvac D7 Connected' => 'neato-botvac-d7',
					'Need for Speed' => 'need-for-speed',
					'Need for Speed Heat' => 'need-for-speed-heat',
					'Need for Speed Payback' => 'need-for-speed-payback',
					'Nerf' => 'nerf',
					'Nescafé' => 'nescafe',
					'Nespresso' => 'nespresso',
					'Nespresso Kaffeemaschinen' => 'nespresso-kaffeemaschinen',
					'Netflix' => 'netflix',
					'NETGEAR' => 'netgear',
					'NETGEAR Nighthawk' => 'netgear-nighthawk',
					'NETGEAR Orbi' => 'netgear-orbi',
					'NETGEAR Router' => 'netgear-router',
					'Netzteile' => 'netzteile',
					'Netzwerk' => 'netzwerk',
					'New Balance' => 'new-balance',
					'Nike' => 'nike',
					'Nike Air Force 1' => 'nike-air-force',
					'Nike Air Max' => 'nike-air-max',
					'Nike Air Max 270' => 'nike-air-max-270',
					'Nike Air Max 720' => 'nike-air-max-720',
					'Nike Air Max Thea' => 'nike-air-max-thea',
					'Nike Air Presto' => 'nike-presto',
					'Nike Free' => 'nike-free',
					'Nike Huarache' => 'nike-huarache',
					'Nike Roshe Run' => 'nike-roshe-run',
					'Nike Schuhe' => 'nike-schuhe',
					'Nikon' => 'nikon',
					'Nikon DSLR' => 'nikon-dslr',
					'Ni No Kuni' => 'ni-no-kuni',
					'Ni No Kuni: Der Fluch der Weißen Königin' => 'ni-no-kuni-der-fluch-der-weissen-koenigin',
					'Ni No Kuni II: Revenant Kingdom' => 'ni-no-kuni-ii',
					'Nintendo' => 'nintendo',
					'Nintendo 2DS Konsolen' => 'nintendo-2ds',
					'Nintendo 3DS Konsolen' => 'nintendo-3ds',
					'Nintendo 3DS Spiele' => 'nintendo-3ds-spiele',
					'Nintendo 3DS Zubehör' => 'nintendo-3ds-zubehoer',
					'Nintendo Classic Mini NES Konsolen' => 'nintendo-classic-mini-nes',
					'Nintendo Classic Mini SNES Konsolen' => 'nintendo-classic-mini-snes',
					'Nintendo eShop Guthaben' => 'nintendo-eshop-guthaben',
					'Nintendo Switch Controller' => 'nintendo-switch-controller',
					'Nintendo Switch Konsolen' => 'nintendo-switch',
					'Nintendo Switch Lite Konsolen' => 'nintendo-switch-lite',
					'Nintendo Switch Pro Controller' => 'nintendo-switch-pro-controller',
					'Nintendo Switch Spiele' => 'nintendo-switch-spiele',
					'Nintendo Switch Zubehör' => 'nintendo-switch-zubehoer',
					'Nintendo Zubehör' => 'nintendo-zubehoer',
					'Nissan' => 'nissan',
					'Nivea' => 'nivea',
					'Nokia' => 'nokia',
					'Nokia Handys' => 'nokia-handys',
					'Nudeln' => 'nudeln',
					'Nuki Smart Locks' => 'nuki-smart-lock',
					'Nüsse' => 'nuesse',
					'Nutella' => 'nutella',
					'Nvidia' => 'nvidia',
					'Nvidia GeForce' => 'nvidia-geforce',
					'Nvidia SHIELD TV' => 'nvidia-shield',
					'o2' => 'o2-netz',
					'Objektive' => 'objektiv',
					'Obst' => 'obst',
					'Obst &amp; Gemüse' => 'obst-gemuese',
					'Oculus Quest' => 'oculus-quest',
					'Oculus Rift' => 'oculus-rift',
					'Office Programme' => 'office-programme',
					'OLED Fernseher' => 'oled-fernseher',
					'Olympus' => 'olympus',
					'On-Ear Kopfhörer' => 'on-ear-kopfhoerer',
					'OnePlus 3' => 'oneplus-3',
					'OnePlus 5' => 'oneplus-5',
					'OnePlus 6' => 'oneplus-6',
					'OnePlus 7' => 'oneplus-7',
					'OnePlus 7 Pro' => 'oneplus-7-pro',
					'OnePlus 7T' => 'oneplus-7t',
					'OnePlus 7T Pro' => 'oneplus-7t-pro',
					'OnePlus 8' => 'oneplus-8',
					'OnePlus 8 Pro' => 'one-plus-8-pro',
					'OnePlus 8T' => 'oneplus-8t',
					'OnePlus Nord' => 'oneplus-nord',
					'OnePlus Smartphones' => 'oneplus-smartphones',
					'Onkyo' => 'onkyo',
					'Opel' => 'opel',
					'OPPO Find X2 Lite' => 'oppo-find-x2-lite',
					'OPPO Find X2 Neo' => 'oppo-find-x2-neo',
					'OPPO Find X2 Pro' => 'oppo-find-x2-pro',
					'OPPO Reno2' => 'oppo-reno2',
					'OPPO Reno2 Z' => 'oppo-reno2-z',
					'OPPO Reno4 5G' => 'oppo-reno4-5g',
					'OPPO Reno4 Pro 5G' => 'oppo-reno4-pro-5g',
					'OPPO Reno4 Z 5G' => 'oppo-reno4-z-5g',
					'OPPO Smartphones' => 'oppo-smartphones',
					'Oral-B' => 'oral-b',
					'Oral-B Elektrische Zahnbürsten' => 'oral-b-elektrische-zahnbuersten',
					'Origin' => 'origin',
					'Osram' => 'osram',
					'Osram Smart+' => 'osram-smart-plus',
					'Osterdeko' => 'osterdeko',
					'Outdoor &amp; Camping' => 'outdoor',
					'Outdoorbekleidung' => 'outdoorbekleidung',
					'Outdoorjacken' => 'outdoorjacken',
					'Outdoor Spielzeuge' => 'outdoor-spielzeug',
					'Over-Ear Kopfhörer' => 'over-ear-kopfhoerer',
					'Pampers' => 'pampers',
					'Panama Jack' => 'panama-jack',
					'Panasonic' => 'panasonic',
					'Panasonic Fernseher' => 'panasonic-fernseher',
					'Panasonic Kameras' => 'panasonic-kameras',
					'Panasonic Lumix' => 'panasonic-lumix',
					'Paper Mario: The Origami King' => 'paper-mario-the-origami-king',
					'Papiertapete' => 'papiertapete',
					'Parfum' => 'parfum',
					'Parfum Damen' => 'parfum-damen',
					'Parfum Herren' => 'parfum-herren',
					'Pauschalreisen' => 'pauschalreise',
					'Pavillons' => 'pavillons',
					'Paw Patrol' => 'paw-patrol',
					'PAYBACK' => 'payback',
					'Payday' => 'payday',
					'Payday 2' => 'payday-2',
					'paydirekt' => 'paydirekt',
					'PC Gaming Systeme' => 'pc-gaming-systeme',
					'PC Gaming Zubehör' => 'pc-gaming-zubehoer',
					'PC Gehäuse' => 'pc-gehaeuse',
					'PC Komponenten' => 'hardware',
					'PC Lautsprecher' => 'pc-lautsprecher',
					'PC Mäuse' => 'pc-maus',
					'PC Spiele' => 'pc-spiele',
					'PC Zubehör' => 'pc-zubehoer',
					'Pendelleuchten' => 'pendelleuchten',
					'Pentax' => 'pentax',
					'Pepe Jeans' => 'pepe-jeans',
					'Peppa Wutz' => 'peppa-wutz',
					'PepperBonus' => 'pepperbonus',
					'Pestos' => 'pestos',
					'Peugeot' => 'peugeot',
					'Pfannen' => 'pfannen',
					'Pflanzen' => 'pflanzen',
					'Philips' => 'philips',
					'Philips Fernseher' => 'philips-fernseher',
					'Philips Hue' => 'philips-hue',
					'Philips Hue E14' => 'philips-hue-e14',
					'Philips Hue E27' => 'philips-hue-e27',
					'Philips Hue Go' => 'philips-hue-go',
					'Philips Hue GU10' => 'philips-hue-gu10',
					'Philips Hue LightStrip' => 'philips-hue-lightstrip',
					'Philips Hue Play Gradient LightStrip' => 'philips-hue-play-gradient-lightstrip',
					'Philips Hue Play HDMI Sync Box' => 'philips-hue-play-hdmi-sync-box',
					'Philips Hue Play Lightbar' => 'philips-hue-play',
					'Philips OneBlade' => 'philips-oneblade',
					'Philips Rasierer' => 'philips-rasierer',
					'Philips Sonicare' => 'philips-sonicare',
					'Philips Staubsauger' => 'philips-staubsauger',
					'Philips Wecker' => 'philips-wecker',
					'Photoshop' => 'photoshop',
					'Pioneer' => 'pioneer',
					'Pizza' => 'pizza',
					'Plattenspieler' => 'plattenspieler',
					'Playboy' => 'playboy',
					'Playerunknown&#039;s Battlegrounds' => 'playerunknowns-battlegrounds',
					'PLAYMOBIL' => 'playmobil',
					'PLAYMOBIL Adventskalender' => 'playmobil-adventskalender',
					'PlayStation' => 'playstation',
					'PlayStation 4 Controller' => 'playstation-4-controller',
					'PlayStation 4 Konsolen' => 'playstation-4',
					'PlayStation 4 Pro Konsolen' => 'playstation-4-pro',
					'PlayStation 4 Spiele' => 'playstation-4-spiele',
					'PlayStation 5 Konsolen' => 'playstation-5',
					'PlayStation 5 Spiele' => 'playstation-5-spiele',
					'PlayStation Classic Konsolen' => 'playstation-classic',
					'PlayStation Now' => 'playstation-now',
					'PlayStation Plus' => 'playstation-plus',
					'PlayStation Zubehör' => 'playstation-zubehoer',
					'Plüschtiere' => 'plueschtiere',
					'Plus Size Mode' => 'plus-size-mode',
					'POCO F2 Pro' => 'poco-f2-pro',
					'POCO X3' => 'poco-x3',
					'Pokémon' => 'pokemon',
					'Pokémon: Let&#039;s Go' => 'pokemon-lets-go',
					'Pokémon Schwert und Schild' => 'pokemon-schwert-schild',
					'Pokémon Tekken' => 'pokemon-tekken',
					'Pokémon Ultrasonne &amp; Ultramond' => 'pokemon-ultrasonne-ultramond',
					'Poloshirts' => 'poloshirts',
					'Polsterbetten' => 'polsterbetten',
					'Polyrattan Möbel' => 'polyrattan',
					'Pools' => 'pools',
					'Powerbanks' => 'powerbanks',
					'Powerbeats Pro' => 'powerbeats',
					'Preisfehler' => 'preisfehler',
					'Prepaid-Tarife' => 'prepaid-tarife',
					'Prime Gaming' => 'twitch-prime',
					'Pro Evolution Soccer' => 'pro-evolution-soccer',
					'Pro Evolution Soccer 2018' => 'pes-2018',
					'Pro Evolution Soccer 2019' => 'pes-2019',
					'Pro Evolution Soccer 2020' => 'pes-2020',
					'Proteine' => 'whey-proteine',
					'Prozessoren' => 'prozessoren',
					'PSN Guthaben' => 'psn-guthaben',
					'Puky' => 'puky',
					'Pullover' => 'pullover',
					'PUMA' => 'puma',
					'Pumps' => 'pumps',
					'Puppen' => 'puppen',
					'Puppenhäuser' => 'puppenhaeuser',
					'Puzzles' => 'puzzle',
					'Qeridoo' => 'qeridoo',
					'Qeridoo Fahrradanhänger' => 'qeridoo-fahrradanhaenger',
					'Qeridoo KidGoo 2' => 'qeridoo-kidgoo-2',
					'Qeridoo Sportrex 2' => 'qeridoo-sportrex-2',
					'Quiksilver' => 'quiksilver',
					'Raclettes' => 'raclettes',
					'Radios' => 'radios',
					'Radsport' => 'radsport',
					'Rasenmäher' => 'rasenmaeher',
					'Rasentrimmer' => 'rasentrimmer',
					'Rasierklingen' => 'rasierklingen',
					'Raspberry Pi' => 'raspberry-pi',
					'Rasur, Enthaarung &amp; Trimmen' => 'rasur-enthaarung',
					'Rauchmelder' => 'rauchmelder',
					'Ravensburger' => 'ravensburger',
					'Ray-Ban' => 'ray-ban',
					'Razer DeathAdder' => 'razer-deathadder',
					'RC Autos' => 'rc-autos',
					'Red Bull' => 'red-bull',
					'Red Dead Redemption' => 'red-dead-redemption',
					'Red Dead Redemption 2' => 'red-dead-redemption-2',
					'Reebok' => 'reebok',
					'Regale' => 'regale',
					'Reifen' => 'reifen',
					'Reinigungsmittel' => 'reinigungsmittel',
					'Reise Apps' => 'reise-apps',
					'Reisen' => 'reisen',
					'Reiskocher' => 'reiskocher',
					'Remington' => 'remington',
					'Renault' => 'renault',
					'Rennräder' => 'rennraeder',
					'Repeater' => 'repeater',
					'Resident Evil' => 'resident-evil',
					'Resident Evil 2' => 'resident-evil-2',
					'Resident Evil 7' => 'resident-evil-7',
					'Restaurant' => 'restaurant',
					'Retro Stil' => 'retro-stil',
					'Rimowa' => 'rimowa',
					'Ring Fit Adventure' => 'ring-fit-adventure',
					'Rituals' => 'rituals',
					'Rituals Adventskalender' => 'rituals-adventskalender',
					'Roborock' => 'xiaomi-roborock',
					'Roborock S5 Max' => 'roborock-s5-max',
					'Roborock S6' => 'roborock-s6',
					'Roborock S6 MaxV' => 'roborock-s6-maxv',
					'ROCCAT' => 'roccat',
					'ROCCAT Tyon' => 'roccat-tyon',
					'Röcke' => 'roecke',
					'Rocket League' => 'rocket-league',
					'Roidmi Staubsauger' => 'roidmi-staubsauger',
					'Rollei' => 'rollei',
					'Rösle' => 'roesle',
					'Router' => 'router',
					'Roxy' => 'roxy',
					'RTX 2060' => 'rtx-2060',
					'RTX 2070' => 'rtx-2070',
					'RTX 2080' => 'rtx-2080',
					'RTX 2080 Ti' => 'rtx-2080-ti',
					'RTX 3070' => 'rtx-3070',
					'RTX 3080' => 'rtx-3080',
					'RTX 3090' => 'rtx-3090',
					'Rucksäcke' => 'rucksaecke',
					'Russell Hobbs' => 'russell-hobbs',
					'RX 480' => 'rx-480',
					'RX 570' => 'rx-570',
					'RX 580' => 'rx-580',
					'RX 590' => 'rx-590',
					'RX 5700 XT' => 'rx-5700-xt',
					'RX 6800' => 'rx-6800',
					'RX 6800 XT' => 'rx-6800-xt',
					'RX 6900 XT' => 'rx-6900-xt',
					'RX Vega 56' => 'rx-vega-56',
					'RX Vega 64' => 'rx-vega-64',
					'Sägen' => 'saegen',
					'Salomon' => 'salomon',
					'Samsonite' => 'samsonite',
					'Samsung' => 'samsung',
					'Samsung Fernseher' => 'samsung-fernseher',
					'Samsung Galaxy A7' => 'samsung-galaxy-a7',
					'Samsung Galaxy A8' => 'samsung-galaxy-a8',
					'Samsung Galaxy A51' => 'samsung-galaxy-a51',
					'Samsung Galaxy A71' => 'samsung-galaxy-a71',
					'Samsung Galaxy Buds' => 'samsung-galaxy-buds',
					'Samsung Galaxy Buds+' => 'samsung-galaxy-buds-plus',
					'Samsung Galaxy Buds Live' => 'samsung-galaxy-buds-live',
					'Samsung Galaxy Buds Pro' => 'samsung-galaxy-buds-pro',
					'Samsung Galaxy Note9' => 'samsung-galaxy-note-9',
					'Samsung Galaxy Note20' => 'samsung-galaxy-note20',
					'Samsung Galaxy Note20 Ultra' => 'samsung-galaxy-note20-ultra',
					'Samsung Galaxy S7' => 'samsung-galaxy-s7',
					'Samsung Galaxy S7 Edge' => 'samsung-galaxy-s7-edge',
					'Samsung Galaxy S8' => 'samsung-galaxy-s8',
					'Samsung Galaxy S8+' => 'samsung-galaxy-s8-plus',
					'Samsung Galaxy S9' => 'samsung-galaxy-s9',
					'Samsung Galaxy S9+' => 'samsung-galaxy-s9-plus',
					'Samsung Galaxy S10' => 'samsung-galaxy-s10',
					'Samsung Galaxy S10+' => 'samsung-galaxy-s10-plus',
					'Samsung Galaxy S10e' => 'samsung-galaxy-s10e',
					'Samsung Galaxy S20' => 'samsung-galaxy-s20',
					'Samsung Galaxy S20 FE' => 'samsung-galaxy-s20-fe',
					'Samsung Galaxy S20 Ultra' => 'samsung-galaxy-s20-ultra',
					'Samsung Galaxy S20+' => 'samsung-galaxy-s20-plus',
					'Samsung Galaxy S21 5G' => 'samsung-galaxy-s21-5g',
					'Samsung Galaxy S21 Ultra 5G' => 'samsung-galaxy-s21-ultra-5g',
					'Samsung Galaxy S21+ 5G' => 'samsung-galaxy-s21-plus-5g',
					'Samsung Galaxy Tab S4' => 'samsung-galaxy-tab-s4',
					'Samsung Galaxy Tab S6' => 'samsung-galaxy-tab-s6',
					'Samsung Galaxy Watch' => 'samsung-galaxy-watch',
					'Samsung Galaxy Watch Active2' => 'samsung-galaxy-watch-active-2',
					'Samsung Gear' => 'samsung-gear',
					'Samsung Gear S3' => 'samsung-gear-s3',
					'Samsung Gear VR' => 'samsung-gear-vr',
					'Samsung Kopfhörer' => 'samsung-kopfhoerer',
					'Samsung Kühlschränke' => 'samsung-kuehlschrank',
					'Samsung Monitore' => 'samsung-monitor',
					'Samsung QLED Fernseher' => 'samsung-qled-fernseher',
					'Samsung Smartphones' => 'samsung-smartphone',
					'Samsung SSD' => 'samsung-ssd',
					'Samsung Tablets' => 'samsung-tablet',
					'Samsung The Frame Fernseher' => 'samsung-the-frame-fernseher',
					'Samsung Waschmaschinen' => 'samsung-waschmaschine',
					'Sandalen' => 'sandalen',
					'SanDisk' => 'sandisk',
					'SanDisk SSD' => 'sandisk-ssd',
					'Sanitär &amp; Armaturen' => 'sanitaer-armaturen',
					'Saucen' => 'saucen',
					'Saugroboter' => 'saugroboter',
					'Scanner' => 'scanner',
					'Schallplatten' => 'schallplatten',
					'Scheppach' => 'scheppach',
					'Schlafsäcke' => 'schlafsack',
					'Schlafsofas' => 'schlafsofas',
					'Schlafzimmer' => 'schlafzimmer',
					'Schlagschrauber' => 'schlagschrauber',
					'Schlauchboote' => 'schlauchboote',
					'Schleich' => 'schleich',
					'Schlitten' => 'schlitten',
					'Schmuck' => 'schmuck',
					'Schneefräsen' => 'schneefraesen',
					'Schnellkochtöpfe' => 'schnellkochtoepfe',
					'Schnürhalbschuhe' => 'schnuerhalbschuhe',
					'Schokolade' => 'schokolade',
					'Schraubendreher' => 'schraubendreher',
					'Schreibgeräte' => 'schreibgeraete',
					'Schreibtische' => 'schreibtisch',
					'Schuhe' => 'schuhe',
					'Schuhschränke' => 'schuhschraenke',
					'Schulbedarf' => 'schulbedarf',
					'Schulranzen' => 'schulranzen',
					'Schutzfolien' => 'schutzfolien',
					'Schwangerschaft' => 'schwangerschaft',
					'Schwerlastregale' => 'schwerlastregale',
					'Scooter' => 'scooter',
					'Scotch Whisky' => 'scotch-whisky',
					'SDHC Speicherkarten' => 'sdhc-speicherkarten',
					'SD Karten' => 'sd-karten',
					'Seagate' => 'seagate',
					'Sea of Thieves' => 'sea-of-thieves',
					'Seat' => 'seat',
					'Sega Mega Drive Mini Konsolen' => 'sega-mega-drive-mini',
					'Seidensticker' => 'seidensticker',
					'Sekiro: Shadows Die Twice' => 'sekiro',
					'Senf' => 'senf',
					'Sennheiser' => 'sennheiser',
					'Senseo' => 'senseo',
					'Service-Verträge' => 'service-vertraege',
					'Sessel' => 'sessel',
					'Sextoys' => 'sextoys',
					'Shadow of the Tomb Raider' => 'shadow-of-the-tomb-raider',
					'Shampoo' => 'shampoo',
					'Sharkoon' => 'sharkoon',
					'Sharp' => 'sharp',
					'Shenmue' => 'shenmue',
					'Shenmue I &amp; II' => 'shenmue-i-ii',
					'Shenmue III' => 'shenmue-iii',
					'Shishas' => 'shishas',
					'Shishas &amp; Zubehör' => 'shishas-zubehoer',
					'Shoop' => 'shoop',
					'Shops: Erfahrungen' => 'shops',
					'Shorts' => 'shorts',
					'Sicherheitstechnik' => 'sicherheitstechnik',
					'Side-by-Side-Kühlschränke' => 'side-by-side-kuehlschrank',
					'Sid Meier&#039;s Civilization VI' => 'sid-meiers-civilization-vi',
					'Sid Meier’s Civilization' => 'sid-meiers-civilization',
					'Siemens' => 'siemens',
					'Siemens Geschirrspüler' => 'siemens-geschirrspueler',
					'Siemens Kühlschränke' => 'siemens-kuehlschrank',
					'Siemens Waschmaschinen' => 'siemens-waschmaschine',
					'Silit' => 'silit',
					'Skandi Stil' => 'skandi-stil',
					'Skateboards' => 'skateboard',
					'Skaten' => 'skaten',
					'Ski &amp; Snowboard' => 'snowboard',
					'Skoda' => 'skoda',
					'Sky' => 'sky',
					'Sky Ticket' => 'sky-ticket',
					'Smarte Beleuchtung' => 'smarte-beleuchtung',
					'Smarte Wecker' => 'smarte-wecker',
					'Smart Home' => 'smart-home',
					'Smart Home Steckdosen' => 'smart-home-steckdosen',
					'Smart Locks' => 'smart-lock',
					'Smartphones' => 'smartphone',
					'Smartphones unter 200€' => 'smartphones-unter-200-euro',
					'Smart Speaker' => 'smart-speaker',
					'Smart Tech &amp; Gadgets' => 'smart-tech',
					'Smartwatches' => 'smartwatch',
					'Smoothie Maker' => 'smoothie-maker',
					'Snacks &amp; Knabberzeug' => 'snacks-knabberzeug',
					'Sneakers' => 'sneaker',
					'Socken' => 'socken',
					'SodaStream' => 'sodastream',
					'Sofas' => 'sofa',
					'Sofortbildkameras' => 'sofortbildkameras',
					'Softdrinks' => 'softdrinks',
					'Software' => 'software',
					'Software &amp; Apps' => 'apps-software',
					'Solarleuchten' => 'solarleuchten',
					'Somat' => 'somat',
					'Sommerreifen' => 'sommerreifen',
					'Sonnenbrillen' => 'sonnenbrillen',
					'Sonnencreme' => 'sonnencreme',
					'Sonnenpflege' => 'sonnenpflege',
					'Sonnenschirme' => 'sonnenschirme',
					'Sonoff' => 'sonoff',
					'Sonos' => 'sonos',
					'Sonos Beam' => 'sonos-beam',
					'Sonos Move' => 'sonos-move',
					'Sonos One' => 'sonos-one',
					'Sonos PLAY:1' => 'sonos-play-1',
					'Sonos PLAY:3' => 'sonos-play-3',
					'Sonos Play:5 (Five)' => 'sonos-play-5',
					'Sonos Playbar' => 'sonos-playbar',
					'Sonos Playbase' => 'sonos-playbase',
					'Sonstiges' => 'diverses',
					'Sony' => 'sony',
					'Sony Alpha 7' => 'sony-alpha-7',
					'Sony Alpha 7 II' => 'sony-alpha-7-ii',
					'Sony Alpha 7 III' => 'sony-alpha-7-iii',
					'Sony Alpha 6000' => 'sony-alpha-6000',
					'Sony Alpha 6300' => 'sony-alpha-6300',
					'Sony Alpha 6400' => 'sony-alpha-6400',
					'Sony Alpha 6500' => 'sony-alpha-6500',
					'Sony DualSense Wireless-Controller' => 'playstation-5-controller',
					'Sony Fernseher' => 'sony-fernseher',
					'Sony Kameras' => 'sony-kameras',
					'Sony Kopfhörer' => 'sony-kopfhoerer',
					'Sony PlayStation VR' => 'sony-playstation-vr',
					'Sony PULSE 3D Wireless Headset' => 'sony-pulse-3d-wireless-headset',
					'Sony WF-1000XM3' => 'sony-wf-1000xm3',
					'Sony WH-1000XM3' => 'sony-wh-1000xm3',
					'Sony WH-1000XM4' => 'sony-wh-1000xm4',
					'Sony Xperia' => 'sony-xperia',
					'Sony Xperia X' => 'sony-xperia-x',
					'Sony Xperia XA' => 'sony-xperia-xa',
					'Sony Xperia XZ' => 'sony-xperia-xz',
					'Soundbar' => 'soundbar',
					'Soundbase' => 'soundbase',
					'Soundkarten' => 'soundkarten',
					'South Park: Die rektakuläre Zerreißprobe' => 'south-park-die-rektakulaere-zerreissprobe',
					'Spartipps' => 'spartipps',
					'Speicherkarten' => 'speicherkarten',
					'Speichermedien' => 'speichermedien',
					'Speiseöle' => 'speiseoele',
					'Spiegelreflexkameras' => 'spiegelreflexkamera',
					'Spiele &amp; Brettspiele' => 'spiele-brettspiele',
					'Spiele Apps' => 'spiele-apps',
					'Spielekonsolen' => 'spielekonsolen',
					'Spielfiguren &amp; Spielsets' => 'spielfiguren-spielsets',
					'Spielzeuge' => 'spielzeug',
					'Spirituosen' => 'spirituosen',
					'Sport &amp; Outdoor' => 'sport',
					'Sportbekleidung' => 'sportbekleidung',
					'Sport Bild' => 'sport-bild',
					'Sportnahrung' => 'sportlernahrung',
					'Sporttasche' => 'sporttasche',
					'Spotify' => 'spotify',
					'Spülmaschinentabs' => 'spuelmaschinentabs',
					'Spyro Reignited Trilogy' => 'spyro-reignited-trilogy',
					'SSD' => 'ssd',
					'Stabmixer' => 'stabmixer',
					'Städtereisen' => 'staedtereise',
					'Standmixer' => 'standmixer',
					'Star Trek' => 'star-trek',
					'Star Wars' => 'star-wars',
					'Star Wars: Battlefront 2' => 'star-wars-battlefront-2',
					'Star Wars: Squadrons' => 'star-wars-squadrons',
					'Star Wars Battlefront' => 'star-wars-battlefront',
					'Star Wars Jedi: Fallen Order' => 'star-wars-jedi-fallen-order',
					'Staubsauger' => 'staubsauger',
					'Staubsaugerbeutel' => 'staubsaugerbeutel',
					'Staubsauger ohne Beutel' => 'staubsauger-ohne-beutel',
					'Steam' => 'steam',
					'Steckschlüssel' => 'steckschluessel',
					'SteelSeries' => 'steelseries',
					'Stehlampen' => 'stehlampen',
					'Steiff' => 'steiff',
					'Stern (Magazin)' => 'stern-magazin',
					'Stichsägen' => 'stichsaegen',
					'Stiefel' => 'stiefel',
					'Stiefeletten' => 'stiefeletten',
					'Stiftung Warentest' => 'stiftung-warentest-magazin',
					'Streaming-Dienste' => 'streaming-dienste',
					'Streaming Lautsprecher' => 'streaming-lautsprecher',
					'Strom &amp; Gas' => 'strom-gas',
					'Stromtarif' => 'stromtarif',
					'Studentenrabatte' => 'studentenrabatte',
					'Stühle' => 'stuehle',
					'Subwoofer' => 'subwoofer',
					'SUP Boards' => 'sup-boards',
					'Superdry' => 'superdry',
					'Super Mario' => 'super-mario',
					'Super Mario 3D All-Stars' => 'super-mario-3d-all-stars',
					'Super Mario Maker 2' => 'super-mario-maker-2',
					'Super Mario Odyssey' => 'super-mario-odyssey',
					'Super Mario Party' => 'super-mario-party',
					'Supermarkt' => 'supermarkt',
					'Super Smash Bros. Ultimate' => 'super-smash-bros-ultimate',
					'Süßigkeiten' => 'suessigkeiten',
					'Synology' => 'synology',
					'Syoss' => 'syoss',
					'Systemkameras' => 'systemkamera',
					'T-Shirts' => 't-shirts',
					'Tablets' => 'tablet',
					'Tablet Zubehör' => 'tablet-zubehoer',
					'tado° Smartes Heizkörper-Thermostat' => 'tado-smartes-thermostat',
					'Tamaris' => 'tamaris',
					'Tangle Teezer' => 'tangle-teezer',
					'Tanqueray' => 'tanqueray',
					'Tapeten' => 'tapeten',
					'Taschen' => 'taschen',
					'Taschenlampen' => 'taschenlampen',
					'Taschentücher' => 'taschentuecher',
					'Tassimo' => 'tassimo',
					'Tassimo Kaffeemaschinen' => 'tassimo-kaffeemaschinen',
					'Tastaturen' => 'tastatur',
					'TCL Fernseher' => 'tcl-fernseher',
					'Team Sonic Racing' => 'team-sonic-racing',
					'Teamsport' => 'teamsport',
					'Tee' => 'tee',
					'Tefal' => 'tefal',
					'Tefal OptiGrills' => 'tefal-optigrill',
					'Tefal Pfannen' => 'tefal-pfannen',
					'Tekken' => 'tekken',
					'Tekken 7' => 'tekken-7',
					'Telefon- &amp; Internet-Verträge' => 'telefon-internet',
					'Telefone &amp; Zubehör' => 'handy-smartphone',
					'Telekom' => 'telekom-net',
					'Telekom Magenta' => 'telekom-magenta',
					'Telekom SmartHome' => 'telekom-smarthome',
					'Teppiche' => 'teppiche',
					'Tesla' => 'tesla',
					'Tetris' => 'tetris',
					'Teufel' => 'teufel',
					'The Elder Scrolls' => 'the-elder-scrolls',
					'The Elder Scrolls V: Skyrim' => 'skyrim',
					'The Evil Within' => 'the-evil-within',
					'The Evil Within 2' => 'the-evil-within-2',
					'The Last of Us' => 'the-last-of-us',
					'The Last of Us Part II' => 'the-last-of-us-part-ii',
					'The Legend of Zelda' => 'the-legend-of-zelda',
					'The Legend of Zelda: Breath of the Wild' => 'zelda-breath-of-the-wild',
					'The Legend of Zelda: Link&#039;s Awakening' => 'zelda-links-awakening',
					'The Legend of Zelda: Skyward Sword HD' => 'zelda-skyward-sword-hd',
					'The North Face' => 'the-north-face',
					'The Outer Worlds' => 'the-outer-worlds',
					'Thermosflaschen' => 'thermosflaschen',
					'Thermoskannen' => 'thermoskanne',
					'The Witcher' => 'the-witcher',
					'The Witcher 3' => 'the-witcher-3',
					'Thule' => 'thule',
					'Thule Chariot Fahrradanhänger' => 'thule-chariot-fahrradanhaenger',
					'Thule Dachboxen' => 'thule-dachboxen',
					'Thule Fahrradträger' => 'thule-fahrradtraeger',
					'Tickets &amp; Shows' => 'erlebnisse',
					'Tiefkühlkost' => 'tiefkuehkost',
					'Timberland' => 'timberland',
					'Tintenstrahldrucker' => 'tintenstrahldrucker',
					'Tischlampen' => 'tischlampen',
					'Tischtennis' => 'tischtennis',
					'Tischtennisplatten' => 'tischtennisplatten',
					'Tischtennisschläger' => 'tischtennisschlaeger',
					'Toaster' => 'toaster',
					'Toilettenpapier' => 'toilettenpapier',
					'tolino' => 'tolino',
					'Tomb Raider' => 'tomb-raider',
					'Tom Clancy&#039;s' => 'tom-clancys',
					'Tom Clancy&#039;s: Ghost Recon Wildlands' => 'tom-clancys-ghost-recon-wildlands',
					'Tom Clancy&#039;s Ghost Recon Breakpoint' => 'tom-clancys-ghost-recon-breakpoint',
					'Tom Clancy&#039;s The Division 2' => 'tom-clancy-the-division-2',
					'Tommy Hilfiger' => 'tommy-hilfiger',
					'TOM TAILOR' => 'tom-tailor',
					'Toner' => 'toner',
					'Tonic Water' => 'tonic-water',
					'Toniebox' => 'toniebox',
					'Tonies Figuren' => 'tonie-figuren',
					'Töpfe' => 'toepfe',
					'Töpfe &amp; Pfannen' => 'kochen',
					'Toplader' => 'toplader',
					'Toshiba' => 'toshiba',
					'Total War' => 'total-war',
					'Toyota' => 'toyota',
					'TP-Link' => 'tp-link',
					'TP-Link Router' => 'tp-link-router',
					'Trampoline' => 'trampolin',
					'TREKSTOR' => 'trekstor',
					'Trockner' => 'trockner',
					'Tropical Islands' => 'tropical-island',
					'Tropico' => 'tropico',
					'Tropico 5' => 'tropico-5',
					'Tropico 6' => 'tropico-6',
					'TV &amp; Video' => 'tv-video',
					'TV Boxen' => 'tv-box',
					'TV Spielfilm' => 'tv-spielfilm',
					'TV Wandhalterungen' => 'tv-wandhalterung',
					'TV Zubehör' => 'tv-zubehoer',
					'Übergangsjacken' => 'uebergangsjacken',
					'Überwachungskamera' => 'ueberwachungskamera',
					'UE BLAST' => 'ue-blast',
					'UE BOOM' => 'ue-boom',
					'UE BOOM 2' => 'ue-boom-2',
					'UE BOOM 3' => 'ue-boom-3',
					'UE MEGABLAST' => 'ue-megablast',
					'UE MEGABOOM' => 'ue-megaboom',
					'UE MEGABOOM 3' => 'ue-megaboom-3',
					'UE WONDERBOOM' => 'ue-wonderboom',
					'UE WONDERBOOM 2' => 'ue-wonderboom-2',
					'UGG' => 'ugg',
					'Uhren' => 'uhren',
					'Umstandsmode' => 'umstandsmode',
					'Uncharted' => 'uncharted',
					'Uncharted 4' => 'uncharted-4',
					'Uncharted: The Lost Legacy' => 'uncharted-the-lost-legacy',
					'Under Armour' => 'under-armour',
					'Universalfernbedienungen' => 'universalfernbedienungen',
					'Unterwäsche' => 'unterwaesche',
					'Uplay' => 'uplay',
					'Urban Sport' => 'urban-sport',
					'Urlaub' => 'urlaub',
					'USB Sticks' => 'usb-stick',
					'Vakuumierer' => 'vakuumierer',
					'Vans' => 'vans',
					'Vans Old Skool' => 'vans-old-skool',
					'Vans Schuhe' => 'vans-schuhe',
					'Vaude' => 'vaude',
					'Ventilatoren' => 'ventilator',
					'Verbandskästen' => 'verbandskaesten',
					'Versicherung' => 'versicherung',
					'Versicherung &amp; Finanzen' => 'vertraege-finanzen',
					'Videobearbeitungsprogramme' => 'videobearbeitungsprogramme',
					'Video Player' => 'video-player',
					'Videospiele' => 'videospiele',
					'Video Streaming' => 'video-streaming',
					'Vileda' => 'vileda',
					'Villeroy &amp; Boch' => 'villeroy-boch',
					'Virenschutz' => 'virenschutz',
					'VISA' => 'visa',
					'Vliestapeten' => 'vliestapete',
					'Vodafone' => 'vodafone-netz',
					'Vodka' => 'vodka',
					'Volvo' => 'volvo',
					'Vorratsdosen' => 'vorratsdosen',
					'Vorstellungsrunde' => 'vorstellungsrunde',
					'VPN' => 'vpn',
					'VPS' => 'vps',
					'VR Brillen' => 'vr-brille',
					'VR Spiele' => 'vr-spiele',
					'VTech' => 'vtech',
					'VW' => 'vw',
					'Waffeleisen' => 'waffeleisen',
					'Wandbilder' => 'wandtattoos',
					'Wanderrucksäcke' => 'wanderrucksack',
					'Wanderschuhe' => 'wanderschuhe',
					'Wandersport' => 'hiking',
					'Wandfarben' => 'wandfarben',
					'Wandlampen' => 'wandlampen',
					'Wäscheständer' => 'waeschestaender',
					'Waschmaschinen' => 'waschmaschinen',
					'Waschmittel' => 'waschmittel',
					'Waschtrockner' => 'waschtrockner',
					'Wasserfilter' => 'wasserfilter',
					'Wasserkocher' => 'wasserkocher',
					'Wasserkühlung' => 'wasserkuehlung',
					'Wasserspielzeuge' => 'wasserspielzeug',
					'Wassersport' => 'wassersport',
					'Watch Dogs' => 'watch-dogs',
					'Watch Dogs 2' => 'watch-dogs-2',
					'Watch Dogs: Legion' => 'watch-dogs-legion',
					'WC Sitze' => 'wc-sitze',
					'WD-40' => 'wd-40',
					'Wearables' => 'wearable',
					'Webcams' => 'webcam',
					'Weber Gasgrills' => 'weber-gasgrill',
					'Weber Grills' => 'weber-grill',
					'Weihnachtsbäume' => 'weihnachtsbaum',
					'Weihnachtsbeleuchtung' => 'weihnachtsbeleuchtung',
					'Weihnachtsdeko' => 'weihnachtsdeko',
					'Weihnachtspullover' => 'weihnachtspullover',
					'Wein' => 'wein',
					'Wellensteyn' => 'wellensteyn',
					'Wellness &amp; Gesundheit' => 'wellness-massagen',
					'Wera' => 'wera',
					'Werkstatt &amp; Service' => 'werkstatt-service',
					'Werkstatteinrichtungen' => 'werkstatteinrichtungen',
					'Werkzeuge' => 'werkzeug',
					'Werkzeugkoffer' => 'werkzeugkoffer',
					'Wesco Mülleimer' => 'wesco-muelleimer',
					'Western Digital' => 'western-digital',
					'Wetterstationen' => 'wetterstationen',
					'Whirlpools' => 'whirlpools',
					'Whisky' => 'whisky',
					'Wiko' => 'wiko',
					'Wilkinson Sword Rasierer' => 'wilkinson-sword',
					'Windeln' => 'windeln',
					'Winkelschleifer' => 'winkelschleifer',
					'Winterdeko' => 'winterdeko',
					'Winterjacken' => 'winterjacken',
					'Winterreifen' => 'winterreifen',
					'Winterstiefel' => 'winterstiefel',
					'Wireless Charger' => 'wireless-charger',
					'Wirtschaftswoche' => 'wirtschaftswoche',
					'WMF' => 'wmf',
					'WMF Besteck' => 'wmf-besteck',
					'WMF Topfset' => 'wmf-topfset',
					'Wohnzimmermöbel' => 'wohnzimmer',
					'Wolfenstein' => 'wolfenstein',
					'Wolfenstein II: The New Colossus' => 'wolfenstein-2-the-new-colossus',
					'Womanizer' => 'womanizer',
					'World of Warcraft' => 'world-of-warcraft',
					'Wrangler' => 'wrangler',
					'X570 Mainboard' => 'x570-mainboard',
					'Xbox' => 'xbox',
					'Xbox Controller' => 'xbox-controller',
					'Xbox Elite Wireless Controller' => 'xbox-one-elite-controller',
					'Xbox Elite Wireless Controller 2' => 'xbox-one-elite-controller-2',
					'Xbox Game Pass' => 'xbox-game-pass',
					'Xbox Game Pass Ultimate' => 'xbox-game-pass-ultimate',
					'Xbox Guthaben' => 'xbox-guthaben',
					'Xbox Live Gold' => 'xbox-live',
					'Xbox One Controller' => 'xbox-one-controller',
					'Xbox One S Konsolen' => 'xbox-one-s',
					'Xbox One Spiele' => 'xbox-one-spiele',
					'Xbox One X Konsolen' => 'xbox-one-x',
					'Xbox Series S Konsolen' => 'xbox-series-s',
					'Xbox Series X Controller' => 'xbox-series-x-controller',
					'Xbox Series X Konsolen' => 'xbox-series-x',
					'Xbox Series X Spiele' => 'xbox-series-x-spiele',
					'Xbox Wireless Headset' => 'xbox-wireless-headset',
					'Xbox Zubehör' => 'xbox-zubehoer',
					'Xiaomi' => 'xiaomi',
					'Xiaomi Air Laptop' => 'xiaomi-air',
					'Xiaomi E-Scooter' => 'xiaomi-e-scooter',
					'Xiaomi Fernseher' => 'xiaomi-fernseher',
					'Xiaomi Kopfhörer' => 'xiaomi-kopfhoerer',
					'Xiaomi Mi 5S' => 'xiaomi-mi-5',
					'Xiaomi Mi 6' => 'xiaomi-mi-6',
					'Xiaomi Mi 8' => 'xiaomi-mi-8',
					'Xiaomi Mi 8 Lite' => 'xiaomi-mi-8-lite',
					'Xiaomi Mi 8 Pro' => 'xiaomi-mi-8-pro',
					'Xiaomi Mi 9' => 'xiaomi-mi-9',
					'Xiaomi Mi 9 Lite' => 'xiaomi-mi-9-lite',
					'Xiaomi Mi 9 SE' => 'xiaomi-mi-9-se',
					'Xiaomi Mi 9T' => 'xiaomi-mi-9t',
					'Xiaomi Mi 9T Pro' => 'xiaomi-mi-9t-pro',
					'Xiaomi Mi 10' => 'xiaomi-mi-10',
					'Xiaomi Mi 10 Lite' => 'xiaomi-mi-10-lite',
					'Xiaomi Mi 10 Pro' => 'xiaomi-mi-10-pro',
					'Xiaomi Mi 11' => 'xiaomi-mi-11',
					'Xiaomi Mi A1' => 'xiaomi-mi-a1',
					'Xiaomi Mi A2' => 'xiaomi-mi-a2',
					'Xiaomi Mi AirDots' => 'xiaomi-mi-airdots',
					'Xiaomi Mi AirDots Pro' => 'xiaomi-airdots-pro',
					'Xiaomi Mi Band' => 'xiaomi-mi-band',
					'Xiaomi Mi Band 4' => 'xiaomi-mi-band-4',
					'Xiaomi Mi Band 5' => 'xiaomi-mi-band-5',
					'Xiaomi Mi Electric Scooter 1S' => 'xiaomi-mi-scooter-1s',
					'Xiaomi Mi Electric Scooter M365' => 'xiaomi-mi-electric-scooter-m365',
					'Xiaomi Mi Electric Scooter Pro 2' => 'xiaomi-mi-electric-scooter-pro-2',
					'Xiaomi Mi Mix' => 'xiaomi-mi-mix',
					'Xiaomi Mi Mix 3' => 'xiaomi-mi-mix-3',
					'Xiaomi Mi Note' => 'xiaomi-mi-note',
					'Xiaomi Mi Note 10' => 'xiaomi-mi-note-10',
					'Xiaomi Mi Note 10 Lite' => 'xiaomi-mi-note-10-lite',
					'Xiaomi Mi Note 10 Pro' => 'xiaomi-mi-note-10-pro',
					'Xiaomi Mi TV 4S' => 'xiaomi-mi-smart-tv-4s',
					'Xiaomi Mi TV Stick' => 'xiaomi-mi-tv-stick',
					'Xiaomi Pocophone F1' => 'xiaomi-pocophone-f1',
					'Xiaomi Redmi 9' => 'xiaomi-redmi-9',
					'Xiaomi Redmi 9A' => 'xiaomi-redmi-9a',
					'Xiaomi Redmi AirDots' => 'xiaomi-redmi-airdots',
					'Xiaomi Redmi Note 4' => 'xiaomi-redmi-note-4',
					'Xiaomi Redmi Note 5' => 'xiaomi-redmi-note-5',
					'Xiaomi Redmi Note 8' => 'xiaomi-redmi-note-8',
					'Xiaomi Redmi Note 8 Pro' => 'xiaomi-redmi-note-8-pro',
					'Xiaomi Redmi Note 9' => 'xiaomi-redmi-note-9',
					'Xiaomi Redmi Note 9 Pro' => 'xiaomi-redmi-note-9-pro',
					'Xiaomi Redmi Note 9S' => 'xiaomi-redmi-note-9s',
					'Xiaomi Redmi Note 10' => 'xiaomi-redmi-note-10',
					'Xiaomi Redmi Note 10 Pro' => 'xiaomi-redmi-note-10-pro',
					'Xiaomi Smart Home' => 'xiaomi-smart-home',
					'Xiaomi Smartphones' => 'xiaomi-smartphones',
					'Xiaomi YouPin' => 'xiaomi-youpin',
					'XMG' => 'xmg',
					'Yamaha' => 'yamaha',
					'Yeelight' => 'xiaomi-yeelight',
					'Yoga' => 'yoga',
					'Yogamatten' => 'yogamatten',
					'Yoshi&#039;s Crafted World' => 'yoshis-crafted-world',
					'Zahnbürsten' => 'zahnbuersten',
					'Zahnpasta' => 'zahnpasta',
					'Zahnzusatzversicherung' => 'zahnzusatzversicherung',
					'Zeitschriften' => 'zeitschriften-magazine',
					'Zelte' => 'zelte',
					'Zirkel' => 'zirkel',
					'Zoo-Tickets' => 'zoo',
					'Zotac' => 'zotac',
					'ZTE Smartphones' => 'zte-smartphones',
					'ZWILLING' => 'zwilling',
					'ZWILLING Besteck' => 'zwilling-besteck',
				)
			),
			'order' => array(
				'name' => 'sortieren nach',
				'type' => 'list',
				'title' => 'Sortierung der deals',
				'values' => array(
					'Vom heißesten zum kältesten Deal' => '-hot',
					'Vom jüngsten Deal zum ältesten' => '-new',
				)
			),
		),
		'Überwachung Diskussion' => array(
			'url' => array(
				'name' => 'URL der Diskussion',
				'type' => 'text',
				'required' => true,
				'title' => 'URL-Diskussion zu überwachen:  https://www.mydealz.de/diskussion/title-123',
				'exampleValue' => '://www.mydealz.de/diskussion/title-123',
				),
			'only_with_url' => array(
				'name' => 'Kommentare ohne URL ausschließen',
				'type' => 'checkbox',
				'title' => 'Kommentare, die keine URL enthalten, im Feed ausschließen',
				'defaultValue' => false,
				)
			)
	);

	public $lang = array(
		'bridge-uri' => SELF::URI,
		'bridge-name' => SELF::NAME,
		'context-keyword' => 'Suche nach Stichworten',
		'context-group' => 'Deals pro Gruppen',
		'context-talk' => 'Überwachung Diskussion',
		'uri-group' => 'gruppe/',
		'request-error' => 'Could not request mydeals',
		'thread-error' => 'Die ID der Diskussion kann nicht ermittelt werden. Überprüfen Sie die eingegebene URL',
		'no-results' => 'Ups, wir konnten keine Deals zu',
		'relative-date-indicator' => array(
			'vor',
			'seit'
		),
		'price' => 'Preis',
		'shipping' => 'Versand',
		'origin' => 'Ursprung',
		'discount' => 'Rabatte',
		'title-keyword' => 'Suche',
		'title-group' => 'Gruppe',
		'title-talk' => 'Überwachung Diskussion',
		'local-months' => array(
			'Jan',
			'Feb',
			'Mär',
			'Apr',
			'Mai',
			'Jun',
			'Jul',
			'Aug',
			'Sep',
			'Okt',
			'Nov',
			'Dez',
			'.'
		),
		'local-time-relative' => array(
			'eingestellt vor ',
			'm',
			'h,',
			'day',
			'days',
			'month',
			'year',
			'and '
		),
		'date-prefixes' => array(
			'eingestellt am ',
			'lokal ',
			'aktualisiert ',
		),
		'relative-date-alt-prefixes' => array(
			'aktualisiert vor ',
			'kommentiert vor ',
			'heiß seit '
		),
		'relative-date-ignore-suffix' => array(
			'/von.*$/'
		),
		'localdeal' => array(
			'Lokal ',
			'Läuft bis '
		)
	);

}
